/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.HashMap;
import omnidex.client.OdxCLJException;

public class OdxCLJResultSet {
    private HashMap m_columnNumbers;
    private String[] m_columnNames;
    private int[] m_columnDatatypes;
    private int[] m_columnLengths;
    private int m_maxFieldSize;
    private int m_maxRows;
    private int m_fetchSize;
    private int m_columnCount;
    private int m_row;
    private int m_rowCount;
    private int m_fetchDirection = 1000;
    private int m_type = 1003;
    private int m_concurrency = 1007;
    private boolean m_open = true;
    private boolean m_wasNull = false;
    private static String m_blank = "";
    private int m_mode = 0;
    private static final int QUERY = 0;
    private static final int INSERT = 1;
    private static final int UPDATE = 2;

    protected OdxCLJResultSet() {
    }

    protected void checkResultSet() throws OdxCLJException {
        if (!this.m_open) {
            throw new OdxCLJException(25501);
        }
    }

    protected void checkColumnNumber(int n) throws OdxCLJException {
        if (n > this.m_columnCount || n <= 0) {
            throw new OdxCLJException(25503);
        }
    }

    protected void checkRow() throws OdxCLJException {
        if (this.isAfterLast()) {
            throw new OdxCLJException(25514);
        }
        if (!this.isInsertMode() && this.m_row == 0) {
            throw new OdxCLJException(25533);
        }
    }

    protected void checkScrollable() throws OdxCLJException {
        if (this.m_type == 1003) {
            throw new OdxCLJException(25534);
        }
    }

    protected void checkUpdatable() throws OdxCLJException {
        if (this.m_concurrency == 1007) {
            throw new OdxCLJException(25536);
        }
    }

    protected void setColumnCount(int n) {
        this.m_columnCount = n;
        this.m_columnNames = new String[n];
        this.m_columnDatatypes = new int[n];
        this.m_columnLengths = new int[n];
    }

    protected void setColumnInfo(int n, String string, int n2, int n3) {
        this.m_columnNames[--n] = string.toString().toUpperCase();
        this.m_columnDatatypes[n] = n2;
        this.m_columnLengths[n] = n3;
    }

    protected void setMaxRows(int n) {
        this.m_maxRows = n;
    }

    protected void setMaxFieldSize(int n) {
        this.m_maxFieldSize = n;
    }

    protected void setType(int n) {
        this.m_type = n;
    }

    protected void setConcurrency(int n) {
        this.m_concurrency = n;
    }

    protected void setRowCount(int n) {
        this.m_rowCount = n;
    }

    protected void setRow(int n) {
        this.m_row = n;
    }

    protected int getMaxRows() {
        return this.m_maxRows;
    }

    protected boolean isQueryMode() {
        return this.m_mode == 0;
    }

    protected boolean isUpdateMode() {
        return this.m_mode == 2;
    }

    protected boolean isInsertMode() {
        return this.m_mode == 1;
    }

    protected void setQueryMode() {
        this.m_mode = 0;
    }

    protected void setUpdateMode() {
        this.m_mode = 2;
    }

    protected void setInsertMode() {
        this.m_mode = 1;
    }

    protected int getMode() {
        return this.m_mode;
    }

    protected void setMode(int n) {
        this.m_mode = n;
    }

    protected String getValueString(int n) {
        return m_blank;
    }

    protected String getValueString(int n, boolean bl) {
        return m_blank;
    }

    protected boolean getValueBoolean(int n) {
        return false;
    }

    protected int getValueInt(int n) {
        return 0;
    }

    protected double getValueDouble(int n) {
        return 0.0;
    }

    protected long getValueTimestamp(int n) {
        return 0L;
    }

    public int getColumnType(int n) throws OdxCLJException {
        this.checkResultSet();
        return 0;
    }

    public String getColumnEnvironment(int n) throws OdxCLJException {
        this.checkResultSet();
        return m_blank;
    }

    public String getColumnDatabase(int n) throws OdxCLJException {
        this.checkResultSet();
        return m_blank;
    }

    public String getColumnTable(int n) throws OdxCLJException {
        this.checkResultSet();
        return m_blank;
    }

    public String getColumnLabel(int n) throws OdxCLJException {
        return this.getColumnName(n);
    }

    public String getColumnAlias(int n) throws OdxCLJException {
        return this.getColumnName(n);
    }

    public int getColumnOccurrences(int n) throws OdxCLJException {
        this.checkResultSet();
        return 1;
    }

    public boolean isReadOnly(int n) {
        return true;
    }

    public boolean wasNull() {
        return this.m_wasNull;
    }

    public boolean next() throws OdxCLJException {
        ++this.m_row;
        return !this.isAfterLast();
    }

    public boolean isBeforeFirst() throws OdxCLJException {
        this.checkResultSet();
        return this.m_row == 0;
    }

    public boolean isFirst() throws OdxCLJException {
        this.checkResultSet();
        return this.m_row == 1;
    }

    public boolean isAfterLast() throws OdxCLJException {
        this.checkResultSet();
        return this.m_row > this.m_rowCount;
    }

    public boolean isLast() throws OdxCLJException {
        this.checkResultSet();
        return this.m_row == this.m_rowCount;
    }

    public void beforeFirst() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public void afterLast() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public boolean first() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public boolean last() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public boolean absolute(int n) throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public boolean relative(int n) throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public boolean previous() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public void updateColumnValue(int n, String string) throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public void deleteRow() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public void cancelRowUpdates() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public void updateRow() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public void moveToInsertRow() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public void insertRow() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public void moveToCurrentRow() throws OdxCLJException {
        throw new OdxCLJException(25500);
    }

    public int getColumnNumber(String string) throws OdxCLJException {
        Integer n = null;
        String string2 = string.toString().toUpperCase();
        if (this.m_columnNumbers == null) {
            this.m_columnNumbers = new HashMap();
        } else {
            n = (Integer)this.m_columnNumbers.get(string2);
        }
        if (n == null) {
            int n2 = this.m_columnNumbers.size() + 1;
            while (n2 <= this.m_columnCount) {
                String string3 = this.getColumnName(n2);
                this.m_columnNumbers.put(string3, new Integer(n2));
                if (string3.equals(string2)) {
                    return n2;
                }
                ++n2;
            }
            throw new OdxCLJException(25506);
        }
        return n;
    }

    public String getColumnName(int n) throws OdxCLJException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return this.m_columnNames[n - 1];
    }

    public int getColumnDatatype(int n) throws OdxCLJException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return this.m_columnDatatypes[n - 1];
    }

    public int getColumnLength(int n) throws OdxCLJException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return this.m_columnLengths[n - 1];
    }

    public int getColumnDisplaySize(int n) throws OdxCLJException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        switch (this.m_columnDatatypes[n - 1]) {
            case 1: 
            case 12: {
                return this.m_columnLengths[n - 1];
            }
        }
        return 32;
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    public int getRow() {
        return this.m_row;
    }

    public int getType() {
        return this.m_type;
    }

    public int getConcurrency() {
        return this.m_concurrency;
    }

    public int getFetchDirection() {
        return this.m_fetchDirection;
    }

    public void setFetchDirection(int n) throws OdxCLJException {
        if (this.m_type == 1003 && n != 1000) {
            throw new OdxCLJException(25505);
        }
        this.m_fetchDirection = n;
    }

    public int getFetchSize() {
        return this.m_fetchSize;
    }

    public void setFetchSize(int n) {
        this.m_fetchSize = n;
    }

    public String getColumnValueString(int n) throws OdxCLJException {
        String string = null;
        int n2 = this.getColumnDatatype(n);
        this.checkRow();
        block0 : switch (n2) {
            case -5: 
            case 1: {
                string = this.getValueString(n);
                break;
            }
            case 12: {
                string = this.getValueString(n, true);
                break;
            }
            case -7: {
                string = String.valueOf(this.getValueBoolean(n));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = String.valueOf(this.getValueInt(n));
                break;
            }
            case 6: 
            case 7: {
                string = String.valueOf(this.getValueDouble(n));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long l = this.getValueTimestamp(n);
                if (l == 0L) break;
                switch (n2) {
                    case 91: {
                        string = DateFormat.getDateInstance().format(new Date(l));
                        break block0;
                    }
                    case 92: {
                        string = new Time(l).toString();
                        break block0;
                    }
                    case 93: {
                        string = new Timestamp(l).toString();
                    }
                }
            }
        }
        if (this.m_maxFieldSize != 0 && string != null) {
            string = string.substring(0, this.m_maxFieldSize);
        }
        this.m_wasNull = string == null;
        return string;
    }

    public boolean getColumnValueBoolean(int n) throws OdxCLJException {
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case 1: {
                return Boolean.valueOf(this.getValueString(n));
            }
            case 12: {
                return Boolean.valueOf(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n) != 0;
            }
            case -5: {
                return Long.parseLong(this.getValueString(n)) != 0L;
            }
            case 6: 
            case 7: {
                return this.getValueDouble(n) != 0.0;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public byte getColumnValueByte(int n) throws OdxCLJException {
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case -5: 
            case 1: {
                return Byte.parseByte(this.getValueString(n));
            }
            case 12: {
                return Byte.parseByte(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? (byte)1 : 0;
            }
            case -6: 
            case 4: 
            case 5: {
                return (byte)this.getValueInt(n);
            }
            case 6: 
            case 7: {
                return (byte)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0;
            }
        }
        return 0;
    }

    public short getColumnValueShort(int n) throws OdxCLJException {
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case -5: 
            case 1: {
                return Short.parseShort(this.getValueString(n));
            }
            case 12: {
                return Short.parseShort(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? (short)1 : 0;
            }
            case -6: 
            case 4: 
            case 5: {
                return (short)this.getValueInt(n);
            }
            case 6: 
            case 7: {
                return (short)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0;
            }
        }
        return 0;
    }

    public int getColumnValueInt(int n) throws OdxCLJException {
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case -5: 
            case 1: {
                return Integer.parseInt(this.getValueString(n));
            }
            case 12: {
                return Integer.parseInt(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? 1 : 0;
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n);
            }
            case 6: 
            case 7: {
                return (int)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0;
            }
        }
        return 0;
    }

    public long getColumnValueLong(int n) throws OdxCLJException {
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case -5: 
            case 1: {
                return Long.parseLong(this.getValueString(n));
            }
            case 12: {
                return Long.parseLong(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? 1L : 0L;
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n);
            }
            case 6: 
            case 7: {
                return (long)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0L;
            }
        }
        return 0L;
    }

    public float getColumnValueFloat(int n) throws OdxCLJException {
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case -5: 
            case 1: {
                return Float.parseFloat(this.getValueString(n));
            }
            case 12: {
                return Float.parseFloat(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? 1.0f : 0.0f;
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n);
            }
            case 6: 
            case 7: {
                return (float)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public double getColumnValueDouble(int n) throws OdxCLJException {
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case -5: 
            case 1: {
                return Double.parseDouble(this.getValueString(n));
            }
            case 12: {
                return Double.parseDouble(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? 1.0 : 0.0;
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n);
            }
            case 6: 
            case 7: {
                return this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0.0;
            }
        }
        return 0.0;
    }

    public Date getColumnValueDate(int n) throws OdxCLJException {
        Date date = null;
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case 1: {
                date = Date.valueOf(this.getValueString(n));
                break;
            }
            case 12: {
                date = Date.valueOf(this.getValueString(n, true));
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                date = null;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long l = this.getValueTimestamp(n);
                if (l == 0L) break;
                date = new Date(l);
            }
        }
        this.m_wasNull = date == null;
        return date;
    }

    public Time getColumnValueTime(int n) throws OdxCLJException {
        Time time = null;
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case 1: {
                time = Time.valueOf(this.getValueString(n));
                break;
            }
            case 12: {
                time = Time.valueOf(this.getValueString(n, true));
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                time = null;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long l = this.getValueTimestamp(n);
                if (l == 0L) break;
                time = new Time(l);
            }
        }
        this.m_wasNull = time == null;
        return time;
    }

    public Timestamp getColumnValueTimestamp(int n) throws OdxCLJException {
        Timestamp timestamp = null;
        this.checkRow();
        switch (this.getColumnDatatype(n)) {
            case 1: {
                timestamp = Timestamp.valueOf(this.getValueString(n));
                break;
            }
            case 12: {
                timestamp = Timestamp.valueOf(this.getValueString(n, true));
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                timestamp = null;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long l = this.getValueTimestamp(n);
                if (l == 0L) break;
                timestamp = new Timestamp(l);
            }
        }
        this.m_wasNull = timestamp == null;
        return timestamp;
    }

    public Object getColumnValueObject(int n) throws OdxCLJException {
        Object object = null;
        int n2 = this.getColumnDatatype(n);
        this.checkRow();
        block0 : switch (n2) {
            case 1: {
                String string = this.getValueString(n);
                if (this.m_maxFieldSize != 0 && string != null) {
                    string = string.substring(0, this.m_maxFieldSize);
                }
                object = string;
                break;
            }
            case 12: {
                String string = this.getValueString(n, true);
                if (this.m_maxFieldSize != 0 && string != null) {
                    string = string.substring(0, this.m_maxFieldSize);
                }
                object = string;
                break;
            }
            case -7: {
                object = new Boolean(this.getValueBoolean(n));
                break;
            }
            case -6: {
                object = new Byte((byte)this.getValueInt(n));
                break;
            }
            case 5: {
                object = new Short((short)this.getValueInt(n));
                break;
            }
            case 4: {
                object = new Integer(this.getValueInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getValueString(n));
                break;
            }
            case 7: {
                object = new Float((float)this.getValueDouble(n));
                break;
            }
            case 6: {
                object = new Double(this.getValueDouble(n));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long l = this.getValueTimestamp(n);
                if (l == 0L) break;
                switch (n2) {
                    case 91: {
                        object = new Date(l);
                        break block0;
                    }
                    case 92: {
                        object = new Time(l);
                        break block0;
                    }
                    case 93: {
                        object = new Timestamp(l);
                    }
                }
            }
        }
        this.m_wasNull = object == null;
        return object;
    }

    public void close() throws OdxCLJException {
        if (this.m_columnNumbers != null) {
            this.m_columnNumbers.clear();
            this.m_columnNumbers = null;
        }
        this.m_columnNames = null;
        this.m_columnDatatypes = null;
        this.m_columnLengths = null;
        this.m_maxFieldSize = 0;
        this.m_maxRows = 0;
        this.m_fetchSize = 0;
        this.m_columnCount = 0;
        this.m_row = 0;
        this.m_rowCount = 0;
        this.m_open = false;
    }
}

