/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.util.Date;

public final class OdxCLJTrace {
    private static boolean m_trace;
    private static PrintWriter m_writer;

    public static void initialize() {
        OdxCLJTrace.setLogWriter(DriverManager.getLogWriter());
    }

    public static boolean isTrace() {
        return m_trace;
    }

    public static void setTrace(boolean bl) {
        m_trace = bl;
    }

    public static void setLogWriter(PrintWriter printWriter) {
        m_writer = printWriter;
        m_trace = m_writer != null;
    }

    public static void setLogWriter(String string, boolean bl) {
        try {
            OdxCLJTrace.setLogWriter(new PrintWriter(new FileWriter(string, bl)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void print(String string) {
        if (!OdxCLJTrace.isTrace() || m_writer == null) {
            OdxCLJTrace.initialize();
        }
        if (!OdxCLJTrace.isTrace() || m_writer == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(new Date().toString());
        stringBuffer.append(": ");
        stringBuffer.append(string);
        m_writer.println(stringBuffer.toString());
        m_writer.flush();
    }

    public static void print(String string, boolean bl) {
        if (!OdxCLJTrace.isTrace() || m_writer == null) {
            OdxCLJTrace.initialize();
        }
        if (!OdxCLJTrace.isTrace() || m_writer == null) {
            return;
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(new Date().toString());
            stringBuffer.append(": ");
            stringBuffer.append(string);
            m_writer.println(stringBuffer.toString());
        } else {
            m_writer.println(string);
        }
        m_writer.flush();
    }

    public static void print(Exception exception) {
        if (!OdxCLJTrace.isTrace() || m_writer == null) {
            OdxCLJTrace.initialize();
        }
        if (!OdxCLJTrace.isTrace() || m_writer == null) {
            return;
        }
        exception.printStackTrace(m_writer);
    }

    public static void print(Object object, String string) {
        if (!OdxCLJTrace.isTrace() || m_writer == null) {
            OdxCLJTrace.initialize();
        }
        if (!OdxCLJTrace.isTrace() || m_writer == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(new Date().toString());
        stringBuffer.append(": ");
        stringBuffer.append(object.toString());
        if (string != null) {
            stringBuffer.append(".");
            stringBuffer.append(string);
        }
        m_writer.println(stringBuffer.toString());
        m_writer.flush();
    }

    static {
        try {
            String string = System.getProperty("OdxCLJTraceFile");
            if (string != null) {
                OdxCLJTrace.setLogWriter(new PrintWriter(new FileWriter(string, true)));
            } else if (Boolean.getBoolean("OdxCLJTrace")) {
                PrintWriter printWriter = DriverManager.getLogWriter();
                if (printWriter != null) {
                    OdxCLJTrace.setLogWriter(printWriter);
                } else {
                    OdxCLJTrace.setLogWriter(new PrintWriter(System.out));
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

