/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJPoolArray;
import omnidex.client.OdxCLJStatus;
import omnidex.client.OdxCLJTrace;

public final class OdxCLJConnectionMgr {
    private static OdxCLJConnectionMgr m_singleton;
    private static int m_size;
    private HashMap m_connections = new HashMap();

    private OdxCLJConnectionMgr() {
    }

    private static OdxCLJStatus openConnection(String string, Properties properties) throws OdxCLJException {
        OdxCLJStatus odxCLJStatus = new OdxCLJStatus();
        odxCLJStatus.connect(string, properties);
        return odxCLJStatus;
    }

    private static synchronized void createSingleton(int n) {
        if (m_singleton == null) {
            m_singleton = new OdxCLJConnectionMgr();
            m_size = n;
        }
    }

    private String createKey(String string, Properties properties) {
        String string2;
        String string3;
        if (properties != null) {
            string3 = properties.getProperty("user");
            string2 = properties.getProperty("password");
        } else {
            string3 = "";
            string2 = "";
        }
        String string4 = OdxCLJStatus.makeOptionString(properties);
        return string + ";" + string3 + ";" + string2 + ";" + string4;
    }

    private OdxCLJStatus lockConnection(String string, Properties properties) throws OdxCLJException {
        this.trace("lockConnection");
        String string2 = this.createKey(string, properties);
        OdxCLJStatus odxCLJStatus = null;
        OdxCLJPoolArray odxCLJPoolArray = (OdxCLJPoolArray)this.m_connections.get(string2);
        if (odxCLJPoolArray != null) {
            odxCLJStatus = (OdxCLJStatus)odxCLJPoolArray.lock();
        } else {
            odxCLJPoolArray = new OdxCLJPoolArray();
        }
        if (odxCLJStatus == null) {
            if (odxCLJPoolArray.size() == m_size) {
                throw new OdxCLJException(25535);
            }
            odxCLJStatus = OdxCLJConnectionMgr.openConnection(string, properties);
            odxCLJStatus.setKey(string2);
            odxCLJPoolArray.addLock(odxCLJStatus);
            this.m_connections.put(string2, odxCLJPoolArray);
        }
        return odxCLJStatus;
    }

    private void unlockConnection(OdxCLJStatus odxCLJStatus) throws OdxCLJException {
        this.trace("unlockConnection");
        OdxCLJPoolArray odxCLJPoolArray = (OdxCLJPoolArray)this.m_connections.get(odxCLJStatus.getKey());
        if (odxCLJPoolArray != null) {
            odxCLJPoolArray.unlock(odxCLJStatus);
        }
    }

    private void clear() throws OdxCLJException {
        this.trace("clear");
        if (this.m_connections != null) {
            Iterator iterator = this.m_connections.values().iterator();
            while (iterator.hasNext()) {
                OdxCLJPoolArray odxCLJPoolArray = (OdxCLJPoolArray)iterator.next();
                Iterator iterator2 = odxCLJPoolArray.iterator();
                while (iterator2.hasNext()) {
                    OdxCLJStatus odxCLJStatus = (OdxCLJStatus)iterator2.next();
                    odxCLJStatus.disconnect();
                }
                odxCLJPoolArray.clear();
            }
            this.m_connections.clear();
            this.m_connections = null;
        }
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    public static OdxCLJStatus getConnection(String string, Properties properties) throws OdxCLJException {
        int n;
        if (m_singleton == null && (n = Integer.getInteger("ODXJDBC_MAXPOOLSIZE", 0).intValue()) != 0) {
            OdxCLJConnectionMgr.createSingleton(n);
        }
        if (OdxCLJConnectionMgr.isPooling()) {
            OdxCLJConnectionMgr odxCLJConnectionMgr = m_singleton;
            synchronized (odxCLJConnectionMgr) {
                OdxCLJStatus odxCLJStatus = m_singleton.lockConnection(string, properties);
                return odxCLJStatus;
            }
        }
        return OdxCLJConnectionMgr.openConnection(string, properties);
    }

    public static void releaseConnection(OdxCLJStatus odxCLJStatus) throws OdxCLJException {
        if (m_singleton == null) {
            odxCLJStatus.disconnect();
        } else {
            OdxCLJConnectionMgr odxCLJConnectionMgr = m_singleton;
            synchronized (odxCLJConnectionMgr) {
                m_singleton.unlockConnection(odxCLJStatus);
            }
        }
    }

    public static void close() throws OdxCLJException {
        if (m_singleton != null) {
            OdxCLJConnectionMgr odxCLJConnectionMgr = m_singleton;
            synchronized (odxCLJConnectionMgr) {
                if (m_singleton != null) {
                    m_singleton.clear();
                    m_singleton = null;
                }
            }
        }
    }

    public static boolean isPooling() {
        return m_singleton != null;
    }
}

