/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.util.Enumeration;
import java.util.Properties;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJNative;
import omnidex.client.OdxCLJTrace;

public class OdxCLJStatus {
    public static final String VERSION = "1.15";
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 15;
    private int[] m_oaStatus = OdxCLJNative.createStatus();
    private String m_key;
    private int m_endian;
    private String m_oaVersion;
    private boolean m_readOnly;
    private String m_syscatName;
    private String m_environmentName;
    private byte[] m_environmentInfo;

    protected OdxCLJStatus() {
    }

    private int[] getStatus() {
        return this.m_oaStatus;
    }

    private void setStatus(int[] nArray) {
        this.m_oaStatus = nArray;
    }

    protected int getErrorCode() {
        return this.m_oaStatus[0];
    }

    protected int getStatusCount() {
        return this.m_oaStatus[3];
    }

    public int getStatusBufferLength() {
        return this.m_oaStatus[4];
    }

    protected int getStatusInstance() {
        return this.m_oaStatus[5];
    }

    protected int getStatusCursor() {
        return this.m_oaStatus[6];
    }

    protected int getStatusCPUTime() {
        return this.m_oaStatus[8];
    }

    protected int getStatusElapsedTime() {
        return this.m_oaStatus[9];
    }

    protected int getStatusParentCount() {
        return this.m_oaStatus[10];
    }

    protected boolean getStatusReadOnly() {
        return this.m_oaStatus[10] != 0;
    }

    protected int getStatusPreIntersectCount() {
        return this.m_oaStatus[11];
    }

    protected int getStatusColumnCount() {
        return this.m_oaStatus[12];
    }

    protected int getStatusStatementId() {
        return this.m_oaStatus[13];
    }

    protected int getStatusEndian() {
        return this.m_oaStatus[14];
    }

    protected int replaceStatusCursor(int n) {
        int n2 = this.m_oaStatus[6];
        this.m_oaStatus[6] = n;
        return n2;
    }

    protected int getEndian() {
        return this.m_endian;
    }

    protected void setEndian(int n) {
        this.m_endian = n;
    }

    protected boolean getReadOnly() {
        return this.m_readOnly;
    }

    protected void setReadOnly(boolean bl) {
        this.m_readOnly = bl;
    }

    protected String getKey() {
        return this.m_key;
    }

    protected void setKey(String string) {
        this.m_key = string;
    }

    protected String getErrorMessage() {
        return OdxCLJNative.getErrorMessage(this.m_oaStatus);
    }

    protected static String getErrorMessage(int n) {
        return OdxCLJNative.getStaticErrorMessage(n);
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected static String makeOptionString(Properties properties) {
        if (properties == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("user") || string2.equalsIgnoreCase("password") || (string = properties.getProperty(string2)) == null) continue;
            stringBuffer.append(",").append(string2).append("='").append(string).append("'");
        }
        return stringBuffer.length() != 0 ? stringBuffer.toString() : "";
    }

    protected void connect(String string, Properties properties) throws OdxCLJException {
        String string2;
        String string3;
        this.trace("connect");
        if (properties != null) {
            string3 = properties.getProperty("user");
            string2 = properties.getProperty("password");
        } else {
            string3 = "";
            string2 = "";
        }
        if (OdxCLJNative.connect(string, OdxCLJStatus.makeOptionString(properties), this.m_oaStatus, string3, string2)) {
            throw new OdxCLJException(this);
        }
        this.trace("jniConnect: " + this.getStatusInstance());
        this.trace("jniGetEnvironmentInfo");
        this.m_environmentInfo = OdxCLJNative.getEnvironmentInfo(this.m_oaStatus);
        if (this.getErrorCode() != 0) {
            int n = this.getErrorCode();
            this.trace("jniDisconnect");
            OdxCLJNative.disconnect(this.m_oaStatus);
            throw new OdxCLJException(n);
        }
        this.setEndian(this.getStatusEndian());
        this.setReadOnly(this.getStatusReadOnly());
    }

    protected void openCursor() throws OdxCLJException {
        this.trace("openCursor: " + this.getStatusInstance());
        if (OdxCLJNative.openCursor(this.m_oaStatus)) {
            throw new OdxCLJException(this);
        }
        this.trace("jniOpenCursor: " + this.getStatusCursor());
    }

    protected void execute(String string, Properties properties, int n) throws OdxCLJException {
        this.trace("execute: " + this.getStatusCursor());
        String string2 = OdxCLJStatus.makeOptionString(properties);
        if (n != 0) {
            string2 = string2 + " TIMEOUT=" + n;
        }
        OdxCLJTrace.print("SQL: " + string);
        if (OdxCLJNative.executeSQL(string, string2, this.m_oaStatus)) {
            OdxCLJTrace.print("Exception occurred.");
            throw new OdxCLJException(this);
        }
        OdxCLJTrace.print("No exception.");
    }

    protected byte[] describe() throws OdxCLJException {
        this.trace("describe: " + this.getStatusCursor());
        byte[] byArray = OdxCLJNative.describe(this.m_oaStatus);
        if (this.getErrorCode() != 0) {
            throw new OdxCLJException(this);
        }
        if (byArray == null) {
            throw new OdxCLJException(25501);
        }
        return byArray;
    }

    protected byte[] describeQualify() throws OdxCLJException {
        this.trace("describe: " + this.getStatusCursor());
        byte[] byArray = OdxCLJNative.describeQualify(this.m_oaStatus);
        if (this.getErrorCode() != 0) {
            throw new OdxCLJException(this);
        }
        if (byArray == null) {
            throw new OdxCLJException(25501);
        }
        return byArray;
    }

    protected byte[] describeKeyword() throws OdxCLJException {
        this.trace("describe: " + this.getStatusCursor());
        byte[] byArray = OdxCLJNative.describeKeyword(this.m_oaStatus);
        if (this.getErrorCode() != 0) {
            throw new OdxCLJException(this);
        }
        if (byArray == null) {
            throw new OdxCLJException(25501);
        }
        return byArray;
    }

    protected boolean isUpdatable(byte[] byArray, int n) {
        return OdxCLJNative.isResultSetUpdatable(byArray, n, this.m_oaStatus);
    }

    protected void fetch(byte[] byArray, int n) throws OdxCLJException {
        this.trace("fetch: " + this.getStatusCursor());
        if (OdxCLJNative.fetch(byArray, n, this.m_oaStatus)) {
            throw new OdxCLJException(this);
        }
    }

    protected void fetchQualify(byte[] byArray, int n) throws OdxCLJException {
        this.trace("fetchQualify: " + this.getStatusCursor());
        if (OdxCLJNative.fetchQualify(byArray, n, this.m_oaStatus)) {
            throw new OdxCLJException(this);
        }
    }

    protected void fetchKeyword(byte[] byArray, int n) throws OdxCLJException {
        this.trace("fetchKeyword: " + this.getStatusCursor());
        if (OdxCLJNative.fetchKeyword(byArray, n, this.m_oaStatus)) {
            throw new OdxCLJException(this);
        }
    }

    protected void cancel() throws OdxCLJException {
        this.trace("cancel" + this.getStatusCursor());
        if (OdxCLJNative.cancel(this.m_oaStatus)) {
            throw new OdxCLJException(this);
        }
    }

    protected String getVersion() {
        this.trace("getVersion: " + this.getStatusCursor());
        if (this.m_oaVersion == null) {
            this.m_oaVersion = OdxCLJNative.getVersion(this.m_oaStatus);
        }
        return this.m_oaVersion;
    }

    protected String getSyscatName() throws OdxCLJException {
        if (this.m_syscatName == null) {
            this.trace("getSyscatName" + this.getStatusInstance());
            this.m_syscatName = OdxCLJNative.getSyscatName(this.m_oaStatus);
            if (this.m_syscatName == null) {
                throw new OdxCLJException(this);
            }
        }
        return this.m_syscatName;
    }

    protected String getEnvironmentName() throws OdxCLJException {
        if (this.m_environmentName == null) {
            this.trace("getEnvironmentName" + this.getStatusInstance());
            this.m_environmentName = OdxCLJNative.getEnvironmentName(this.m_environmentInfo);
            if (this.m_environmentName == null) {
                throw new OdxCLJException(this);
            }
        }
        return this.m_environmentName;
    }

    protected byte[] getDatabaseInfo() throws OdxCLJException {
        this.trace("getDatabaseInfo: " + this.getStatusInstance());
        byte[] byArray = OdxCLJNative.getDatabaseInfo(this.m_oaStatus);
        if (this.getErrorCode() != 0) {
            throw new OdxCLJException(this);
        }
        return byArray;
    }

    protected byte[] getTableInfo(String string, String string2, String string3, int n) throws OdxCLJException {
        this.trace("getTableInfo: " + this.getStatusInstance());
        byte[] byArray = OdxCLJNative.getTableInfo(this.m_oaStatus, string, string2, string3, n);
        if (this.getErrorCode() != 0) {
            throw new OdxCLJException(this);
        }
        return byArray;
    }

    protected byte[] getColumnInfo(String string, String string2, String string3, String string4) throws OdxCLJException {
        this.trace("getColumnInfo: " + this.getStatusInstance());
        byte[] byArray = OdxCLJNative.getColumnInfo(this.m_oaStatus, string, string2, string3, string4);
        if (this.getErrorCode() != 0) {
            throw new OdxCLJException(this);
        }
        return byArray;
    }

    protected byte[] getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws OdxCLJException {
        this.trace("getIndexInfo: " + this.getStatusInstance());
        byte[] byArray = OdxCLJNative.getIndexInfo(this.m_oaStatus, string, string2, string3, bl, bl2);
        if (this.getErrorCode() != 0) {
            throw new OdxCLJException(this);
        }
        return byArray;
    }

    protected byte[] getComponentInfo(String string, String string2, String string3, String string4) throws OdxCLJException {
        this.trace("getComponentInfo: " + this.getStatusInstance());
        byte[] byArray = OdxCLJNative.getComponentInfo(this.m_oaStatus, string, string2, string3, string4);
        if (this.getErrorCode() != 0) {
            throw new OdxCLJException(this);
        }
        return byArray;
    }

    protected void closeCursor() throws OdxCLJException {
        this.trace("closeCursor: " + this.getStatusCursor());
        if (this.getStatusCursor() != 0 && OdxCLJNative.closeCursor(this.m_oaStatus)) {
            throw new OdxCLJException(this);
        }
    }

    protected void disconnect() throws OdxCLJException {
        this.trace("disconnect: " + this.getStatusInstance() + "," + this.getStatusCursor());
        this.closeCursor();
        if (OdxCLJNative.disconnect(this.m_oaStatus)) {
            throw new OdxCLJException(this);
        }
        this.m_oaStatus[0] = 0;
        this.m_oaStatus[5] = 0;
        this.m_oaStatus[6] = 0;
    }
}

