/*
 * Decompiled with CFR 0.152.
 */
package omnidex.oaobj;

import java.util.Enumeration;
import java.util.Vector;
import omnidex.oaobj.OaoCursor;
import omnidex.oaobj.OaoException;

public class OaoInstance {
    private Vector m_vCursors = new Vector();
    protected int m_wCppIndex = -1;

    public native int JInstDisconnect(String var1);

    public native int JInstOpenCursor(String var1);

    public native String JInstGetErrorMsg();

    public native int JInstInsertRow(String var1, String var2, Vector var3);

    public native int JInstInsertRow(String var1, String var2, Vector var3, String var4);

    public native Vector JInstEnvironmentInfo();

    public native Vector JInstDatabaseInfo(String var1);

    public native Vector JInstTableInfo(String var1);

    public native Vector JInstColumnListInfo(String var1, String var2);

    public OaoInstance() {
        this.m_wCppIndex = -1;
    }

    public OaoInstance(int n) {
        String string = new String();
        this.m_wCppIndex = n;
    }

    public String getErrorMessage() throws OaoException {
        try {
            if (this.m_wCppIndex >= 0) {
                String string = new String(this.JInstGetErrorMsg());
                return string;
            }
            String string = new String("");
            return string;
        }
        catch (Exception exception) {
            throw new OaoException("Exception thrown [OaoInstance.getErrorMessage]: " + exception.getMessage() + ".");
        }
    }

    public void finalize() {
        if (this.m_wCppIndex >= 0) {
            try {
                String string = "";
                this.disconnect(string);
                super.finalize();
            }
            catch (OaoException oaoException) {
                System.out.println("OaoException thrown [OaoInstance.finalize]: " + oaoException.getMessage() + ".");
            }
            catch (Throwable throwable) {
                System.out.println("Throwable exception thrown [OaoInstance.finalize]: " + throwable.getMessage() + ".");
            }
        }
    }

    public void closeAllCursors() {
        if (this.m_wCppIndex >= 0) {
            try {
                String string = "";
                Enumeration enumeration = this.m_vCursors.elements();
                while (enumeration.hasMoreElements()) {
                    OaoCursor oaoCursor = (OaoCursor)enumeration.nextElement();
                    oaoCursor.closeCursor(string);
                    oaoCursor = null;
                }
                this.m_vCursors.removeAllElements();
                this.m_vCursors.trimToSize();
            }
            catch (Exception exception) {
                System.out.println("Exception thrown [OaoInstance.closeAllCursors]: " + exception.getMessage() + ".");
            }
        }
    }

    public OaoCursor openCursor(String string) throws OaoException {
        int n = -1;
        if (this.m_wCppIndex >= 0 && (n = this.JInstOpenCursor(string)) < 0) {
            throw new OaoException("Error from JInstOpenCursor native method call.");
        }
        if (n >= 0) {
            OaoCursor oaoCursor = new OaoCursor(n, this.m_wCppIndex);
            this.insertCursor(oaoCursor);
            return oaoCursor;
        }
        return null;
    }

    public int disconnect(String string) throws OaoException {
        int n = 0;
        if (this.m_wCppIndex >= 0) {
            this.closeAllCursors();
            n = this.JInstDisconnect(string);
            this.m_wCppIndex = -1;
        }
        return n;
    }

    public void insertCursor(OaoCursor oaoCursor) {
        try {
            int n = this.m_vCursors.size();
            if (this.m_vCursors.capacity() <= n) {
                this.m_vCursors.ensureCapacity(n + 1);
            }
            this.m_vCursors.addElement(oaoCursor);
        }
        catch (Exception exception) {
            System.out.println("Exception thrown [OaoInstance.insertCursor]: " + exception.getMessage() + ".");
        }
    }

    public void removeCursor(OaoCursor oaoCursor) {
        try {
            int n = this.m_vCursors.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.m_vCursors.elementAt(n2) == oaoCursor) {
                    this.m_vCursors.removeElementAt(n2);
                    this.m_vCursors.trimToSize();
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception thrown [OaoInstance.removeCursor]: " + exception.getMessage() + ".");
        }
    }

    public int insertRow(String string, String string2, Vector vector) throws OaoException {
        try {
            return this.JInstInsertRow(string, string2, vector);
        }
        catch (Exception exception) {
            throw new OaoException("Exception thrown [OaoInstance.insertRow]: " + exception.getMessage() + ".");
        }
    }

    public int insertRow(String string, String string2, Vector vector, String string3) throws OaoException {
        try {
            return this.JInstInsertRow(string, string2, vector, string3);
        }
        catch (Exception exception) {
            throw new OaoException("Exception thrown [OaoInstance.insertRow]: " + exception.getMessage() + ".");
        }
    }

    public Vector getColumnListInfo(String string, String string2) throws OaoException {
        try {
            return this.JInstColumnListInfo(string, string2);
        }
        catch (Exception exception) {
            throw new OaoException("Exception thrown [OaoInstance.getColumnListInfo]: " + exception.getMessage() + ".");
        }
    }

    public Vector getEnvironmentInfo() throws OaoException {
        try {
            return this.JInstEnvironmentInfo();
        }
        catch (Exception exception) {
            throw new OaoException("Exception thrown [OaoInstance.getEnvironmentInfo]: " + exception.getMessage() + ".");
        }
    }

    public Vector getDatabaseInfo(String string) throws OaoException {
        try {
            return this.JInstDatabaseInfo(string);
        }
        catch (Exception exception) {
            throw new OaoException("Exception thrown [OaoInstance.getDatabaseInfo]: " + exception.getMessage() + ".");
        }
    }

    public Vector getTableInfo(String string) throws OaoException {
        try {
            return this.JInstTableInfo(string);
        }
        catch (Exception exception) {
            throw new OaoException("Exception thrown [OaoInstance.getTableInfo]: " + exception.getMessage() + ".");
        }
    }
}

