/*
 * Decompiled with CFR 0.152.
 */
package omnidex.oaobj;

import java.util.Enumeration;
import java.util.Vector;
import omnidex.oaobj.OaoException;
import omnidex.oaobj.OaoInstance;

public class OaoWorkSpace {
    private Vector m_vInstances = new Vector();
    protected int m_wCppIndex;
    protected String m_sPassword;
    protected String m_sUser;

    public native int JWorkSpaceConstructor();

    public native int JWorkSpaceConstructor(String var1, String var2);

    public native int JWorkSpaceDestructor();

    public native int JWorkSpaceConnect(String var1, String var2);

    public native String JWorkSpaceGetErrorMsg();

    public OaoWorkSpace() throws OaoException {
        int n = -1;
        this.m_sPassword = "";
        this.m_sUser = "";
        n = this.JWorkSpaceConstructor();
        if (n < 0) {
            throw new OaoException("Error instantiating native OaoWorkSpace object.");
        }
        this.m_wCppIndex = n;
    }

    public OaoWorkSpace(String string, String string2) throws OaoException {
        int n = -1;
        this.m_sPassword = string;
        this.m_sUser = string2;
        n = this.JWorkSpaceConstructor(string, string2);
        if (n < 0) {
            throw new OaoException("Error instantiating native OaoWorkSpace object.");
        }
        this.m_wCppIndex = n;
    }

    public OaoInstance connect(String string, String string2) throws OaoException {
        OaoInstance oaoInstance = null;
        int n = -1;
        try {
            n = this.JWorkSpaceConnect(string, string2);
            if (n >= 0) {
                oaoInstance = new OaoInstance(n);
                this.insertInstance(oaoInstance);
            } else {
                oaoInstance = null;
            }
        }
        catch (Exception exception) {
            throw new OaoException("Exception thrown [OaoWorkSpace.connect]: " + exception.getMessage() + ".");
        }
        return oaoInstance;
    }

    public String getErrorMessage() throws OaoException {
        try {
            if (this.m_wCppIndex >= 0) {
                String string = new String(this.JWorkSpaceGetErrorMsg());
                return string;
            }
            String string = new String("");
            return string;
        }
        catch (Exception exception) {
            throw new OaoException("Exception thrown [OaoWorkSpace.getErrorMessage]: " + exception.getMessage() + ".");
        }
    }

    public void finalize() {
        if (this.m_wCppIndex >= 0) {
            try {
                this.closeAllInstances();
                this.JWorkSpaceDestructor();
                super.finalize();
            }
            catch (Exception exception) {
                System.out.println("Exception thrown [OaoWorkSpace.finalize]: " + exception.getMessage() + ".");
            }
            catch (Throwable throwable) {
                System.out.println("Throwable exception thrown [OaoWorkSpace.finalize]: " + throwable.getMessage() + ".");
            }
        }
    }

    public void insertInstance(OaoInstance oaoInstance) {
        try {
            int n = this.m_vInstances.size();
            if (this.m_vInstances.capacity() <= n) {
                this.m_vInstances.ensureCapacity(n + 1);
            }
            this.m_vInstances.addElement(oaoInstance);
        }
        catch (Exception exception) {
            System.out.println("Exception thrown [OaoWorkSpace.insertInstance]: " + exception.getMessage() + ".");
        }
    }

    public void removeInstance(OaoInstance oaoInstance) {
        try {
            int n = this.m_vInstances.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.m_vInstances.elementAt(n2) == oaoInstance) {
                    this.m_vInstances.removeElementAt(n2);
                    this.m_vInstances.trimToSize();
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception thrown [OaoWorkSpace.removeInstance]: " + exception.getMessage() + ".");
        }
    }

    public void closeAllInstances() {
        if (this.m_wCppIndex >= 0) {
            try {
                String string = "";
                Enumeration enumeration = this.m_vInstances.elements();
                while (enumeration.hasMoreElements()) {
                    OaoInstance oaoInstance = (OaoInstance)enumeration.nextElement();
                    oaoInstance.disconnect(string);
                    oaoInstance = null;
                }
                this.m_vInstances.removeAllElements();
                this.m_vInstances.trimToSize();
            }
            catch (Exception exception) {
                System.out.println("OaoException thrown [OaoWorkSpace.closeAllInstances]: " + exception.getMessage() + ".");
            }
        }
    }

    static {
        try {
            System.loadLibrary("odxoaojni");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Error: Either can't find odxoaojni library or error during load." + unsatisfiedLinkError);
        }
        catch (SecurityException securityException) {
            System.err.println("Can't Load oao Library...Security Violation" + securityException);
        }
    }
}

