/************** DISC ODXClnt source header file - cloa.h *********************/
/*   This C language source file contains the Client OmniAccess Routines.    */
/*                                                                           */
/*                                                                           */
/*                      (c) 1997, Dynamic Information Systems Corporation    */
/*****************************************************************************/

/*******************  Omnidex Client version 3.2 code ************************/

#ifndef H_CLOA
#define H_CLOA


#if !defined (OA_H_DEFINED)
/********************** DEFINE STATEMENTS from oa.h 30700 ********************/

/* VARIABLE DECLARATION DEFINES */

#undef int32
#undef fcn_opts

#if defined (__hpux) || defined (__mpexl)
#define int32                     int
#elif defined (VMS) || defined (__osf__)
#define int32                     int
#elif defined (__sun)
#define int32                     int
#elif defined (_SEQUENT_)
#define int32                     int
#elif defined (_AIX)
#include <sys/types.h>
#define int32                     int
#elif defined (i386) || defined(__linux__)
#define int32    int
#elif defined (WIN32)
#define int32                     int
#elif defined (_WINDOWS) || defined (__MSDOS__) || defined (_MSDOS)
#define int32                     long
#endif


/* VARIABLE DECLARATION DEFINES */


/* Environment Variables and Definitions */

#define     OAVAR_OMNIDEX_LIBS                    "OMNIDEX_LIBS"
#define     OAVAR_OMNIDEX_REG                     "OMNIDEX_REG"
#define     OAVAR_GLOBAL_ENV_NAME                 "OAGLOBAL"
#define     OAVAR_DEBUG                           "OA_DEBUG"
#define     OAVAR_DATABASE_ACCESS                 "OA_DATABASE_ACCESS"


#define     OA_GLOBAL_MSG_ID_PREFIX               "OAMSG"
#define     OA_GLOBAL_HELP_PREFIX                 "OAHELP"

#if __mpexl
#define     OA_GLOBAL_ENV_NAME                    "OAGLOBAL"
#elif VAX
#define     OA_GLOBAL_ENV_NAME                    "OAGLOBAL.ENV"
#else
#define     OA_GLOBAL_ENV_NAME                    "oaglobal.env"
#endif


/* Tokens */

#define     OATOKEN_RECNO                         "$RECNO"
#define     OATOKEN_ROWID                         "$ROWID"
#define     OATOKEN_ODXID                         "$ODXID"
#define     OATOKEN_VALUES                        "$VALUES"
#define     OATOKEN_TOKEN_ID                      '$'

/* Sizes and limits */

#define     OAMAXSIZE_ENV_NAME                    32
#define     OAMAXSIZE_DB_NAME                     32
#define     OAMAXSIZE_USERNAME                    32
#define     OAMAXSIZE_PASSWORD                    32
#define     OAMAXSIZE_TABLE_NAME                  32
#define     OAMAXSIZE_COLUMN_NAME                 32
#define     OAMAXSIZE_NAME_PAIR                   76
#define     OAMAXSIZE_INDEX_NAME                  32
#define     OAMAXSIZE_INDEX_COMP_NAME             32
#define     OAMAXSIZE_FILENAME                    255
#define     OAMAXSIZE_ERROR_MSG                   255
#define     OAMAXSIZE_HELP_MSG                    32768
#define     OAMAXSIZE_OPTIONLIST                  256
#define     OAMAXSIZE_MESSAGE_ID                  32
#define     OAMAXSIZE_MESSAGE                     32768
#define     OAMAXSIZE_TABLELIST                   4096
#define     OAMAXSIZE_SELECTLIST                  65536
#define     OAMAXSIZE_CRITERIA                    65536
#define     OAMAXSIZE_ODX_CRITERIA                4096
#define     OAMAXSIZE_SQL_STATEMENT               65536
#define     OAMAXSIZE_OPERATOR                    24
#define     OAMAXSIZE_VALUE                       64
#define     OAMAXSIZE_VALUES_LABEL                8
#define     OAMAXSIZE_TAGNAME                     30
#define     OAMAXSIZE_EXPORT_SIZE                 65536
#define     OAMAXSIZE_TITLE                       80
#define     OAMAXSIZE_VERSION                     32
#define     OAMAXSIZE_PROMPT                      32
#define     OAMAXSIZE_HEADING                     32
#define     OAMAXSIZE_LABEL                       32
#define     OAMAXSIZE_SAVEPOINT                   32

#define     OALIMIT_MAX_OPERANDS                  64
#define     OALIMIT_MAX_VALUES                    256
#define     OALIMIT_MAX_VERSIONS                  160
#define     OALIMIT_TIDMAP_ENTRIES                6
#define     OALIMIT_USER_DBS_PER_ENV              1
#define     OALIMIT_TBLS_PER_DB                   1024 
#define     OALIMIT_PRI_CONSTS_PER_TBL            1
#define     OALIMIT_FOR_CONSTS_PER_TBL            31
#define     OALIMIT_COLS_PER_TBL                  1024
#define     OALIMIT_RECLEN_PER_TBL                65536

#define     OADEFAULT_EXPORT_LIMIT                10000000
#define     OADEFAULT_EXPORT_SIZE                 65536
#ifdef __mpexl
#define     OADEFAULT_EXPORT_PROGRESS_FILE        "exportlg"
#else
#define     OADEFAULT_EXPORT_PROGRESS_FILE        "export.log"
#endif
#define     OADEFAULT_CHAR_SIZE                   32
#define     OADEFAULT_APPROX_MATCH_TOLERANCE      2.0e-7

/* oadescribe types */

#define     OA_COLUMN_IDENTIFIER                  1
#define     OA_COLUMN_INTEGER                     2
#define     OA_COLUMN_FLOAT                       3
#define     OA_COLUMN_LITERAL                     4
#define     OA_COLUMN_EXPRESSION                  5

/* subtypes */
#define     OA_COLUMN_SUBTYPE_PSEUDO              1

/* datatypes used in oadescribe, oabind, oa___info, etc. */

#define     OADATATYPE_MIXED                      99    /* for indexes only */
#define     OADATATYPE_CHAR                       100
#define     OADATATYPE_C_STRING                   201
#define     OADATATYPE_SIGNED_INT                 300
#define     OADATATYPE_INTEGER                    300
#define     OADATATYPE_UNSIGN_INT                 400
#define     OADATATYPE_BOOLEAN                    500
#define     OADATATYPE_BITMAP                     501
#define     OADATATYPE_FLOAT                      600
#define     OADATATYPE_HP_REAL                    601
#define     OADATATYPE_HP_FLOAT                   601
#define     OADATATYPE_D_FLOAT                    602
#define     OADATATYPE_G_FLOAT                    603
#define     OADATATYPE_F_FLOAT                    604
#define     OADATATYPE_PACKED                     700
#define     OADATATYPE_ZONED                      800
#define     OADATATYPE_R_O_ZONED                  800
#define     OADATATYPE_R_EBCDIC_O_ZONED           800
#define     OADATATYPE_L_O_ZONED                  801
#define     OADATATYPE_L_EBCDIC_O_ZONED           801
#define     OADATATYPE_R_S_ZONED                  802
#define     OADATATYPE_L_S_ZONED                  803
#define     OADATATYPE_UNSIGN_ZONED               804
#define     OADATATYPE_DIBOL_ZONED                805
#define     OADATATYPE_R_ASCII_O_ZONED            805
#define     OADATATYPE_L_ASCII_O_ZONED            806
#define     OADATATYPE_RADIX50                    900
#define     OADATATYPE_DATE                       1000  /* yyyy-mm-dd */
#define     OADATATYPE_INFORMIX_DATE              1001
#define     OADATATYPE_PH_DATE                    1002
#define     OADATATYPE_ASK_DATE                   1003
#define     OADATATYPE_J_DATE                     1004
#define     OADATATYPE_MM_DATE                    1005
#define     OADATATYPE_RSI_DATE                   1006
#define     OADATATYPE_ODBC_DATE                  1007
#define     OADATATYPE_ASCII_DATE                 1008
#define     OADATATYPE_OMNIDEX_DATE               1099
#define     OADATATYPE_TIME                       1100  /* hh:mm:ss.ff */
#define     OADATATYPE_ODBC_TIME                  1101
#define     OADATATYPE_OMNIDEX_TIME               1199
#define     OADATATYPE_DATETIME                   1200/*yyyy-mm-dd hh:mm:ss.ff*/
#define     OADATATYPE_VMS_DATETIME               1201
#define     OADATATYPE_ORACLE_DATETIME            1202
#define     OADATATYPE_SYBASE_DATETIME            1204
#define     OADATATYPE_C_DATETIME                 1205
#define     OADATATYPE_INFORMIX_DATETIME          1206
#define     OADATATYPE_ODBC_DATETIME              1207
#define     OADATATYPE_OMNIDEX_DATETIME           1299
#define     OADATATYPE_DISC_DATETIME              1299
#define     OADATATYPE_ORACLE_ROWID               1501
#define     OADATATYPE_RMS_ROWID                  1502
#define     OADATATYPE_IMAGE_ROWID                1503
#define     OADATATYPE_FLATFILE_ROWID             1504
#define     OADATATYPE_INFORMIX_ROWID             1506
#define     OADATATYPE_SYBASE_ROWID               1507
#define     OADATATYPE_ISAM_ROWID                 1508
#define     OADATATYPE_CISAM_ROWID                1509
#define     OADATATYPE_ODBC_ROWID                 1510
#define     OADATATYPE_DISAM_ROWID                1511
#define     OADATATYPE_RECNO                      1600


/* datatypes used in oadescribe, oabind, oa___info, etc. */

#define     OADATAUSAGE_CURRENCY                  1
#define     OADATAUSAGE_DATE                      2
#define     OADATAUSAGE_TIME                      3
#define     OADATAUSAGE_DATETIME                  4
#define     OADATAUSAGE_FILENAME                  5
#define     OADATAUSAGE_FILEOPTIONS               6
#define     OADATAUSAGE_FILEOFFSET                7
#define     OADATAUSAGE_FILELENGTH                8
#define     OADATAUSAGE_ROWID                     9
#define     OADATAUSAGE_AUTO_ROWID                10


/* Function Defines for  Oa_last_function */
#define     OAFUNCTION_ASSIGNVALUES               1
#define     OAFUNCTION_BEGIN                      2
#define     OAFUNCTION_BIND                       3
#define     OAFUNCTION_CLOSECURSOR                4
#define     OAFUNCTION_COLUMNLISTINFO             5
#define     OAFUNCTION_COMMAND                    6
#define     OAFUNCTION_COMMIT                     7
#define     OAFUNCTION_CONNECT                    8
#define     OAFUNCTION_CONVERTDATA                9
#define     OAFUNCTION_COPYFILE                   10
#define     OAFUNCTION_CURSORINFO                 11
#define     OAFUNCTION_DATABASEINFO               12
#define     OAFUNCTION_DBINFO                     13
#define     OAFUNCTION_DELETE                     14
#define     OAFUNCTION_DELETEINDEX                15
#define     OAFUNCTION_DELETEWHERE                16
#define     OAFUNCTION_DESCRIBE                   17
#define     OAFUNCTION_DISCONNECT                 18
#define     OAFUNCTION_DROPTABLE                  19
#define     OAFUNCTION_ENVIRONMENTINFO            20
#define     OAFUNCTION_ERROR                      21
#define     OAFUNCTION_EXECDB                     22
#define     OAFUNCTION_EXECSQL                    23
#define     OAFUNCTION_EXPORT                     24
#define     OAFUNCTION_EXTERNAL                   25
#define     OAFUNCTION_FETCH                      26
#define     OAFUNCTION_FETCHKEYS                  27
#define     OAFUNCTION_FORM                       28
#define     OAFUNCTION_INDEXINFO                  29
#define     OAFUNCTION_INSERT                     30
#define     OAFUNCTION_INSERTINDEX                31
#define     OAFUNCTION_JOIN                       32
#define     OAFUNCTION_LIST                       33
#define     OAFUNCTION_MESSAGE                    34
#define     OAFUNCTION_OPENCURSOR                 35
#define     OAFUNCTION_QUALIFY                    36
#define     OAFUNCTION_ROLLBACK                   37
#define     OAFUNCTION_SAVEPOINT                  38
#define     OAFUNCTION_SELECT                     39
#define     OAFUNCTION_SHOW                       40
#define     OAFUNCTION_STATEMENTINFO              41
#define     OAFUNCTION_TABLEINFO                  42
#define     OAFUNCTION_UPDATE                     43
#define     OAFUNCTION_UPDATEINDEX                44
#define     OAFUNCTION_UPDATEWHERE                45
#define     OAFUNCTION_VERSION                    46

/* The following are used both in select/fetch from the environment file
   (system catalog) and in oa___info routines return values */

/* Byte order of host, passed back in status->OA_ENDIAN from oa___info() */

#define     OA_LITTLE_ENDIAN                      0
#define     OA_BIG_ENDIAN                         1

/* oaenv_t "precedence" */

#define     OA_OPER_PREC_NOT_AND_OR               1
#define     OA_OPER_PREC_NOT_OR_AND               2

/* oadb_t "type" */

#define     OA_DATABASETYPE_ORACLE                1
#define     OA_DATABASETYPE_INGRES                2
#define     OA_DATABASETYPE_INFORMIX              3
#define     OA_DATABASETYPE_SYBASE                4
#define     OA_DATABASETYPE_INTERBASE             5
#define     OA_DATABASETYPE_ALLBASE               6
#define     OA_DATABASETYPE_RDB                   7
#define     OA_DATABASETYPE_FOCUS                 8
#define     OA_DATABASETYPE_TURBOIMAGE            9
#define     OA_DATABASETYPE_IMAGESQL              10
#define     OA_DATABASETYPE_RMS                   11
#define     OA_DATABASETYPE_ISAM                  12
#define     OA_DATABASETYPE_CISAM                 13
#define     OA_DATABASETYPE_FLATFILE              14
#define     OA_DATABASETYPE_VIRTUAL               15
#define     OA_DATABASETYPE_LOGICAL               OA_DATABASETYPE_VIRTUAL
#define     OA_DATABASETYPE_CDD                   16
#define     OA_DATABASETYPE_PDL                   17
#define     OA_DATABASETYPE_IMSAM                 18
#define     OA_DATABASETYPE_ODBC                  19
#define     OA_DATABASETYPE_DISAM                 20
#define     OA_DATABASETYPE_UNION                 21
#define     OA_DATABASETYPE_DB2                   22
#define     OA_DATABASETYPE_SQL_DEVELOPMENT       219
#define     OA_DATABASETYPE_TBL_DEVELOPMENT       220
#define     OA_DATABASETYPE_ENVMAP                223

/* oadb_t "subtype" */

#define     OA_DATABASE_SUBTYPE_UNKNOWN           0
#define     OA_DATABASE_SUBTYPE_ORACLE            1
#define     OA_DATABASE_SUBTYPE_INFORMIX          2
#define     OA_DATABASE_SUBTYPE_SYBASE            3
#define     OA_DATABASE_SUBTYPE_DB2               4
#define     OA_DATABASE_SUBTYPE_SQLSERVER         5
#define     OA_DATABASE_SUBTYPE_ACCESS            6

/* oadb_t "access_flag" */

#define     OA_DATABASEACCESS_READ_ONLY           1
#define     OA_DATABASEACCESS_READ_WRITE          2
#define     OA_DATABASEACCESS_ASSUMED_UPDATE      3

/* oadb_t "locking_flag" */

#define     OA_DATABASELOCKING_STANDARD           1
#define     OA_DATABASELOCKING_OPTIMISTIC         2


/* oadb_t "classification" */

#define     OA_DATABASECLASS_SQL                  1
#define     OA_DATABASECLASS_TABLE                3

/* oatbl_t "type" */

#define     OA_TABLETYPE_INDEXED                  1    /* rms only */
#define     OA_TABLETYPE_SEQUENTIAL               2    /* rms only */
#define     OA_TABLETYPE_RELATIVE                 3    /* rms only */
#define     OA_TABLETYPE_STREAM                   4    /* rms only */
#define     OA_TABLETYPE_LF                       5    /* flatfile only */
#define     OA_TABLETYPE_NOLF                     6    /* flatfile only */
#define     OA_TABLETYPE_RELATIONAL               7
#define     OA_TABLETYPE_DETAIL                   8    /* TurboIMAGE only */
#define     OA_TABLETYPE_MANUAL                   9    /* TurboIMAGE only */
#define     OA_TABLETYPE_AUTO                     10   /* TurboIMAGE only */
#define     OA_TABLETYPE_IMSAM                    11
#define     OA_TABLETYPE_PRESORTED                12
#define     OA_TABLETYPE_MERGED                   13
#define     OA_TABLETYPE_OST                      14   /* flatfile only */
#define     OA_TABLETYPE_TDF                      15   /* flatfile only */
#define     OA_TABLETYPE_DEVELOPMENT              221
#define     OA_TABLETYPE_AGGREGATE_VIEW           222
#define     OA_TABLETYPE_VIEW                     223  /* relational DBs only */


/* oatbl_t "odx_table_type", oacursor_t "odx_list_type", and
   oaidx_t "owner_odx_table_type" */

#define     OA_ODX_TYPE_NONE                      0  /* No omnidex installed */
#define     OA_ODX_TYPE_IDSI                      1
#define     OA_ODX_TYPE_TR                        2
#define     OA_ODX_TYPE_TRR                       3
#define     OA_ODX_TYPE_DR                        4
#define     OA_ODX_TYPE_LINKED_CHILD              5
#define     OA_ODX_TYPE_RS_CHILD                  6  /* odx_list_type only */
#define     OA_ODX_TYPE_RC_CHILD                  7  /* odx_list_type only */
#define     OA_ODX_TYPE_ASK_ONLY                  8
#define     OA_ODX_TYPE_IMSAM_ONLY                OA_ODX_TYPE_ASK_ONLY
#define     OA_ODX_TYPE_HYBRID_DR                 9
#define     OA_ODX_TYPE_UNKNOWN                   99

/* oaconst_t "type" */

#define     OA_CONSTRAINTTYPE_PRIMARY_KEY         1
#define     OA_CONSTRAINTTYPE_FOREIGN_KEY         2

/* oacol_t "type" */

#define     OA_COLUMNTYPE_NATIVE                  1
#define     OA_COLUMNTYPE_VIRTUAL                 2

/* oacol_t "datatype" values: refer to OADATATYPE #defines above */

/* oaidx_t "method" */

#define     OA_INDEXTYPE_HASHED                   1
#define     OA_INDEXTYPE_LINKED                   2
#define     OA_INDEXTYPE_SORTED                   3
#define     OA_INDEXTYPE_INVERTED                 4
#define     OA_INDEXTYPE_OMNIDEX_ASK              5
#define     OA_INDEXTYPE_ODX_SORTED               OA_INDEXTYPE_OMNIDEX_ASK 
#define     OA_INDEXTYPE_OMNIDEX_MDK              6
#define     OA_INDEXTYPE_ODX_INVERTED             OA_INDEXTYPE_OMNIDEX_MDK 
#define     OA_INDEXTYPE_AGGREGATE                7
#define     OA_INDEXTYPE_ARRAYED_AGGREGATE        8

/* optimization types */

#define     OA_OPT_USING_ASK                      1
#define     OA_OPT_USING_IMSAM                    OA_OPT_USING_ASK 
#define     OA_OPT_USING_MDK_COUNT                2
#define     OA_OPT_USING_ODX_COUNT                OA_OPT_USING_MDK_COUNT 
#define     OA_OPT_MEMORY_MULTIFIND               3
#define     OA_OPT_FILE_MULTIFIND                 4
#define     OA_OPT_COMPRESS                       5
#define     OA_OPT_EXPAND                         6
#define     OA_OPT_COMPRESS_AND_EXPAND            7
#define     OA_OPT_DEFERRED_COMPRESS              8
#define     OA_OPT_DEFERRED_EXPAND                9
#define     OA_OPT_DEFERRED_COMP_AND_EXPAND      10
#define     OA_OPT_BITMAP_JOIN                   11
#define     OA_OPT_UNDO                          12
#define     OA_OPT_PRESERVE_RS                   13
#define     OA_OPT_DEFERRED_PRESERVE_RS          14
#define     OA_OPT_DEFERRED_BITMAP_JOIN          15

/* oaidx_component_t "type" */

#define     OA_IXCOMPTYPE_DATA                    1
#define     OA_IXCOMPTYPE_TARGET_PRIMARY_SI       4
#define     OA_IXCOMPTYPE_TARGET_FOREIGN_SI       5
#define     OA_IXCOMPTYPE_TARGET_RECNO            6
#define     OA_IXCOMPTYPE_TARGET_ROWID            7

/* oacursor_t "cursor_state" */

#define     OA_CURSORSTATE_EMPTY                  1
#define     OA_CURSORSTATE_LOADED                 2
#define     OA_CURSORSTATE_DESCRIBED              3
#define     OA_CURSORSTATE_BOUND                  4
#define     OA_CURSORSTATE_CUSTOM                 5
#define     OA_CURSORSTATE_ACTIVE                 6
#define     OA_CURSORSTATE_DEACTIVATED            7

/* statement-id returned by oaexecsql */

#define     OASTATEMENT_COMMAND                   1 
#define     OASTATEMENT_CONNECT                   2
#define     OASTATEMENT_OPEN                      3
#define     OASTATEMENT_QUALIFY                   4
#define     OASTATEMENT_JOIN                      5
#define     OASTATEMENT_SELECT                    6
#define     OASTATEMENT_SELECT_INTO               7
#define     OASTATEMENT_SELECT_BENCHMARK          8
#define     OASTATEMENT_EXPORT                    9
#define     OASTATEMENT_INSERT                    10
#define     OASTATEMENT_UPDATE                    11
#define     OASTATEMENT_DELETE                    12
#define     OASTATEMENT_CLOSE                     13
#define     OASTATEMENT_DISCONNECT                14
#define     OASTATEMENT_SET                       15
#define     OASTATEMENT_VERSION                   16
#define     OASTATEMENT_ATTACH                    17
#define     OASTATEMENT_DETACH                    18
#define     OASTATEMENT_DROP                      19
#define     OASTATEMENT_CREATE_TABLE              20
#define     OASTATEMENT_ASSIGNVALUES              21
#define     OASTATEMENT_INSERTINDEX               22
#define     OASTATEMENT_DELETEINDEX               23
#define     OASTATEMENT_UPDATEINDEX               24


/* OA_PREPROCESSOR_STATES describe the current state of the processor */
#define     OA_PREPROCESSOR_STATE_STUB            -1
#define     OA_PREPROCESSOR_STATE_OFF             0
#define     OA_PREPROCESSOR_STATE_ON              1

/* OA_PREPROCESSOR_ACTION describe the action for oap_state */
#define     OA_PREPROCESSOR_ACTION_OFF            0
#define     OA_PREPROCESSOR_ACTION_ON             1
#define     OA_PREPROCESSOR_ACTION_POLL           2


/* oastatus data elements */

#define     OA_AUTOID                             data[0]
#define     OA_PARENT_COUNT                       data[0]
#define     OA_GROUP_COUNT                        data[0]
#define     OA_PREINTERSECT_COUNT                 data[1]
#define     OA_PREINT_COUNT                       data[1]
#define     OA_VERSION_NUMBER                     data[1]
#define     OA_NUM_COLS                           data[2]
#define     OA_IDX_ENTRIES                        data[2]
#define     OA_INDEX_RS                           data[2]
#define     OA_OPTIMIZATION                       data[3]
#define     OA_STATEMENT_ID                       data[3]
#define     OA_ENDIAN                             data[4]
#define     OA_INDEX_SI_LEN                       data[4]
#define     OA_VALUE_SIZE                         data[4]
#define     OA_MAXFOPENS                          data[4]
#define     OA_INDEX_MAX_KEY_LENGTH               data[5]
#define     OA_RECNO                              data[5]
#define     OA_IABASEID                           data[5]

/* data returned by VERSION command of oaexecsql() */
#define     OA_OMNIACCESS_VERSION                 data[0]
#define     OA_INDEXACCESS_VERSION                data[1]
#define     OA_BUILD_VERSION                      data[2]


/* OA_SELECT_TYPES is for ways of describing the type of SQL statement*/
#define     OA_SELECT_TYPE                        data[1]
#define     OA_SELECT_TYPE_NONE                        0
#define     OA_SELECT_TYPE_INTO                        1



#endif

/* client specific oastatus data usages */
/* oaconnect */
#define     CL_OA_VERSION_NUMBER                  data[0]
#define     OAMAXSIZE_NODENAME                    32
/* oainsertindex, etc. */
#define     OA_BUFFER_LEN                         data[0]
#define     OA_ROWID                              data[1]
#define     OA_BEFORE_BUFFER_LEN                  data[2]
#define     OA_BEFORE_ROWID                       data[3]


#if !defined (OA_H_DEFINED)
/**************************** TYPE DECLARACTIONS      ************************/

/*  oastatus_t is a type declaration for the OmniAccess status               */
/*  array, which is used in nearly all OmniAccess routines                   */

typedef struct oastatus_30600
{
  int                   error;
  int                   warn;
  int                   info;
  int                   count;
  int                   bufflen;
  int                   instance;
  int                   cursor;
  int                   transaction;
  int                   data[6];
  char                  buffer[36];
} oastatus_30600_t;


typedef struct oastatus
{
  int                   error;
  int                   warn;
  int                   info;
  int                   count;
  int                   bufflen;
  int                   instance;
  int                   cursor;
  int                   transaction;
  int                   cpu;
  int                   elapsed;
  int                   data[32];
  char                  buffer[256];
  char                  native_error[256];
  char                  location[256]; /* In form of: file(routine):line */
  char                  context[256];
  char                  msgs[8][256];
  char                  reserved[1024];
} oastatus_t;


/*  oaselect_list_t is a type declaration for the OmniAccess select          */
/*  list control blocks.  These control blocks are used exclusively          */
/*  by the oadescribe() and oabind() functions.                              */

typedef struct oaselect_list
{
  int                   type;
  int                   subtype;
  union
  {
    char                expression[132];
    char                literal[132];
    char                numeric[36];
    struct
    {
      char              environment[33];
      char              database[33];
      char              table[33];
      char              column[33];
    } column;
  } select_item;
  char                  alias[36];
  int                   datatype;
  int                   length;
  int                   usage;
  int                   occurrences;
  int                   offset;
  char                  options[64];
  int                   req_datatype;
  int                   req_length;
  int                   req_usage;
  int                   req_offset;
  char                  req_options[64];
#if defined __osf__
  int                   data;
  int                   null_indicator;
#else
  char                  *data;
  int                   *null_indicator;
#endif
} oaselect_list_t;

typedef struct oaversion
{
  char                  tag[16];
  char                  product[64];
  int                   version_no;
  char                  version[256];
} oaversion_t;

#endif


/* Client Specific definitions */
#define OALOCAL_NODENAME          "$LOCAL"


#define HOAINSTANCE                 int32
#define HOACURSOR                   int32

#define LPHOAINSTANCE               HOAINSTANCE FAR *
#define LPHOACURSOR                 HOACURSOR FAR *

#define OASTATUS                    oastatus_t
#define LPOASTATUS                  oastatus_t FAR *

#define OASELECTLIST                oaselect_list_t
#define LPOASELECTLIST              OASELECTLIST FAR *

#define OASELECTSHORTLIST           oaselect_shortlist_t
#define LPOASELECTSHORTLIST         OASELECTSHORTLIST FAR *

#define OAVERSION                   oaversion_t
#define LPOAVERSION                 OAVERSION FAR *


#if defined fcn_opts
#undef fcn_opts
#endif

#if defined FCN_OPTS
#undef FCN_OPTS
#endif



#if defined(WIN32)
# define FCN_OPTS  __stdcall
# define fcn_opts  __stdcall
#elif defined (_WINDOWS)
# define FCN_OPTS PASCAL FAR 
# define fcn_opts PASCAL FAR 
#else
# define FCN_OPTS
# define fcn_opts
#endif

#define API_STATUS      DWORD

#if !defined (_WINDOWS)
# ifndef DWORD
#  define DWORD   int
# endif
# ifndef LPCSTR
#  define LPCSTR  const char *
# endif
# ifndef LPSTR
#  define LPSTR   char *
# endif
# ifndef LPVOID
#  define LPVOID  void *
# endif
# ifndef LPLONG
#  define LPLONG  int *
# endif
# ifndef FAR
#  define FAR 
# endif
#endif



#ifdef __cplusplus
extern "C" {                    /* Assume C declarations for C++ */
#endif /* __cplusplus */


API_STATUS FCN_OPTS   CLoaconnect(
        LPCSTR                                  lpszEnvironment,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszUser,
        LPCSTR                                  lpszPassword,
        LPHOAINSTANCE                           lphLocalInstance );


API_STATUS FCN_OPTS   CLoadisconnect(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus );


API_STATUS FCN_OPTS   CLoaopencursor(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPHOACURSOR                             lphLocalCursor );


API_STATUS FCN_OPTS   CLoaclosecursor(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus );


API_STATUS FCN_OPTS   CLoaqualify(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszOwner,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumn,
        LPCSTR                                  lpszCriteria );


API_STATUS FCN_OPTS   CLoajoin(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszFromTable,
        LPCSTR                                  lpszFromColumn,
        LPCSTR                                  lpszToOwner,
        LPCSTR                                  lpszToTable,
        LPCSTR                                  lpszToColumn );


API_STATUS FCN_OPTS CLoaexecsql(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszSQLStatement);


API_STATUS FCN_OPTS CLoaexecdb(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszDataBase,
        LPCSTR                                  lpszStatement);

API_STATUS FCN_OPTS CLoadroptable(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable);


API_STATUS FCN_OPTS   CLoaselect(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumn,
        LPCSTR                                  lpszCriteria );


API_STATUS FCN_OPTS   CLoadescribe(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwNumItems,
        LPOASELECTLIST                          lpOASelectList );


API_STATUS FCN_OPTS   CLoabind(       
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwNumItems,
        LPOASELECTLIST                          lpOASelectList );


API_STATUS FCN_OPTS   CLoaassignvalues(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszLabel,
        DWORD                                   dwCount,
        LPVOID                                  lpValues );


API_STATUS FCN_OPTS   CLoafetch(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwCount,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   CLoaexport(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszFilename );


API_STATUS FCN_OPTS   CLoafetchkeys(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwCount,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   CLoainsert(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   CLoaupdate(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   CLoadelete(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable );


API_STATUS FCN_OPTS   CLoaupdatewhere(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPCSTR                                  lpszCriteria,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   CLoadeletewhere(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTables,
        LPCSTR                                  lpszCriteria );


API_STATUS FCN_OPTS   CLoainsertindex(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpvBuffer,
        LPVOID                                  lpvRowid );


API_STATUS FCN_OPTS   CLoaupdateindex(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpvBeforeBuffer,
        LPVOID                                  lpvBeforeRowid,
        LPVOID                                  lpvAfterBuffer,
        LPVOID                                  lpvAfterRowid );


API_STATUS FCN_OPTS   CLoadeleteindex(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpvFullBuffer,
        LPVOID                                  lpvRowid );


API_STATUS FCN_OPTS   CLoabegin(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus );


API_STATUS FCN_OPTS   CLoasavepoint(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszSavePoint );


API_STATUS FCN_OPTS   CLoarollback(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszSavePoint );


API_STATUS FCN_OPTS   CLoacommit(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus );


LPSTR FCN_OPTS        CLoaerror(
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszOptions,
        LPSTR                                   lpszMessage );


API_STATUS FCN_OPTS   CLoalist(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPCSTR                                  lpszCriteria,
        DWORD                                   dwCount,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   CLoaform(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumn,
        DWORD                                   dwCount,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   CLoadebug(
        HOACURSOR                               hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode );


API_STATUS FCN_OPTS   CLoadebugsettings(
        HOACURSOR                               hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszSettings);


API_STATUS FCN_OPTS   CLoaversion(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        DWORD                                   dwNumVersions,
        LPOAVERSION                             lpOAVersion );


API_STATUS FCN_OPTS   CLoacommand(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPVOID                                  lpvCommandInput,
        DWORD                                   dwInputLength,
        LPVOID                                  lpvCommandOutput,
        DWORD                                   dwOutputLength );


API_STATUS FCN_OPTS   CLoaexternal(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszLibName,
        LPCSTR                                  lpszRoutineName,
        LPVOID                                  lpvRoutineInput,
        DWORD                                   dwInputLength,
        LPVOID                                  lpvRoutineOutput,
        DWORD                                   dwOutputLength );



API_STATUS FCN_OPTS   CLoaenvironmentinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpEnvironmentName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );

API_STATUS FCN_OPTS   CL_oaenvironmentinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpEnvironmentName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );

API_STATUS FCN_OPTS   CLoadatabaseinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpDatabaseName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );

API_STATUS FCN_OPTS   CL_oadatabaseinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpDatabaseName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );

API_STATUS FCN_OPTS   CLoatableinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpTableName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );

API_STATUS FCN_OPTS   CL_oatableinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpTableName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );

API_STATUS FCN_OPTS   CLoaindexinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpIndexName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   CLoacolumnlistinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpTableName,
        LPCSTR                                  lpColumnList,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   CLoacursorinfo(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   CLoastatementinfo(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );
API_STATUS FCN_OPTS CL_oastatementinfo(
                                    HOACURSOR           hLocalCursor,
                                    LPCSTR              lpszOptions,
                                    LPOASTATUS          lpOAStatus,
                                    DWORD               dwBuffsize,
                                    LPVOID              lpvBuffer);


API_STATUS FCN_OPTS   CLoacopyfile(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszFromNode,
        LPCSTR                                  lpszFromFileName,
        LPCSTR                                  lpszFromFileOptions,
        LPCSTR                                  lpszToNode,
        LPCSTR                                  lpszToFileName,
        LPCSTR                                  lpszToFileOptions );



LPSTR FCN_OPTS   CLoabanner(
        LPSTR                                   lpszBanner,
        LPCSTR                                  lpszTitle,
        DWORD                                   dwProductNo,
        DWORD                                   dwVersion,
        LPCSTR                                  lpszComments );


/* client/server only routines -- currently undocumented */

API_STATUS FCN_OPTS   CLoaexportenv(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszName,
        LPCSTR                                  lpszValue );


API_STATUS FCN_OPTS   CLoagetenv(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszName,
        DWORD                                   dwValuesize,
        LPCSTR                                  lpvValue );

API_STATUS FCN_OPTS   CLoacancel(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus);



/*  M A I N   O M N I A C C E S S   R O U T I N E S  */


#if !defined (OA_H_DEFINED)

API_STATUS FCN_OPTS   oaconnect(
        LPCSTR                                  lpszEnvironment,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszUser,
        LPCSTR                                  lpszPassword,
        LPHOAINSTANCE                           lphLocalInstance );


API_STATUS FCN_OPTS   oadisconnect(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus );


API_STATUS FCN_OPTS   oaopencursor(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPHOACURSOR                             lphLocalCursor );


API_STATUS FCN_OPTS   oaclosecursor(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus );


API_STATUS FCN_OPTS   oaqualify(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszOwner,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumn,
        LPCSTR                                  lpszCriteria );


API_STATUS FCN_OPTS   oajoin(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszFromTable,
        LPCSTR                                  lpszFromColumn,
        LPCSTR                                  lpszToOwner,
        LPCSTR                                  lpszToTable,
        LPCSTR                                  lpszToColumn );


API_STATUS FCN_OPTS   oaselect(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumn,
        LPCSTR                                  lpszCriteria );


API_STATUS FCN_OPTS oaexecsql(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszSQLStatement);


API_STATUS FCN_OPTS oaexecdb(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszDataBase,
        LPCSTR                                  lpszStatement);

API_STATUS FCN_OPTS oadroptable(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable);


API_STATUS FCN_OPTS   oadescribe(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwNumItems,
        LPOASELECTLIST                          lpOASelectList );


API_STATUS FCN_OPTS   oabind(       
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwNumItems,
        LPOASELECTLIST                          lpOASelectList );


API_STATUS FCN_OPTS   oaassignvalues(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszLabel,
        DWORD                                   dwCount,
        LPVOID                                  lpValues );


API_STATUS FCN_OPTS   oafetch(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwCount,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   oaexport(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszFilename );


API_STATUS FCN_OPTS   oafetchkeys(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwCount,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   oainsert(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   oaupdate(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   oadelete(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable );


API_STATUS FCN_OPTS   oaupdatewhere(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPCSTR                                  lpszCriteria,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   oadeletewhere(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTables,
        LPCSTR                                  lpszCriteria );


API_STATUS FCN_OPTS   oainsertindex(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpvBuffer,
        LPVOID                                  lpvRowid );


API_STATUS FCN_OPTS   oaupdateindex(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpvBeforeBuffer,
        LPVOID                                  lpvBeforeRowid,
        LPVOID                                  lpvAfterBuffer,
        LPVOID                                  lpvAfterRowid );


API_STATUS FCN_OPTS   oadeleteindex(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPVOID                                  lpvFullBuffer,
        LPVOID                                  lpvRowid );


API_STATUS FCN_OPTS   oabegin(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus );


API_STATUS FCN_OPTS   oasavepoint(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszSavePoint );


API_STATUS FCN_OPTS   oarollback(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszSavePoint );


API_STATUS FCN_OPTS   oacommit(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus );


LPSTR FCN_OPTS        oaerror(
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszOptions,
        LPSTR                                   lpszMessage );


API_STATUS FCN_OPTS   oalist(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumns,
        LPCSTR                                  lpszCriteria,
        DWORD                                   dwCount,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   oaform(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszTable,
        LPCSTR                                  lpszColumn,
        DWORD                                   dwCount,
        LPVOID                                  lpBuffer );


API_STATUS FCN_OPTS   oadebug(
        HOACURSOR                               hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode );

API_STATUS FCN_OPTS   oadebugsettings(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszSettings);


API_STATUS FCN_OPTS   oaversion(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        DWORD                                   dwNumVersions,
        LPOAVERSION                             lpOAVersion );


API_STATUS FCN_OPTS   oacommand(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPVOID                                  lpvCommandInput,
        DWORD                                   dwInputLength,
        LPVOID                                  lpvCommandOutput,
        DWORD                                   dwOutputLength );


API_STATUS FCN_OPTS   oaexternal(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszLibName,
        LPCSTR                                  lpszRoutineName,
        LPVOID                                  lpvRoutineInput,
        DWORD                                   dwInputLength,
        LPVOID                                  lpvRoutineOutput,
        DWORD                                   dwOutputLength );



API_STATUS FCN_OPTS   oaenvironmentinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpEnvironmentName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   oadatabaseinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpDatabaseName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   oatableinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpTableName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   oaindexinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpIndexName,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   oacolumnlistinfo(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpTableName,
        LPCSTR                                  lpColumnList,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   oacursorinfo(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );


API_STATUS FCN_OPTS   oastatementinfo(
        HOACURSOR                               hLocalCursor,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        DWORD                                   dwBuffSize,
        LPVOID                                  lpvBuffer );

API_STATUS FCN_OPTS   oacopyfile(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszFromNode,
        LPCSTR                                  lpszFromFileName,
        LPCSTR                                  lpszFromFileOptions,
        LPCSTR                                  lpszToNode,
        LPCSTR                                  lpszToFileName,
        LPCSTR                                  lpszToFileOptions );



/* host only routines -- currently not supported in client server */

API_STATUS FCN_OPTS   oaconvertdata(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPVOID                                  lpvInputData,
        LPCSTR                                  lpszInputType,
        DWORD                                   dwInputLength,
        LPVOID                                  lpvOutputData,
        LPCSTR                                  lpszOutputType,
        DWORD                                   dwOutputLength );


LPSTR FCN_OPTS   oabanner(
        LPSTR                                   lpszBanner,
        LPCSTR                                  lpszTitle,
        DWORD                                   dwProductNo,
        DWORD                                   dwVersion,
        LPCSTR                                  lpszComments );


API_STATUS FCN_OPTS   oashow(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus );



API_STATUS FCN_OPTS   oamessage(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszMessageId,
        LPCSTR                                  lpszMessage );


/* client/server only routines -- currently undocumented */

API_STATUS FCN_OPTS   oaexportenv(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszName,
        LPCSTR                                  lpszValue );


API_STATUS FCN_OPTS   oagetenv(
        HOAINSTANCE                             hLocalInstance,
        LPCSTR                                  lpszOptions,
        LPOASTATUS                              lpOAStatus,
        LPCSTR                                  lpszNode,
        LPCSTR                                  lpszName,
        DWORD                                   dwValuesize,
        LPCSTR                                  lpvValue );

#endif

#ifdef __cplusplus
} /* Assume C declarations for C++ */
#endif  /* __cplusplus */

#endif
