/************** OmniAccess Information API Header file - oai30700.h **********/
/*   This C language header file describes the OmniAccess selection and      */
/*   criteria items for the OmniAccess information routines.                 */
/*                                                                           */
/*                      (c) 1996, Dynamic Information Systems Corporation    */
/*****************************************************************************/

#ifndef OAI30700_H_DEFINED
#define OAI30700_H_DEFINED


#define OAINFO_VERSION_OPTION_STRING "OA30700"

#define OAINFO_BASIC
#include "oainfo.h"
#undef  OAINFO_BASIC


/* The following structures may be used if desired for referencing
   arrays of names.  For example, the list of db_names returned by
   an oaenvironmentinfo ALL or DATABASES call.
*/
typedef struct oadbname
{
  char                     name[36];
  char                     full_name[80];
} oadbname_t;

typedef struct oatblname
{
  char                     name[36];
  char                     full_name[120];
} oatblname_t;

typedef struct oacolname
{
  char                     name[36];
} oacolname_t;




/* Note:  stucture name synonyms for "omnidex" and "imsam" have been removed:
Example:    (old name)               (new name)
#define num_simple_omnidex_keys  num_simple_mdk_keys
*/



/* Note:  Any offset returned in the structures below is relative
   to the beginning of the structure in which it is defined.
   A 0-valued offset indicates the information was not returned,
   either because it was not requested or does not exist.
*/
     


/* The "oaenv" structure is the base structure used in oaenvironmentinfo.
   It starts at the beginning of the passed buffer.
*/
typedef struct oaenv
{
  int32                    number;
  char                     name[36];
  char                     physical[256];
  char                     title[84];
  char                     version[36];
  unsigned int32           checksum;

  char                     scope[36];  /* OA, IA, DA, NA */
  char                     access[36]; /* Read-only, update, exclusive, etc */
  char                     env_access[36]; /* '' */

  char                     user[36];
  char                     password[36];
  char                     wildcard_any_char;
  char                     wildcard_single_char;
  char                     wildcard_single_digit;
  char                     escape_char;
  char                     odx_sentinel;

  int32                    interpretation;
  int32                    sql_syntax;
  int32                    century_threshold;
  int32                    prep_state;

  int32                    precedence;
  char                     precedence_desc[36]; /* Not, Or, And -OR- Not, And, Or */

  int32                    total_size;

  int32                    num_view_tbls;

  int32                    num_db_names;
  int32                    db_names_offset;
  int32                    db_name_size; /* == sizeof( struct oadbname) */

} oaenv_t;


/* The "oadb" structure is the base structure used in oadatabaseinfo.
   It starts at the beginning of the passed buffer.
*/
typedef struct oadb
{
  int32                    number;
  char                     env_name[36];
  char                     name[36];
  char                     full_name[80];
  char                     physical[256];
  char                     index_prefix[256];
  int32                    tpi_enabled;
  int32                    system_db;

  int32                    type;
  char                     type_desc[36];  /* Oracle, Image, etc. */

  int32                    classification;
  char                     classification_desc[36]; /* SQL or Table */
  
  /* new in 3.7 */
  int32                    cache_age_threshold;
  int32                    cache_purge_threshold;
  int32                    cache_initial_size;
  int32                    cache_extent_size;

  int32                    access_flag;
  int32                    locking_flag;

  char                     version[36];
  char                     def_uclass_user[36];
  char                     def_uclass_password[36];
  int32                    total_size;

  int32                    num_view_tbls;

  int32                    num_tbl_names;
  int32                    tbl_names_offset;
  int32                    tbl_name_size; /* == sizeof( struct oatblname) */
} oadb_t;


/* The "oatbl" structure is the base structure used in oatableinfo.
   It starts at the beginning of the passed buffer.

   It is also used as an optional detail in oacursorinfo when the
   ALL or TABLE option is passed.
   In this case it starts at the address specified by the address of
   the "oacursor" structure plus the "tbl_offset" element of "oacursor".
*/
typedef struct oatbl
{
  int32                    number;
  char                     env_name[36];
  char                     db_name[36];
  char                     name[36];   
  char                     full_name[120];  /* for OST, it's same as name */
  char                     options[256];/* added in 3.6 */
  int32                    temporary;   /* new in 3.6, 
                                           Values: 0=permanent table
                                                   1=temporary table
                                        */

  int32                    type;
  char                     type_desc[36]; /* Relational, Indexed, etc */

  char                     tidmap[36]; /* blank if tidmap not required. */
  int32                    record_length;

  int32                    rowid_datatype;
  int32                    rowid_length;
  int32                    recno_is_seq_asc; /*1 if seqential ascending recno */
  int32                    well_behaved_id; /*1 if well behaved Omnidex ID */

  int32                    num_native_cols;  /* non pseudo-columns */
  int32                    native_record_length;

  int32                    odx_installed; /* non-zero if any Omnidex MDK or ASK
                              indexes were installed, or if table is part of an
                              MDK domain through a link field */
  int32                    odx_record_length;
  int32                    odx_differs; /* non-zero if any columns have 
                              different Omnidex datatypes or lengths */
  int32                    odx_table_type;
  char                     odx_table_type_desc[36]; /* Possible values:
                              IDSI, TR, or TRR for MDK parents;
                              CHILD for linked child, DR for unlinked child,
                              HYBRID_DR for linked and $DR child,
                              ASK for ASK-only installations, or
                              NONE when no Omnidex was installed. */
  int32                    rec_installed; /* non-zero if ;REC option used in
                              ASK installation */
                              
  int32                    cache_age_threshold;   /* new in 3.7 */
  int32                    cache_purge_threshold;
  int32                    cache_initial_size;
  int32                    cache_extent_size;
  int32                    cache_load_flag;   /* Values:  1 = PRELOAD,
                                                          2 = ON DEMAND */

  int32                    total_native_idxs;
  int32                    total_mdk_idxs; /* subset of total_mdkdomain_idxs */
  int32                    total_mdkdomain_idxs;
  int32                    total_ask_idxs;

  int32                    total_size;

  int32                    num_consts;
  int32                    consts_offset;
  int32                    const_size; /* == sizeof( struct oaconst) */

  int32                    num_parent_tbl_names;
  int32                    parent_tbl_names_offset;
  int32                    parent_tbl_name_size;/* ==sizeof(struct oatblname) */

  int32                    num_child_tbl_names;
  int32                    child_tbl_names_offset;
  int32                    child_tbl_name_size;/* == sizeof(struct oatblname) */

  /* Future enhancement:  add flag for whether it's basic or regular cols */
  int32                    num_cols;
  int32                    cols_offset;
  int32                    col_size; /* == sizeof( struct oacol) */

  int32                    num_idxs; /* if any subset of indexes are requested,
                              this is the actual number returned; otherwise,
                              it is the total number of indexes that would be
                              returned with an "INDEXES" option. */
  int32                    idxs_offset;
  int32                    idx_size; /* == sizeof( struct oaidx) */

  int32                    physical_offset;
  int32                    physical_size;
  
  int32                    partition_offset;
  int32                    partition_size;

  int32                    view_flag;     /* set to 1 if there is an AS       
                                             clause, 0 otherwise.
                                             This way we can check in
                                             advance to see if we need to
                                             get the AS clause.
                                          */

  int32                    as_table_offset;
  int32                    as_table_size;

  int32                    autofilter_offset;
  int32                    autofilter_size;
} oatbl_t;


/* The "oaconst" structure is an optional detail returned from an
   oatableinfo call when passed the ALL or CONSTRAINTS option.
   It starts at the address specified by the address of the "oatbl"
   structure plus the "consts_offset" element of "oatbl".

   It is also part of the "oaidx" structure, occurring directly within
   the "oaidx".
*/
typedef struct oaconst
{
  int32                    number;
  int32                    type;
  int32                    ref_const;  /* if this is a foreign key const. */
  char                     ref_tbl_name[36];
  char                     ref_tbl_full_name[120];
  int32                    idx_no; /* offset into the array of oaidx_t 
                                      described in oatbl_t */

  int32                    num_col_names;
  int32                    col_names_offset;
  int32                    col_name_size; /* == sizeof( struct oacolname) */
} oaconst_t;


/* The "oacol" structure is an optional detail returned from an
   oatableinfo call when passed the ALL or COLUMNS option.
   It starts at the address specified by the address of the "oatbl"
   structure plus the "cols_offset" element of "oatbl".

   It is also an optional detail returned from an oacolumnlistinfo call
   when passed the ALL or COLUMNS option.
   It starts at the address specified by the address of the "oacols"
   structure plus the "cols_offset" element of "oacols".
*/
typedef struct oacol
{
  int32                    number;
  char                     name[36];

  int32                    type;
  char                     type_desc[36];

  char                     physical[256];

  int32                    datatype;
  char                     datatype_desc[36];

  /* Note: usages and options are currently unsupported v30420. */

  int32                    length;
  int32                    occurs;
  int32                    scale;
  int32                    precision;
  int32                    usage;
  char                     usage_desc[36];
  char                     options[36];
  char                     format[36];

  int32                    odx_datatype;
  char                     odx_datatype_desc[36];
  int32                    odx_length;
  int32                    odx_occurs;
  int32                    odx_scale;
  int32                    odx_precision;
  char                     odx_options[36];
  char                     odx_format[36];

  int32                    ext_datatype;
  char                     ext_datatype_desc[36];
  int32                    ext_length;
  int32                    ext_occurs;
  int32                    ext_scale;
  int32                    ext_precision;
  int32                    ext_usage;
  char                     ext_usage_desc[36];
  char                     ext_options[36];
  char                     ext_format[36];

  char                     prompt[36];
  char                     heading[36];
  char                     label[36];
  
  int32                    cache_flag;    /* new in 3.7
                                             Values: 1 = COLUMN CACHE
                                                     2 = COLUMN CACHE INDEXED 
                                          */
  int32                    century_threshold;

  int32                    num_simple_mdk_keys;
  int32                    num_simple_ask_keys;
  int32                    num_simple_native_keys;
  int32                    num_composite_mdk_keys;
  int32                    num_composite_ask_keys;
  int32                    num_composite_native_keys;
  
  int32                    as_column_offset;    /* pseudo-column */
  int32                    as_column_size;      

  int32                    sql_select_offset;
  int32                    sql_select_size;

  int32                    sql_insert_offset;
  int32                    sql_insert_size;
} oacol_t;



/* The "oabasic_col" structure is an optional detail returned from an
   oatableinfo call when passed the ALL or COLUMNS option and the BASIC_COLUMNS
   option.
   It starts at the address specified by the address of the "oatbl"
   structure plus the "cols_offset" element of "oatbl".

   It is also an optional detail returned from an oacolumnlistinfo call
   when passed the ALL or COLUMNS option and the BASIC_COLUMNS option.
   It starts at the address specified by the address of the "oacols"
   structure plus the "cols_offset" element of "oacols".
*/
typedef struct oabasic_col
{
  int32                    number;
  char                     name[36];

  int32                    type;
  char                     type_desc[36];

  int32                    datatype;
  char                     datatype_desc[36];

  /* Note: usages and options are currently unsupported. */

  int32                    length;
  int32                    occurs;
  int32                    scale;
  int32                    precision;
  int32                    usage;
  char                     usage_desc[36];
  char                     options[36];
  char                     format[36];

  int32                    odx_datatype;
  char                     odx_datatype_desc[36];
  int32                    odx_length;
  int32                    odx_occurs;
  int32                    odx_scale;
  int32                    odx_precision;
  char                     odx_options[36];
  char                     odx_format[36];

  int32                    ext_datatype;
  char                     ext_datatype_desc[36];
  int32                    ext_length;
  int32                    ext_occurs;
  int32                    ext_scale;
  int32                    ext_precision;
  int32                    ext_usage;
  char                     ext_usage_desc[36];
  char                     ext_options[36];
  char                     ext_format[36];

  int32                    num_simple_mdk_keys;
  int32                    num_simple_ask_keys;
  int32                    num_simple_native_keys;
  int32                    num_composite_mdk_keys;
  int32                    num_composite_ask_keys;
  int32                    num_composite_native_keys;
} oabasic_col_t;


/* The "oaidxs" structure is the base structure used in oaindexinfo.
   It starts at the beginning of the passed buffer.
*/

typedef struct oaidxs
{
  char                     env_name[36];
  char                     db_name[36];

  int32                    num_native_idxs;
  int32                    num_mdk_idxs;
  int32                    num_ask_idxs;

  int32                    total_size;

  int32                    num_idxs;
  int32                    idxs_offset;
  int32                    idx_size;
} oaidxs_t;


/* The "oaidx" structure is an optional detail returned from an
   oatableinfo call when passed the ALL, INDEXES, NATIVE, MDK,
   MDKDOMAIN, or ASK option.
   It starts at the address specified by the address of the "oatbl" 
   structure plus the "idxs_offset" element of "oatbl".

   It is also an optional detail returned from an oaindexinfo call
   when passed the ALL, NATIVE, MDK, or ASK option.
   In this case it starts at the address specified by the address of
   the "oaidxs" structure plus the "idxs_offset" element of "oaidxs".

   It is also an optional detail returned from oacursorinfo when
   passed the ALL or INDEX option.
   In this case it starts at the address specified by the address of
   the "oacursor" structure plus the "idx_offset" element of "oacursor".
*/
typedef struct oaidx
{
  int32                    number;
  char                     name[36];
  int32                    method;
  char                     method_desc[36]; /* Omnidex Inverted, Hashed, etc */
  char                     prompt[36];
  char                     physical[256];

  int32                    primary_tbl_number;
  char                     primary_tbl_name[36];
  char                     primary_tbl_full_name[120];
  int32                    owner_tbl_number;
  char                     owner_tbl_name[36];
  char                     owner_tbl_full_name[120];
  int32                    owner_odx_table_type;
  oaconst_t                odxsi;
  int32                    rowid_available;

  int32                    datatype;
  char                     datatype_desc[36];

  int32                    length;
  int32                    index_size; /* in Kbytes */
  char                     index_filename[256];

  /* The following are all flags:  0 means false, non-zero means true. */
  int32                    sorted;
  int32                    composite;
  int32                    excluded_words;
  int32                    translate;
  int32                    parsed;
  int32                    soundex;
  int32                    synonym;        /* Unsupported v30420 */
  int32                    plurality;      /* Unsupported v30420 */
  int32                    typecasting;
  int32                    record_complex;
  int32                    record_specific;
  int32                    blob;              /* ;bb option in dbinstal */
  int32                    batch_indexing;
  int32                    unique;
  int32                    bitmap;            /* ;bm */
  int32                    proximity;         /* ;px */
  int32                    external_indexing; /* ;ex */
  int32                    distributed_index; /* ;di */
  /* end flag section */

  int32                    group_number;
  int32                    group_master_index_number;

  int32                    num_idx_components;
  int32                    idx_components_offset;
  int32                    idx_component_size;
} oaidx_t;


/* The "oaidx_component" structure is present whenever the "oaidx"
   is present.
   It starts at the address specified by the address of the "oaidx" plus
   the "idx_components_offset" element of "oaidx".
*/
typedef struct oaidx_component
{
  int32                    type;
  int32                    start_byte;
  int32                    length;
  int32                    datatype;
  int32                    typecasting;
  int32                    tbl_number;
  char                     tbl_name[36];
  char                     tbl_full_name[120];
  int32                    col_number;
  char                     col_name[36];
} oaidx_component_t;



/* The "oacursor" structure is the base structure used in oacursorinfo.
   It starts at the beginning of the buffer.
*/
typedef struct oacursor
{
  int32                    instance;
  char                     scope[36];
  char                     access[36];

  char                     mdk_optimization[36];
  char                     ask_optimization[256];
  char                     native_optimization[36];

  char                     required_optimization[256];

  int32                    total_size;

  int32                    most_recent_count;
  int32                    count_up_to_date;

  int32                    cursor_state;

  int32                    escape_char; /* 0 if disabled */

  /* The select_list elements reference oaselect_list_t structures identical 
     to oadescribe.  These are used to describe both FETCH and FETCHKEYS 
     buffers */
  int32                    num_select_list;
  int32                    select_list_offset;
  int32                    select_list_size;
  int32                    bufflen;  /* Length of buffer to be returned */

  int32                    idx_offset; /* index described in oafetchkeys */

  /* The summary structure outlines a SELECT statement */
  int32                    summary_offset;

  /* The qualification structures are used to describe the steps taken by 
     the optimizer processing a SELECT statement */
  int32                    num_qualification_steps;
  int32                    qualification_steps_offset;
  int32                    qualification_step_size;

  /* The retrieval structures are used to describe the steps taken by 
     the retrieval engine processing a SELECT statement */
  int32                    num_retrieval_steps;
  int32                    retrieval_steps_offset;
  int32                    retrieval_step_size;

  int32                    select_profile_offset;

  int32                    notes_offset;
  int32                    notes_size;
  /* notes is a char string of length notes_size describing
     certain optimization decisions */

  int32                    addin_explain_only;
  /* addin_explain_only is set to 1 if the addin pre-processo the SQL and
     performs multiple selects, therefore regular explain is not available */

  int32                    addin_notes_offset;
  int32                    addin_notes_size;
  /* addin_notes is a char string of length addin_notes_size describing
     addin pre-process steps. */
} oacursor_t;


/* auxiliary structures */
typedef struct oatbl_alias
{
  char                     tbl_name[36];
  char                     alias[36];
} oatbl_alias_t;

typedef struct oafilter
{
  char                     filter[256];
} oafilter_t;

typedef struct oadata_item
{
  char                     description[128];
  char                     alias[36]; /* for RETURN_DATA */
} oadata_item_t;

typedef struct oasort_item
{
  char                     description[128];
  int32                    sort_order; /* 'A' = ascending, 'D' = descending */
} oasort_item_t;

typedef struct oafilename
{
  char                     filename[256];
} oafilename_t;

typedef struct oaqueuename
{
  char                     queuename[36];
} oaqueuename_t;


/* aggregation can only use simple column names, not expressions:
   SUM(COL1) is ok, but not SUM(COL1 * COL2 / 100) */
/* Note that a GROUP implies an ORDER.  If both GROUP and ORDER were requested
   on the same column, only the GROUP will show up.   ORDERs on non-group
   columns are handled outside of the aggregation index step. */
typedef struct oaaggregation
{
  char                     operation[8]; /* SUM, AVG, MIN, MAX, COUNT, GROUP */
  int32                    distinct;     /* is this a COUNT(distinct col) ? */
  char                     col_name[36];
  int32                    offset;
  int32                    length;
} oaaggregation_t;

/* Used in oars_create_tbl */
typedef struct oacreate_col
{
  char                     name[36];
  int32                    datatype;
  char                     datatype_desc[36];
  int32                    length;
} oacreate_col_t;



typedef struct oacsr_join_col
{
  char                     env_name[36];
  char                     db_name[36]; 
  char                     tbl_name[36];
  char                     col_name[36];
} oacsr_join_col_t;

typedef struct oacsr_criteria_col
{
  char                     env_name[36];
  char                     db_name[36]; 
  char                     tbl_name[36];
  char                     col_name[36];
} oacsr_criteria_col_t;

typedef struct oacsr_groupby_col
{
  char                     env_name[36];
  char                     db_name[36]; 
  char                     tbl_name[36];
  char                     col_name[36];
  int                      select_item;
} oacsr_groupby_col_t;

typedef struct oacsr_having_col
{
  char                     env_name[36];
  char                     db_name[36]; 
  char                     tbl_name[36];
  char                     col_name[36];
  int                      select_item;
} oacsr_having_col_t;

#define OA_DIRECTION_ASCENDING  1
#define OA_DIRECTION_DESCENDING 2
typedef struct oacsr_orderby_col
{
  char                     env_name[36];
  char                     db_name[36]; 
  char                     tbl_name[36];
  char                     col_name[36];
  int                      select_item;
  int                      direction;
  int                      unique;
} oacsr_orderby_col_t;

typedef struct oacsr_tbl
{
  char                     env_name[36];
  char                     db_name[36]; 
  char                     tbl_name[36];
} oacsr_tbl_t;

/* SELECT PROFILE option */
typedef struct oacsr_sel_profile
{
  /* The tbls structures are used to describe the tables of a SELECT
     statement.  This uses oacsr_tbl_t. */
  int32                    num_tbls;
  int32                    tbls_offset;
  int32                    tbl_size;

  /* The join columns structures are used to describe the columns used in 
     join clauses or predicates of a SELECT statement.
     This uses oacsr_join_col_t */
  int32                    num_join_cols;
  int32                    join_cols_offset;
  int32                    join_col_size;

  /* The criteria columns structures are used to describe the columns used in 
     criteria predicates of a SELECT statement. This uses oacsr_criteria_col_t*/
  int32                    num_criteria_cols;
  int32                    criteria_cols_offset;
  int32                    criteria_col_size;

  /* The groupby structures are used to describe the GROUP BY elements 
     of a SELECT statement. This uses oacsr_groupby_col_t */
  int32                    num_groupby_cols;
  int32                    groupby_cols_offset;
  int32                    groupby_col_size;

  /* The having structures are used to describe the HAVING elements 
     of a SELECT statement. This uses oacsr_having_col_t */
  int32                    num_having_cols;
  int32                    having_cols_offset;
  int32                    having_col_size;

  /* The orderby structures are used to describe the ORDER BY elements 
     of a SELECT statement. This uses oacsr_orderby_col_t */
  int32                    num_orderby_cols;
  int32                    orderby_cols_offset;
  int32                    orderby_col_size;
} oacsr_sel_profile_t;


/* SUMMARY option */


/* select list (non-aggregate) optimization */
#define OASUMM_OPT_ASKRETRIEVAL         0x1
/* where clause optimization */
#define OASUMM_OPT_MDKQUAL              0x1
#define OASUMM_OPT_ASKQUAL              0x2
#define OASUMM_OPT_ASKLINK              0x4
/* order by optimization */
#define OASUMM_OPT_ASKORDERBY           0x1
/* aggregation or group-by optimization */
#define OASUMM_OPT_AGGREGATION          0x1
#define OASUMM_OPT_STARSCHEMA           0x4


typedef struct oacsr_summary
{
  /* The original sql statement: */
  int32                    sql_stmt_offset;
  int32                    sql_stmt_size;
  /* then the sql stmt is just a char string of length sql_stmt_size */


  /* The requested optimization options for this select */
  char                     req_mdk_optimization[36];
  char                     req_ask_optimization[256];
  char                     req_native_optimization[36];

  /* The REQUIRED_OPTIMIZATION options for this select */
  char                     required_optimization[256];

  /* The into structures describe a SELECT ... INTO table clause */
  char                     into_tbl[68];
  char                     into_tbl_physical[256];


  /* Flags indicating omnidex or imsam optimization (use OASUMM_OPT_xxx): */
  int32                    select_list_optim;
  int32                    where_clause_optim;
  int32                    order_by_optim;
  int32                    aggregate_group_optim;

  int32                    expected_count; /* after where_clause optimization */
  int32                    count_is_reliable;

#define OA_USER_EXPLAIN_ONLY   1
#define OA_FORCED_EXPLAIN_ONLY 2

  /* Flags indicating reasons for unreliable counts */
  int32                    explain_only; /* No actual qualifies were done */
  int32                    multiple_tables;
  int32                    having_clause;
  /* Next three also indicate potentially slow query */
  int32                    xref_files;   /* cross-reference file(s) involved */
  int32                    unoptimized_criteria;
  int32                    cartesian_products;

  /* For backward compatibility: */
#define complex_omnidex_filters xref_files
#define non_omnidex_filters     unoptimized_criteria

  /* Flags indicating reasons for potentially slow queries: */
  int32                    multifind; /* table join by multifind */
  int32                    unoptimized_aggregation; /* Not using agg index */
  int32                    unoptimized_sort;  /* Order by, group by, distinct*/
  int32                    sequential_scan;   /* Serial read on table(s) */
  int32                    sequential_table_join; /* No index on table join */

} oacsr_summary_t;



/* QUALIFICATION option */
/* Qualification steps: */

#define OAQS_QUALIFY       1
#define OAQS_JOIN          2
#define OAQS_EXPORT        3
#define OAQS_BUILD_XREF    4

typedef struct oaqs_qualify
{
  int32                    cursor;
  char                     options[256];
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[36];
  char                     owner_tbl_name[36];
  char                     idx_name[36];

  int32                    idx_type; /* OA_INDEXTYPE_OMNIDEX_MDK, ..._ASK, ...*/
  int32                    odx_list_type; /* OA_ODX_TYPE_... */

  char                     criteria[256];

  int32                    count;
  int32                    parent_count;
  int32                    preintersect_count;
  int32                    error;
  int32                    warn;
  int32                    info;

  char                     clock[40];
} oaqs_qualify_t;

typedef struct oaqs_join
{
  int32                    cursor;
  char                     options[256];
  char                     from_env_name[36];
  char                     from_db_name[36];
  char                     from_tbl_name[36];
  char                     from_col_name[36];
  char                     to_owner_tbl_name[36];
  char                     to_env_name[36];
  char                     to_db_name[36];
  char                     to_tbl_name[36];
  char                     to_col_name[36];
  int32                    odx_list_type;
  int32                    count;
  int32                    parent_count;
  int32                    preintersect_count;
  int32                    error;
  int32                    warn;
  int32                    info;

  char                     clock[40];
} oaqs_join_t;

typedef struct oaqs_export
{
  int32                    cursor;
  char                     options[256];
  char                     filename[256];
  int32                    count;
  int32                    error;
  int32                    warn;
  int32                    info;

  /* For a DATA export, this was the select: */
  char                     select_options[256];
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[36];
  /* The column(s) selected for export: */
  int32                    num_cols;
  int32                    cols_offset;
  int32                    col_size; /* oacolname_t */

  char                     clock[40];
} oaqs_export_t;

typedef struct oaqs_build_xref
{
  char                     xref_filename[256];
  int32                    count; /* records in the main xref */

  int32                    num_export_files;
  int32                    export_files_offset;
  int32                    export_file_size; /* oafilename_t */

  char                     clock[40];
} oaqs_build_xref_t;

typedef struct oaqualification_step
{
  int32                    type; /* OAQS_QUALIFY, JOIN, EXPORT */
  union
  {
     struct oaqs_qualify     qualify;
     struct oaqs_join        join;
     struct oaqs_export      exprt;   /* export is a reserved word in MSVC */
     struct oaqs_build_xref  build_xref;
  }  step;

  int32                    skipped;
  /* qualification steps automatically proceed to the next one in the list, and
     end at the final step in the list.   "skipped" indicates the step was
     planned but because of qualifying counts reduced to 0 (or some similar
     situation) the step was optimized out.  */
} oaqualification_step_t;


/* RETRIEVAL option */
/* Retrieval steps: */

#define OARS_QUALIFY         1
#define OARS_FETCHKEYS       2
#define OARS_READ_XREF       3
#define OARS_RETRIEVE_ROW    4
#define OARS_FILTER_ROW      5
#define OARS_SORT            6
#define OARS_AGG_IDX         7
#define OARS_RETURN_DATA     8
#define OARS_PASS_TO_QUEUE   9
#define OARS_CREATE_TBL      10
#define OARS_INSERT          11
#define OARS_SORTED_MERGE    12
#define OARS_PASS_TO_SORT    OARS_PASS_TO_QUEUE



/* When joining tables using an Imsam key (native key unavailable), a qualify
   is done for each join value; here the criteria shows the table.column
   that we're joining from, if that's the case.  Qualifies done on the "where"
   clause of the select statement are shown in the qualification_steps, returned
   when oacursorinfo is called with the QUALIFICATION option.  */
typedef struct oars_qualify
{
  int32                    cursor;
  char                     options[36];
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[36];
  char                     owner_tbl_name[36];
  char                     idx_name[36];

  char                     criteria[256];
} oars_qualify_t;

/* fetchkeys step indicates a $odxid retrieval.  When it's the first step, the
odxid list is from either a user-qualified list or an optimizer-created list */
typedef struct oars_fetchkeys
{
  int32                    cursor;
  char                     options[36];

  int32                    count;

  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[36];

  char                     order_by_idx[36]; /* ASKORDERBY optimization */

  /* The column(s) brought back by oafetchkeys */
  int32                    num_cols;
  int32                    cols_offset;
  int32                    col_size; /* oacolname_t */
} oars_fetchkeys_t;

/* "xref" is a "cross-reference file" created when multiple omnidex-able
   filters cannot be combined into a single odxid list.  */
typedef struct oars_read_xref
{
  char                     xref_filename[256];
  int32                    sequential; /* 1 or 0 */
  char                     search_value[68]; /* blank if sequential is 1 */
  char                     retrieved_value[68];
} oars_read_xref_t;


#define OAMETHOD_SEQUENTIAL 1
#define OAMETHOD_INDEXED    2
#define OAMETHOD_ROWID      3

typedef struct oars_retrieve_row
{
  char                     env_name[36];
  char                     db_name[36]; /* each new db must have its own step */

  int32                    num_tbls;
  int32                    tbls_offset;
  int32                    tbl_size; /* oatbl_alias_t */

  /* use db_class to decide which struct of "details" to reference */
  int32                    db_class; /* OA_DATABASECLASS_SQL, _TABLE */
  union
  {
     struct
     {
        /* For TABLE databases: */
        /* Access describes how we get a row from the table:  could be
           sequential,  indexed, or by rowid. */
        int32              access_method;
        char               access_method_desc[36];
        char               access_idx_name[36]; /* if access_method is INDEXED*/
        char               access_operator[8]; /* =, <, >=, BETWEEN, etc */
        char               access_value[68]; /* could be tbl.column */
     } table_db;
     struct
     {
        /* for SQL databases: */
        /* sql_stmt is a character string of length "sql_stmt_size" */
        int32              sql_stmt_offset; /* relative to retrieval_step */
        int32              sql_stmt_size;
        /* Is the native database handling . . . */
        int32              distinct;
        int32              aggregation;
        int32              table_join;
        int32              filters;
        int32              group_by;
        int32              order_by;
        int32              having;
     } sql_db;
  } details;
} oars_retrieve_row_t;

typedef struct oars_filter_row
{
  int32                    num_filters;
  int32                    filters_offset;
  int32                    filter_size; /* oafilter_t */
} oars_filter_row_t;

/* takes care of qualify w/mask and fetchkeys */
typedef struct oars_aggregation_index
{
  char                     env_name[36];
  char                     db_name[36];
  char                     primary_tbl_name[36];
  char                     idx_name[36];

  int32                    alt_sort; /* are the columns grouped in a
                                        different order than installed? */

  int32                    num_aggregations;
  int32                    aggregations_offset;
  int32                    aggregation_size; /* oaaggregation_t */

  /* ASK-optimized "having" clauses.
     Note: more than 1 "having" indicates implied "AND" */
  int32                    num_havings;
  int32                    havings_offset;
  int32                    having_size; /* oafilter_t */
  
  /* Partitioned-qualify columns */
  int32                    num_pq_columns;
  int32                    pq_columns_offset;
  int32                    pq_columns_size; /* oacolname_t */
} oars_aggregation_index_t;

/* Lists data items inserted into a queue for later processing */
typedef struct oars_pass_to_queue
{
  char                     queue_name[36];

  int32                    num_data_items;
  int32                    data_items_offset;
  int32                    data_item_size; /* oadata_item_t */
} oars_pass_to_queue_t;
#define oars_pass_to_sort_t oars_pass_to_queue_t
#define sort_queue_name     queue_name

/* reasons for sorting: */
#define OARS_GROUP_SORT 1
#define OARS_ORDER_SORT 2
#define OARS_DISTINCT_SORT 3
typedef struct oars_sort
{
  int32                    sort_type;  /* GROUP, ORDER, DISTINCT */
  char                     sort_queue_name[36];

  /* The table is sorted in the order of the sort items.  Note the table could
     have more columns that are used as data but not as sort items. */
  int32                    num_sort_items;
  int32                    sort_items_offset;
  int32                    sort_item_size; /* oasort_item_t */
} oars_sort_t;

/* Lists select items returned to user: */
typedef struct oars_return_data
{
  char                     top_or_random[32];/*TOP y%/RANDOM n (if specified)*/
  int32                    num_data_items;
  int32                    data_items_offset;
  int32                    data_item_size; /* oadata_item_t */
} oars_return_data_t;

/* Describes table created on a "select col_list INTO .." */
typedef struct oars_create_tbl
{
  char                     db_name[36];
  char                     tbl_name[36];
  char                     physical[256];
  int32                    num_create_cols;
  int32                    create_cols_offset;
  int32                    create_col_size;
} oars_create_tbl_t;

/* Describes table insert for a "select col_list INTO .." */
typedef struct oars_insert
{
  char                     tbl_name[36];
  int32                    num_data_items;
  int32                    data_items_offset;
  int32                    data_item_size; /* oadata_item_t */
} oars_insert_t;

typedef struct oars_sorted_merge
{
  int32                    num_queues;
  int32                    queues_offset;
  int32                    queue_size; /* oaqueuename_t */
} oars_sorted_merge_t;



typedef struct oaretrieval_step
{
  int32                    type; /* OARS_FETCHKEYS, RETRIEVE_ROW, SORT, etc. */
  union
  {
    struct oars_qualify            qualify;
    struct oars_fetchkeys          fetchkeys;
    struct oars_read_xref          read_xref;
    struct oars_retrieve_row       retrieve_row;
    struct oars_filter_row         filter_row;
    struct oars_pass_to_queue      pass_to_queue;
    struct oars_pass_to_queue      pass_to_sort;
    struct oars_aggregation_index  agg_idx;
    struct oars_sort               sort;
    struct oars_return_data        return_data;
    struct oars_create_tbl         create_tbl;
    struct oars_insert             insert;
    struct oars_sorted_merge       sorted_merge;
  } step;

  int32                    loop_level;

  int32                    next_step;
  /* next step tells where to go after current step is done (0-relative).
     -1 indicates return to the user.  When multiple "loops" exist,
     an end-of-data condition from a fetch or fetchkeys will trigger the
     next loop to begin. */
} oaretrieval_step_t;


/* The "oacols" structure is the base structure used in oacolumlistinfo.
   It starts at the beginning of the passed buffer.
*/
typedef struct oacols
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[36];

  char                     collist[1024]; /* list of passed columns */

  int32                    total_size;

  int32                    fetch_bufflen;
  int32                    fetch_char_bufflen; /* This represents the
                           length of the buffer on a CHAR update or select.
                           If the CHAR=n option is passed to oacolumnlistinfo,
                           "n" is used instead of the default. */

  /* Future enhancement:  add flag for whether it's basic or regular cols */
  int32                    num_cols;
  int32                    cols_offset;
  int32                    col_size;
} oacols_t;


/* The start of structures used in oastatementinfo(). */

typedef struct oastmt_assign
{
  char                   options[260];
  char                   label[12];
  int                    num_values;
} oastmt_assign_t;

typedef struct oastmt_attach
{
  oatbl_t                tbl;
  char                   options[260];
} oastmt_attach_t;

typedef struct oastmt_close
{
  char                   options[260];
} oastmt_close_t;

typedef struct oastmt_command
{
  char                   options[260];
} oastmt_command_t;  

typedef struct oastmt_connect
{
  oaenv_t                env;
  char                   options[260];
} oastmt_connect_t;

typedef struct oastmt_createtbl
{
  oatbl_t                tbl;
  char                   options[260];
} oastmt_createtbl_t;

typedef struct oastmt_delete
{
  oatbl_t                tbl;
  char                   options[260];
  int                    num_rows;
  int                    rowid_offset;  /* offset of rowid value */
  int                    rowid_size;    /* length of rowid value */
} oastmt_delete_t;

typedef struct oastmt_delidx
{
  oatbl_t                 tbl;
  oacols_t                cols;
  char                    options[260];
  int                     num_rows;
} oastmt_delidx_t;  

typedef struct oastmt_detach
{
  oadb_t                 db;
  char                   tbl_name[36];
  char                   options[260];
} oastmt_detach_t;

typedef struct oastmt_disconnect
{
  char                   options[260];
} oastmt_disconnect_t;

typedef struct oastmt_drop
{
  oadb_t                 db;
  char                   tbl_name[264];
  char                   options[260];
} oastmt_drop_t;

typedef struct oastmt_export
{
  /* Use oadescribe and oacursorinfo to determine characteristics of select */
  char                   filename[256];
  char                   filetype[36];
  char                   node[36];
  char                   options[260];
  int                    num_rows;
} oastmt_export_t;

typedef struct oastmt_insert
{
  oatbl_t                tbl;
  oacols_t               cols;
  char                   options[260];
  int                    num_rows;
  int                    rowid_offset;  /* offset of rowid value */
  int                    rowid_size;    /* length of rowid value */
} oastmt_insert_t;

typedef struct oastmt_insidx
{
  oatbl_t               tbl;
  oacols_t              cols;
  char                  options[260];
  int                   num_rows;
} oastmt_insidx_t;

typedef struct oastmt_join
{
  oaidx_t                from_idx;
  oaidx_t                to_idx;
  char                   options[260];
  int                    count;
  int                    parent_count;
  int                    preintersect_count;
} oastmt_join_t;

typedef struct oastmt_open
{
  oacursor_t             cursor;
  char                   options[260];
} oastmt_open_t;

typedef struct oastmt_qualify
{
  oaidx_t                idx;
  char                   options[260];
  int                    count;
  int                    parent_count;
  int                    preintersect_count;
  int                    max_key_length;
  int                    si_length;
} oastmt_qualify_t;

typedef struct oastmt_select_value
{
  int                    value_length;
} oastmt_select_value_t;
  
typedef struct oastmt_select
{
  /* Use oadescribe and oacursorinfo to determine characteristics of select */
  char                   options[260];
  int                    bufflen;
  int                    num_cols;
  int                    num_values_clauses;
  int                    values_lengths_offset; /* beginning of oastmt_select_value_t */
  int                    values_lengths_size; /* sizeof oastmt_select_value_t */
} oastmt_select_t;

typedef struct oastmt_set
{
  char                   options[260];
} oastmt_set_t;

typedef struct oastmt_update
{
  oatbl_t                tbl;
  oacols_t               cols;
  char                   options[260];
  int                    num_rows;
  int                    rowid_offset;  /* offset of rowid value */
  int                    rowid_size;    /* length of rowid value */
} oastmt_update_t;

typedef struct oastmt_updidx
{
  oatbl_t                 tbl;
  oacols_t                cols;
  char                    options[260];
  int                     num_rows;
} oastmt_updidx_t;

typedef struct oastmt_version
{
  char                   options[260];
} oastmt_version_t;

typedef struct oastmt_detail
{
  union
  {
    oastmt_assign_t      assign_stmt;
    oastmt_attach_t      attach_stmt;
    oastmt_close_t       close_stmt;
    oastmt_command_t     command_stmt;
    oastmt_connect_t     connect_stmt;
    oastmt_createtbl_t   createtbl_stmt;
    oastmt_delete_t      delete_stmt;
    oastmt_delidx_t      delidx_stmt;
    oastmt_detach_t      detach_stmt;
    oastmt_disconnect_t  disconnect_stmt;
    oastmt_drop_t        drop_stmt;
    oastmt_export_t      export_stmt;
    oastmt_insert_t      insert_stmt;
    oastmt_insidx_t      insidx_stmt;
    oastmt_join_t        join_stmt;
    oastmt_open_t        open_stmt;
    oastmt_qualify_t     qualify_stmt;
    oastmt_select_t      select_stmt;
    oastmt_set_t         set_stmt;
    oastmt_update_t      update_stmt;
    oastmt_updidx_t      updidx_stmt;
    oastmt_version_t     version_stmt;
  } stmt;
  int                    statement_offset;
  int                    statement_length;
} oastmt_detail_t;

  
/* The "oastmt_t" structure is the base structure used in oastatementinfo().
   It starts at the beginning of the passed buffer.
*/
  
typedef struct oastmt
{
  int                    statement_id;     /* OASTATEMENT_ #define for last statement */
  
  int                    total_size;

  int                    instance;
  int                    cursor;

  int                    detail_offset;
  int                    detail_size;   /* sizeof oastmt_detail_t */
} oastmt_t;


#endif  /* OAI30700_H_DEFINED */
