/************** OmniAccess Information API Header file - oainfo.h ************/
/*   This C language header file describes the OmniAccess selection and      */
/*   criteria items for the OmniAccess information routines.                 */
/*                                                                           */
/*                      (c) 1996, Dynamic Information Systems Corporation    */
/*****************************************************************************/

#ifndef OAINFO_H_DEFINED
#define OAINFO_H_DEFINED


#ifdef int32
#undef int32
#endif

#if defined (__hpux) || defined (__mpexl)
#  define int32    int
#  define OAINFO_ENDIAN_OPTION_STRING "BIG_ENDIAN"
#elif defined (VMS) || defined (__osf__)
#  define int32    int
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#elif defined (__sun)
#  define int32    int
#  define OAINFO_ENDIAN_OPTION_STRING "BIG_ENDIAN"
#elif defined (_SEQUENT_)
#  define int32    int
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#elif defined (_AIX)
#  include <sys/types.h>
#  define int32    int
#  define OAINFO_ENDIAN_OPTION_STRING "BIG_ENDIAN"
#elif defined (i386) || defined(__linux__)
#  define int32    int
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#elif defined (WIN32)
#  define int32    int
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#elif defined (_WINDOWS) || defined (__MSDOS__) || defined (_MSDOS)
#  define int32    long
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#endif





/* If you're using a different version of the structures, #define OAINFO_BASIC
   before the #include "oainfo.h" */
#ifndef OAINFO_BASIC
/* include latest version of oainfo structures & macros. */
#include "oai30700.h"
#endif


/* routines and options: */

/* Actual function prototypes are contained in oa.h */
/*
int32 oaenvironmentinfo(int32 instance, char *options, oastatus_t *status,
                        char *environment, int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
OA30600, etc     Version string
ALL
DATABASES

int32 oadatabaseinfo(int32 instance, char *options, oastatus_t *status,
                        char *database, int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
OA30600, etc     Version string
ALL
TABLES

int32 oatableinfo(int32 instance, char *options, oastatus_t *status,
                        char *table, int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
OA30600, etc     Version string
ALL
CONSTRAINTS
PARENTS
CHILDREN
COLUMNS
BASIC_COLUMNS
INDEXES
NATIVE
MDK[=owner]
MDKDOMAIN[=owner]
ASK

int32 oaindexinfo(int32 instance, char *options, oastatus_t *status,
                  char *database, int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
OA30600, etc     Version string
ALL
NATIVE
MDK
ASK

int32 oacursorinfo(int32 cursor, char *options, oastatus_t *status,
                   int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
OA30600, etc     Version string
ALL
SUMMARY
QUALIFICATION
RETRIEVAL

int32 oacolumnlistinfo(int32 instance, char *options, oastatus_t *status,
                       char *table_name, char *column_names,
                       int32 buffer_length, void *buffer);

options:
CHARFILL
BIG_ENDIAN
LITTLE_ENDIAN
OA30600, etc     Version string
ALL
COLUMNS
BASIC_COLUMNS
CHAR[=n]

int oastatementinfo(char *options, oastatus_t *status, int size, void *buffer);

OPTIONS:

OA30600, etc     Version string
CHARFILL         
BIG_ENDIAN     
LITTLE_ENDIAN  
ALL            
HOOK           
PREP           
   
*/


#endif  /* OAINFO_H_DEFINED */
