/************** OmniAccess Information API Header file - oainfo.h ************/
/*   This C language header file describes the OmniAccess selection and      */
/*   criteria items for the OmniAccess information routines.                 */
/*                                                                           */
/*                      (c) 1996, Dynamic Information Systems Corporation    */
/*****************************************************************************/

#ifndef OAINFPRV_H_DEFINED
#define OAINFPRV_H_DEFINED

#define OAINFO_BASIC
#include "oainfo.h"
#undef  OAINFO_BASIC

#include "eaodx.h"

#define OAI_MIN( a, b)  ( (a) < (b) ? (a) : (b) )

#define OAI_FLIP(a)     dl_data_flip(&(a),&(a),sizeof(a))


#define OAINF_DEBUG( rtn) \
    ( Oa_debug[ rtn].debug || Oa_debug[ OAINFO].debug )

#define OAINF_CLOCKS( rtn) \
    ( Oa_debug[ rtn].clocks || Oa_debug[ OAINFO].clocks )

#define OAINF_PARMS( rtn) \
    ( PRINT_OA_PARMS(rtn) || PRINT_OA_PARMS(OAINFO) )

#define OAINF_MEMORY( rtn) \
    ( Oa_debug[ rtn].memory || Oa_debug[ OAINFO].memory )

#define OAINF_EXCEPTIONS( rtn) \
    ( Oa_debug[ rtn].exceptions || Oa_debug[ OAINFO].exceptions )

#define OAINF_CTRLBLKS( rtn) \
    ( Oa_debug[ rtn].ctrlblks || Oa_debug[ OAINFO].ctrlblks )

#define OAINF_HOOK( rtn) \
    ( PRINT_OA_HOOK(rtn) || PRINT_OA_HOOK(OAINFO) )

#define OAINF_PREP( rtn) \
    ( PRINT_OA_PREP(rtn) || PRINT_OA_PREP(OAINFO) )


/* map options so we only have to pass one int instead of one for each option */

#define OAINFO_OPT_CONSTRAINTS          0x000001
#define OAINFO_OPT_PARENTS              0x000002
#define OAINFO_OPT_CHILDREN             0x000004
#define OAINFO_OPT_COLUMNS              0x000008
#define OAINFO_OPT_BASIC_COLUMNS        0x000010
#define OAINFO_OPT_INDEXES              0x000020
#define OAINFO_OPT_NATIVE               0x000040
#define OAINFO_OPT_OMNIDEX              0x000080
#define OAINFO_OPT_ODX_DOMAIN           0x000100
#define OAINFO_OPT_IMSAM                0x000200
#define OAINFO_OPT_TABLE                0x000400
#define OAINFO_OPT_INDEX                0x000800
#define OAINFO_OPT_CSR_SUMMARY          0x001000
#define OAINFO_OPT_CSR_OMNIDEX          0x002000
#define OAINFO_OPT_CSR_RETRIEVAL        0x004000
#define OAINFO_OPT_CSR_FETCHKEYS        0x008000
#define OAINFO_OPT_CSR_SEL_LIST         0x010000
#define OAINFO_OPT_CSR_SEL_PROFILE      0x020000
#define OAINFO_OPT_CSR_IDX              0x040000
#define OAINFO_OPT_CSR_NOTES            0x080000
#define OAINFO_OPT_TBL_VARINFO          0x100000

/* map option for oaenvironment info */
#define OAINFO_OPT_ENV_SYSCAT           0x0001
#define OAINFO_OPT_ENV_TEMPDB           0x0002
#define OAINFO_OPT_ENV_USER             0x0004

/* map option for oastatement info */
#define OAINFO_OPT_STMT_ALL             0x0001
#define OAINFO_OPT_STMT_BIG_ENDIAN      0x0002
#define OAINFO_OPT_STMT_LITTLE_ENDIAN   0x0004


/* Structures used for select/fetch when we can't get the info from the cache */


#define OA_INFO_NUM_TCON_COLS 6
typedef struct oa_info_tcon
{
   int32  tbl_num;
   int32  num;
   int32  type;
   int32  ref;
   int32  num_comps;
   int32  first_comp_index;
} oa_info_sel_tcon_t;
/*
      "$TABLE_NUMBER",
      "$NUMBER",
      "$TYPE",
      "$REFERENCE_CONSTRAINT",
      "$COMPONENT_COUNT",
      0
*/

#define OA_INFO_NUM_TCCOM_COLS 4
typedef struct oa_info_sel_tccom
{
   int32  tbl_num;
   int32  constr_num;
   int32  comp_order;
   int32  col_num;
} oa_info_sel_tccom_t;
/*
      "$TABLE_NUMBER",
      "$CONSTRAINT_NUMBER",
      "$COMPONENT_ORDER",
      "$COLUMN_NUMBER"
*/

typedef struct oa_info_constraints
{
   int32               num_consts;
   oa_info_sel_tcon_t  *tbl_constraints;
   void                **comp_col_names;    /* oacolname_t */
   int32               num_comps;
   oa_info_sel_tccom_t *tbl_const_comps;
   int32               max_comps;
} oa_info_constraints_t;


#define OA_INFO_PARENT 1
#define OA_INFO_CHILD  2 /* Linked */
#define OA_INFO_DR     3



/* Even when we add things to 3.5.10, we should be able to use same routine
   here, since we're always going against the 3.5.10 syscat; just don't use
   all the elements in 3.4.50 or 3.5.00, etc. */

typedef struct oainfo_sel_idx
{
  int32      method;
  int32      num_comps;
  int32      num;
  int32      owner;
  int32      domain_type;
  int32      datatype;
  int32      data_length;
  int32      composite;
  int32      excluded_words;
  int32      translate;
  int32      parsed;
  int32      soundex;
  int32      synonym;
  int32      plurality;
  int32      sorted_order;
  int32      rec_specific;
  int32      rec_complex;
  int32      blob;
  int32      batch_update;
  int32      constraint_flag;
  int32      typecast_flag;
  int32      group_num;
  int32      group_master;
  char       name[36];
  char       method_desc[36];
  char       prompt[36];
  char       datatype_desc[36];
  char       physical[256];
} oa_info_sel_idx_t;


/* Keep these same as the above struct and the select list set up below. */
#define OA_INFO_NAME_NUM        23
#define OA_INFO_TYPE_DESC_NUM   24
#define OA_INFO_PROMPT_NUM      25
#define OA_INFO_DT_DESC_NUM     26
#define OA_INFO_PHYSICAL_NUM    27

#define OA_INFO_NUM_IDX_COLS    28


/*
These are the columns selected:
"$TYPE, $COMPONENT_COUNT, $NUMBER, $OWNER_TABLE_NUMBER, $OMNIDEX_TABLE_TYPE, \
$CAST_DATATYPE, $DATA_LENGTH, $COMPOSITE_FLAG, $EXCLUDE_FLAG, \
$TRANSLATE_DATA_FLAG, \
$PARSED_FLAG, $SOUNDEX_FLAG, $SYNONYM_FLAG, $PLURALITY_FLAG, $SORTED_ORDER, \
$RECORD_SPECIFIC_FLAG, $RECORD_COMPLEX_FLAG, $BLOB_FLAG, $UPDATE_FLAG, \
$CONSTRAINT_FLAG, $TYPECASTING_FLAG, $GROUP_NUMBER, $GRP_MASTER_IDX_NUM, \
$NAME, $TYPE_DESC, $PROMPT, $CAST_DATATYPE_DESC, $PHYSICAL_NAME";
*/


typedef struct oa_info_sel_comp
{
  int32      idx_num;
  int32      type;
  int32      start_byte;
  int32      length;
  int32      datatype;
  int32      tbl_num;
  int32      col_num;
} oa_info_sel_comp_t;

#define OA_INFO_NUM_COMP_COLS   7
/*
"$INDEX_NUMBER, $TYPE, $OFFSET, $LENGTH, $DATATYPE $TABLE_NUMBER, $COLUMN_NUMBER";
*/

typedef struct oa_info_idx_extras
{
   int32 primary_tbl_num;
   int32 first_data_comp;
   int32 first_target_comp;
} oa_info_idx_extras_t ;


typedef struct oa_info_indexes
{
  int32                 num_idxs;
  oa_info_sel_idx_t     *idxs;
  oa_info_idx_extras_t  *idx_extras;
  int32                 num_comps;
  oa_info_sel_comp_t    *idx_comps;
  int32                 num_pseudos;
  ea_odx_pseudo_t       *pseudo_list;
} oa_info_indexes_t;



/* 4/30/99 mgm -- note we can't change this private structure without also
making changes in 3.4.50 version.  Can't #define num_odx_idxs to num_mdk_idxs
because we use "num_odx_idxs" from ea_tbl_t. */


/* Malloc on db->mem_handle so memory will get released with db */
typedef struct oa_info_db_drv
{
  int32  num_native_idxs;
  int32  num_native_comps;
  int32  num_odx_idxs;
  int32  num_odx_comps;
  int32  num_ims_idxs;
  int32  num_ims_comps;

  int32  num_consts;
  int32  num_const_comps;
  int32  max_const_comps;

  int32  num_pseudo_idxs;
  int32  num_pseudo_comps;
} oa_info_db_drv_t;


typedef struct oa_info_idx_counts
{
  int32      type;
  int32      count;
  double     total_comps;
} oa_info_idx_counts_t;




/* function prototypes */
void oa_info_get_odx_type     (int32                 ia_installed,
                               int32                 *odx_type,
                               char                  *odx_type_desc,
                               ea_idx_t              *idx);

void oa_info_get_scope        (int32                 scope,
                               char                  *description);

void oa_info_get_access       (int32                 access_code,
                               char                  *description);

void oa_info_get_optimization (int32                 optimization,
                               char                  *odx_optimization,
                               char                  *ims_optimization,
                               char                  *native_optimization);

void oa_info_get_required_opt (int32                 optimization,
                               char                  *required_opt);


int oa_info_get_col_name      (ea_tbl_list_t         *tbl_list_entry,
                               int                   col_num,
                               char                  *col_name,
                               int                   *col_list_num);

int oa_info_get_tbl_name      (ea_db_t               *db,
                               int                   tbl_num,
                               char                  *tbl_name,
                               int                   *tbl_list_num);

void oa_info_get_model_index  (oa_info_sel_idx_t     **model_index,
                               oa_info_sel_comp_t    **model_comp,
                               oa_info_indexes_t     *indexes,
                               int                   current_idx);

int oa_info_find_foreign_constraint(
                               ea_tbl_t              *tbl,
                               ea_idx_t              *idx,
                               int                   *fc_index,
                               oastatus_t            *status);

int oa_info_find_sel_for_const(int                   ref_const_num,
                               int                   child_tbl_num,
                               oa_info_constraints_t *constraints,
                               int                   num_idx_comps,
                               oa_info_sel_comp_t    *selected_idx_comps,
                               int                   *for_const,
                               oastatus_t            *status);

int oa_info_find_pseudo_for_const(
                               ea_odx_pseudo_t       *pseudo_idx,
                               ea_col_list_t         *col_list_entry,
                               oa_info_constraints_t *constraints,
                               int                   *for_const,
                               oastatus_t            *status);



int32 oa_dbnamesize_30600();
int32 oa_tblnamesize_30600();
int32 oa_colnamesize_30600();
int32 oa_envsize_30600();
int32 oa_dbsize_30600();
int32 oa_tblsize_30600();
int32 oa_total_constsize_30600(ea_tbl_t *tbl);
int32 oa_colsize_30600( int basic);
int32 oa_colasize_30600( ea_col_t **cols, int num_cols);
int32 oa_idxsize_30600();
int32 oa_idxssize_30600();
int32 oa_idxcompsize_30600();
int32 oa_csrsize_30600();
int32 oa_colssize_30600();
int32 oa_stmtsize_30600();
int32 oa_stmtdsize_30600();

int32 oa_envinfo_30600( oa_instance_t *inst,
                        ea_env_t      *env,
                        void          *buffer,
                        int32         total_size,
                        int32         option_map,
                        int32         pad_c,
                        int32         flip_ints,
                        oastatus_t    *status);

int32 oa_dbinfo_30600(  ea_env_t      *env,
                        ea_db_t       *db,
                        void          *buffer,
                        int32         total_size,
                        int32         tables,
                        int32         pad_c,
                        int32         flip_ints,
                        oastatus_t    *status);

int32 oa_tblinfo_30600( ea_env_t      *env,
                        ea_tbl_t      *tbl,
                        ea_tbl_t      *owner_tbl,
                        void          *buffer,
                        int32         total_size,
                        int32         options_map,
                        int32         *skip_index,
                        int32         num_idxs,
                        int32         num_native_idxs,
                        int32         num_odx_idxs,
                        int32         num_odxdomain_idxs,
                        int32         num_ims_idxs,
                        int32         pad_c,
                        int32         flip_ints,
                        oastatus_t    *status);

int32 oa_idxinfo_30600( ea_env_t      *env,
                        ea_db_t       *db,
                        oa_info_db_drv_t *db_drv,
                        oa_info_constraints_t *constraints,
                        oa_info_indexes_t *idxs,
                        void          *buffer,
                        int32         total_size,
                        int32         num_idxs,
                        int32         num_comps,
                        int32         indexes,
                        int32         pad_c,
                        int32         flip_ints,
                        oastatus_t    *status);

int32 oa_collistinfo_30600(char          *col_names,
                           ea_env_t      *env,
                           ea_tbl_t      *tbl,
                           int32         num_cols,
                           ea_col_t      **cols,
                           void          *buffer,
                           int32         total_size,
                           int32         options_map,
                           int32         char_length,
                           int32         pad_c,
                           int32         flip_ints,
                           oastatus_t    *status);

int32 oa_csrinfo_30600( int32         cursor_no,
                        void          *buffer,
                        int32         total_size,
                        int32         options_map,
                        int32         pad_c,
                        int32         flip_ints,
                        oastatus_t    *status);

int32 oa_stmtinfo_30600( void          *buffer,
                         int32         total_size,
                         int32         option_map,
                         int32         pad_c,
                         int32         flip_ints,
                         oastatus_t    *status);

int32 oa_csr_summsize_30600( oa_cursor_t *csr);
int32 oa_csr_qualsize_30600( oa_cursor_t *csr, oastatus_t *status);
int32 oa_csr_retrsize_30600( oa_cursor_t *csr, oastatus_t *status);
int32 oa_csr_notesize_30600( oa_cursor_t *csr, oastatus_t *status);

/* 11/08/99 CHY:  Some of 3.7.00 structures are identical, just reuse code */

int32 oa_dbnamesize_30700();
int32 oa_tblnamesize_30700();
int32 oa_colnamesize_30700();
int32 oa_envsize_30700();
int32 oa_dbsize_30700();
int32 oa_tblsize_30700();
int32 oa_tblvsize_30700(ea_tbl_t *tbl);
int32 oa_total_constsize_30700(ea_tbl_t *tbl);
int32 oa_colsize_30700();
int32 oa_colvarsize_30700( ea_col_t **cols, int num_cols);
#define oa_colasize_30700         oa_colasize_30600
int32 oa_idxsize_30700();
int32 oa_idxcompsize_30700();
#define oa_idxssize_30700         oa_idxssize_30600
#define oa_colssize_30700         oa_colssize_30600
int32 oa_csrsize_30700();
int32 oa_csr_summsize_30700( oa_cursor_t *csr);
int32 oa_csr_qualsize_30700( oa_cursor_t *csr, oastatus_t *status);
int32 oa_csr_retrsize_30700( oa_cursor_t *csr, oastatus_t *status);
int32 oa_csr_fkeys_size_30700( oa_cursor_t *csr, char *options, oastatus_t *status);
int32 oa_csr_sellist_size_30700( oa_cursor_t *csr, oastatus_t *status);
int32 oa_csr_selprofile_size_30700( oa_cursor_t *csr, oastatus_t *status);
int32 oa_csr_idx_size_30700( oa_cursor_t *csr, oastatus_t *status);
int32 oa_csr_notesize_30700( oa_cursor_t *csr, oastatus_t *status);
int32 oa_stmtsize_30700();
int32 oa_stmtdsize_30700();

int32 oa_envinfo_30700( int           instance,
                        oa_instance_t *inst,
                        ea_env_t      *env,
                        void          *buffer,
                        int32         total_size,
                        int32         option_map,
                        int32         pad_c,
                        int32         flip_ints,
                        oastatus_t    *status);


int32 oa_dbinfo_30700(  ea_env_t      *env,
                        ea_db_t       *db,
                        void          *buffer,
                        int32         total_size,
                        int32         tables,
                        int32         pad_c,
                        int32         flip_ints,
                        oastatus_t    *status);

int32 oa_tblinfo_30700( ea_env_t      *env,
                        ea_tbl_t      *tbl,
                        ea_tbl_t      *owner_tbl,
                        void          *buffer,
                        int32         total_size,
                        int32         options_map,
                        int32         *skip_index,
                        int32         num_idxs,
                        int32         num_native_idxs,
                        int32         num_odx_idxs,
                        int32         num_odxdomain_idxs,
                        int32         num_ims_idxs,
                        int32         pad_c,
                        int32         flip_ints,
                        oastatus_t    *status);

#define oa_idxinfo_30700          oa_idxinfo_30600

int32 oa_collistinfo_30700(char          *col_names,
                           ea_env_t      *env,
                           ea_tbl_t      *tbl,
                           int32         num_cols,
                           ea_col_t      **cols,
                           void          *buffer,
                           int32         total_size,
                           int32         options_map,
                           int32         char_length,
                           int32         pad_c,
                           int32         flip_ints,
                           oastatus_t    *status);

int32 oa_csrinfo_30700( int32         cursor_no,
                        void          *buffer,
                        int32         total_size,
                        int32         options_map,
                        int32         pad_c,
                        int32         flip_ints,
                        char          *fkeys_options,
                        oastatus_t    *status);


int32 oa_stmtinfo_30700( void          *buffer,
                         int32         total_size,
                         int32         option_map,
                         int32         pad_c,
                         int32         flip_ints,
                         oastatus_t    *status);

#endif  /* OAINFPRV_H_DEFINED */
