
#if !defined(__OAO_H)
#define __OAO_H

#if defined(_WINDOWS) || defined(WIN32)
// Disable "forcing value to bool 'true' or 'false' (performance warning)"
# pragma warning(disable:4800)
// Disable "unsafe use of type 'bool' in operation"
# pragma warning(disable:4804)
// Disable "identifier was truncated to '255' characters in the debug information"
#pragma warning(disable:4786)
// Disable "x needs to have dll-interface to be used by clients of class y"
#pragma warning(disable:4251)
#endif

#if defined(_WINDOWS) && !defined(NTSERVER)
#define PCHARCAST
#else
#define PCHARCAST (char*)
#endif

#include <string>
#include <vector>
#include <assert.h>

#if defined(VALARRAY_MISSING)
#define valarray vector
#else
#include <valarray>
#endif
#if !defined(NO_NAMESPACE)
using std::vector;
using std::valarray;
using std::string;
#endif

#if defined(_WINDOWS) || defined(WIN32)
# pragma warning(default:4800)
# pragma warning(default:4804)

// Prototypes required by Microsoft`s buggy STL implementation to instantiate vector<class xxx>
class COaoParentLink;
class COaoChildLink;
class COaoTable;
bool operator<(const COaoParentLink&, const COaoParentLink&);
bool operator==(const COaoParentLink&, const COaoParentLink&);
bool operator<(const COaoChildLink&, const COaoChildLink&);
bool operator==(const COaoChildLink&, const COaoChildLink&);
bool operator<(const COaoTable&, const COaoTable&);
bool operator==(const COaoTable&, const COaoTable&);
#endif

#include "oainfo.h"

#if !defined(_WINDOWS) && !defined(WIN32)
// Unix

# define DllImportExport
# define CALLINGCONVENTION

#elif !defined(_USRDLL)
// Windows exe

# define DllImportExport
# define CALLINGCONVENTION __stdcall

#elif defined(_ODXOLB_DLL)	// __OAO_CPP
// Included in DLL - so export symbols for use by client program
# define DllImportExport	__declspec(dllexport)
# define CALLINGCONVENTION __stdcall

#else
// Included in client program - so import symbols
# define DllImportExport	__declspec(dllimport)
#endif

class OaoInstance;
class OaoCursor;

extern "C" {
DllImportExport void CALLINGCONVENTION OaoSwapBytes(void* pSwapMe, int length); // Swap the bytes in a number
}

class DllImportExport OaoStatus {
public:
	OaoStatus() {};
	char* ErrorMessage(const char* Options="MAXLEN=256");
	char message[256 + 100];								// oaerror() buffer
	//operator oastatus_t*() { return &status; };
	oastatus_t m_oastatus;
	enum { STATUS_OK=0, MESSAGE_BASE=26000 };
private:
	OaoStatus(const OaoStatus&);							 // Not implemented
	OaoStatus& operator=(const OaoStatus&);					 // Not implemented
};	// class OaoStatus


// base class for OaoWorkSpace && OaoInstance
class DllImportExport OaoCollection {
public:
	OaoCollection() { m_nElements = 0; m_ppCollected = NULL; };
	~OaoCollection() { delete m_ppCollected; };
	void* operator[](int nIndex) { return m_ppCollected[nIndex]; };
	int Count() { return m_nElements; };

protected:
	int Append(void* pCollected);
private:
	void** m_ppCollected;							  // Array of child objects
	int m_nElements;				// Number of child objects in m_ppCollected
	OaoCollection(const OaoCollection&);					 // Not implemented
	OaoCollection& operator=(const OaoCollection&);			 // Not implemented
};	// class OaoCollection


class DllImportExport OaoWorkSpace : public OaoCollection {
public:
	OaoWorkSpace();
	~OaoWorkSpace();

	OaoInstance* connect(const char* EnvironmentFile, const char* Options="");
	char* getErrorMessage() { return m_cStatus.ErrorMessage(); };
	oastatus_t& getStatus() { return m_cStatus.m_oastatus; };

	OaoInstance* operator[](int nIndex) { return (OaoInstance*)OaoCollection::operator[](nIndex); };

	char User[32];
	char Password[32];

	OaoStatus m_cStatus;
protected:
#if defined(_WINDOWS) || defined(WIN32)
//	enum { OA_LITTLE_ENDIAN=0, OA_BIG_ENDIAN=1, };
#endif
private:
	OaoWorkSpace(const OaoWorkSpace&);						 // Not implemented
	OaoWorkSpace& operator=(const OaoWorkSpace&);			 // Not implemented
};	// class OaoWorkSpace


class COaoParentLink {
public:
	COaoParentLink(int pt, int n) : m_iParentTable(pt), number(n) {};
	COaoParentLink() : m_iParentTable(0), number(0) { assert(0); };
	//	COaoParentLink(const COaoParentLink&);
	COaoParentLink& operator=(const COaoParentLink&) { assert(0); return *this; };

	const int m_iParentTable;							  // Tables array index
	vector<string> m_vsColumns;						// Link columns
	const int number;					// For linking from child`s 'ref_const'
};
class COaoChildLink {
public:
	COaoChildLink(int ot, int ref) : m_iOwnerTable(ot), ref_const(ref), m_iParentTable(-1), m_iParentLink(-1) {};
	COaoChildLink() : m_iOwnerTable(0), ref_const(0) { assert(0); };
	//	COaoChildLink(const COaoChildLink&);
	COaoChildLink& operator=(const COaoChildLink&) { assert(0); return *this; };

	int m_iParentTable,					  // Tables array index of parent table
		m_iParentLink;			// Links array index of parent table`s ref link
	const int m_iOwnerTable;			   // Tables array index of owner table
	vector<string> m_vsColumns;						// Link columns

	bool m_bUsed;					 // true if link is referenced in traversal
	const int ref_const;					// For linking to parent`s 'number'
};
class COaoTable {
public:
	COaoTable(const char* name);
	COaoTable();
	//	COaoTable(const COaoTable&);
	//	COaoTable& operator=(const COaoTable&);

	string m_sName;										  // Table name
	vector<COaoParentLink> m_vParentLinks;		// List of COaoParentLink s
	vector<COaoChildLink> m_vChildLinks;		 // List of COaoChildLink s
	vector<int> m_viTables;							   // Linked tables

	bool m_bUsed;					// true if table is referenced in traversal
	bool m_bChecked;						 // true if we`ve tested this table
};
class DllImportExport OaoInstance : public OaoCollection {	friend class OaoWorkSpace;
public:
	OaoInstance(int32 inst);
	~OaoInstance();

	int32 callOS(const char* Node,
		const char* Input, int32 InputLength, /* char* Output, int32 OutputLength, */
		const char* Options="");
	int32 disconnect(const char* Options="");
	int32 callSubroutine(const char* Node, const char* LibName, const char* RoutineName,
		const void* Input, int32 InputLength, void* Output, int32 OutputLength,
		const char* Options="");
	char* getErrorMessage() { return m_cStatus.ErrorMessage(); };
	oastatus_t& getStatus() { return m_cStatus.m_oastatus; };
	int32 insertRow(const char* Table, const char* Columns, const void* Buffer, const char* Options="");
	int32 instance() { return m_instance; };
	OaoCursor* openCursor(const char* Options="");
	oaversion_t* getVersions(const char* Node, int32 NumVersions, const char* Options="");

	// Info calls
	oaenv_t* getEnvironmentInfo();
	oadb_t* getDatabaseInfo(const char*pDatabaseName);
	oatbl_t* getTableInfo(const char*pTableName, const char* Options ="");

	// Returns oacolumnlistinfo in a pointer to managed memory
	oacols_t* getColumnListInfo(const char*pTableName, const char*pColumnNames);

	// Returns oacolumnlistinfo in the columnInfo parameter
	void ColumnListInfo(valarray<char>& columnInfo, const char*pTableName, const char*pColumnNames);
	oaidxs_t* getIndexInfo(const char* pDB_Name);
	int getTableJoinSQL(const char* TableList, string& JoinCriteria);
	OaoCursor* operator[](int nIndex) { return (OaoCursor*)OaoCollection::operator[](nIndex); };
	OaoStatus m_cStatus;

#if defined(_WINDOWS) || defined(WIN32)
	bool bSwapBytes() { return m_iServerByteOrder != m_iLocalByteOrder; };
#endif

private:
	oaenv_t* m_pOaenv;
	oadb_t* m_pOadb;
	oatbl_t* m_pOatbl;
	oaidxs_t* m_pOaidxs;
	oacols_t* m_pOacols;
	vector<COaoTable> Tables;

protected:
	int FindTable(const char* TableName);		 // Return index of Table in Tables
	void LinkTwoTables(int t1, int t2);				  // Mark the foreign link used
	bool JoinOneTable(const int tbl); // Join table tbl to other tables that have m_bUsed true
	int JoinTables(const char* TableList);
	bool GenerateCriteria(string& JoinCriteria);
	bool InitializeGetTableJoinSQL();

#if defined(_WINDOWS) || defined(WIN32)
# if 0
	enum eByteOrder { OA_LITTLE_ENDIAN=0, OA_BIG_ENDIAN=1, };
	enum eByteOrder m_iServerByteOrder,
					m_iLocalByteOrder;
# else
	int m_iServerByteOrder, m_iLocalByteOrder;
# endif
#endif
	int32 m_instance;									  // Native oa instance
	oaversion_t* m_pVersionBuffer;
private:
	OaoInstance(const OaoInstance&);						 // Not implemented
	OaoInstance& operator=(const OaoInstance&);				 // Not implemented
};	// class OaoInstance


class DllImportExport OaoCursor {	friend class OaoInstance;
public:
#if defined(_WINDOWS) || defined(WIN32)
//	enum eByteOrder { OA_LITTLE_ENDIAN=0, OA_BIG_ENDIAN=1, };
#endif

	OaoCursor(int crs
#if defined(_WINDOWS) || defined(WIN32)
		, int iServerByteOrder, int iPlatformByteOrder
#endif
	);
	~OaoCursor();

	int32 execSQL(const char* SQLStatement, const char* Options="");
	int32 joinCursor(const char* Label, int32 NumValues, const void* Data, const char* Options="");
	int32 bindColumns(const oaselect_list_t* pSelectList);
	int32 closeCursor(const char* Options="");
	int32 columnCount()	 { return m_iSelectColumnCount; };
	int32 cursor() { return m_cursor; }
	int32 instance() { return m_instance->instance(); }
	oacursor_t* getCursorInfo(const char* Options="");
	int32 deleteWhere(const char* Table, const char* Criteria, const char* Options="");
	oaselect_list_t* describeColumns();
	int32 exportFile(const char* Node, const char* Filename, const char* Options="");
	int32 fetchRows(int32 req_count, const char* Options="");
	int32 fetchRowCount() { return m_iFetchRowCount; };
	char* getKeys(int32 num_keys, const char* Options="");
	char* getColumns(const char* ColumnList, int iRow = -1);
	char* getErrorMessage() { return m_cStatus.ErrorMessage(); };
	oastatus_t& getStatus() { return m_cStatus.m_oastatus; };
	int32 joinTables(const char* From_Table, const char* From_Col, const char* To_Table, const char* To_Col, const char* Options="");

	void moveFirst();
	void moveLast();
	int movePrevious(int nRows=1);
	int moveNext(int nRows=1);

	int32 qualifyRows(const char* Table, const char* Column, const char* Criteria, const char* Options="");
	int32 qualifyRowCount() { return m_iQualifyRowCount; };
	int32 selectColumns(const char* Table, const char* Column, const char* Criteria, const char* Options="odxid");

	int32 deleteRow(int iRow= -1, const char* Options="");
	int32 updateRow(const char* ColumnList, void* DataBuffer, int iRow=-1, const char* Options="");

	int iRequestedColumns() { return m_iRequestedColumns; };
	oaselect_list_t* pSelectList() { return m_pSelectList; };
	const int* piSelectListIndex() { return m_piSelectListIndex; };

	const char* getTable() { return m_szTable; };

	// Properties
	char Owner[33];												 // oaqualify()

	char To_Owner[33];												// oajoin()

	OaoStatus m_cStatus;

#if defined(_WINDOWS) || defined(WIN32)
	bool bSwapBytes() { return m_iServerByteOrder != m_iLocalByteOrder; };
#endif
private:
	char m_szTable[33];
	oacursor_t* m_pOacursor;

public:
	int CountRequestedColumns(const char* ColumnList); // Calculates m_iRequestedColumns
	int LoopColumnList(const char* ColumnList); // void (OaoCursor::*pMemberFunction)(int iSelectIndex)
	int PopulateSelectListIndex(const char* ColumnList);

protected:
	int32 MoveIDPointer(int iRow);
	int32 DescribeAndBind();

#if defined(_WINDOWS) || defined(WIN32)
	int m_iServerByteOrder, m_iLocalByteOrder;
#endif

	OaoInstance* m_instance;
	int32 m_cursor;											// Native oa cursor

	int m_iRequestedColumns;  // Number of column`s data requested of GetData()

	char* m_pFetchbuffer;									   // For oafetch()
	char* m_pDatabuffer; // For GetData() to return the data to the calling program
	char* m_pFetchKeysBuffer;							   // For oafetchkeys()

	int* m_piSelectListIndex; // GetData()'s Requested columns' indices into m_pSelectList
	oaselect_list_t* m_pSelectList;							// For oadescribe()

	int32 m_iQualifyRowCount,								// From oaqualify()
		  m_iSelectColumnCount,								 // From oaselect()
		  m_iFetchRowCount;									  // From oafetch()

	int32 m_iServerRowPointer;
	int32 m_iCurrentRow; // Which of the oafetch()ed row(s) GetData() will return
	int32 m_iBufflen;						 // Buffer length - from oaselect()
	int32 m_iOa_index_max_key_length;					   // For oafetchkeys()

	static int32 ConvertDataType(int32 lFromType, int32 lFromLength, int& lToType, int& lToLength);
private:
	OaoCursor(const OaoCursor&);							 // Not implemented
	OaoCursor& operator=(const OaoCursor&);					 // Not implemented
};	// class OaoCursor

#endif // __OAO_H
