/*
 * Decompiled with CFR 0.152.
 */
package omnidex.java;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import omnidex.java.OmniSearch;
import omnidex.java.Value;
import omnidex.java.ValueList;

public class RangeValues
extends ValueList {
    private String _minValue;
    private String _maxValue;
    private String _minSelectedValue;
    private String _maxSelectedValue;
    private boolean _selectAll;
    private static String MINSELECTED_TAG = "\"minSelectedValue\"";
    private static String MAXSELECTED_TAG = "\"maxSelectedValue\"";

    protected RangeValues(String string, OmniSearch omniSearch, String string2, String string3) {
        super(string, omniSearch, string2, string3, false);
        this.initialize();
    }

    protected RangeValues(String string, OmniSearch omniSearch, String string2, String string3, int n, int n2, int n3) {
        super(string, omniSearch, string2, string3, n, n2, n3);
        this.initialize();
    }

    private void initialize() {
        this._range = true;
        this._maxSelectedValue = null;
        this._minSelectedValue = null;
        this._maxValue = null;
        this._minValue = null;
    }

    public String getMinimumValue() throws SQLException {
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getMinimumValue", true);
        }
        this.checkForActive();
        String string = null;
        if (this._values != null) {
            this.getValues();
            string = this._values[0].getValue();
        } else {
            this.getRangeValues();
            string = this._minValue;
        }
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getMinimumValue", true, string);
        }
        return string;
    }

    public String getMaximumValue() throws SQLException {
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getMaximumValue", true);
        }
        this.checkForActive();
        String string = null;
        if (this._values != null) {
            this.getValues();
            string = this._values[this._values.length - 1].getValue();
        } else {
            this.getRangeValues();
            string = this._maxValue;
        }
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getMaximumValue", true, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedRange(String string, String string2) throws SQLException {
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "setSelectedRange", true, string, string2);
        }
        this.checkForActive();
        if (string != null) {
            string = string.trim();
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        boolean bl = false;
        if (!this.compareString(string, this._minSelectedValue)) {
            this._minSelectedValue = string;
            bl = true;
        }
        if (!this.compareString(string2, this._maxSelectedValue)) {
            this._maxSelectedValue = string2;
            bl = true;
        }
        if (!bl) {
            return;
        }
        if (this._values != null) {
            if (this._countChanged) {
                Value[] valueArray = this._values;
                synchronized (this._values) {
                    for (Value value : this._values) {
                        value.active(false);
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    this._omniSearch.setRecalcCount(true);
                }
            } else {
                this._count = this.setValueRanges();
                this._omniSearch.setCount(this._count);
            }
        } else {
            this._omniSearch.setRecalcCount(true);
        }
        {
            this._omniSearch.setCountChanged(this);
            this._omniSearch.executeListeners();
            this._selectAll = false;
            return;
        }
    }

    public String getSelectedMinimumValue() throws SQLException {
        String string;
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getSelectedMinimumValue", true);
        }
        this.checkForActive();
        String string2 = string = this._minSelectedValue == null ? this.getMinimumValue() : this._minSelectedValue;
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getSelectedMinimumValue", true, string);
        }
        return string;
    }

    public String getSelectedMaximumValue() throws SQLException {
        String string;
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getSelectedMaximumValue", true);
        }
        this.checkForActive();
        String string2 = string = this._maxSelectedValue == null ? this.getMaximumValue() : this._maxSelectedValue;
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getSelectedMaximumValue", true, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value[] getValues() throws SQLException {
        super.getValues();
        this._count = 0L;
        if (this._selectAll) {
            Value[] valueArray = this._values;
            synchronized (this._values) {
                for (Value value : this._values) {
                    value.selected(true);
                    this._count += value.count();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else if (this._minSelectedValue != null || this._maxSelectedValue != null) {
            this._count = this.setValueRanges();
        }
        {
            this._omniSearch.setCount(this._count);
            return this._values;
        }
    }

    public void selectAll() throws SQLException {
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "selectAll", true);
        }
        this.setSelectedRange(null, null);
        this._selectAll = true;
    }

    public void clearCriteria() throws SQLException {
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "clearCriteria", true);
        }
        this.setSelectedRange(null, null);
        this._selectAll = false;
    }

    protected String getCriteria() {
        String string;
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getCriteria", false);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this._minSelectedValue != null) {
            if (this._maxSelectedValue != null) {
                stringBuilder.append(this._columnName);
                stringBuilder.append(" between '");
                stringBuilder.append(this._minSelectedValue);
                stringBuilder.append("' and '");
                stringBuilder.append(this._maxSelectedValue);
                stringBuilder.append("'");
            } else {
                stringBuilder.append(this._columnName);
                stringBuilder.append(" >= '");
                stringBuilder.append(this._minSelectedValue);
                stringBuilder.append("'");
            }
        } else if (this._maxSelectedValue != null) {
            stringBuilder.append(this._columnName);
            stringBuilder.append(" <= '");
            stringBuilder.append(this._maxSelectedValue);
            stringBuilder.append("'");
        }
        String string2 = string = stringBuilder.length() == 0 ? null : stringBuilder.toString();
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getCriteria", false, string);
        }
        return string;
    }

    protected String save() {
        StringBuilder stringBuilder = new StringBuilder(super.save());
        stringBuilder.setLength(stringBuilder.length() - 1);
        if (this._minSelectedValue != null) {
            this._omniSearch.setEntry(stringBuilder, MINSELECTED_TAG, this._minSelectedValue, ",");
        }
        if (this._minSelectedValue != null) {
            this._omniSearch.setEntry(stringBuilder, MAXSELECTED_TAG, this._maxSelectedValue, ",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected void open(char[] cArray, int[] nArray) throws SQLException {
        super.open(cArray, nArray);
        if (this._omniSearch.entryExist(cArray, nArray, MINSELECTED_TAG)) {
            this._minSelectedValue = this._omniSearch.getString(cArray, nArray);
        }
        if (this._omniSearch.entryExist(cArray, nArray, MAXSELECTED_TAG)) {
            this._maxSelectedValue = this._omniSearch.getString(cArray, nArray);
        }
    }

    protected long setValueRanges() {
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "setValueRanges", false);
        }
        long l = this._columnType == 6 || this._columnType == 7 ? this.setSelectedFloat(this._minSelectedValue, this._maxSelectedValue) : this.setSelectedInteger(this._minSelectedValue, this._maxSelectedValue);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRangeValues() throws SQLException {
        if (this._omniSearch.isTrace()) {
            this._omniSearch.trace(this, "getRangeValues", false);
        }
        this.checkForActive();
        if (this._countChanged || this._minValue == null) {
            Statement statement;
            String string = this._omniSearch.getCriteria(this);
            if (this._columnName == null) {
                this.getColumnInfo(string);
            }
            String string2 = this._omniSearch.getRangeSql(this._columnName, string);
            Statement statement2 = statement = this._omniSearch.getStatement();
            synchronized (statement2) {
                ResultSet resultSet = null;
                try {
                    if (this._omniSearch.isTrace()) {
                        this._omniSearch.trace(this, "Statement.executeQuery", false, string2);
                    }
                    if (!(resultSet = statement.executeQuery(string2)).next()) {
                        throw new SQLException("Unable to get the minimum and maximum value.");
                    }
                    this._minValue = resultSet.getString(1);
                    this._maxValue = resultSet.getString(2);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
    }

    private boolean compareString(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2) || string2 != null && string2.equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long setSelectedFloat(String string, String string2) {
        double d = string == null ? Double.MIN_VALUE : Double.parseDouble(string);
        double d2 = string2 == null ? Double.MAX_VALUE : Double.parseDouble(string2);
        long l = 0L;
        Value[] valueArray = this._values;
        synchronized (this._values) {
            Value[] valueArray2 = this._values;
            int n = valueArray2.length;
            for (int i = 0; i < n; ++i) {
                Value value;
                double d3 = Double.parseDouble((value = valueArray2[i]).getValue());
                value.selected(d3 >= d && d3 <= d2);
                if (!value.selected()) continue;
                l += value.count();
            }
            // ** MonitorExit[var9_6] (shouldn't be in output)
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long setSelectedInteger(String string, String string2) {
        long l = string == null ? Long.MIN_VALUE : Long.parseLong(string);
        long l2 = string2 == null ? Long.MAX_VALUE : Long.parseLong(string2);
        long l3 = 0L;
        Value[] valueArray = this._values;
        synchronized (this._values) {
            Value[] valueArray2 = this._values;
            int n = valueArray2.length;
            for (int i = 0; i < n; ++i) {
                Value value;
                long l4 = Long.parseLong((value = valueArray2[i]).getValue());
                value.selected(l4 >= l && l4 <= l2);
                if (!value.selected()) continue;
                l3 += value.count();
            }
            // ** MonitorExit[var9_6] (shouldn't be in output)
            return l3;
        }
    }
}

