create environment             "$OMNIDEX_GLOBAL_CONFIGURATION"
 in                            "Omnidex.xml"
 with                          delete;

create database                "$OMNIDEX_GLOBAL_CONFIGURATION"
 type                          flatfile
 index_directory               "idx"
 in                            "Omnidex.xml";

create table                   "$LISTS"
 options                       "TDF"
 physical                      "{$OMNIDEX_LANG/lists/*.txt},{$OMNIDEX_LANG/lists/*.tdf}"
 (
  "$LIST"                            character(32),
  "$REPLACEMENT"                     string(4094),
  "$COMMENTS"                        string(255),
  custom "$LIST" ("$LIST") case_insensitive
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$STOPWORDS"
 options                       "TDF"
 physical                      "{$OMNIDEX_LANG/stopwords/*.txt},{$OMNIDEX_LANG/stopwords/*.tdf}"
 (
  "$LIST"                            character(32),
  "$WORD"                            string(127),
  "$COMMENTS"                        string(255),
  custom "$LIST" ("$LIST") case_insensitive,
  custom "$WORD" ("$WORD") case_insensitive,
  custom "LIST_WORD" ("$LIST", "$WORD") case_insensitive
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$SYNONYMS"
 options                       "TDF"
 physical                      "{$OMNIDEX_LANG/synonyms/*.txt},{$OMNIDEX_LANG/synonyms/*.tdf}"
 (
  "$LIST"                            character(32),
  "$WORD"                            string(127),
  "$REPLACEMENT"                     string(4094),
  "$COMMENTS"                        string(255),
  custom "$LIST" ("$LIST") case_insensitive,
  custom "$WORD" ("$WORD") case_insensitive,
  custom "LIST_WORD" ("$LIST", "$WORD") case_insensitive
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PHONETIC"
 options                       "TDF"
 physical                      "{$OMNIDEX_LANG/phonetic/*.txt},{$OMNIDEX_LANG/phonetic/*.tdf}"
 (
  "$LIST"                            character(32),
  "$WORD"                            string(127),
  "$TYPE"                            character(8),
  "$SOUNDEX"                         character(64),
  "$METAPHONE1"                      character(64),
  "$METAPHONE2"                      character(64),
  "$COMMENTS"                        string(255),
  custom "$LIST" ("$LIST") case_insensitive,
  custom "$TYPE" ("$TYPE") case_insensitive,
  custom "$WORD" ("$WORD") case_insensitive,
  custom "$SOUNDEX" ("$SOUNDEX") case_insensitive,
  custom "$METAPHONE1" ("$METAPHONE1") case_insensitive,
  custom "$METAPHONE2" ("$METAPHONE2") case_insensitive,
  custom "LIST_TYPE" ("$LIST", "$TYPE") case_insensitive,
  custom "LIST_TYPE_SOUNDEX" ("$LIST", "$TYPE", "$SOUNDEX") case_insensitive
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$USAGES"
 options                       "TDF"
 physical                      "{$OMNIDEX_LANG/usages/*.txt},{$OMNIDEX_LANG/usages/*.tdf}"
 (
  "$LIST"                            character(32),
  "$USAGE"                           character(32),
  "$PARSING"                         character(32),
  "$FORMAT"                          character(255),
  "$POWERSEARCH"                     string(4094),
  "$COMMENTS"                        string(255),
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$MESSAGES"
 options                       "TDF"
 physical                      "{$OMNIDEX_LANG/messages/*.txt},{$OMNIDEX_LANG/messages/*.tdf}"
 (
  "$ERROR"                           integer,
  "$MESSAGE"                         string(255)
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$ENVIRONMENTS"
 physical                      "{$OMNIDEX_LOGS/monenv.dat}"
 options                       "MAPPED"
 (
  "$HOST"                            string(63),
  "$ENVIRONMENTID"                   integer,
  "$FILENAME"                        string(255),
  "$ROLE"                            string(15),
  "$DATE_CREATED"                    c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  constraint ENVIRONMENTS_ENVIRONMENTI_PK primary ("$ENVIRONMENTID")
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$CURRENT_CONNECTIONS"
 physical                      "{$OMNIDEX_LOGS/monconn.dat}"
 options                       "MAPPED"
 autofilter                    "$connectionid > 0"
 (
  "$HOST"                            string(63),
  "$CONNECTIONID"                    integer,
  "$ENVIRONMENTID"                   integer,
  "$TYPE"                            string(15),
  "$PORT"                            integer,
  "$PID"                             integer,
  "$INSTANCE"                        integer,
  "$ACTIVE_STATEMENTID"              integer,
  "$CLIENT_HOST"                     string(63),
  "$CLIENT_PID"                      integer,
  "$CLIENT_CONNECTIONID"             integer,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(31),
  "$CHECKPOINT"                      string(255),
  constraint CURRENT_CONN_CONNECTIONID_PK primary ("$CONNECTIONID"),
  constraint CURRENT_CONN_ENVIRONMENTI_FK foreign ("$ENVIRONMENTID")
   references "$ENVIRONMENTS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PAST_CONNECTIONS"
 options                       "TDF"
 physical                      "{$OMNIDEX_LOGS/connections_*.txt}"
 (
  "$HOST"                            string(63),
  "$CONNECTIONID"                    integer,
  "$ENVIRONMENTID"                   integer,
  "$TYPE"                            string(15),
  "$PORT"                            integer,
  "$PID"                             integer,
  "$INSTANCE"                        integer,
  "$ACTIVE_STATEMENTID"              integer,
  "$CLIENT_HOST"                     string(63),
  "$CLIENT_PID"                      integer,
  "$CLIENT_CONNECTIONID"             integer,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(31),
  "$CHECKPOINT"                      string(255),
  constraint PAST_CONNECT_CONNECTIONID_PK primary ("$CONNECTIONID"),
  constraint PAST_CONNECT_ENVIRONMENTI_FK foreign ("$ENVIRONMENTID")
   references "$ENVIRONMENTS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$CURRENT_STATEMENTS"
 physical                      "{$OMNIDEX_LOGS/monstmts.dat}"
 options                       "MAPPED"
 autofilter                    "$statementid > 0"
 (
  "$HOST"                            string(63),
  "$CONNECTIONID"                    integer,
  "$STATEMENTID"                     integer,
  "$CURSOR"                          integer,
  "$RETRIEVED"                       unsigned integer,
  "$ROUTINE"                         integer,
  "$ERROR"                           integer,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(31),
  "$CHECKPOINT"                      string(255),
  "$CPU"                             float,
  "$ELAPSED"                         float,
  "$STATEMENT_TYPE"                  string(31),
  "$SQL_STATEMENT"                   string(8191),
  constraint CURRENT_STMT_STMTID_PK primary ("$STATEMENTID"),
  constraint CURRENT_STMT_CONNECTIONID_FK foreign ("$CONNECTIONID")
   references "$CURRENT_CONNECTIONS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PAST_STATEMENTS"
 options                       "TDF"
 physical                      "{$OMNIDEX_LOGS/statements_*.txt}"
 (
  "$HOST"                            string(63),
  "$CONNECTIONID"                    integer,
  "$STATEMENTID"                     integer,
  "$CURSOR"                          integer,
  "$RETRIEVED"                       unsigned integer,
  "$ROUTINE"                         integer,
  "$ERROR"                           integer,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(31),
  "$CHECKPOINT"                      string(255),
  "$CPU"                             float,
  "$ELAPSED"                         float,
  "$STATEMENT_TYPE"                  string(31),
  "$SQL_STATEMENT"                   string(8191),
  constraint CURRENT_STMT_STMTID_PK primary ("$STATEMENTID"),
  constraint CURRENT_STMT_CONNECTIONID_FK foreign ("$CONNECTIONID")
   references "$CURRENT_CONNECTIONS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$ODXNET"
 options                       "TDF"
 physical                      "{$OMNIDEX_LOGS/odxnet.log}"
 (
  "$TIMESTAMP"                       character(32),
  "$LISTENERPID"                     integer,
  "$PID"                             integer,
  "$CLIENTPID"                       integer,
  "$HOST"                            string(63),
  "$APPLICATION"                     character(32),
  "$SIGNAL"                          character(32),
  "$CONNECTTIME"                     character(32),
  "$TOT_CONNECT"                     integer,
  "$CUR_CONNECT"                     integer,
  "$TOT_CURSORS"                     integer,
  "$CUR_CURSORS"                     integer,
  "$REQUESTS"                        integer,
  "$FETCH"                           integer,
  "$ROWS"                            integer,
  "$DESCRIBE"                        integer,
  "$INFO"                            integer,
  "$QUALIFY"                         integer,
  "$INSERT"                          integer,
  "$UPDATE"                          integer,
  "$DELETE"                          integer,
  "$INDEX"                           integer,
  "$QUERYSTATE"                      character(32),
  "$QUERYSTART"                      character(32),
  "$QUERYSTOP"                       character(32),
  "$QUERYELAPSED"                    character(32),
  "$SQL"                             string(8191)
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PROCESS_DUMPS"
 options                       "TDF"
 physical                      "{$OMNIDEX_LOGS/processdumps.txt}"
 (
  "$PROCESSID"                       integer,
  "$HOST"                            string(63),
  "$CONNECTIONID"                    integer,
  "$STATEMENTID"                     integer,
  "$SIGNAL"                          character(32),
  "$TIMESTAMP"                       c datetime(4),
  "$CALL_STACK_FILENAME"             string(255),
  "$DUMP_FILENAME"                   string(255),
  constraint PROCESS_DUMPS_PK primary ("$PROCESSID")
 )
 in                            "Omnidex.xml"
 with                          noinstall;
