/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCSql {
    private Connection m_conn;
    private Statement m_stmt;
    private ResultSet m_rs;
    private String m_sql;
    private int m_count;
    private String m_header;
    private String m_headerLine;
    private boolean m_qa;
    private boolean m_autoExit;

    public static void main(String[] stringArray) {
        JDBCSql jDBCSql = new JDBCSql();
        if (jDBCSql.initialize()) {
            if (stringArray.length == 0) {
                jDBCSql.run();
            } else {
                String string = null;
                String string2 = null;
                for (String string3 : stringArray) {
                    if (string3.equals("-qa")) {
                        jDBCSql.setQA(true);
                        continue;
                    }
                    if (string3.equals("-exit")) {
                        jDBCSql.setAutoExit(true);
                        continue;
                    }
                    if (string3.equals("-help") || string3.equals("-?")) {
                        jDBCSql.printUsage();
                        continue;
                    }
                    if (string3.startsWith("-use=")) {
                        if (string != null) {
                            jDBCSql.printUsage();
                            continue;
                        }
                        string = string3.substring(5);
                        if (string.length() != 0) continue;
                        jDBCSql.printUsage();
                        continue;
                    }
                    if (string3.startsWith("-")) {
                        jDBCSql.printUsage();
                        continue;
                    }
                    if (string2 != null) {
                        jDBCSql.printUsage();
                        continue;
                    }
                    string2 = string3;
                }
                jDBCSql.run(string, string2);
            }
        }
    }

    private void setQA(boolean bl) {
        this.m_qa = bl;
    }

    private void setAutoExit(boolean bl) {
        this.m_autoExit = bl;
    }

    private void printString(String string) {
        System.out.println(string);
    }

    private void printLine() {
        System.out.println("");
    }

    private void printError(String string) {
        System.out.println("*E* " + string);
    }

    private String prompt(String string) {
        System.out.print(string);
        byte[] byArray = new byte[512];
        int n = 0;
        try {
            n = System.in.read(byArray);
        }
        catch (IOException iOException) {
            this.printError(iOException.getMessage());
        }
        if (n != 0) {
            while (n != 0 && (byArray[n - 1] == 10 || byArray[n - 1] == 13)) {
                --n;
            }
        }
        return n != 0 ? new String(byArray, 0, n) : null;
    }

    private boolean initialize() {
        this.printString("Omnidex JDBC SQL program.");
        this.printString("Dynamic Information Systems Corporation (c) 2013.");
        this.printLine();
        try {
            Class.forName("omnidex.jdbc.OdxJDBCDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.printError("Unable to find Omnidex JDBC driver.");
            return false;
        }
        return true;
    }

    private void printUsage() {
        this.printString("Syntax:   java JDBCSql [environment] [options]");
        this.printLine();
        this.printString("Options:  -use=filename    Execute statements in the named file");
        this.printString("          -exit            Exit after completion of use file");
        this.printString("          -qa              QA mode, line terminator needed");
        this.printString("          -? -help         print this help message");
        this.printLine();
        System.exit(0);
    }

    private void run() {
        this.run(null, null);
    }

    private void run(String string, String string2) {
        try {
            boolean bl = false;
            if (string2 != null) {
                string2 = "connect " + string2;
                this.parseCommand(string2, false);
            }
            if (string != null) {
                string = "use " + string;
                bl = this.parseCommand(string, bl);
                if (this.m_autoExit) {
                    return;
                }
            }
            while (true) {
                String string3;
                if ((string3 = bl ? this.prompt(">> ") : this.prompt("> ")) == null || (string3 = string3.trim()).length() == 0) {
                    continue;
                }
                bl = this.parseCommand(string3, bl);
            }
        }
        finally {
            this.disconnect(true);
        }
    }

    private boolean parseCommand(String string, boolean bl) {
        try {
            if (string.equals(";") ? !bl : string.startsWith(";")) {
                return bl;
            }
            if (!bl) {
                this.m_sql = null;
            }
            boolean bl2 = false;
            if (string.endsWith("\\")) {
                bl = true;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith(";")) {
                bl = false;
                string = string.substring(0, string.length() - 1);
                bl2 = true;
            } else if (this.m_qa) {
                bl = false;
                bl2 = true;
            }
            this.m_sql = this.m_sql == null ? string : this.m_sql + " " + string;
            if (!bl) {
                String string2;
                String string3;
                int n;
                if (this.m_sql.equalsIgnoreCase("exit") || this.m_sql.equalsIgnoreCase("quit")) {
                    System.exit(0);
                }
                if ((n = this.m_sql.indexOf(32)) == -1) {
                    string3 = this.m_sql;
                    string2 = null;
                } else {
                    string3 = this.m_sql.substring(0, n);
                    string2 = this.m_sql.substring(n + 1).trim();
                }
                if (string3.equalsIgnoreCase("use")) {
                    this.use(string2);
                } else if (string3.equalsIgnoreCase("connect")) {
                    this.connect(string2);
                } else if (string3.equalsIgnoreCase("disconnect")) {
                    this.disconnect(false);
                } else if (bl2) {
                    if (this.m_conn == null) {
                        this.printError("This statement requires a connection to an environment file");
                    } else {
                        this.execSql(this.m_sql);
                    }
                } else {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            this.printError(exception.getMessage());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void use(String string) throws Exception {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            boolean bl = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                this.printString(">> " + string2);
                if (string2.length() == 0) continue;
                bl = this.parseCommand(string2, bl);
            }
            if (bl) {
                this.printString(">> ;");
                this.parseCommand(";", bl);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
        }
    }

    private boolean isExitCommand(String string) {
        return string.equalsIgnoreCase("exit") || string.equalsIgnoreCase("quit");
    }

    public void connect(String string) {
        try {
            this.disconnect(false);
            String string2 = "jdbc:omnidex:" + string;
            this.m_conn = DriverManager.getConnection(string2, null);
            this.m_stmt = this.m_conn.createStatement(1004, 1007);
            this.printString("Connected to " + string);
        }
        catch (SQLException sQLException) {
            this.printError("Unable to connect to " + string);
            sQLException.printStackTrace();
            this.disconnect(true);
        }
    }

    private void disconnect(boolean bl) {
        if (this.m_stmt != null) {
            try {
                this.m_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_stmt = null;
        }
        if (this.m_conn != null) {
            block7: {
                try {
                    this.m_conn.close();
                    if (!bl) {
                        this.printString("Disconnected");
                    }
                }
                catch (Exception exception) {
                    if (bl) break block7;
                    this.printError(exception.getMessage());
                }
            }
            this.m_conn = null;
        }
    }

    private void execSql(String string) throws Exception {
        if (this.m_rs != null) {
            this.m_rs.close();
            this.m_rs = null;
        }
        this.m_count = -1;
        if (this.m_stmt.execute(string)) {
            this.m_rs = this.m_stmt.getResultSet();
        } else {
            this.m_count = this.m_stmt.getUpdateCount();
        }
        this.m_header = null;
        this.m_headerLine = null;
        this.displayResult();
    }

    private int getRowSize(ResultSetMetaData resultSetMetaData, int n, int[] nArray) {
        int n2 = 0;
        try {
            for (int i = 1; i <= n; ++i) {
                nArray[i] = resultSetMetaData.getColumnDisplaySize(i);
                n2 += nArray[i] + 2;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return n2;
    }

    private void displayHeader(ResultSetMetaData resultSetMetaData, int n, int n2, int[] nArray) {
        if (this.m_header == null) {
            try {
                char[] cArray = new char[n2];
                char[] cArray2 = new char[n2];
                int n3 = 0;
                for (int i = 1; i <= n; ++i) {
                    String string = resultSetMetaData.getColumnLabel(i);
                    int n4 = nArray[i];
                    string.getChars(0, string.length() < n4 ? string.length() : n4, cArray, n3);
                    for (int j = 0; j < n4; ++j) {
                        cArray2[n3 + j] = 45;
                    }
                    n3 += n4 + 2;
                }
                this.m_header = new String(cArray);
                this.m_headerLine = new String(cArray2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                this.m_header = "";
                this.m_headerLine = "";
            }
        }
        this.printString(this.m_header);
        this.printString(this.m_headerLine);
    }

    private void displayResult() {
        if (this.m_rs == null) {
            if (this.m_count != -1) {
                this.printString("Number of row(s) affected: " + this.m_count);
            } else {
                this.printString("No result set.");
            }
            this.printLine();
            return;
        }
        try {
            int n = 0;
            ResultSetMetaData resultSetMetaData = this.m_rs.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            int[] nArray = new int[n2 + 1];
            int n3 = this.getRowSize(resultSetMetaData, n2, nArray);
            char[] cArray = new char[n3];
            this.printLine();
            this.displayHeader(resultSetMetaData, n2, n3, nArray);
            while (this.m_rs.next()) {
                int n4 = 0;
                for (int i = 1; i <= n2; ++i) {
                    int n5 = nArray[i];
                    for (int j = 0; j < n5; ++j) {
                        cArray[n4 + j] = 32;
                    }
                    String string = this.m_rs.getString(i);
                    if (string != null) {
                        string.getChars(0, string.length(), cArray, n4);
                    }
                    n4 += n5 + 2;
                }
                this.printString(new String(cArray));
                ++n;
            }
            this.printLine();
            if (n < 2) {
                this.printString(n + " row returned");
            } else {
                this.printString(n + " rows returned");
            }
        }
        catch (SQLException sQLException) {
            this.printError(sQLException.getMessage());
        }
    }
}

