/************** OmniAccess API C Header file - oa.h **************************/
/*   This C language header file describes the OmniAccess API layer of       */
/*   Omnidex for Open Systems                                                */
/*                                                                           */
/*                 (c) 1993-2005, Dynamic Information Systems Corporation    */
/*****************************************************************************/

#ifndef OA_H_DEFINED
#define OA_H_DEFINED

/**************************** DEFINE STATEMENTS    ***************************/

/* VARIABLE DECLARATION DEFINES */

#undef int32

#if defined (__hpux)
#define int32                     int
#elif defined (__sun)
#define int32                     int
#elif defined(__linux__)
#define int32    int
#elif defined (_WIN32)
#define int32                     int
#elif defined (_WINDOWS) || defined (__MSDOS__) || defined (_MSDOS)
#define int32                     long
#endif


/* Shared library section */

#if defined (__hpux)
# if defined(__ia64)
# define OA_LIBRARY_NAME     "libodxoa.so"
# else
# define OA_LIBRARY_NAME     "libodxoa.sl"
# endif
#elif defined (__linux__) || defined (__sun)
#define OA_LIBRARY_NAME     "libodxoa.so"
#elif defined (_WIN32) || defined (_WINDOWS) || defined (__MSDOS__) || defined (_MSDOS)
#define OA_LIBRARY_NAME     "odxoa.dll"
#else
#define OA_LIBRARY_NAME     "NO_OA_DYN_LIB"
#endif

/* Environment Variables and Definitions */

#define     OAVAR_OMNIDEX_LIBS                    "OMNIDEX_LIBS"
#define     OAVAR_OMNIDEX_REG                     "OMNIDEX_REG"
#define     OAVAR_OMNIDEX_PROXY                   "OMNIDEX_PROXY"
#define     OAVAR_OMNIDEX_HOME                    "OMNIDEX_HOME"
#define     OAVAR_OMNIDEX_DATA                    "OMNIDEX_DATA"
#define     OAVAR_OMNIDEX_LANG                    "OMNIDEX_LANG"
#define     OAVAR_OMNIDEX_LOGS                    "OMNIDEX_LOGS"
#define     OAVAR_OMNIDEX_DEBUG                   "OMNIDEX_DEBUG"
#define     OAVAR_OMNIDEX_DEBUG_FILE              "OMNIDEX_DEBUG_FILE"
#define     OAVAR_OMNIDEX_OPTIONS                 "OMNIDEX_OPTIONS"
#define     OAVAR_OMNIDEX_ENV_NAME                "OMNIDEX_ENV"
#define     OAVAR_ODXERROR                        "ODXERROR"
#define     OAVAR_WNSEARCHDIR                     "WNSEARCHDIR"
#define     OAVAR_DEBUG                           "OA_DEBUG"
#define     OAVAR_DATABASE_ACCESS                 "OA_DATABASE_ACCESS"

#define     OA_GLOBAL_ENV_NAME                    "Omnidex.xml"
#define     OA_GLOBAL_REG_NAME                    "odxreg"
#define     OA_GLOBAL_PROXY_NAME                  "odxproxy"
#if defined (_WIN32)
#define     OA_GLOBAL_LIB_DIR                     "bin"
#else
#define     OA_GLOBAL_LIB_DIR                     "lib"
#endif
#define     OA_GLOBAL_CONFIG_DIR                  "config"
#define     OA_GLOBAL_DEBUG_FILE                  "odxdebug.log"
#define     OA_GLOBAL_XML_NAMESPACE               "Omnidex"
#define     OA_GLOBAL_XML_SCHEMA                  "Omnidex.xsd"

#define     OA_TEMPDB_NAME                        "$TEMPDB"
#define     OA_GLOBALDB_NAME                      "$OMNIDEX_GLOBAL_CONFIGURATION"
#define     OA_SYSCATDB_NAME                      "$SYSTEM_CATALOG"

/* Suffixes */

#define     OA_DDL_SUFFIX                         ".sql"
#define     OA_DSN_SUFFIX                         ".dsn"
#define     OA_FIX_SUFFIX                         ".dat"
#define     OA_OFX_SUFFIX                         ".ofx"
#define     OA_OST_SUFFIX                         ".ost"
#define     OA_OXB_SUFFIX                         ".env"
#define     OA_TDF_SUFFIX                         ".tdf"
#define     OA_XML_SUFFIX                         ".xml"
#define     OA_STATS_SUFFIX                       "STATS"

/* Tokens */

#define     OATOKEN_TOKEN_ID                      '$'
#define     OATOKEN_ROWID                         "$ROWID"
#define     OATOKEN_ODXID                         "$ODXID"
#define     OATOKEN_VALUES                        "$VALUES"
#define     OATOKEN_UNIQUEKEY                     "$UNIQUEKEY"
#define     OATOKEN_LOCAL                         "$LOCAL"

/* Sizes and limits */

#define     OAMAXSIZE_ENV_NAME                    32
#define     OAMAXSIZE_DB_NAME                     32
#define     OAMAXSIZE_USERNAME                    32
#define     OAMAXSIZE_PASSWORD                    32
#define     OAMAXSIZE_TABLE_NAME                  32
#define     OAMAXSIZE_COLUMN_NAME                 32
#define     OAMAXSIZE_NAME_PAIR                   76
#define     OAMAXSIZE_INDEX_NAME                  32
#define     OAMAXSIZE_INDEX_COMP_NAME             32
#define     OAMAXSIZE_CONST_NAME                  32
#define     OAMAXSIZE_NODENAME                    32
#define     OAMAXSIZE_POOLNAME                    32
#define     OAMAXSIZE_FILENAME                    255
#define     OAMAXSIZE_PHYSICAL                    255
#define     OAMAXSIZE_ERROR_MSG                   255
#define     OAMAXSIZE_OPTIONLIST                  256
#define     OAMAXSIZE_MESSAGE_ID                  64
#define     OAMAXSIZE_MESSAGE                     32768
#define     OAMAXSIZE_TABLELIST                   4096
#define     OAMAXSIZE_SELECTLIST                  65536
#define     OAMAXSIZE_CRITERIA                    65536
#define     OAMAXSIZE_ODX_CRITERIA                4096
#define     OAMAXSIZE_SQL_STATEMENT               65536
#define     OAMAXSIZE_OPERATOR                    24
#define     OAMAXSIZE_VALUE                       64
#define     OAMAXSIZE_VALUES_LABEL                8
#define     OAMAXSIZE_TAGNAME                     30
#define     OAMAXSIZE_EXPORT_SIZE                 65536
#define     OAMAXSIZE_TITLE                       80
#define     OAMAXSIZE_VERSION                     32
#define     OAMAXSIZE_PROMPT                      32
#define     OAMAXSIZE_HEADING                     32
#define     OAMAXSIZE_LABEL                       32
#define     OAMAXSIZE_SAVEPOINT                   32
#define     OAMAXSIZE_SEGMENT_NAME                32
#define     OAMAXSIZE_HOSTNAME                    64
#define     OAMAXSIZE_GROUP_NAME                  32
#define     OAMAXSIZE_CONNECTION_STRING           2062

#define     OALIMIT_MAX_VALUES                    256
#define     OALIMIT_MAX_VERSIONS                  200

#define     OALIMIT_COL_LENGTH                    67108864 /* 64M */
#define     OALIMIT_CHAR_LENGTH                   4095 /* 4K - 1 */
#define     OALIMIT_ROWID_LENGTH                  64
#define     OALIMIT_UNIQUEKEY_LENGTH              64
#define     OALIMIT_PRI_CONST_LENGTH              246
#define     OALIMIT_TBLS_PER_DB                   511
#define     OALIMIT_PRI_CONSTS_PER_TBL            1
#define     OALIMIT_FOR_CONSTS_PER_TBL            31
#define     OALIMIT_CHILDREN_PER_PARENT           31
#define     OALIMIT_COLS_PER_TBL                  1024
#define     OALIMIT_COLS_PER_DB                   8192
#define     OALIMIT_ODX_COL_LENGTH                16777216 /* 16M */
#define     OALIMIT_ODX_RECLEN_PER_TBL            16842751 /* 65535 + 16M */
#define     OALIMIT_ODX_OFFSET_PER_COL            65535
#define     OALIMIT_ODX_CHAR_LENGTH               4095 /* 4K - 1 */
#define     OALIMIT_IDX_FILES_PER_DB              2048 /* Including root file */
#define     OALIMIT_PARSED_KEYWORD_LENGTH         32
#define     OALIMIT_DISTRIBUTED_INDEX_LENGTH      244
#define     OALIMIT_BITMAP_INDEX_CARDINALITY      100

#define     OADEFAULT_EXPORT_LIMIT                10000000
#define     OADEFAULT_EXPORT_SIZE                 65536
#define     OADEFAULT_EXPORT_PROGRESS_FILE        "export.log"
#define     OADEFAULT_CHAR_SIZE                   32
#define     OADEFAULT_APPROX_MATCH_TOLERANCE      2.0e-7
#define     OADEFAULT_LANGUAGE                    "english"
#define     OADEFAULT_PORT                        7555
#define     OADEFAULT_EXTRACT_FILE                "extract.sql"

/* oadescribe types */

#define     OA_COLUMN_IDENTIFIER                  1
#define     OA_COLUMN_INTEGER                     2
#define     OA_COLUMN_FLOAT                       3
#define     OA_COLUMN_LITERAL                     4
#define     OA_COLUMN_EXPRESSION                  5

/* subtypes */
#define     OA_COLUMN_SUBTYPE_PSEUDO              1
#define     OA_COLUMN_SUBTYPE_MERGED              2

/* datatypes used in oadescribe, oabind, oa___info, etc. */

#define     OADATATYPE_MIXED                      99    /* for indexes only */
#define     OADATATYPE_CHAR                       100
#define     OADATATYPE_NCHAR                      102
#define     OADATATYPE_C_STRING                   201
#define     OADATATYPE_NC_STRING                  202
#define     OADATATYPE_SIGNED_INT                 300
#define     OADATATYPE_INTEGER                    300
#define     OADATATYPE_SIGNED_TINYINT             301
#define     OADATATYPE_TINYINT                    301
#define     OADATATYPE_SIGNED_SMALLINT            302
#define     OADATATYPE_SMALLINT                   302
#define     OADATATYPE_SIGNED_BIGINT              303
#define     OADATATYPE_BIGINT                     303
#define     OADATATYPE_OMNIDEX_LATITUDE           304
#define     OADATATYPE_OMNIDEX_LONGITUDE          305
#define     OADATATYPE_UNSIGN_INT                 400
#define     OADATATYPE_UNSIGN_TINYINT             401
#define     OADATATYPE_UNSIGN_SMALLINT            402
#define     OADATATYPE_UNSIGN_BIGINT              403
#define     OADATATYPE_BOOLEAN                    500
#define     OADATATYPE_BITMAP                     501
#define     OADATATYPE_FLOAT                      600
#define     OADATATYPE_HP_REAL                    601
#define     OADATATYPE_HP_FLOAT                   601
#define     OADATATYPE_D_FLOAT                    602
#define     OADATATYPE_G_FLOAT                    603
#define     OADATATYPE_F_FLOAT                    604
#define     OADATATYPE_DOUBLE                     605
#define     OADATATYPE_PACKED                     700
#define     OADATATYPE_ZONED                      800
#define     OADATATYPE_R_O_ZONED                  800
#define     OADATATYPE_R_EBCDIC_O_ZONED           800
#define     OADATATYPE_L_O_ZONED                  801
#define     OADATATYPE_L_EBCDIC_O_ZONED           801
#define     OADATATYPE_R_S_ZONED                  802
#define     OADATATYPE_L_S_ZONED                  803
#define     OADATATYPE_UNSIGN_ZONED               804
#define     OADATATYPE_DIBOL_ZONED                805
#define     OADATATYPE_R_ASCII_O_ZONED            805
#define     OADATATYPE_L_ASCII_O_ZONED            806
#define     OADATATYPE_RADIX50                    900
#define     OADATATYPE_ANSI_DATE                  1000  /* yyyy-mm-dd */
#define     OADATATYPE_INFORMIX_DATE              1001
#define     OADATATYPE_PH_DATE                    1002
#define     OADATATYPE_ASK_DATE                   1003
#define     OADATATYPE_J_DATE                     1004
#define     OADATATYPE_MM_DATE                    1005
#define     OADATATYPE_RSI_DATE                   1006
#define     OADATATYPE_ODBC_DATE                  1007
#define     OADATATYPE_ASCII_DATE                 1008
#define     OADATATYPE_OMNIDEX_DATE               1099
#define     OADATATYPE_ANSI_TIME                  1100  /* hh:mm:ss.ff */
#define     OADATATYPE_ODBC_TIME                  1101
#define     OADATATYPE_OMNIDEX_TIME               1199
#define     OADATATYPE_ANSI_DATETIME              1200/*yyyy-mm-dd hh:mm:ss.ff*/
#define     OADATATYPE_VMS_DATETIME               1201
#define     OADATATYPE_ORACLE_DATETIME            1202
#define     OADATATYPE_SQLSERVER_DATETIME         1204
#define     OADATATYPE_SYBASE_DATETIME            1204
#define     OADATATYPE_C_DATETIME                 1205
#define     OADATATYPE_INFORMIX_DATETIME          1206
#define     OADATATYPE_ODBC_DATETIME              1207
#define     OADATATYPE_OMNIDEX_DATETIME           1299
#define     OADATATYPE_DISC_DATETIME              1299
#define     OADATATYPE_ORACLE_ROWID               1501
#define     OADATATYPE_RMS_ROWID                  1502
#define     OADATATYPE_IMAGE_ROWID                1503
#define     OADATATYPE_FLATFILE_ROWID             1504
#define     OADATATYPE_INFORMIX_ROWID             1506
#define     OADATATYPE_SYBASE_ROWID               1507
#define     OADATATYPE_ISAM_ROWID                 1508
#define     OADATATYPE_CISAM_ROWID                1509
#define     OADATATYPE_DISAM_ROWID                1511
#define     OADATATYPE_SQLSERVER_ROWID            1513
#define     OADATATYPE_VARCHAR                    1700
#define     OADATATYPE_NVARCHAR                   1702
#define     OADATATYPE_OMNIDEX_VARCHAR            1799
#define     OADATATYPE_CLOB                       1800
#define     OADATATYPE_NCLOB                      1802
#define     OADATATYPE_OMNIDEX_CLOB               1899
#define     OADATATYPE_BLOB                       1900
#define     OADATATYPE_OMNIDEX_BLOB               1999


/* dataclasses used in oadescribe, oabind, oa___info, etc. */

#define     OADATACLASS_BINARY                    0
#define     OADATACLASS_CHAR                      1
#define     OADATACLASS_INT                       3
#define     OADATACLASS_FLOAT                     6
#define     OADATACLASS_DATE                      10
#define     OADATACLASS_ROWID                     15


/* datausages used in oadescribe, oabind, oa___info, etc. */

#define     OADATAUSAGE_NONE                      0
#define     OADATAUSAGE_ADDRESS                   1
#define     OADATAUSAGE_CITY                      2
#define     OADATAUSAGE_STATE                     3
#define     OADATAUSAGE_COUNTY                    4
#define     OADATAUSAGE_COUNTRY                   5
#define     OADATAUSAGE_ZIPCODE                   6
#define     OADATAUSAGE_LATITUDE                  7
#define     OADATAUSAGE_LONGITUDE                 8
#define     OADATAUSAGE_AUTOID                    9
#define     OADATAUSAGE_ROWID                     10
#define     OADATAUSAGE_AUTO_ROWID                11
#define     OADATAUSAGE_ASC_ROWID                 12
#define     OADATAUSAGE_ASC_AUTO_ROWID            13

/* Function Defines for Oa_last_function */
/* NOTE: Changes here need to be reflected in dl_mon */
#define     OAFUNCTION_ASSIGNVALUES               1
#define     OAFUNCTION_BEGIN                      2
#define     OAFUNCTION_BIND                       3
#define     OAFUNCTION_CLOSECURSOR                4
#define     OAFUNCTION_COLUMNLISTINFO             5
#define     OAFUNCTION_COMMAND                    6
#define     OAFUNCTION_COMMIT                     7
#define     OAFUNCTION_CONNECT                    8
#define     OAFUNCTION_CONVERTDATA                9
#define     OAFUNCTION_COPYFILE                   10
#define     OAFUNCTION_CURSORINFO                 11
#define     OAFUNCTION_DATABASEINFO               12
#define     OAFUNCTION_DELETE                     13
#define     OAFUNCTION_DELETEINDEX                14
#define     OAFUNCTION_DELETEWHERE                15
#define     OAFUNCTION_DESCRIBE                   16
#define     OAFUNCTION_DISCONNECT                 17
#define     OAFUNCTION_DROPTABLE                  18
#define     OAFUNCTION_ENVIRONMENTINFO            19
#define     OAFUNCTION_ERROR                      20
#define     OAFUNCTION_EXECDB                     21
#define     OAFUNCTION_EXECSQL                    22
#define     OAFUNCTION_EXPLAINPLAN                23
#define     OAFUNCTION_EXPORT                     24
#define     OAFUNCTION_EXTERNAL                   25
#define     OAFUNCTION_EXTRACT                    26
#define     OAFUNCTION_FETCH                      27
#define     OAFUNCTION_FETCHKEYS                  28
#define     OAFUNCTION_FORM                       29
#define     OAFUNCTION_HELPER                     30
#define     OAFUNCTION_INDEXINFO                  31
#define     OAFUNCTION_INSERT                     32
#define     OAFUNCTION_INSERTINDEX                33
#define     OAFUNCTION_JOIN                       34
#define     OAFUNCTION_LIST                       35
#define     OAFUNCTION_MESSAGE                    36
#define     OAFUNCTION_OPENCURSOR                 37
#define     OAFUNCTION_QUALIFY                    38
#define     OAFUNCTION_ROLLBACK                   39
#define     OAFUNCTION_SAVEPOINT                  40
#define     OAFUNCTION_SELECT                     41
#define     OAFUNCTION_SETTINGSINFO               42
#define     OAFUNCTION_SHOW                       43
#define     OAFUNCTION_STATEMENTINFO              44
#define     OAFUNCTION_TABLEINFO                  45
#define     OAFUNCTION_UPDATE                     46
#define     OAFUNCTION_UPDATEINDEX                47
#define     OAFUNCTION_UPDATEINDEXES              48
#define     OAFUNCTION_UPDATEROLLUP               49
#define     OAFUNCTION_UPDATEROLLUPS              50
#define     OAFUNCTION_UPDATESTATISTICS           51
#define     OAFUNCTION_UPDATETEXT                 52
#define     OAFUNCTION_UPDATEWHERE                53
#define     OAFUNCTION_VERSION                    54
#define     OAFUNCTION_DEBUG                      55
#define     OAFUNCTION_DEBUGSETTINGS              56


/* The following are used both in select/fetch from the environment file
   (system catalog) and in oa___info routines return values */

/* Byte order of host, passed back in status->OA_ENDIAN from oa___info() */

#define     OA_BIG_ENDIAN                         1
#define     OA_LITTLE_ENDIAN                      2

/* oaenv_t "type" */

#define     OA_ENVIRONMENTTYPE_ENV                2
#define     OA_ENVIRONMENTTYPE_EAC                5
#define     OA_ENVIRONMENTTYPE_XML                6
#define     OA_ENVIRONMENTTYPE_DSN                7

/* oaenvnode_t "type" */

#define     OA_NODETYPE_UNKNOWN                   0
#define     OA_NODETYPE_PARTITIONED               1
#define     OA_NODETYPE_UNPARTITIONED             2
#define     OA_NODETYPE_ROLLUP                    3

/* oadb_t "type" */

#define     OA_DATABASETYPE_UNKNOWN               0
#define     OA_DATABASETYPE_ORACLE                1
#define     OA_DATABASETYPE_INFORMIX              3
#define     OA_DATABASETYPE_RMS                   11
#define     OA_DATABASETYPE_FLATFILE              14
#define     OA_DATABASETYPE_ODBC                  19
#define     OA_DATABASETYPE_GRID_CONTROLLER       21
#define     OA_DATABASETYPE_DB2                   22
#define     OA_DATABASETYPE_SQLSERVER             23
#define     OA_DATABASETYPE_SQL_DEVELOPMENT       219
#define     OA_DATABASETYPE_TBL_DEVELOPMENT       220
#define     OA_DATABASETYPE_ENVMAP                223

/* oadb_t "subtype" */

#define     OA_DATABASE_SUBTYPE_NONE              0
#define     OA_DATABASE_SUBTYPE_ORACLE            1
#define     OA_DATABASE_SUBTYPE_INFORMIX          2
#define     OA_DATABASE_SUBTYPE_DB2               4
#define     OA_DATABASE_SUBTYPE_SQLSERVER         5
#define     OA_DATABASE_SUBTYPE_ACCESS            6
#define     OA_DATABASE_SUBTYPE_MYSQL             7

/* oadb_t "access_flag" */

#define     OA_DATABASEACCESS_READ_ONLY           1
#define     OA_DATABASEACCESS_READ_WRITE          2
#define     OA_DATABASEACCESS_ASSUMED_UPDATE      3

/* oadb_t "locking_flag" */

#define     OA_DATABASELOCKING_STANDARD           1
#define     OA_DATABASELOCKING_OPTIMISTIC         2

/* oadb_t "classification" */

#define     OA_DATABASECLASS_SQL                  1
#define     OA_DATABASECLASS_TABLE                3

/* oadb_t "indexmaintenance" and oatbl_t "indexmaintenance" */

#define     OA_INDEXMAINTENANCE_API               1
#define     OA_INDEXMAINTENANCE_DBMS              2

/* oatbl_t "type" */

#define     OA_TABLETYPE_NONE                     0
#define     OA_TABLETYPE_INDEXED                  1    /* rms only */
#define     OA_TABLETYPE_SEQUENTIAL               2    /* rms only */
#define     OA_TABLETYPE_RELATIVE                 3    /* rms only */
#define     OA_TABLETYPE_OST                      14   /* flatfile only */
#define     OA_TABLETYPE_TDF                      15   /* flatfile only */
#define     OA_TABLETYPE_XML                      16
#define     OA_TABLETYPE_FIXED                    18
#define     OA_TABLETYPE_GRID                     19
#define     OA_TABLETYPE_SYSCAT                   32
#define     OA_TABLETYPE_CACHED_VIEW              222
#define     OA_TABLETYPE_DYNAMIC_VIEW             223
#define     OA_TABLETYPE_VIEW                     OA_TABLETYPE_DYNAMIC_VIEW

/* oatbl_t "role" */

#define     OA_TABLEROLE_TABLE                    1
#define     OA_TABLEROLE_PARTITIONED_TABLE        2
#define     OA_TABLEROLE_PARTITION                3
#define     OA_TABLEROLE_ROLLUP                   4

/* oatbl_t "odx_table_type", oacursor_t "odx_list_type", and
   oaidx_t "owner_odx_table_type" */

#define     OA_ODX_TYPE_NONE                      0  /* No omnidex installed */
#define     OA_ODX_TYPE_IDSI                      1
#define     OA_ODX_TYPE_TR                        2
#define     OA_ODX_TYPE_TRR                       3
#define     OA_ODX_TYPE_DR                        4
#define     OA_ODX_TYPE_LINKED_CHILD              5
#define     OA_ODX_TYPE_HYBRID_IDSI               6
#define     OA_ODX_TYPE_HYBRID_TR                 7
#define     OA_ODX_TYPE_HYBRID_TRR                8
#define     OA_ODX_TYPE_HYBRID_DR                 9
#define     OA_ODX_TYPE_ASK_ONLY                  10
#define     OA_ODX_TYPE_IMSAM_ONLY                OA_ODX_TYPE_ASK_ONLY
#define     OA_ODX_TYPE_RS_CHILD                  11 /* odx_list_type only */
#define     OA_ODX_TYPE_RC_CHILD                  12 /* odx_list_type only */
#define     OA_ODX_TYPE_PROXIMITY                 13 /* odx_list_type only */
#define     OA_ODX_TYPE_KEYWD                     14 /* odx_list_type only */
#define     OA_ODX_TYPE_UNKNOWN                   99

/* oatbl_t "data_cache" */

#define     OA_DATA_CACHING_STATIC                1
#define     OA_DATA_CACHING_DYNAMIC               2
#define     OA_DATA_CACHING_NONE                  3


/* oaconst_t "type" */

#define     OA_CONSTRAINTTYPE_PRIMARY_KEY         1
#define     OA_CONSTRAINTTYPE_FOREIGN_KEY         2
#define     OA_CONSTRAINTTYPE_UNIQUE_KEY          3
#define     OA_CONSTRAINTTYPE_DISTINCT_KEY        4

/* oacol_t "type" */

#define     OA_COLUMNTYPE_NATIVE                  1
#define     OA_COLUMNTYPE_KEY                     2
#define     OA_COLUMNTYPE_USER_PSEUDO             3
#define     OA_COLUMNTYPE_AUTO_PSEUDO             4

/* oacol_t "datatype" values: refer to OADATATYPE #defines above */

/* oaidx_t "type" and "method" */

#define     OA_INDEXTYPE_NATIVE                   3
#define     OA_INDEXTYPE_HASHED                   OA_INDEXTYPE_NATIVE
#define     OA_INDEXTYPE_LINKED                   OA_INDEXTYPE_NATIVE
#define     OA_INDEXTYPE_SORTED                   OA_INDEXTYPE_NATIVE
#define     OA_INDEXTYPE_INVERTED                 OA_INDEXTYPE_NATIVE
#define     OA_INDEXTYPE_OMNIDEX_ASK              5
#define     OA_INDEXTYPE_ODX_SORTED               OA_INDEXTYPE_OMNIDEX_ASK
#define     OA_INDEXTYPE_OMNIDEX_MDK              6
#define     OA_INDEXTYPE_ODX_INVERTED             OA_INDEXTYPE_OMNIDEX_MDK
#define     OA_INDEXTYPE_OMNIDEX                  11
#define     OA_INDEXTYPE_QUICKTEXT                12
#define     OA_INDEXTYPE_FULLTEXT                 13
#define     OA_INDEXTYPE_CUSTOM                   20

/* optimization types */

#define     OA_OPT_USING_ASK                      1
#define     OA_OPT_USING_IMSAM                    OA_OPT_USING_ASK
#define     OA_OPT_USING_MDK_COUNT                2
#define     OA_OPT_USING_ODX_COUNT                OA_OPT_USING_MDK_COUNT
#define     OA_OPT_MEMORY_MULTIFIND               3
#define     OA_OPT_FILE_MULTIFIND                 4
#define     OA_OPT_COMPRESS                       5
#define     OA_OPT_EXPAND                         6
#define     OA_OPT_COMPRESS_AND_EXPAND            7
#define     OA_OPT_DEFERRED_COMPRESS              8
#define     OA_OPT_DEFERRED_EXPAND                9
#define     OA_OPT_DEFERRED_COMP_AND_EXPAND      10
#define     OA_OPT_BITMAP_JOIN                   11
#define     OA_OPT_UNDO                          12
#define     OA_OPT_PRESERVE_RS                   13
#define     OA_OPT_DEFERRED_PRESERVE_RS          14
#define     OA_OPT_DEFERRED_BITMAP_JOIN          15

/* oaidx_component_t "type" */

#define     OA_IXCOMPTYPE_DATA                    1
#define     OA_IXCOMPTYPE_TARGET                  2
#define     OA_IXCOMPTYPE_TARGET_PRIMARY_SI       4
#define     OA_IXCOMPTYPE_TARGET_FOREIGN_SI       5
#define     OA_IXCOMPTYPE_TARGET_UNIQUEKEY        6

/* oacursor_t "cursor_state" */

#define     OA_CURSORSTATE_EMPTY                  1
#define     OA_CURSORSTATE_LOADED                 2
#define     OA_CURSORSTATE_DESCRIBED              3
#define     OA_CURSORSTATE_BOUND                  4
#define     OA_CURSORSTATE_CUSTOM                 5
#define     OA_CURSORSTATE_ACTIVE                 6
#define     OA_CURSORSTATE_DEACTIVATED            7

/* oaenv_t "sql_syntax" and oacursor_t "sql_syntax" */

#define     OA_SQL_SYNTAX_OMNIDEX                 1
#define     OA_SQL_SYNTAX_OMNIDEX_PLUS            2
#define     OA_SQL_SYNTAX_ORACLE                  4
#define     OA_SQL_SYNTAX_SQLSERVER               8


/* statement-id returned by oaexecsql */

#define     OASTATEMENT_COMMAND                   1
#define     OASTATEMENT_CONNECT                   2
#define     OASTATEMENT_OPEN                      3
#define     OASTATEMENT_QUALIFY                   4
#define     OASTATEMENT_JOIN                      5
#define     OASTATEMENT_SELECT                    6
#define     OASTATEMENT_SELECT_INTO               7
#define     OASTATEMENT_SELECT_BENCHMARK          8
#define     OASTATEMENT_EXPORT                    9
#define     OASTATEMENT_EXPORT_WHERE              10
#define     OASTATEMENT_INSERT                    11
#define     OASTATEMENT_UPDATE                    12
#define     OASTATEMENT_UPDATE_WHERE              13
#define     OASTATEMENT_DELETE                    14
#define     OASTATEMENT_DELETE_WHERE              15
#define     OASTATEMENT_CLOSE                     16
#define     OASTATEMENT_DISCONNECT                17
#define     OASTATEMENT_SET                       18
#define     OASTATEMENT_VERSION                   19
#define     OASTATEMENT_ATTACH_TABLE              20
#define     OASTATEMENT_DETACH_TABLE              21
#define     OASTATEMENT_DROP_TABLE                22
#define     OASTATEMENT_CREATE_TABLE              23
#define     OASTATEMENT_ASSIGNVALUES              24
#define     OASTATEMENT_INSERTINDEX               25
#define     OASTATEMENT_DELETEINDEX               26
#define     OASTATEMENT_UPDATEINDEX               27
#define     OASTATEMENT_REMOVE_FILE               28
#define     OASTATEMENT_UPDATE_INDEXES            30
#define     OASTATEMENT_UPDATE_ROLLUPS            31
#define     OASTATEMENT_UPDATE_STATISTICS         32
#define     OASTATEMENT_UPDATE_TEXT               33
#define     OASTATEMENT_HELPER                    34
#define     OASTATEMENT_LOAD_OFX                  35
#define     OASTATEMENT_INSTALL_INDEXES           36
#define     OASTATEMENT_REMOVE_INDEXES            37
#define     OASTATEMENT_PARTITION                 38
#define     OASTATEMENT_UPDATE_ROLLUP             39
#define     OASTATEMENT_CREATE_ENVIRONMENT        40
#define     OASTATEMENT_DROP_ENVIRONMENT          41
#define     OASTATEMENT_CREATE_DATABASE           42
#define     OASTATEMENT_DROP_DATABASE             43
#define     OASTATEMENT_CREATE_INDEX              44
#define     OASTATEMENT_DROP_INDEX                45
#define     OASTATEMENT_CREATE_INDEX_GROUP        46
#define     OASTATEMENT_DROP_INDEX_GROUP          47
#define     OASTATEMENT_EXTRACT_DDL               48
#define     OASTATEMENT_EXTRACT_DML               49
#define     OASTATEMENT_ATTACH_DATABASE           50
#define     OASTATEMENT_DETACH_DATABASE           51
#define     OASTATEMENT_ATTACH_SEGMENT            52
#define     OASTATEMENT_DETACH_SEGMENT            53
#define     OASTATEMENT_CREATE_SEGMENT            54
#define     OASTATEMENT_CREATE_SEGMENT_WHERE      55
#define     OASTATEMENT_DROP_SEGMENT              56
#define     OASTATEMENT_ACQUIRE_CONNECTION        57
#define     OASTATEMENT_RELEASE_CONNECTION        58
#define     OASTATEMENT_SETENV                    59

/* OA_PREPROCESSOR_STATES describe the current state of the processor */
#define     OA_PREPROCESSOR_STATE_STUB            -1
#define     OA_PREPROCESSOR_STATE_OFF             0
#define     OA_PREPROCESSOR_STATE_ON              1

/* OA_PREPROCESSOR_ACTIONS describe the action for oap_state */
#define     OA_PREPROCESSOR_ACTION_OFF            0
#define     OA_PREPROCESSOR_ACTION_ON             1
#define     OA_PREPROCESSOR_ACTION_POLL           2

/* OA_SERVER_STATES describe the current state of the server */
#define     OA_SERVER_STATE_UNKNOWN               0
#define     OA_SERVER_STATE_DISCONNECTED          1
#define     OA_SERVER_STATE_WAITING               2
#define     OA_SERVER_STATE_PROCESSING            3
#define     OA_SERVER_STATE_TRANSMITTING          4

/* OA_LICENSE_TYPE describes the type of Omnidex license */
#define     OA_LICENSE_TYPE_NONE                  0
#define     OA_LICENSE_TYPE_TRIAL                 1
#define     OA_LICENSE_TYPE_DEVELOPER             2
#define     OA_LICENSE_TYPE_ENTERPRISE            3
#define     OA_LICENSE_TYPE_LEGACY_TRIAL          8
#define     OA_LICENSE_TYPE_LEGACY_ENTERPRISE     9

/* OA_PERSISTENCE describes the persistence of a table's or segment's data */
#define     OA_PERSISTENCE_PERMANENT              1
#define     OA_PERSISTENCE_TEMPORARY              2

/* OA_METADATA describes the type of a table's or database's metadata */
#define     OA_METADATA_LOCAL                     1
#define     OA_METADATA_TEMPORARY                 2
#define     OA_METADATA_ATTACHED                  3


/* oastatus data elements */


#define     OA_PARENT_COUNT                       data[0]
#define     OA_GROUP_COUNT                        data[0]
#define     OA_PREINTERSECT_COUNT                 data[1]
#define     OA_PREINT_COUNT                       data[1]
#define     OA_VERSION_NUM                        data[1]
#define     OA_NUM_COLS                           data[2]
#define     OA_IDX_ENTRIES                        data[2]
#define     OA_INDEX_RS                           data[2]
#define     OA_OPTIMIZATION                       data[3]
#define     OA_STATEMENT_ID                       data[3]
#define     OA_ENDIAN                             data[4]
#define     OA_INDEX_SI_LEN                       data[4]
#define     OA_VALUE_SIZE                         data[4]
#define     OA_MAXFOPENS                          data[4]
#define     OA_INDEX_MAX_KEY_LENGTH               data[5]
#define     OA_IABASEID                           data[5]
#define     OA_INDEX_PROXIMITY                    data[6]
#define     OA_INDEX_PRESERVE_RS                  data[7]
#define     OA_INDEX_KEYWD                        data[8]
#define     OA_ODX_TYPE                           data[9]
#define     OA_CONNECTIONID                       data[10]
#define     OA_STATEMENTID                        data[11]
#define     OA_SINGLE_COUNT                       data[15]
#define     OA_NUM_SKIPPED                        data[16] /* EOD condition only; PARTIAL amount */
#define     OA_EVERY_REMAINDER                    data[17] /* EOD condition only */
#define     OA_UNIQUEKEY_WB                       data[31] /* is uniquekey a well-behaved 4-byte int? */

/* CLOA-specific oastatus data usages */
#define     CL_OA_VERSION_NUMBER                  data[0]
#define     OA_BUFFER_LEN                         data[0]
#define     OA_ROWID                              data[1]
#define     OA_BEFORE_BUFFER_LEN                  data[2]
#define     OA_BEFORE_ROWID                       data[3]
#define     OA_SERVER_STATE                       data[4]
#define     OA_SERVER_HOST                        msgs[7]

/* data returned by VERSION command of oaexecsql() */
#define     OA_OMNIACCESS_VERSION                 data[0]
#define     OA_INDEXACCESS_VERSION                data[1]
#define     OA_BUILD_VERSION                      data[2]

/* OdxNet-specific information sent to oaconnect */
#define     OA_CLIENT_HOST                        msgs[0]
#define     OA_CLIENT_PORT                        data[0]
#define     OA_CLIENT_PID                         data[1]
#define     OA_CLIENT_CONNECTIONID                data[2]

/* OA_SELECT_TYPES is for ways of describing the type of SQL statement */
#define     OA_SELECT_TYPE                        data[1]
#define     OA_SELECT_TYPE_NONE                        0
#define     OA_SELECT_TYPE_INTO                        1
#define     OA_SELECT_TYPE_ROLLUP                      2


/**************************** TYPE DECLARACTIONS      ************************/

/*  oastatus_t is a type declaration for the OmniAccess status               */
/*  array, which is used in nearly all OmniAccess routines                   */

#define OAMAXNUM_STATUSMSGS 8

typedef struct oastatus
{
  int                   error;
  int                   warn;
  int                   info;
  int                   count;
  int                   bufflen;
  int                   instance;
  int                   cursor;
  int                   transaction;
  int                   cpu;
  int                   elapsed;
  int                   data[32];
  char                  buffer[256];
  char                  native_error[256];
  char                  location[256]; /* In form of: file(routine):line */
  char                  context[256];
  char                  msgs[OAMAXNUM_STATUSMSGS][256];
  char                  host[64];
  char                  reserved[960];
} oastatus_t;


/*  oaselect_list_t is a type declaration for the OmniAccess select          */
/*  list control blocks.  These control blocks are used exclusively          */
/*  by the oadescribe() and oabind() functions.                              */

typedef struct oaselect_list
{
  int                   type;
  int                   subtype;
  union
  {
    char                expression[132];
    char                literal[132];
    char                numeric[36];
    struct
    {
      char              environment[33];
      char              database[33];
      char              table[67];
      char              column[33];
    } column;
  } select_item;
  char                  alias[36];
  int                   datatype;
  int                   length;
  int                   usage;
  int                   occurrences;
  int                   offset;
  char                  options[64];
  int                   req_datatype;
  int                   req_length;
  int                   req_usage;
  int                   req_offset;
  char                  req_options[64];
  char                  *data;
  int                   *null_indicator;
  unsigned int          *data_length;
#if !defined (__LP64__) && !defined (_WIN64)
  /* Pad so structure is the same size on all platforms */
  int                   reserved[3];
#endif
} oaselect_list_t;

typedef struct oaselect_class
{
  int                   type;
  int                   subtype;
  union
  {
    char                expression[144];
    char                literal[144];
    char                numeric[144];
    struct
    {
      char              environment[36];
      char              database[36];
      char              table[68];
      char              column[36];
    } column;
  } select_item;
  char                  alias[36];
  int                   datatype;
  int                   length;
  int                   usage;
  int                   occurrences;
  int                   offset;
  char                  options[64];
  int                   req_datatype;
  int                   req_length;
  int                   req_usage;
  int                   req_offset;
  char                  req_options[64];
  unsigned int          data_offset;
  unsigned int          ni_offset;
  unsigned int          dl_offset;
} oaselect_class_t;

typedef struct oaversion
{
  char                  tag[16];
  char                  product[64];
  int                   version_no;
  char                  version[256];
} oaversion_t;


/**************************** FUNCTION PROTOTYPES  ***************************/

/* Put all function prototypes between the cplusplus brackets, otherwise
   C++ users get unresolved externals.   */

#ifdef __cplusplus
extern "C"
{
#endif


/* OmniAccess API */

#if defined (_WIN32) && !defined (_WIN64)
# define FCN_OPTS(fcn_type) fcn_type __stdcall
#else
# define FCN_OPTS(fcn_type) fcn_type
#endif


FCN_OPTS(int) oaconnect            (const char          *environment,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *username,
                                    const char          *password,
                                    int                 *instance);

FCN_OPTS(int) oadisconnect         (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status);

FCN_OPTS(int) oaopencursor         (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 *cursor);

FCN_OPTS(int) oaclosecursor        (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status);

FCN_OPTS(int) oaqualify            (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *owner,
                                    const char          *table,
                                    const char          *column,
                                    const char          *criteria);

FCN_OPTS(int) oajoin               (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *from_table,
                                    const char          *from_column,
                                    const char          *to_owner,
                                    const char          *to_table,
                                    const char          *to_column);

FCN_OPTS(int) oaselect             (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *tables,
                                    const char          *columns,
                                    const char          *criteria);

FCN_OPTS(int) oadescribe           (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_columns,
                                    oaselect_list_t     *select_list);

FCN_OPTS(int) oabind               (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_columns,
                                    oaselect_list_t     *select_list);

FCN_OPTS(int) oadescribe_class     (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_columns,
                                    int                 num_rows,
                                    oaselect_class_t    *select_class);

FCN_OPTS(int) oabind_class         (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_columns,
                                    int                 num_rows,
                                    oaselect_class_t    *select_class);

FCN_OPTS(int) oaexecsql            (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *statement);

FCN_OPTS(int) oaexecdb             (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *database,
                                    const char          *statement);

FCN_OPTS(int) oadroptable          (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table);

FCN_OPTS(int) oaassignvalues       (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *label,
                                    int                 num_values,
                                    void                *values);

FCN_OPTS(int) oafetch              (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_rows,
                                    void                *buffer);

FCN_OPTS(int) oaexport             (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    const char          *filename);

FCN_OPTS(int) oafetchkeys          (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_keys,
                                    void                *keys);

FCN_OPTS(int) oainsert             (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *buffer);

FCN_OPTS(int) oaupdate             (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *buffer);

FCN_OPTS(int) oadelete             (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table);

FCN_OPTS(int) oaupdatewhere        (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *tables,
                                    const char          *columns,
                                    const char          *criteria,
                                    void                *values);

FCN_OPTS(int) oadeletewhere        (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *tables,
                                    const char          *criteria);

FCN_OPTS(int) oainsertindex        (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *buffer,
                                    void                *uniquekey);

FCN_OPTS(int) oaupdateindex        (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *before_buffer,
                                    void                *before_uniquekey,
                                    void                *after_buffer,
                                    void                *after_uniquekey);

FCN_OPTS(int) oadeleteindex        (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *buffer,
                                    void                *uniquekey);

FCN_OPTS(int) oabegin              (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status);

FCN_OPTS(int) oasavepoint          (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *savepoint);

FCN_OPTS(int) oarollback           (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *savepoint);

FCN_OPTS(int) oacommit             (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status);

FCN_OPTS(char *) oaerror           (oastatus_t          *status,
                                    const char          *options,
                                    char                *msg);

FCN_OPTS(int) oamessage            (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *message_id,
                                    char                *message);

FCN_OPTS(int) oalist               (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *tables,
                                    const char          *columns,
                                    const char          *criteria,
                                    int                 num_rows,
                                    void                *buffer);

FCN_OPTS(int) oaform               (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *tables,
                                    const char          *columns,
                                    int                 list_entry,
                                    void                *buffer);

FCN_OPTS(int) oashow               (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status);

FCN_OPTS(int) oadebug              (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node);

FCN_OPTS(int) oadebugsettings      (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    char                *settings);

FCN_OPTS(int) oaversion            (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    int                 num_versions,
                                    oaversion_t         *versions);

FCN_OPTS(int) oacommand            (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    const char          *input,
                                    int                 input_length,
                                    char                *output,
                                    int                 output_length);

FCN_OPTS(int) oaexternal           (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    const char          *library_name,
                                    const char          *routine_name,
                                    const char          *input,
                                    int                 input_length,
                                    char                *output,
                                    int                 output_length);

FCN_OPTS(int) oaconvertdata        (const char          *options,
                                    oastatus_t          *status,
                                    void                *input_data,
                                    const char          *input_type,
                                    int                 input_length,
                                    void                *output_data,
                                    const char          *output_type,
                                    int                 output_length);

FCN_OPTS(int) oaenvironmentinfo    (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *environment,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) oadatabaseinfo       (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *database,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) oatableinfo          (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) oaindexinfo          (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *database,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) oacursorinfo         (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) oacolumnlistinfo     (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table_name,
                                    const char          *column_names,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) oastatementinfo      (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 size,
                                    void                *buffer);

FCN_OPTS(int) oasettingsinfo       (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 size,
                                    void                *buffer);

FCN_OPTS(int) oadbinfo             (int                 instance,
                                    char                *db_name,
                                    int                 mode,
                                    oastatus_t          *status,
                                    void                *parm,
                                    void                *buffer);

FCN_OPTS(int) oacopyfile           (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *from_node,
                                    const char          *from_filename,
                                    const char          *from_options,
                                    const char          *to_file,
                                    const char          *to_filename,
                                    const char          *to_options);

FCN_OPTS(int) oaexplainplan        (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 size,
                                    char                *buffer);

FCN_OPTS(int) oahelper             (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    char                *msg);

/* Client OmniAccess API */

FCN_OPTS(int) CLoaconnect          (const char          *environment,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *username,
                                    const char          *password,
                                    int                 *instance);

FCN_OPTS(int) CLoadisconnect       (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status);

FCN_OPTS(int) CLoaopencursor       (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 *cursor);

FCN_OPTS(int) CLoaclosecursor      (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status);

FCN_OPTS(int) CLoaqualify          (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *owner,
                                    const char          *table,
                                    const char          *column,
                                    const char          *criteria);

FCN_OPTS(int) CLoajoin             (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *from_table,
                                    const char          *from_column,
                                    const char          *to_owner,
                                    const char          *to_table,
                                    const char          *to_column);

FCN_OPTS(int) CLoaselect           (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *tables,
                                    const char          *columns,
                                    const char          *criteria);

FCN_OPTS(int) CLoadescribe         (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_columns,
                                    oaselect_list_t     *select_list);

FCN_OPTS(int) CLoabind             (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_columns,
                                    oaselect_list_t     *select_list);

FCN_OPTS(int) CLoadescribe_class   (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_columns,
                                    int                 num_rows,
                                    oaselect_class_t    *select_class);

FCN_OPTS(int) CLoabind_class       (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_columns,
                                    int                 num_rows,
                                    oaselect_class_t    *select_class);

FCN_OPTS(int) CLoaexecsql          (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *statement);

FCN_OPTS(int) CLoaexecdb           (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *database,
                                    const char          *statement);

FCN_OPTS(int) CLoadroptable        (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table);

FCN_OPTS(int) CLoaassignvalues     (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *label,
                                    int                 num_values,
                                    void                *values);

FCN_OPTS(int) CLoafetch            (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_rows,
                                    void                *buffer);

FCN_OPTS(int) CLoaexport           (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    const char          *filename);

FCN_OPTS(int) CLoafetchkeys        (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 num_keys,
                                    void                *keys);

FCN_OPTS(int) CLoainsert           (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *buffer);

FCN_OPTS(int) CLoaupdate           (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *buffer);

FCN_OPTS(int) CLoadelete           (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table);

FCN_OPTS(int) CLoaupdatewhere      (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *tables,
                                    const char          *columns,
                                    const char          *criteria,
                                    void                *values);

FCN_OPTS(int) CLoadeletewhere      (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *tables,
                                    const char          *criteria);

FCN_OPTS(int) CLoainsertindex      (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *buffer,
                                    void                *uniquekey);

FCN_OPTS(int) CLoaupdateindex      (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *before_buffer,
                                    void                *before_uniquekey,
                                    void                *after_buffer,
                                    void                *after_uniquekey);

FCN_OPTS(int) CLoadeleteindex      (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    const char          *columns,
                                    void                *buffer,
                                    void                *uniquekey);

FCN_OPTS(int) CLoabegin            (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status);

FCN_OPTS(int) CLoasavepoint        (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *savepoint);

FCN_OPTS(int) CLoarollback         (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *savepoint);

FCN_OPTS(int) CLoacommit           (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status);

FCN_OPTS(char *) CLoaerror         (oastatus_t          *status,
                                    const char          *options,
                                    char                *msg);

FCN_OPTS(int) CLoamessage          (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *message_id,
                                    char                *message);

FCN_OPTS(int) CLoadebug            (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node);


FCN_OPTS(int) CLoadebugsettings    (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    char                *settings);


FCN_OPTS(int) CLoaversion          (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    int                 num_versions,
                                    oaversion_t         *versions);

FCN_OPTS(int) CLoacommand          (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    const char          *input,
                                    int                 input_length,
                                    char                *output,
                                    int                 output_length);

FCN_OPTS(int) CLoaexternal         (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *node,
                                    const char          *library_name,
                                    const char          *routine_name,
                                    const char          *input,
                                    int                 input_length,
                                    char                *output,
                                    int                 output_length);

FCN_OPTS(int) CLoaenvironmentinfo  (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *environment,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) CLoadatabaseinfo     (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *database,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) CLoatableinfo        (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) CLoaindexinfo        (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *database,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) CLoacursorinfo       (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) CLoacolumnlistinfo   (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *table_name,
                                    const char          *column_names,
                                    int                 buffer_length,
                                    void                *buffer);

FCN_OPTS(int) CLoastatementinfo    (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 size,
                                    void                *buffer);

FCN_OPTS(int) CLoasettingsinfo     (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 size,
                                    void                *buffer);

FCN_OPTS(int) CL_oacopyfile        (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    const char          *LocalFilename,
                                    const char          *ServerFilename);

FCN_OPTS(int) CLoaexplainplan      (int                 cursor,
                                    const char          *options,
                                    oastatus_t          *status,
                                    int                 size,
                                    char                *buffer);

FCN_OPTS(int) CLoahelper           (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status,
                                    char                *msg);

FCN_OPTS(int) CLoacancel           (int                 instance,
                                    const char          *options,
                                    oastatus_t          *status);

#ifdef __cplusplus
}
#endif


#endif  /* OA_H_DEFINED  */
