/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.util.Properties;
import omnidex.client.OdxCLJConnection;
import omnidex.client.OdxCLJDataResultSet;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJResultSet;
import omnidex.client.OdxCLJStatus;
import omnidex.client.OdxCLJTrace;

public final class OdxCLJStatement {
    private OdxCLJConnection m_owner;
    private OdxCLJConnection m_connection;
    private OdxCLJDataResultSet m_resultSet;
    private OdxCLJStatus m_status;
    private int m_updateCount;
    private int[] m_qualifyCounts;
    private int m_cpuTime;
    private int m_elapsedTime;
    private int m_queryTimeout;
    private int m_maxRows;
    private int m_maxFieldSize;
    private int m_fetchSize;
    private int m_resultSetType;
    private int m_resultSetConcurrency;
    private int m_fetchDirection;
    private boolean m_open;

    protected OdxCLJStatement(OdxCLJConnection odxCLJConnection) {
        this.trace(null);
        this.m_owner = odxCLJConnection;
        this.m_resultSetType = 1003;
        this.m_resultSetConcurrency = 1007;
        this.m_fetchDirection = 1000;
        this.m_qualifyCounts = new int[3];
        this.m_open = true;
    }

    private void checkStatement() throws OdxCLJException {
        if (!this.m_open) {
            throw new OdxCLJException(25504);
        }
    }

    private void clearResultSet() throws OdxCLJException {
        this.trace("clearResultSet");
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
            this.m_resultSet = null;
        }
    }

    private void clearCounts() {
        this.m_qualifyCounts[0] = 0;
        this.m_qualifyCounts[1] = 0;
        this.m_qualifyCounts[2] = 0;
        this.m_cpuTime = 0;
        this.m_elapsedTime = 0;
    }

    private void lockConnection() throws OdxCLJException {
        this.trace("lockConnection");
        if (this.m_connection == null) {
            this.m_connection = this.m_owner.lockConnection();
            this.m_status = this.m_connection.getStatus();
        }
    }

    protected void unlockConnection() throws OdxCLJException {
        this.trace("unlockConnection");
        if (this.m_connection != null) {
            this.m_owner.unlockConnection(this.m_connection);
            this.m_connection = null;
            this.m_status = null;
        }
    }

    protected void clear() throws OdxCLJException {
        this.trace("clear");
        this.clearResultSet();
        this.m_open = false;
    }

    protected void setResultSetType(int n) {
        this.m_resultSetType = n;
    }

    protected void setResultSetConcurrency(int n) {
        if (n == 1005) {
            n = 1004;
        }
        this.m_resultSetConcurrency = n;
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    public int getQueryTimeout() {
        return this.m_queryTimeout;
    }

    public void setQueryTimeout(int n) {
        this.m_queryTimeout = n;
    }

    public int getMaxRows() {
        return this.m_maxRows;
    }

    public void setMaxRows(int n) {
        this.m_maxRows = n;
    }

    public int getMaxFieldSize() {
        return this.m_maxFieldSize;
    }

    public void setMaxFieldSize(int n) {
        this.m_maxFieldSize = n;
    }

    public int getResultSetType() {
        return this.m_resultSetType;
    }

    public int getResultSetConcurrency() {
        return this.m_resultSetConcurrency;
    }

    public int getFetchDirection() {
        return this.m_fetchDirection;
    }

    public void setFetchDirection(int n) {
        this.m_fetchDirection = n;
    }

    public int getFetchSize() {
        return this.m_fetchSize;
    }

    public void setFetchSize(int n) throws OdxCLJException {
        if (n < 0 || this.m_maxRows != 0 && n > this.m_maxRows) {
            throw new OdxCLJException(25516);
        }
        this.m_fetchSize = n;
    }

    public int getUpdateCount() {
        return this.m_updateCount;
    }

    public int[] getQualifyCounts() {
        return this.m_qualifyCounts;
    }

    public int getQualifyingCount() {
        return this.m_qualifyCounts[0];
    }

    public int getParentCount() {
        return this.m_qualifyCounts[1];
    }

    public int getPreIntersectCount() {
        return this.m_qualifyCounts[2];
    }

    public int getCPUTime() {
        return this.m_cpuTime;
    }

    public int getElapsedTime() {
        return this.m_elapsedTime;
    }

    public OdxCLJResultSet executeSQL(String string, Properties properties) throws OdxCLJException {
        this.trace("executeSQL");
        this.checkStatement();
        this.lockConnection();
        this.clearResultSet();
        this.clearCounts();
        byte[] byArray = this.m_status.executeSQL(string, properties, this.m_queryTimeout);
        this.trace("Statement ID: " + this.m_status.getStatusStatementId());
        this.trace("Column Count: " + this.m_status.getStatusColumnCount());
        this.m_qualifyCounts[0] = this.m_updateCount = this.m_status.getStatusCount();
        this.m_qualifyCounts[1] = this.m_status.getStatusParentCount();
        this.m_qualifyCounts[2] = this.m_status.getStatusPreIntersectCount();
        this.m_cpuTime = this.m_status.getStatusCPUTime();
        this.m_elapsedTime = this.m_status.getStatusElapsedTime();
        if (this.m_status.getStatusColumnCount() != 0) {
            this.m_resultSet = new OdxCLJDataResultSet(this, this.m_status, byArray, this.m_owner.getEndian());
            this.m_resultSet.initialize();
            this.m_resultSet.setMaxRows(this.m_maxRows);
            this.m_resultSet.setMaxFieldSize(this.m_maxFieldSize);
            this.m_resultSet.setFetchSize(this.m_fetchSize);
            this.m_resultSet.setFetchDirection(this.m_fetchDirection);
            this.m_resultSet.setType(this.m_resultSetType);
            this.m_resultSet.setConcurrency(this.m_resultSetConcurrency);
        } else {
            OdxCLJTrace.print("Updated: " + this.m_updateCount);
        }
        return this.m_resultSet;
    }

    public OdxCLJResultSet getResultSet() throws OdxCLJException {
        this.checkStatement();
        return this.m_resultSet;
    }

    public void cancel() throws OdxCLJException {
        this.trace("cancel");
        this.checkStatement();
        this.m_status.cancel();
    }

    public void close() throws OdxCLJException {
        this.trace("close");
        this.clear();
        this.unlockConnection();
        this.m_owner.freeStatement(this);
    }
}

