/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import omnidex.client.OdxCLJException;

public final class OdxJDBCBlob
implements Blob {
    private byte[] m_data;
    private long m_length;

    protected OdxJDBCBlob() {
    }

    protected OdxJDBCBlob(byte[] byArray) {
        this.m_data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.m_data, 0, byArray.length);
        this.m_length = byArray.length;
    }

    protected void setInputStream(InputStream inputStream) throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10240);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[10240];
            int n = bufferedInputStream.read(byArray, 0, 10240);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                byArray = new byte[10240];
                n = bufferedInputStream.read(byArray, 0, 10240);
            }
            this.m_data = byteArrayOutputStream.toByteArray();
            this.m_length = this.m_data.length;
        }
        catch (IOException iOException) {
            throw new OdxCLJException(iOException);
        }
    }

    public long length() throws SQLException {
        return this.m_length;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l >= (long)n) {
            throw new OdxCLJException(25521);
        }
        if ((long)n > this.m_length - l) {
            n = (int)((long)n - l);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_data, (int)l, byArray, 0, n);
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.m_data);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        int n = (int)(--l);
        while (n < this.m_data.length) {
            if (byArray.length > this.m_data.length - n) break;
            if (this.m_data[n] == byArray[0]) {
                boolean bl = true;
                int n2 = 1;
                while (n2 < byArray.length) {
                    if (this.m_data[n + n2] != byArray[n2]) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    return n + 1;
                }
            }
            ++n;
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }
}

