/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJResultSet;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCBlob;
import omnidex.jdbc.OdxJDBCResultSetMetaData;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class OdxJDBCResultSet
implements ResultSet {
    private OdxCLJResultSet m_oaResultSet;
    private OdxJDBCResultSetMetaData m_metaData;
    private Statement m_jdbcStatement;
    private InputStream m_inputStream;

    protected OdxJDBCResultSet(Statement statement, OdxCLJResultSet odxCLJResultSet) {
        this.trace(null);
        this.m_oaResultSet = odxCLJResultSet;
        this.m_metaData = new OdxJDBCResultSetMetaData(odxCLJResultSet);
        this.m_jdbcStatement = statement;
        this.m_inputStream = null;
    }

    protected void checkResultSet() throws SQLException {
        if (this.m_oaResultSet == null) {
            throw new OdxCLJException(25501);
        }
        if (this.m_inputStream != null) {
            try {
                this.m_inputStream.close();
            }
            catch (IOException iOException) {
                throw new OdxCLJException(iOException);
            }
            this.m_inputStream = null;
        }
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected void dump() {
        OdxCLJTrace.print("Inside " + this);
        OdxCLJTrace.print(" - " + this.m_oaResultSet);
        OdxCLJTrace.print(" - " + this.m_jdbcStatement);
        if (this.m_metaData != null) {
            OdxCLJTrace.print(" - " + this.m_metaData);
            this.m_metaData.dump();
        }
    }

    public boolean next() throws SQLException {
        this.trace("next");
        this.checkResultSet();
        return this.m_oaResultSet.next();
    }

    public void close() throws SQLException {
        this.trace("close");
        if (this.m_oaResultSet != null) {
            this.m_oaResultSet.close();
            this.m_oaResultSet = null;
            this.m_jdbcStatement = null;
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.wasNull();
    }

    public String getString(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueString(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueBoolean(n);
    }

    public byte getByte(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueByte(n);
    }

    public short getShort(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueShort(n);
    }

    public int getInt(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueInt(n);
    }

    public long getLong(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueLong(n);
    }

    public float getFloat(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueFloat(n);
    }

    public double getDouble(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        if (string == null) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        bigDecimal.setScale(n2);
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkResultSet();
        try {
            String string = this.m_oaResultSet.getColumnValueString(n);
            return string == null ? null : new BASE64Decoder().decodeBuffer(string);
        }
        catch (IOException iOException) {
            throw new OdxCLJException(iOException);
        }
    }

    public Date getDate(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueDate(n);
    }

    public Time getTime(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueTimestamp(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        if (string == null) {
            return null;
        }
        try {
            this.m_inputStream = new ByteArrayInputStream(string.getBytes("8859_1"));
            return this.m_inputStream;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OdxCLJException(unsupportedEncodingException);
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        if (string == null) {
            return null;
        }
        try {
            this.m_inputStream = new ByteArrayInputStream(string.getBytes("8859_1"));
            return this.m_inputStream;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OdxCLJException(unsupportedEncodingException);
        }
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : new ByteArrayInputStream(byArray);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        throw new OdxCLJException(25500);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkResultSet();
        return new OdxJDBCResultSetMetaData(this.m_oaResultSet);
    }

    public Object getObject(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnValueObject(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnNumber(string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return new CharArrayReader(this.getString(n).toCharArray());
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        return string == null ? null : new BigDecimal(string);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.afterLast();
    }

    public boolean first() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.first();
    }

    public boolean last() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.last();
    }

    public int getRow() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getRow();
    }

    public boolean absolute(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.absolute(n);
    }

    public boolean relative(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.relative(n);
    }

    public boolean previous() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.previous();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getFetchSize();
    }

    public int getType() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getType();
    }

    public int getConcurrency() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        throw new OdxCLJException(25500);
    }

    public boolean rowInserted() throws SQLException {
        throw new OdxCLJException(25500);
    }

    public boolean rowDeleted() throws SQLException {
        throw new OdxCLJException(25500);
    }

    public void updateNull(int n) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, null);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(bl));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(by));
    }

    public void updateShort(int n, short s) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(s));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(n2));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(l));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(f));
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(d));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, bigDecimal.toString());
    }

    public void updateString(int n, String string) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, new BASE64Encoder().encode(byArray));
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, date.toString());
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, time.toString());
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, timestamp.toString());
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkResultSet();
        try {
            byte[] byArray = new byte[n2];
            inputStream.read(byArray, 0, n2);
            this.m_oaResultSet.updateColumnValue(n, new String(byArray, "8859_1"));
        }
        catch (IOException iOException) {
            throw new OdxCLJException(iOException);
        }
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkResultSet();
        try {
            byte[] byArray = new byte[n2];
            inputStream.read(byArray, 0, n2);
            this.updateBytes(n, byArray);
        }
        catch (IOException iOException) {
            throw new OdxCLJException(iOException);
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkResultSet();
        try {
            char[] cArray = new char[n2];
            reader.read(cArray, 0, n2);
            this.m_oaResultSet.updateColumnValue(n, new String(cArray));
        }
        catch (IOException iOException) {
            throw new OdxCLJException(iOException);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, object.toString());
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, object.toString());
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.insertRow();
    }

    public void updateRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.deleteRow();
    }

    public void refreshRow() throws SQLException {
        throw new OdxCLJException(25500);
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        this.checkResultSet();
        return this.m_jdbcStatement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw new OdxCLJException(25500);
    }

    public Blob getBlob(int n) throws SQLException {
        return new OdxJDBCBlob(this.getBytes(n));
    }

    public Clob getClob(int n) throws SQLException {
        throw new OdxCLJException(25500);
    }

    public Array getArray(int n) throws SQLException {
        throw new OdxCLJException(25500);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }
}

