/************** OmniAccess Hooks C Header file - oahook.h ********************/
/*   This C language header file describes the OmniAccess Hooks layer of     */
/*   Omnidex for Open Systems                                                */
/*                                                                           */
/*                      (c) 1993, Dynamic Information Systems Corporation    */
/*****************************************************************************/

#ifndef OAHOOK_H_DEFINED
#define OAHOOK_H_DEFINED

#include "oa.h"


int oaconnect_entr_hook       (char                *dictionary,
                               char                *options,
                               oastatus_t          *status,
                               char                *username,
                               char                *password,
                               int                 *instance_no);

int oaconnect_exit_hook       (char                *dictionary,
                               char                *options,
                               oastatus_t          *status,
                               char                *username,
                               char                *password,
                               int                 *instance_no);

int oadisconnect_entr_hook    (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status);

int oadisconnect_exit_hook    (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status);

int oaopencursor_entr_hook    (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *cursor_no);

int oaopencursor_exit_hook    (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *cursor_no);

int oaclosecursor_entr_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status);

int oaclosecursor_exit_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status);

int oaqualify_entr_hook       (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *owner,
                               char                *table,
                               char                *column,
                               char                *criteria);

int oaqualify_exit_hook       (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *owner,
                               char                *table,
                               char                *column,
                               char                *criteria);

int oajoin_entr_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *from_table,
                               char                *from_column,
                               char                *to_owner,
                               char                *to_table,
                               char                *to_column);

int oajoin_exit_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *from_table,
                               char                *from_column,
                               char                *to_owner,
                               char                *to_table,
                               char                *to_column);

int oaselect_entr_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria);

int oaselect_exit_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria);

int oadescribe_entr_hook      (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_columns,
                               oaselect_list_t     *select_list);

int oadescribe_exit_hook      (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_columns,
                               oaselect_list_t     *select_list);

int oabind_entr_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_columns,
                               oaselect_list_t     *select_list);

int oabind_exit_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_columns,
                               oaselect_list_t     *select_list);

int oaassignvalues_entr_hook  (int                 *cursor_no,
                               char                *option_list,
                               oastatus_t          *status,
                               char                *label,
                               int                 *num_values,
                               void                *values);

int oaassignvalues_exit_hook  (int                 *cursor_no,
                               char                *option_list,
                               oastatus_t          *status,
                               char                *label,
                               int                 *num_values,
                               void                *values);

int oafetch_entr_hook         (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_rows,
                               void                *buffer);

int oafetch_exit_hook         (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_rows,
                               void                *buffer);

int oaexport_entr_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *filename);

int oaexport_exit_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *filename);

int oafetchkeys_entr_hook     (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_keys,
                               void                *keys);

int oafetchkeys_exit_hook     (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_keys,
                               void                *keys);

int oainsert_entr_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values);

int oainsert_exit_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values);

int oaupdate_entr_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values);

int oaupdate_exit_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values);

int oadelete_entr_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table);

int oadelete_exit_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table);

int oaupdatewhere_entr_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               void                *values,
                               char                *criteria);

int oaupdatewhere_exit_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               void                *values,
                               char                *criteria);

int oadeletewhere_entr_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *criteria);

int oadeletewhere_exit_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *criteria);

int oainsertindex_entr_hook   (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values,
                               void                *rowid);

int oainsertindex_exit_hook   (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values,
                               void                *rowid);

int oaupdateindex_entr_hook   (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *before_buffer,
                               void                *before_rowid,
                               void                *after_buffer,
                               void                *after_rowid);

int oaupdateindex_exit_hook   (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *before_buffer,
                               void                *before_rowid,
                               void                *after_buffer,
                               void                *after_rowid);

int oadeleteindex_entr_hook   (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *full_buffer,
                               void                *rowid);

int oadeleteindex_exit_hook   (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *full_buffer,
                               void                *rowid);

int oabegin_entr_hook         (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status);

int oabegin_exit_hook         (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status);

int oasavepoint_entr_hook     (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *savepoint);

int oasavepoint_exit_hook     (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *savepoint);

int oarollback_entr_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *savepoint);

int oarollback_exit_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *savepoint);

int oacommit_entr_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status);

int oacommit_exit_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status);

char *oaerror_entr_hook       (oastatus_t          *status,
                               char                *options,
                               char                *msg);

char *oaerror_exit_hook       (oastatus_t          *status,
                               char                *options,
                               char                *msg);

int oamessage_entr_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *message_id,
                               char                *message);

int oamessage_exit_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *message_id,
                               char                *message);

int oalist_entr_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria,
                               int                 *num_rows,
                               void                *buffer);

int oalist_exit_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria,
                               int                 *num_rows,
                               void                *buffer);

int oaform_entr_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               int                 *list_entry,
                               void                *buffer);

int oaform_exit_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               int                 *list_entry,
                               void                *buffer);

int oashow_entr_hook          (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status);

int oashow_exit_hook          (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status);

int oaversion_entr_hook       (int                 *instance_no,
                               char                *passed_option_list,
                               oastatus_t          *status,
                               char                *passed_node,
                               int                 *num_versions,
                               oaversion_t         *versions);

int oaversion_exit_hook       (int                 *instance_no,
                               char                *passed_option_list,
                               oastatus_t          *status,
                               char                *passed_node,
                               int                 *num_versions,
                               oaversion_t         *versions);

int oacommand_entr_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *input,
                               int                 *input_length,
                               char                *output,
                               int                 *output_length);

int oacommand_exit_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *input,
                               int                 *input_length,
                               char                *output,
                               int                 *output_length);

int oaconvertdata_entr_hook   (char                *Options,
                               oastatus_t          *Status,
                               void                *Input_data,
                               char                *Input_type,
                               int                 *Input_length,
                               void                *Output_data,
                               char                *Output_type,
                               int                 *Output_length);

int oaconvertdata_exit_hook   (char                *Options,
                               oastatus_t          *Status,
                               void                *Input_data,
                               char                *Input_type,
                               int                 *Input_length,
                               void                *Output_data,
                               char                *Output_type,
                               int                 *Output_length);

int oaexternal_entr_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *library_name,
                               char                *routine_name,
                               char                *input,
                               int                 *input_length,
                               char                *output,
                               int                 *output_length);

int oaexternal_exit_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *library_name,
                               char                *routine_name,
                               char                *input,
                               int                 *input_length,
                               char                *output,
                               int                 *output_length);

int oaenvinfo_entr_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *env_name,
                               int32               *buffer_length,
                               void                *buffer);

int oaenvinfo_exit_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *env_name,
                               int32               *buffer_length,
                               void                *buffer);

int oadbinfo_entr_hook        (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *db_name,
                               int32               *buffer_length,
                               void                *buffer);

int oadbinfo_exit_hook        (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *db_name,
                               int32               *buffer_length,
                               void                *buffer);

int oatblinfo_entr_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tbl_name,
                               int32               *buffer_length,
                               void                *buffer);

int oatblinfo_exit_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tbl_name,
                               int32               *buffer_length,
                               void                *buffer);

int oacollistinfo_entr_hook   (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tbl_name,
                               char                *col_names,
                               int32               *buffer_length,
                               void                *buffer);

int oacollistinfo_exit_hook   (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tbl_name,
                               char                *col_names,
                               int32               *buffer_length,
                               void                *buffer);

int oaidxinfo_entr_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *database_name,
                               int32               *buffer_length,
                               void                *buffer);

int oaidxinfo_exit_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *database_name,
                               int32               *buffer_length,
                               void                *buffer);

int oacsrinfo_entr_hook       (int32               *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer);

int oacsrinfo_exit_hook       (int32               *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer);

int oastmtinfo_entr_hook      (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer);
                               
int oastmtinfo_exit_hook      (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer);                               

int oacopyfile_entr_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *from_node,
                               char                *from_filename,
                               char                *from_options,
                               char                *to_file,
                               char                *to_filename,
                               char                *to_options);

int oacopyfile_exit_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *from_node,
                               char                *from_filename,
                               char                *from_options,
                               char                *to_file,
                               char                *to_filename,
                               char                *to_options);

int oaexecsql_entr_hook       (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *statement);

int oaexecsql_exit_hook       (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *statement);

int oaexecdb_entr_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *db_name,
                               char                *statement);
                                                          
int oaexecdb_exit_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *db_name,
                               char                *statement);

int oadroptable_entr_hook     (int                 *instance_no, 
                               char                *options, 
                               oastatus_t          *status, 
                               char                *table);

int oadroptable_exit_hook     (int                 *instance_no, 
                               char                *options, 
                               oastatus_t          *status, 
                               char                *table);

int oaexplainplan_entr_hook   (int                 *cursor_no, 
                               char                *options, 
                               oastatus_t          *status, 
                               int                 bufsize,
                               char                *buffer);

int oaexplainplan_exit_hook   (int                 *cursor_no, 
                               char                *options, 
                               oastatus_t          *status, 
                               int                 bufsize,
                               char                *buffer);

#endif   /* OAHOOK_H_DEFINED */

