create database 'orders' in discdemoinf;
database 'orders';
CREATE TABLE CUSTOMERS
  (
   CUSTOMER_NO             INTEGER,
   COMPANY          CHAR(40),
   CONTACT          CHAR(24),
   TITLE            CHAR(30),
   SALUTATION       CHAR(24),
   ADDRESS1         CHAR(30),
   ADDRESS2         CHAR(30),
   CITY             CHAR(20),
   STATE            CHAR(2),
   POSTAL_CODE      CHAR(10),
   COUNTRY          CHAR(20),
   PHONE_NO         CHAR(18),
   FAX_NO           CHAR(20),
   AKA_COMPANY      CHAR(20),
   COMMENTS         CHAR(60),
   LICENSEE         INTEGER
  );
CREATE UNIQUE INDEX CCUSTOMER_NO ON CUSTOMERS (CUSTOMER_NO);
CREATE TABLE ACTIVITY
  (
   CUSTOMER_NO      INTEGER,
   DATE_TICKLER     CHAR(6),
   TICKLER          CHAR(2),
   INITIALS         CHAR(4),
   ACTION_INFO      CHAR(60)
  );
CREATE INDEX ACUSTOMER_NO ON ACTIVITY(CUSTOMER_NO);
CREATE TABLE CUST_NOTES
  (
   CUSTOMER_NO      INTEGER,
   DATE_ENTERED     CHAR(6),
   ENTERED_BY       CHAR(4),
   DESC_LINES1      CHAR(60),
   DESC_LINES2      CHAR(60),
   DESC_LINES3      CHAR(60),
   DESC_LINES4      CHAR(60),
   DESC_LINES5      CHAR(60)
  );
CREATE INDEX NCUSTOMER_NO ON CUST_NOTES (CUSTOMER_NO);
CREATE TABLE PRODUCTS
  (
   PRODUCT_NO       CHAR(12),
   PRODUCT_CLASS    CHAR(20),
   PRODUCT_NAME     CHAR(40),
   SALES_PRICE      INTEGER,
   PRODUCT_COST     INTEGER
  );
CREATE UNIQUE INDEX PPRODUCT_NO ON PRODUCTS (PRODUCT_NO);
CREATE TABLE INVENTORY
  (
   PRODUCT_NO       CHAR(12),
   INV_DATE         CHAR(6),
   INV_QTY          SMALLINT,
   INV_COST         INTEGER,
   INV_LOC          CHAR(16)
  );
CREATE INDEX IPRODUCT_NO ON INVENTORY (PRODUCT_NO);
CREATE TABLE ORDERS
  (
   CUSTOMER_NO      INTEGER,
   PRODUCT_NO       CHAR(12),
   ORDER_DATE       CHAR(6),
   STATUS           CHAR(4),
   QUANTITY         INTEGER,
   AMOUNT           INTEGER
  );
CREATE INDEX OCUSTOMER_NO ON ORDERS (CUSTOMER_NO);
CREATE INDEX OPRODUCT_NO ON ORDERS (PRODUCT_NO);
