/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import omnidex.client.OdxCLJColumnInfo;
import omnidex.client.OdxCLJDatabaseInfo;
import omnidex.client.OdxCLJEnvironmentInfo;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJIndexComponentInfo;
import omnidex.client.OdxCLJIndexInfo;
import omnidex.client.OdxCLJPoolArray;
import omnidex.client.OdxCLJResultSet;
import omnidex.client.OdxCLJStatement;
import omnidex.client.OdxCLJStatus;
import omnidex.client.OdxCLJTableInfo;
import omnidex.client.OdxCLJTableTypes;
import omnidex.client.OdxCLJTrace;

public final class OdxCLJConnection {
    private String m_url;
    private Properties m_options;
    private OdxCLJPoolArray m_connections;
    private ArrayList m_statements;
    private OdxCLJStatus m_status;

    private void checkConnection() throws OdxCLJException {
        if (this.m_status == null) {
            throw new OdxCLJException(25502);
        }
    }

    private void connect(String string, Properties properties) throws OdxCLJException {
        this.trace("connect");
        if (this.m_status != null) {
            this.m_status.disconnect();
            this.m_status = null;
        }
        this.m_status = new OdxCLJStatus();
        this.m_status.connect(string, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OdxCLJConnection lockConnection() throws OdxCLJException {
        OdxCLJConnection odxCLJConnection;
        this.trace("lockConnection");
        OdxCLJPoolArray odxCLJPoolArray = this.m_connections;
        synchronized (odxCLJPoolArray) {
            odxCLJConnection = (OdxCLJConnection)this.m_connections.lock();
        }
        if (odxCLJConnection == null) {
            odxCLJConnection = new OdxCLJConnection();
            odxCLJConnection.connect(this.m_url, this.m_options);
            odxCLJPoolArray = this.m_connections;
            synchronized (odxCLJPoolArray) {
                this.m_connections.addLock(odxCLJConnection);
            }
        }
        return odxCLJConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockConnection(OdxCLJConnection odxCLJConnection) throws OdxCLJException {
        this.trace("unlockConnection");
        OdxCLJPoolArray odxCLJPoolArray = this.m_connections;
        synchronized (odxCLJPoolArray) {
            this.m_connections.unlock(odxCLJConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeStatement(OdxCLJStatement odxCLJStatement) {
        this.trace("freeStatement");
        ArrayList arrayList = this.m_statements;
        synchronized (arrayList) {
            this.m_statements.remove(odxCLJStatement);
        }
    }

    protected int getEndian() throws OdxCLJException {
        this.checkConnection();
        return this.m_status.getEndian();
    }

    protected OdxCLJStatus getStatus() {
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() throws OdxCLJException {
        this.trace("release");
        ArrayList arrayList = this.m_statements;
        synchronized (arrayList) {
            Iterator iterator = this.m_statements.iterator();
            while (iterator.hasNext()) {
                ((OdxCLJStatement)iterator.next()).clear();
            }
            this.m_statements.clear();
        }
        if (this.m_status != null) {
            this.m_status.disconnect();
            this.m_status = null;
        }
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    public OdxCLJConnection() {
        this.trace(null);
        this.m_connections = new OdxCLJPoolArray();
        this.m_statements = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string, Properties properties) throws OdxCLJException {
        this.trace("open");
        this.connect(string, properties);
        this.m_url = string;
        this.m_options = new Properties(properties);
        OdxCLJPoolArray odxCLJPoolArray = this.m_connections;
        synchronized (odxCLJPoolArray) {
            this.m_connections.add(this);
        }
    }

    public boolean isReadOnly() throws OdxCLJException {
        this.checkConnection();
        return this.m_status.getReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OdxCLJStatement createStatement(int n, int n2, boolean bl) throws OdxCLJException {
        this.trace("createStatement");
        this.checkConnection();
        OdxCLJStatement odxCLJStatement = new OdxCLJStatement(this);
        odxCLJStatement.setResultSetType(n);
        odxCLJStatement.setResultSetConcurrency(n2);
        odxCLJStatement.setNoThread(bl);
        ArrayList arrayList = this.m_statements;
        synchronized (arrayList) {
            this.m_statements.add(odxCLJStatement);
        }
        return odxCLJStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws OdxCLJException {
        this.trace("close");
        OdxCLJPoolArray odxCLJPoolArray = this.m_connections;
        synchronized (odxCLJPoolArray) {
            Iterator iterator = this.m_connections.iterator();
            while (iterator.hasNext()) {
                ((OdxCLJConnection)iterator.next()).release();
            }
            this.m_connections.clear();
        }
    }

    public String getURL() {
        return this.m_url;
    }

    public String getUserName() {
        return this.m_options != null ? this.m_options.getProperty("user") : "";
    }

    public String getVersion() throws OdxCLJException {
        this.checkConnection();
        return this.m_status.getVersion();
    }

    public String getEnvironmentName() throws OdxCLJException {
        this.checkConnection();
        return this.m_status.getEnvironmentName();
    }

    public OdxCLJResultSet getEnvironment() throws OdxCLJException {
        this.checkConnection();
        return new OdxCLJEnvironmentInfo().initialize(this.m_status);
    }

    public OdxCLJResultSet getDatabases() throws OdxCLJException {
        this.checkConnection();
        return new OdxCLJDatabaseInfo().initialize(this.m_status);
    }

    public OdxCLJResultSet getTables(String string, String string2, String string3, String[] stringArray) throws OdxCLJException {
        this.checkConnection();
        return new OdxCLJTableInfo().initialize(this.m_status, string, string2, string3, stringArray);
    }

    public OdxCLJResultSet getTableTypes() throws OdxCLJException {
        this.checkConnection();
        return new OdxCLJTableTypes().initialize();
    }

    public OdxCLJResultSet getColumns(String string, String string2, String string3, String string4) throws OdxCLJException {
        this.checkConnection();
        return new OdxCLJColumnInfo().initialize(this.m_status, string, string2, string3, string4);
    }

    public OdxCLJResultSet getIndexes(String string, String string2, String string3, boolean bl, boolean bl2) throws OdxCLJException {
        return new OdxCLJIndexInfo().initialize(this.m_status, string, string2, string3, bl, bl2);
    }

    public OdxCLJResultSet getIndexComponents(String string, String string2, String string3, String string4) throws OdxCLJException {
        return new OdxCLJIndexComponentInfo().initialize(this.m_status, string, string2, string3, string4);
    }
}

