/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.util.Enumeration;
import java.util.Properties;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJNative;
import omnidex.client.OdxCLJTrace;

public class OdxCLJStatus {
    public static final String VERSION = "4.1.3";
    public static final int MAJOR_VERSION = 4;
    public static final int MINOR_VERSION = 1;
    public static final int BUILD_VERSION = 3;
    public static final int JDBC_MAJOR_VERSION = 1;
    public static final int JDBC_MINOR_VERSION = 3;
    private byte[] m_instance;
    private int[] m_oaStatus = OdxCLJNative.createStatus();
    private int m_endian;
    private boolean m_readOnly;
    private int m_updateCursor;
    private String m_oaVersion;
    private String m_environmentName;
    private String m_syscatName;
    private byte[] m_databaseInfo;

    protected OdxCLJStatus() {
        this.m_instance = OdxCLJNative.createInstance();
    }

    private int[] getStatus() {
        return this.m_oaStatus;
    }

    private void setStatus(int[] nArray) {
        this.m_oaStatus = nArray;
    }

    protected int getErrorCode() {
        return this.m_oaStatus[0];
    }

    protected int getStatusCount() {
        return this.m_oaStatus[3];
    }

    public int getStatusBufferLength() {
        return this.m_oaStatus[4];
    }

    protected int getStatusCursor() {
        return this.m_oaStatus[6];
    }

    protected int getStatusCPUTime() {
        return this.m_oaStatus[8];
    }

    protected int getStatusElapsedTime() {
        return this.m_oaStatus[9];
    }

    protected int getStatusParentCount() {
        return this.m_oaStatus[10];
    }

    protected int getStatusPreIntersectCount() {
        return this.m_oaStatus[11];
    }

    protected int getStatusColumnCount() {
        return this.m_oaStatus[12];
    }

    protected int getStatusStatementId() {
        return this.m_oaStatus[13];
    }

    protected int getStatusUpdateFlag() {
        return this.m_oaStatus[16];
    }

    private int replaceStatusCursor(int n) {
        int n2 = this.m_oaStatus[6];
        this.m_oaStatus[6] = n;
        return n2;
    }

    protected int getEndian() {
        return this.m_endian;
    }

    protected boolean getReadOnly() {
        return this.m_readOnly;
    }

    protected String getErrorMessage() {
        return OdxCLJNative.getErrorMessage(this.m_instance, this.m_oaStatus);
    }

    protected static String getErrorMessage(int n) {
        return OdxCLJNative.getStaticErrorMessage(n);
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected static String makeOptionString(Properties properties) {
        if (properties == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("user") || string2.equalsIgnoreCase("password") || (string = properties.getProperty(string2)) == null) continue;
            stringBuffer.append(",").append(string2).append("='").append(string).append("'");
        }
        return stringBuffer.length() != 0 ? stringBuffer.toString() : "";
    }

    protected void connect(String string, Properties properties) throws OdxCLJException {
        String string2;
        String string3;
        this.trace("connect");
        if (properties != null) {
            string3 = properties.getProperty("user");
            string2 = properties.getProperty("password");
        } else {
            string3 = "";
            string2 = "";
        }
        String string4 = OdxCLJStatus.makeOptionString(properties);
        string4 = string4 + " HOSTOACONNECTOPTIONS='CLIENT=JDBC'";
        byte[] byArray = OdxCLJNative.connect(string, string4, this.m_oaStatus, string3, string2, this.m_instance);
        int n = this.m_oaStatus[0];
        if (n != 0) {
            OdxCLJNative.disconnect(this.m_instance, this.m_oaStatus);
            throw new OdxCLJException(byArray, n);
        }
        this.m_endian = OdxCLJNative.getEndianFlag(byArray);
        this.m_readOnly = OdxCLJNative.getReadOnlyFlag(byArray);
        this.m_oaVersion = OdxCLJNative.getOaVersion(byArray);
        this.m_environmentName = OdxCLJNative.getEnvironmentName(byArray);
        this.m_syscatName = OdxCLJNative.getSyscatName(byArray);
        this.trace("OA Version     : " + this.m_oaVersion);
        this.trace("Addin Version  : " + OdxCLJNative.getAddinVersion(byArray));
        this.trace("ODBCSRV Version: " + OdxCLJNative.getOdbcSrvVersion(byArray));
        byArray = null;
    }

    protected byte[] executeSQL(String string, Properties properties, int n) throws OdxCLJException {
        OdxCLJTrace.print("SQL: " + string);
        byte[] byArray = OdxCLJNative.executeSQL(this.m_instance, this.m_oaStatus, OdxCLJStatus.makeOptionString(properties), n, string);
        if (this.m_oaStatus[0] != 0) {
            throw new OdxCLJException(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected void executeUpdate(String string) throws OdxCLJException {
        OdxCLJTrace.print("SQL: " + string);
        int n = this.replaceStatusCursor(this.m_updateCursor);
        byte[] byArray = OdxCLJNative.executeSQL(this.m_instance, this.m_oaStatus, "", 0, string);
        this.m_updateCursor = this.replaceStatusCursor(n);
        if (this.m_oaStatus[0] != 0) {
            throw new OdxCLJException(byArray, this.m_oaStatus[0]);
        }
        byArray = null;
    }

    protected void fetch(byte[] byArray, int n, byte[] byArray2) throws OdxCLJException {
        byte[] byArray3 = OdxCLJNative.fetch(this.m_instance, this.m_oaStatus, n, byArray, byArray2);
        if (byArray3 != null) {
            throw new OdxCLJException(byArray3, this.m_oaStatus[0]);
        }
    }

    protected String getVersion() {
        return this.m_oaVersion;
    }

    protected String getSyscatName() {
        return this.m_syscatName;
    }

    protected String getEnvironmentName() {
        return this.m_environmentName;
    }

    protected int getDatabaseCount() throws OdxCLJException {
        if (this.m_databaseInfo == null) {
            byte[] byArray = OdxCLJNative.getDatabaseInfo(this.m_instance, this.m_oaStatus);
            if (this.m_oaStatus[0] != 0) {
                throw new OdxCLJException(byArray, this.m_oaStatus[0]);
            }
            this.m_databaseInfo = byArray;
        }
        return OdxCLJNative.getInfoCount(this.m_databaseInfo);
    }

    protected String getDatabaseName(int n) {
        return OdxCLJNative.getDatabaseName(this.m_databaseInfo, n);
    }

    protected byte[] getTableInfo(String string, String string2, String string3, int n) throws OdxCLJException {
        byte[] byArray = OdxCLJNative.getTableInfo(this.m_instance, this.m_oaStatus, string, string2, string3, n);
        if (this.m_oaStatus[0] != 0) {
            throw new OdxCLJException(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected byte[] getColumnInfo(String string, String string2, String string3, String string4) throws OdxCLJException {
        byte[] byArray = OdxCLJNative.getColumnInfo(this.m_instance, this.m_oaStatus, string, string2, string3, string4);
        if (this.m_oaStatus[0] != 0) {
            throw new OdxCLJException(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected byte[] getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws OdxCLJException {
        byte[] byArray = OdxCLJNative.getIndexInfo(this.m_instance, this.m_oaStatus, string, string2, string3, bl, bl2);
        if (this.m_oaStatus[0] != 0) {
            throw new OdxCLJException(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected byte[] getComponentInfo(String string, String string2, String string3, String string4) throws OdxCLJException {
        byte[] byArray = OdxCLJNative.getComponentInfo(this.m_instance, this.m_oaStatus, string, string2, string3, string4);
        if (this.m_oaStatus[0] != 0) {
            throw new OdxCLJException(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected void cancel() throws OdxCLJException {
        byte[] byArray = OdxCLJNative.cancel(this.m_instance, this.m_oaStatus);
        if (byArray != null) {
            throw new OdxCLJException(byArray, this.m_oaStatus[0]);
        }
    }

    protected void closeCursor() throws OdxCLJException {
        if (this.getStatusCursor() != 0 || this.m_updateCursor != 0) {
            this.m_oaStatus[7] = this.m_updateCursor;
            byte[] byArray = OdxCLJNative.closeCursor(this.m_instance, this.m_oaStatus);
            if (byArray != null) {
                throw new OdxCLJException(byArray, this.m_oaStatus[0]);
            }
            this.m_updateCursor = 0;
            this.m_oaStatus[6] = 0;
        }
    }

    protected void disconnect() throws OdxCLJException {
        this.closeCursor();
        byte[] byArray = OdxCLJNative.disconnect(this.m_instance, this.m_oaStatus);
        if (byArray != null) {
            throw new OdxCLJException(byArray, this.m_oaStatus[0]);
        }
        this.m_oaStatus[6] = 0;
        this.m_oaStatus[5] = 0;
        this.m_oaStatus[0] = 0;
    }
}

