/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import omnidex.client.OdxCLJTrace;

public final class OdxCLJPoolArray {
    private ArrayList m_inUse = new ArrayList();
    private LinkedList m_available = new LinkedList();

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    public int size() {
        return this.m_inUse.size() + this.m_available.size();
    }

    public boolean isEmpty() {
        return this.m_inUse.size() != 0 || this.m_available.size() != 0;
    }

    public int getLockCount() {
        return this.m_inUse.size();
    }

    public void add(Object object) {
        this.trace("add");
        this.m_available.addFirst(object);
    }

    public void addLock(Object object) {
        this.trace("addLock");
        this.m_inUse.add(object);
    }

    public Object lock() {
        this.trace("lock");
        if (this.m_available.isEmpty()) {
            return null;
        }
        Object e = this.m_available.getFirst();
        if (e != null) {
            this.m_inUse.add(e);
            this.m_available.removeFirst();
        }
        return e;
    }

    public void unlock(Object object) {
        this.trace("unlock");
        if (this.m_inUse.remove(object)) {
            this.m_available.addFirst(object);
        }
    }

    public Iterator iterator() {
        this.trace("iterator");
        ArrayList arrayList = new ArrayList();
        if (!this.m_inUse.isEmpty()) {
            arrayList.addAll(this.m_inUse);
        }
        if (!this.m_available.isEmpty()) {
            arrayList.addAll(this.m_available);
        }
        return arrayList.iterator();
    }

    public void clear() {
        this.trace("clear");
        this.m_available.clear();
        this.m_inUse.clear();
    }

    public void remove(Object object) {
        this.trace("remove");
        if (this.m_inUse.contains(object)) {
            this.m_inUse.remove(object);
        } else if (this.m_available.contains(object)) {
            this.m_available.remove(object);
        }
    }

    public void finalize() {
        this.clear();
    }

    public void dump() {
        OdxCLJTrace.print("Inside " + this);
        OdxCLJTrace.print(" - Used: " + this.m_inUse);
        OdxCLJTrace.print(" - Available: " + this.m_available);
    }
}

