:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                                                                           ::
:: This script builds the Omnidex demos                                      ::
::                                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

::
:: This script presumes it is being run from %OMNIDEX_HOME%\demo
::

::-----------------------------------------------------------------------------
::
:: ORDERS database
::
::-----------------------------------------------------------------------------

cd %OMNIDEX_HOME%\demo\orders

echo Compiling ORDERS environment ...
del /f /q orders.env
%OMNIDEX_HOME%\bin\oacomp orders > oacomp.log

echo Deleting existing ORDERS indexes ...
del /f /q idx\*

echo Installing ORDERS indexes ...
%OMNIDEX_HOME%\bin\dbinstal < ordersin > ordersin.log

echo Building ORDERS indexes ...
%OMNIDEX_HOME%\bin\dbinstal < ordersix > ordersix.log

cd %OMNIDEX_HOME%\demo

::-----------------------------------------------------------------------------
::
:: STAR database, HD installation
::
::-----------------------------------------------------------------------------

cd %OMNIDEX_HOME%\demo\star

echo Compiling STAR environment ...
del /f /q star.env
%OMNIDEX_HOME%\bin\oacomp star > oacomp.log

echo Deleting existing STAR indexes ...
del /f /q idx\*

echo Installing STAR indexes ...
%OMNIDEX_HOME%\bin\dbinstal < starhdin > starhdin.log

echo Building STAR indexes ...
%OMNIDEX_HOME%\bin\dbinstal < starhdix > starhdix.log

echo Creating Omnidex Text files for STAR database ...
%OMNIDEX_HOME%\bin\odxsql < starupdatetext > starupdatetext.log

cd %OMNIDEX_HOME%\demo

