/******** DISC Source file - oahook.c ****************************************/
/*   This C language source file contains the hook intrinsic stubs for the   */
/*   OmniAccess API layer.                                                   */
/*                      (c) 1993, Dynamic Information Systems Corporation    */
/*****************************************************************************/

#include    <stdlib.h>

#include    "oa.h"
#include    "oahook.h"


int oaconnect_entr_hook       (char                *environment,
                               char                *options,
                               oastatus_t          *status,
                               char                *username,
                               char                *password,
                               int                 *instance_no)
{
  return status->error;
}

int oaconnect_exit_hook       (char                *environment,
                               char                *options,
                               oastatus_t          *status,
                               char                *username,
                               char                *password,
                               int                 *instance_no)
{
  return status->error;
}


int oadisconnect_entr_hook    (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}

int oadisconnect_exit_hook    (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}


int oaopencursor_entr_hook    (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *cursor_no)
{
  return status->error;
}

int oaopencursor_exit_hook    (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *cursor_no)
{
  return status->error;
}


int oaclosecursor_entr_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}

int oaclosecursor_exit_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}


int oaqualify_entr_hook       (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *owner,
                               char                *table,
                               char                *column,
                               char                *criteria)
{
  return status->error;
}

int oaqualify_exit_hook       (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *owner,
                               char                *table,
                               char                *column,
                               char                *criteria)
{
  return status->error;
}


int oajoin_entr_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *from_table,
                               char                *from_column,
                               char                *to_owner,
                               char                *to_table,
                               char                *to_column)
{
  return status->error;
}

int oajoin_exit_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *from_table,
                               char                *from_column,
                               char                *to_owner,
                               char                *to_table,
                               char                *to_column)
{
  return status->error;
}


int oaselect_entr_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria)
{
  return status->error;
}

int oaselect_exit_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria)
{
  return status->error;
}


int oadescribe_entr_hook      (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_columns,
                               oaselect_list_t     *select_list)
{
  return status->error;
}

int oadescribe_exit_hook      (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_columns,
                               oaselect_list_t     *select_list)
{
  return status->error;
}


int oabind_entr_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_columns,
                               oaselect_list_t     *select_list)
{
  return status->error;
}

int oabind_exit_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_columns,
                               oaselect_list_t     *select_list)
{
  return status->error;
}


int oaassignvalues_entr_hook  (int                 *cursor_no,
                               char                *option_list,
                               oastatus_t          *status,
                               char                *label,
                               int                 *num_values,
                               void                *values)
{
  return status->error;
}

int oaassignvalues_exit_hook   (int                 *cursor_no,
                                char                *option_list,
                                oastatus_t          *status,
                                char                *label,
                                int                 *num_values,
                                void                *values)
{
  return status->error;
}


int oafetch_entr_hook         (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_rows,
                               void                *buffer)
{
  return status->error;
}

int oafetch_exit_hook         (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_rows,
                               void                *buffer)
{
  return status->error;
}


int oaexport_entr_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *filename)
{
  return status->error;
}

int oaexport_exit_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *filename)
{
  return status->error;
}


int oafetchkeys_entr_hook     (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_keys,
                               void                *keys)
{
  return status->error;
}

int oafetchkeys_exit_hook     (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *num_keys,
                               void                *keys)
{
  return status->error;
}


int oainsert_entr_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values)
{
  return status->error;
}

int oainsert_exit_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values)
{
  return status->error;
}


int oaupdate_entr_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values)
{
  return status->error;
}

int oaupdate_exit_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values)
{
  return status->error;
}


int oadelete_entr_hook        (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table)
{
  return status->error;
}

int oadelete_exit_hook            (int                 *cursor_no,
                                   char                *options,
                                   oastatus_t          *status,
                                   char                *table)
{
  return status->error;
}


int oaupdatewhere_entr_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria,
                               void                *values)
{
  return status->error;
}

int oaupdatewhere_exit_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria,
                               void                *values)
{
  return status->error;
}


int oadeletewhere_entr_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *criteria)
{
  return status->error;
}

int oadeletewhere_exit_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *criteria)
{
  return status->error;
}


int oainsertindex_entr_hook   (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values,
                               void                *rowid)
{
  return status->error;
}

int oainsertindex_exit_hook   (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *values,
                               void                *rowid)
{
  return status->error;
}


int oadeleteindex_entr_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *full_buffer,
                               void                *rowid)
{
  return status->error;
}

int oadeleteindex_exit_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *full_buffer,
                               void                *rowid)
{
  return status->error;
}


int oaupdateindex_entr_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *before_buffer,
                               void                *before_rowid,
                               void                *after_buffer,
                               void                *after_rowid)
{
  return status->error;
}

int oaupdateindex_exit_hook   (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *table,
                               char                *columns,
                               void                *before_buffer,
                               void                *before_rowid,
                               void                *after_buffer,
                               void                *after_rowid)
{
  return status->error;
}


int oabegin_entr_hook         (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}

int oabegin_exit_hook         (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}


int oasavepoint_entr_hook     (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *savepoint)
{
  return status->error;
}

int oasavepoint_exit_hook     (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *savepoint)
{
  return status->error;
}


int oarollback_entr_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *savepoint)
{
  return status->error;
}

int oarollback_exit_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *savepoint)
{
  return status->error;
}


int oacommit_entr_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}

int oacommit_exit_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}


char *oaerror_entr_hook       (oastatus_t          *status,
                               char                *options,
                               char                *msg)
{
  return (char*)NULL;
}

char *oaerror_exit_hook       (oastatus_t          *status,
                               char                *options,
                               char                *msg)
{
  return msg;
}


int oamessage_entr_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *message_id,
                               char                *message)
{
  return status->error;
}

int oamessage_exit_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *message_id,
                               char                *message)
{
  return status->error;
}


int oalist_entr_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria,
                               int                 *num_rows,
                               void                *buffer)
{
  return status->error;
}

int oalist_exit_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               char                *criteria,
                               int                 *num_rows,
                               void                *buffer)
{
  return status->error;
}


int oaform_entr_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               int                 *list_entry,
                               void                *buffer)
{
  return status->error;
}

int oaform_exit_hook          (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tables,
                               char                *columns,
                               int                 *list_entry,
                               void                *buffer)
{
  return status->error;
}


int oashow_entr_hook          (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}

int oashow_exit_hook          (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status)
{
  return status->error;
}


int oaversion_entr_hook       (int                 *inst,
                               char                *passed_option_list,
                               oastatus_t          *status,
                               char                *passed_node,
                               int                 *num_versions,
                               oaversion_t         *versions)
{
  return status->error;
}

int oaversion_exit_hook       (int                 *inst,
                               char                *passed_option_list,
                               oastatus_t          *status,
                               char                *passed_node,
                               int                 *num_versions,
                               oaversion_t         *versions)
{
  return status->error;
}

int oacommand_entr_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *input,
                               int                 *input_length,
                               char                *output,
                               int                 *output_length)
{
  return status->error;
}

int oacommand_exit_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *input,
                               int                 *input_length,
                               char                *output,
                               int                 *output_length)
{
  return status->error;
}

int oaexternal_entr_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *library_name,
                               char                *routine_name,
                               char                *input,
                               int                 *input_length,
                               char                *output,
                               int                 *output_length)
{
  return status->error;
}

int oaexternal_exit_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *node,
                               char                *library_name,
                               char                *routine_name,
                               char                *input,
                               int                 *input_length,
                               char                *output,
                               int                 *output_length)
{
  return status->error;
}


int oaconvertdata_entr_hook   (char                *options,
                               oastatus_t          *status,
                               void                *input_data,
                               char                *input_type,
                               int                 *input_length,
                               void                *output_data,
                               char                *output_type,
                               int                 *output_length)
{
  return status->error;
}

int oaconvertdata_exit_hook   (char                *options,
                               oastatus_t          *status,
                               void                *input_data,
                               char                *input_type,
                               int                 *input_length,
                               void                *output_data,
                               char                *output_type,
                               int                 *output_length)
{
  return status->error;
}


int oaenvinfo_entr_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *env_name,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}


int oaenvinfo_exit_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *env_name,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}


int oadbinfo_entr_hook        (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *db_name,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}

int oadbinfo_exit_hook        (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *db_name,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}


int oatblinfo_entr_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tbl_name,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}

int oatblinfo_exit_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tbl_name,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}


int oacollistinfo_entr_hook   (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tbl_name,
                               char                *col_names,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}

int oacollistinfo_exit_hook   (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *tbl_name,
                               char                *col_names,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}


int oaidxinfo_entr_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *database_name,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}

int oaidxinfo_exit_hook       (int32               *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *database_name,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}


int oacsrinfo_entr_hook       (int32               *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}

int oacsrinfo_exit_hook       (int32               *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}

int oastmtinfo_entr_hook      (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}

int oastmtinfo_exit_hook      (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}

int oasettingsinfo_entr_hook  (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}

int oasettingsinfo_exit_hook  (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               int32               *buffer_length,
                               void                *buffer)
{
  return status->error;
}                                 

int oacopyfile_entr_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *from_node,
                               char                *from_filename,
                               char                *from_options,
                               char                *to_file,
                               char                *to_filename,
                               char                *to_options)
{
  return status->error;
}

int oacopyfile_exit_hook      (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *from_node,
                               char                *from_filename,
                               char                *from_options,
                               char                *to_file,
                               char                *to_filename,
                               char                *to_options)
{
  return status->error;
}


/* to be retired */
int oagetinfo_entr_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *qualifier_types,
                               void                *qualifier,
                               int                 *itemnums,
                               void                *items)
{
  return status->error;
}

int oagetinfo_exit_hook       (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               int                 *qualifier_types,
                               void                *qualifier,
                               int                 *itemnums,
                               void                *items)
{
  return status->error;
}

int oaexecsql_entr_hook       (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *statement)
{
  return status->error;
}

int oaexecsql_exit_hook       (int                 *cursor_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *statement)
{
  return status->error;
}

int oaexecdb_entr_hook        (int                 *instance_no,
                               char                *options,
                               oastatus_t          *status,
                               char                *db_name,
                               char                *statement)
{
  return status->error;
}

int oaexecdb_exit_hook       (int                 *instance_no,
                              char                *options,
                              oastatus_t          *status,
                              char                *db_name,
                              char                *statement)
{
  return status->error;
}

int oadroptable_entr_hook     (int                 *instance_no, 
                               char                *options, 
                               oastatus_t          *status, 
                               char                *table)
{
  return status->error;
}

int oadroptable_exit_hook     (int                 *instance_no, 
                               char                *options, 
                               oastatus_t          *status, 
                               char                *table)
{
  return status->error;
}

int oaexplainplan_entr_hook   (int                 *cursor_no, 
                               char                *options, 
                               oastatus_t          *status, 
                               int                 bufsize,
                               char                *buffer)
{
  return status->error;
}

int oaexplainplan_exit_hook   (int                 *cursor_no, 
                               char                *options, 
                               oastatus_t          *status, 
                               int                 bufsize,
                               char                *buffer)
{
  return status->error;
}

