#!/bin/ksh
export LOG_DIR=log
export EXE_HOME=/dba1/ora/demo/orders
export USERPASS="orders/orders"
if [ $# -ne 2 ]; then
   echo "Usage: $0 ORACLE_SID and username/password"
   echo
   echo "       Enter ORACLE_SID and schema name to create the orders demo"
   exit
fi

export ORACLE_SID=$1
#ORAENV_ASK=NO; . oraenv; ORAENV_ASK=

echo "Creating Orders Demo in schema $1 located in database $ORACLE_SID"

sqlplus $2 << EOT

set head off
set pause off
set verify off
set termout off
set pagesize 0
set feedback off
set linesize 132 
@$EXE_HOME/create_orders.sql

exit
EOT
sqlldr $2 control=$EXE_HOME/activity.ctl log=$LOG_DIR/activity.log bad=$LOG_DIR/activity.bad data=$EXE_HOME/activity.dat 
sqlldr $2 control=$EXE_HOME/cust_notes.ctl log=$LOG_DIR/cust_notes.log bad=$LOG_DIR/cust_notes.bad data=$EXE_HOME/cust_notes.dat
sqlldr $2 control=$EXE_HOME/customers.ctl log=$LOG_DIR/customers.log bad=$LOG_DIR/customers.bad data=$EXE_HOME/customers.dat
sqlldr $2 control=$EXE_HOME/inventory.ctl log=$LOG_DIR/inventory.log bad=$LOG_DIR/inventory.bad  data=$EXE_HOME/inventory.dat
sqlldr $2 control=$EXE_HOME/orders.ctl log=$LOG_DIR/orders.log bad=$LOG_DIR/orders.bad data=$EXE_HOME/orders.dat
sqlldr $2 control=$EXE_HOME/products.ctl log=$LOG_DIR/products.log bad=$LOG_DIR/products.bad data=$EXE_HOME/products.dat

exit
