CREATE TABLE "ACTIVITY" (
   "CUSTOMER_NO" NUMBER(*,0), 
   "DATE_TICKLER" CHAR(6), 
   "TICKLER" CHAR(2), 
   "INITIALS" CHAR(4), 
   "ACTION_INFO" CHAR(60)) 
   STORAGE(INITIAL 100k NEXT 10k 
	   MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50 );

CREATE INDEX "ACUSTOMER_NO" ON "ACTIVITY" ("CUSTOMER_NO")
   STORAGE (INITIAL 170k NEXT 82k
            MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50 ) ;

CREATE TABLE "CUSTOMERS" (
   "CUSTOMER_NO" NUMBER(*,0), 
   "COMPANY" CHAR(40), 
   "CONTACT" CHAR(24), 
   "TITLE" CHAR(30), 
   "SALUTATION" CHAR(24), 
   "ADDRESS1" CHAR(30), 
   "ADDRESS2" CHAR(30), 
   "CITY" CHAR(20), 
   "STATE" CHAR(2), 
   "POSTAL_CODE" CHAR(10), 
   "COUNTRY" CHAR(20),
   "PHONE_NO" CHAR(18), 
   "FAX_NO" CHAR(20), 
   "AKA_COMPANY"  CHAR(20),
   "COMMENTS" CHAR(60), 
   "LICENSEE" NUMBER(*,0)) 
   STORAGE(INITIAL 500k NEXT 500k
           MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50 );

CREATE UNIQUE INDEX "CCUSTOMER_NO" ON "CUSTOMERS" ("CUSTOMER_NO")
   STORAGE (INITIAL 20k NEXT 16k
            MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50 ) ;

CREATE TABLE "CUST_NOTES" (
   "CUSTOMER_NO" NUMBER(*,0), 
   "DATE_ENTERED" CHAR(6), 
   "ENTERED_BY" CHAR(4), 
   "DESC_LINES1" CHAR(60), 
   "DESC_LINES2" CHAR(60), 
   "DESC_LINES3" CHAR(60), 
   "DESC_LINES4" CHAR(60),
   "DESC_LINES5" CHAR(60)) 
   STORAGE(INITIAL 500k NEXT 100k 
	   MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50) ;

CREATE INDEX "NCUSTOMER_NO" ON "CUST_NOTES" ("CUSTOMER_NO" ) 
   STORAGE (INITIAL 10k NEXT 10k
            MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50) ;

CREATE TABLE "INVENTORY" (
   "PRODUCT_NO" CHAR(12), 
   "INV_DATE" CHAR(6), 
   "INV_QTY" NUMBER(*,0), 
   "INV_COST" NUMBER(*,0), 
   "INV_LOC" CHAR(16)) 
   STORAGE(INITIAL 32k NEXT 16k
	   MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50) ;

CREATE INDEX "IPRODUCT_NO" ON "INVENTORY" ("PRODUCT_NO" ) 
   STORAGE (INITIAL 10k NEXT 10k 
            MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50);

 CREATE TABLE "ORDERS" (
    "CUSTOMER_NO" NUMBER(*,0), 
    "PRODUCT_NO" CHAR(12), 
    "ORDER_DATE" CHAR(6), 
    "STATUS" CHAR(4), 
    "QUANTITY" NUMBER(*,0), 
    "AMOUNT" NUMBER(*,0)) 
    STORAGE(INITIAL 580k NEXT 280k
            MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50);

CREATE INDEX "OCUSTOMER_NO" ON "ORDERS" ("CUSTOMER_NO" ) 
   STORAGE (INITIAL 260k NEXT 124k
            MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50);

CREATE INDEX "OPRODUCT_NO" ON "ORDERS" ("PRODUCT_NO" ) 
   STORAGE (INITIAL 390k NEXT 186k 
	    MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50);

CREATE TABLE "PRODUCTS" (
   "PRODUCT_NO" CHAR(12), 
   "PRODUCT_CLASS" CHAR(20), 
   "PRODUCT_NAME" CHAR(40), 
   "SALES_PRICE" NUMBER(*,0), 
   "PRODUCT_COST" NUMBER(*,0)) 
   STORAGE(INITIAL 20k NEXT 16k
           MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50);

CREATE UNIQUE INDEX "PPRODUCT_NO" ON "PRODUCTS" ("PRODUCT_NO") 
   STORAGE (INITIAL 10k NEXT 10k
            MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 50);

exit
