/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import omnidex.client.OdxCLJTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OdxCLJPoolArray<E> {
    private ArrayList<E> m_inUse = new ArrayList();
    private LinkedList<E> m_available = new LinkedList();

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    public int size() {
        return this.m_inUse.size() + this.m_available.size();
    }

    public boolean isEmpty() {
        return this.m_inUse.size() != 0 || this.m_available.size() != 0;
    }

    public int getLockCount() {
        return this.m_inUse.size();
    }

    public void add(E e) {
        this.trace("add");
        this.m_available.addFirst(e);
    }

    public void addLock(E e) {
        this.trace("addLock");
        this.m_inUse.add(e);
    }

    public E lock() {
        this.trace("lock");
        if (this.m_available.isEmpty()) {
            return null;
        }
        E e = this.m_available.getFirst();
        if (e != null) {
            this.m_inUse.add(e);
            this.m_available.removeFirst();
        }
        return e;
    }

    public void unlock(E e) {
        this.trace("unlock");
        if (this.m_inUse.remove(e)) {
            this.m_available.addFirst(e);
        }
    }

    public Iterator<E> iterator() {
        this.trace("iterator");
        ArrayList<E> arrayList = new ArrayList<E>();
        if (!this.m_inUse.isEmpty()) {
            arrayList.addAll(this.m_inUse);
        }
        if (!this.m_available.isEmpty()) {
            arrayList.addAll(this.m_available);
        }
        return arrayList.iterator();
    }

    public void clear() {
        this.trace("clear");
        this.m_available.clear();
        this.m_inUse.clear();
    }

    public void remove(E e) {
        this.trace("remove");
        if (this.m_inUse.contains(e)) {
            this.m_inUse.remove(e);
        } else if (this.m_available.contains(e)) {
            this.m_available.remove(e);
        }
    }

    public void finalize() {
        this.clear();
    }

    public void dump() {
        OdxCLJTrace.print("Inside " + this);
        OdxCLJTrace.print(" - Used: " + this.m_inUse);
        OdxCLJTrace.print(" - Available: " + this.m_available);
    }
}

