/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import omnidex.client.OdxCLJConnection;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCDatabaseMetaData;
import omnidex.jdbc.OdxJDBCPooledConnection;
import omnidex.jdbc.OdxJDBCPreparedStatement;
import omnidex.jdbc.OdxJDBCStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OdxJDBCConnection
implements Connection {
    private OdxCLJConnection m_oaConnection;
    private DatabaseMetaData m_dbMetaData;
    private OdxJDBCPooledConnection m_pooledConnection;
    private ArrayList<OdxJDBCStatement> m_jdbcStatements;
    private Map<String, Class<?>> m_typeMap;
    private boolean m_noThread;

    protected OdxJDBCConnection() {
        this.trace(null);
        this.m_jdbcStatements = new ArrayList();
        this.m_typeMap = new HashMap();
        this.m_noThread = false;
    }

    protected void open(String string, Properties properties) throws SQLException {
        this.trace("initialize");
        this.m_oaConnection = new OdxCLJConnection();
        this.m_oaConnection.open(string, properties);
    }

    protected void setConnections(OdxJDBCPooledConnection odxJDBCPooledConnection, OdxJDBCConnection odxJDBCConnection) {
        this.trace("initialize(pooledConnection)");
        this.m_pooledConnection = odxJDBCPooledConnection;
        this.m_oaConnection = odxJDBCConnection.getOaConnection();
    }

    protected OdxCLJConnection getOaConnection() {
        return this.m_oaConnection;
    }

    protected void checkConnection() throws SQLException {
        if (this.m_oaConnection == null) {
            throw OdxCLJException.error(25502);
        }
    }

    protected void clearConnection() {
        this.m_oaConnection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatements() throws SQLException {
        this.trace("closeStatements");
        ArrayList<OdxJDBCStatement> arrayList = this.m_jdbcStatements;
        synchronized (arrayList) {
            Iterator<OdxJDBCStatement> iterator = this.m_jdbcStatements.iterator();
            while (iterator.hasNext()) {
                iterator.next().connectionClosed();
            }
            this.m_jdbcStatements.clear();
        }
    }

    private void closeConnection() throws SQLException {
        this.trace("closeConnection");
        this.m_oaConnection.close();
        this.m_oaConnection = null;
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected void finalize() throws SQLException, Throwable {
        this.close();
        super.finalize();
    }

    protected void dump() {
        OdxCLJTrace.print("Inside " + this);
        OdxCLJTrace.print(" - " + this.m_oaConnection);
        for (int i = 0; i < this.m_jdbcStatements.size(); ++i) {
            this.m_jdbcStatements.get(i).dump();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.trace("nativeSQL");
        return string;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (!bl) {
            throw OdxCLJException.error(25509);
        }
    }

    @Override
    public boolean getAutoCommit() {
        return true;
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() throws SQLException {
        throw OdxCLJException.error(25508);
    }

    @Override
    public void close() throws SQLException {
        this.trace("close");
        this.closeStatements();
        if (this.m_pooledConnection != null) {
            this.m_pooledConnection.logicalClose();
            this.clearConnection();
        } else {
            this.closeConnection();
        }
    }

    @Override
    public boolean isClosed() {
        return this.m_oaConnection == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.trace("getMetaData");
        this.checkConnection();
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new OdxJDBCDatabaseMetaData(this, this.m_oaConnection);
        }
        return this.m_dbMetaData;
    }

    public void setNoThread(boolean bl) throws SQLException {
        this.m_noThread = bl;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (bl) {
            throw OdxCLJException.error(25510);
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setCatalog(String string) {
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkConnection();
        return this.m_oaConnection.getEnvironmentName();
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        if (n != 0) {
            throw OdxCLJException.error(25511);
        }
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.trace("createStatement");
        this.checkConnection();
        OdxJDBCStatement odxJDBCStatement = new OdxJDBCStatement(this);
        odxJDBCStatement.initialize(this.m_oaConnection, n, n2, this.m_noThread);
        ArrayList<OdxJDBCStatement> arrayList = this.m_jdbcStatements;
        synchronized (arrayList) {
            this.m_jdbcStatements.add(odxJDBCStatement);
        }
        return odxJDBCStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkConnection();
        OdxJDBCPreparedStatement odxJDBCPreparedStatement = new OdxJDBCPreparedStatement(this);
        odxJDBCPreparedStatement.initialize(this.m_oaConnection, string, n, n2, this.m_noThread);
        ArrayList<OdxJDBCStatement> arrayList = this.m_jdbcStatements;
        synchronized (arrayList) {
            this.m_jdbcStatements.add(odxJDBCPreparedStatement);
        }
        return odxJDBCPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.trace("prepareCall");
        throw OdxCLJException.error(25507);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.m_typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.m_typeMap = map;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw OdxCLJException.error(25500);
    }
}

