/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCDriver;
import omnidex.jdbc.OdxJDBCRouterPreparedStatement;
import omnidex.jdbc.OdxJDBCRouterServer;
import omnidex.jdbc.OdxJDBCRouterStatement;
import omnidex.xml.OdxJDBCIR.ConfigType;
import omnidex.xml.OdxJDBCIR.ConnectionPoolingType;
import omnidex.xml.OdxJDBCIR.RuleTypeType;
import omnidex.xml.OdxJDBCIR.RulesType;
import omnidex.xml.OdxJDBCIR.ServersType;
import omnidex.xml.OdxJDBCIR.WhenExhaustedActionType;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OdxJDBCRouterConnection
implements Connection {
    private static String XML_PACKAGE_NAME = "omnidex.xml.OdxJDBCIR";
    private static String RULE_NAME_OPTION = ";RULE=";
    private ConfigType m_config;
    private HashMap<String, OdxJDBCRouterServer> m_serverList;
    private RulesType.Rule m_rule;
    private static HashMap<String, GenericObjectPool> m_connectionPoolList;
    private ArrayList<Statement> m_statements;
    private Map<String, Class<?>> m_typeMap;
    private Boolean m_autoCommit;
    private Boolean m_readOnly;
    private String m_catalog = null;
    private Integer m_level;
    private Integer m_holdability;

    protected OdxJDBCRouterConnection() {
        this.trace(null);
        this.m_statements = new ArrayList();
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected void open(String string, Properties properties) throws SQLException {
        String string2;
        String string3 = null;
        int n = string.indexOf(59);
        if (n >= 0) {
            string2 = string.substring(n);
            if (string2.toUpperCase().startsWith(RULE_NAME_OPTION)) {
                string3 = string2.substring(RULE_NAME_OPTION.length());
                string = string.substring(0, n);
            } else {
                throw OdxCLJException.error(25544);
            }
        }
        this.trace("Opening: " + string);
        if (string3 != null) {
            this.trace("Rule passed in the connection string: " + string3);
        }
        try {
            string2 = JAXBContext.newInstance((String)XML_PACKAGE_NAME);
            Unmarshaller unmarshaller = string2.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((InputStream)new FileInputStream(string));
            this.m_config = (ConfigType)jAXBElement.getValue();
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
        catch (JAXBException jAXBException) {
            throw OdxCLJException.error((Exception)((Object)jAXBException));
        }
        this.setServerList();
        this.setRule(string3);
    }

    private void setRule(String string) throws SQLException {
        RulesType rulesType = this.m_config.getRules();
        if (string == null) {
            string = rulesType.getDefaultRule();
            if (string != null) {
                this.trace("Using default rule: " + string);
            }
        } else {
            this.trace("Using the following rule: " + string);
        }
        if (string == null) {
            List<RulesType.Rule> list = rulesType.getRule();
            this.m_rule = list.get(0);
            this.trace("Using the first rule in the config file: " + this.m_rule.getName());
            this.checkRule(this.m_rule);
        } else {
            this.m_rule = this.getRule(string);
        }
    }

    private void setServerList() {
        this.m_serverList = new HashMap();
        List<ServersType.Server> list = this.m_config.getServers().getServer();
        for (ServersType.Server server : list) {
            OdxJDBCRouterServer odxJDBCRouterServer = new OdxJDBCRouterServer(server.getName(), server.getDescription(), server.getJdbcDriver(), server.getConnectionString());
            this.m_serverList.put(odxJDBCRouterServer.getName().toUpperCase(), odxJDBCRouterServer);
            this.saveConnectionPoolingInfo(odxJDBCRouterServer, server.getConnectionPooling());
        }
    }

    private void checkRule(RulesType.Rule rule) throws SQLException {
        RuleTypeType ruleTypeType = rule.getType();
        if (ruleTypeType == null) {
            throw OdxCLJException.error(25553);
        }
        if (ruleTypeType == RuleTypeType.JAVA) {
            String string = rule.getClassName();
            if (string == null) {
                throw OdxCLJException.error(25546);
            }
            this.trace("Rule type: JAVA, className: " + string);
        } else if (ruleTypeType == RuleTypeType.REGEXP) {
            if (rule.getConditions() == null) {
                throw OdxCLJException.error(25548);
            }
            this.trace("Rule type: REGEXP");
        } else if (ruleTypeType == RuleTypeType.DEFAULTSERVER) {
            String string = rule.getDefaultServer();
            if (string == null) {
                throw OdxCLJException.error(25547);
            }
            this.trace("Rule type: DEFAULTSERVER, serverName: " + string);
        }
    }

    private void saveConnectionPoolingInfo(OdxJDBCRouterServer odxJDBCRouterServer, ConnectionPoolingType connectionPoolingType) {
        ConnectionPoolingType connectionPoolingType2 = this.m_config.getGlobal() == null ? null : this.m_config.getGlobal().getConnectionPooling();
        Integer n = null;
        Integer n2 = null;
        Long l = null;
        WhenExhaustedActionType whenExhaustedActionType = null;
        if (connectionPoolingType != null) {
            n = connectionPoolingType.getMaxActive();
            whenExhaustedActionType = connectionPoolingType.getWhenExhaustedAction();
            l = connectionPoolingType.getMaxWait();
            n2 = connectionPoolingType.getMaxIdle();
        }
        if (connectionPoolingType2 != null) {
            if (n == null) {
                n = connectionPoolingType2.getMaxActive();
            }
            if (whenExhaustedActionType == null) {
                whenExhaustedActionType = connectionPoolingType2.getWhenExhaustedAction();
            }
            if (l == null) {
                l = connectionPoolingType2.getMaxWait();
            }
            if (n2 == null) {
                n2 = connectionPoolingType2.getMaxIdle();
            }
        }
        if (n != null) {
            odxJDBCRouterServer.setMaxActive(n);
        }
        if (whenExhaustedActionType != null) {
            if (whenExhaustedActionType == WhenExhaustedActionType.BLOCK) {
                odxJDBCRouterServer.setWhenExhaustedAction((byte)1);
            } else if (whenExhaustedActionType == WhenExhaustedActionType.FAIL) {
                odxJDBCRouterServer.setWhenExhaustedAction((byte)0);
            } else if (whenExhaustedActionType == WhenExhaustedActionType.GROW) {
                odxJDBCRouterServer.setWhenExhaustedAction((byte)2);
            }
        }
        if (l != null) {
            odxJDBCRouterServer.setMaxWait(l);
        }
        if (n2 != null) {
            odxJDBCRouterServer.setMaxIdle(n2);
        }
    }

    protected RulesType.Rule getRule(String string) throws SQLException {
        if (string == null) {
            return this.m_rule;
        }
        RulesType.Rule rule = null;
        RulesType rulesType = this.m_config.getRules();
        List<RulesType.Rule> list = rulesType.getRule();
        for (RulesType.Rule rule2 : list) {
            if (!string.equalsIgnoreCase(rule2.getName())) continue;
            rule = rule2;
            break;
        }
        if (rule == null) {
            throw OdxCLJException.error(25545, string);
        }
        this.checkRule(rule);
        return rule;
    }

    protected HashMap<String, OdxJDBCRouterServer> getServerList() {
        return this.m_serverList;
    }

    protected OdxJDBCRouterServer getServer(String string) {
        return this.m_serverList.get(string.toUpperCase());
    }

    protected Connection getConnection(OdxJDBCRouterServer odxJDBCRouterServer) throws SQLException {
        if (odxJDBCRouterServer == null) {
            throw OdxCLJException.error(25551);
        }
        String string = odxJDBCRouterServer.getJdbcDriver();
        if (string == null) {
            throw OdxCLJException.error(25549);
        }
        this.trace("Loading driver: " + string);
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw OdxCLJException.error(25552, string);
        }
        String string2 = odxJDBCRouterServer.getConnectionString();
        if (string2 == null) {
            throw OdxCLJException.error(25550);
        }
        this.trace("Connection string: " + string2);
        string2 = OdxJDBCDriver.translatePath(string2);
        Connection connection = OdxJDBCRouterConnection.getConnectionFromPool(string2, odxJDBCRouterServer);
        if (this.m_typeMap != null) {
            connection.setTypeMap(this.m_typeMap);
        }
        if (this.m_autoCommit != null) {
            connection.setAutoCommit(this.m_autoCommit);
        }
        if (this.m_readOnly != null) {
            connection.setReadOnly(this.m_readOnly);
        }
        if (this.m_catalog != null) {
            connection.setCatalog(this.m_catalog);
        }
        if (this.m_level != null) {
            connection.setTransactionIsolation(this.m_level);
        }
        if (this.m_holdability != null) {
            connection.setHoldability(this.m_holdability);
        }
        return connection;
    }

    private static synchronized Connection getConnectionFromPool(String string, OdxJDBCRouterServer odxJDBCRouterServer) throws SQLException {
        GenericObjectPool genericObjectPool = null;
        if (m_connectionPoolList == null) {
            m_connectionPoolList = new HashMap();
        } else {
            genericObjectPool = m_connectionPoolList.get(string);
        }
        if (genericObjectPool == null) {
            OdxCLJTrace.print("New connection pool created");
            genericObjectPool = new GenericObjectPool(null);
            m_connectionPoolList.put(string, genericObjectPool);
            DriverManagerConnectionFactory driverManagerConnectionFactory = new DriverManagerConnectionFactory(string, null);
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, (ObjectPool)genericObjectPool, null, null, false, true);
        }
        genericObjectPool.setMaxActive(odxJDBCRouterServer.getMaxActive());
        genericObjectPool.setWhenExhaustedAction(odxJDBCRouterServer.getWhenExhaustedAction());
        genericObjectPool.setMaxWait(odxJDBCRouterServer.getMaxWait());
        genericObjectPool.setMaxIdle(odxJDBCRouterServer.getMaxIdle());
        return new PoolingDataSource((ObjectPool)genericObjectPool).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStatement(Statement statement) {
        ArrayList<Statement> arrayList = this.m_statements;
        synchronized (arrayList) {
            this.m_statements.add(statement);
        }
    }

    protected void finalize() throws SQLException, Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public Statement createStatement() throws SQLException {
        OdxJDBCRouterStatement odxJDBCRouterStatement = new OdxJDBCRouterStatement(this);
        this.addStatement(odxJDBCRouterStatement);
        return odxJDBCRouterStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        OdxJDBCRouterPreparedStatement odxJDBCRouterPreparedStatement = new OdxJDBCRouterPreparedStatement(this);
        this.addStatement(odxJDBCRouterPreparedStatement);
        odxJDBCRouterPreparedStatement.initialize(string);
        return odxJDBCRouterPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        throw OdxCLJException.error(25507);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.m_autoCommit = bl;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.m_autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void rollback() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ArrayList<Statement> arrayList = this.m_statements;
        synchronized (arrayList) {
            Iterator<Statement> iterator = this.m_statements.iterator();
            while (iterator.hasNext()) {
                iterator.next().close();
            }
            this.m_statements.clear();
        }
        this.m_config = null;
        this.m_serverList = null;
        this.m_rule = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_config == null && this.m_serverList == null && this.m_rule == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.m_readOnly = bl;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.m_readOnly;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.m_catalog = string;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.m_catalog;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.m_level = n;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.m_level == null ? 0 : this.m_level;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        OdxJDBCRouterStatement odxJDBCRouterStatement = new OdxJDBCRouterStatement(this);
        odxJDBCRouterStatement.initialize(n, n2);
        this.addStatement(odxJDBCRouterStatement);
        return odxJDBCRouterStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        OdxJDBCRouterPreparedStatement odxJDBCRouterPreparedStatement = new OdxJDBCRouterPreparedStatement(this);
        this.addStatement(odxJDBCRouterPreparedStatement);
        odxJDBCRouterPreparedStatement.initialize(string, n, n2);
        return odxJDBCRouterPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw OdxCLJException.error(25507);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.m_typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.m_typeMap = map;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.m_holdability = n;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.m_holdability == null ? 2 : this.m_holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        OdxJDBCRouterStatement odxJDBCRouterStatement = new OdxJDBCRouterStatement(this);
        odxJDBCRouterStatement.initialize(n, n2, n3);
        this.addStatement(odxJDBCRouterStatement);
        return odxJDBCRouterStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        OdxJDBCRouterPreparedStatement odxJDBCRouterPreparedStatement = new OdxJDBCRouterPreparedStatement(this);
        this.addStatement(odxJDBCRouterPreparedStatement);
        odxJDBCRouterPreparedStatement.initialize(string, n, n2, n3);
        return odxJDBCRouterPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw OdxCLJException.error(25507);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw OdxCLJException.error(25500);
    }
}

