/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import omnidex.client.OdxCLJConnectionMgr;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCConnection;
import omnidex.jdbc.OdxJDBCRouterConnection;

public final class OdxJDBCDriver
implements Driver {
    private static String SUBNAME_PREFIX = "jdbc:omnidex:";
    private static String DRIVER_PREFIX = "jdbc:omnidex:driver:";
    private static String ROUTER_PREFIX = "jdbc:omnidex:router:";

    public Connection connect(String string, Properties properties) throws SQLException {
        OdxCLJTrace.print("Driver.connect(" + string + ")");
        if (string != null) {
            String string2 = string.toLowerCase();
            if (string2.startsWith(ROUTER_PREFIX)) {
                OdxJDBCRouterConnection odxJDBCRouterConnection = new OdxJDBCRouterConnection();
                odxJDBCRouterConnection.open(OdxJDBCDriver.translatePath(string.substring(ROUTER_PREFIX.length())), properties);
                return odxJDBCRouterConnection;
            }
            if (string2.startsWith(DRIVER_PREFIX)) {
                OdxJDBCConnection odxJDBCConnection = new OdxJDBCConnection();
                odxJDBCConnection.open(OdxJDBCDriver.translatePath(string.substring(DRIVER_PREFIX.length())), properties);
                return odxJDBCConnection;
            }
            if (string2.startsWith(SUBNAME_PREFIX)) {
                OdxJDBCConnection odxJDBCConnection = new OdxJDBCConnection();
                odxJDBCConnection.open(OdxJDBCDriver.translatePath(string.substring(SUBNAME_PREFIX.length())), properties);
                return odxJDBCConnection;
            }
        }
        return null;
    }

    public boolean acceptsURL(String string) {
        OdxCLJTrace.print("Driver.acceptsURL(" + string + ")");
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).startsWith(DRIVER_PREFIX) || string.startsWith(ROUTER_PREFIX) || string.startsWith(SUBNAME_PREFIX);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        OdxCLJTrace.print("Driver.getPropertyInfo(" + string + ")");
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 4;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static void closeConnectionPooling() throws SQLException {
        OdxCLJConnectionMgr.close();
    }

    protected static String translatePath(String string) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf("${", n2)) != -1) {
            int n3 = string.indexOf(125, n);
            if (n3 != -1) {
                String string2 = string.substring(n + 2, n3);
                String string3 = System.getenv(string2);
                OdxCLJTrace.print("Translating: " + string);
                if (string3 != null) {
                    string = string.substring(0, n) + string3 + string.substring(n3 + 1);
                }
                OdxCLJTrace.print("Environment: " + string2 + " = " + string3);
                OdxCLJTrace.print("Translation: " + string);
            }
            n2 = n + 1;
        }
        return string;
    }

    static {
        try {
            OdxCLJTrace.print("Loading OdxJDBC class...");
            DriverManager.registerDriver(new OdxJDBCDriver());
        }
        catch (SQLException sQLException) {
            OdxCLJTrace.print("Unable to load or register OdxJDBC driver");
            OdxCLJTrace.print(sQLException);
        }
    }
}

