/*
 * Decompiled with CFR 0.152.
 */
package omnidex.java;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omnidex.java.RangeValues;
import omnidex.java.ValueList;

public class OmniSearch {
    public static final int ROW_COUNT = 1;
    public static final int DISTINCT_COUNT = 2;
    public static final int COUNT = 3;
    private Connection _jdbcConnection;
    private Statement _jdbcStatement;
    private DatabaseMetaData _jdbcMetaData;
    private String _tableName;
    private String _distinctColumn;
    private LinkedHashMap<String, ValueList> _columns;
    private long _count;
    private long _distinctCount;
    private boolean _recalcCount;
    private boolean _recalcDistinct;
    private ArrayList<ChangeListener> _listeners;
    private static PrintWriter _logWriter;
    private static String ACTIVECOUNT_KEY;
    private static String KWDSEARCH_KEY;
    private static String SQL_KEY;
    private static String RANGECOUNT_KEY;
    private static String RANGESQL_KEY;
    private static String CRITERIA_KEY;
    private static String OMNISEARCH_TAG;
    private static String TABLE_TAG;
    private static String DISTINCT_TAG;
    private static String VALUELIST_TAG;

    public OmniSearch(Connection connection) {
        this._jdbcConnection = connection;
        this._jdbcStatement = null;
        this._columns = new LinkedHashMap();
        this._listeners = new ArrayList();
        this.initialize();
    }

    private void initialize() {
        this._tableName = null;
        this._distinctColumn = null;
        this._distinctCount = 0L;
        this._count = 0L;
        this._recalcCount = false;
        this._recalcDistinct = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogWriter(PrintWriter printWriter) {
        Object object = OmniSearch.class;
        synchronized (OmniSearch.class) {
            _logWriter = printWriter;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = OmniSearch.formatTrace("OmniSearch", "setLogWriter", true);
            ((StringBuilder)object).append(" started on ");
            ((StringBuilder)object).append(new SimpleDateFormat("MM/dd/yyyy").format(new Date()));
            OmniSearch.writeTrace((StringBuilder)object);
            return;
        }
    }

    public static PrintWriter getLogWriter() {
        return _logWriter;
    }

    public Connection getConnection() {
        return this._jdbcConnection;
    }

    public long getCount(int n) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "getCount", true, n);
        }
        if (this._tableName == null || this._columns.size() == 0) {
            return 0L;
        }
        if (this._recalcCount) {
            this.calculateCount();
            this.executeListeners();
        }
        switch (n) {
            case 1: {
                return this._count;
            }
            case 2: 
            case 3: {
                if (this._distinctColumn == null) {
                    if (n == 2) {
                        throw new SQLException("There is no distinct column.");
                    }
                    this._distinctCount = this._count;
                } else if (this._recalcDistinct) {
                    if (this._count == 0L) {
                        this._distinctCount = 0L;
                        this._recalcDistinct = false;
                    } else {
                        this.calcDistinctCount();
                    }
                }
                return this._distinctCount;
            }
        }
        throw new SQLException("Unknown count type.");
    }

    public String getSql() throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "getSql", true);
        }
        if (this._tableName == null || this._columns.size() == 0) {
            return null;
        }
        String string = this.getCriteria(null);
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select count(*)");
        if (this._distinctColumn != null) {
            stringBuilder.append(", count(distinct ");
            stringBuilder.append(this._distinctColumn);
            stringBuilder.append(")");
        }
        stringBuilder.append(" from ");
        stringBuilder.append(this._tableName);
        stringBuilder.append(" where ");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public void setTable(String string) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "setTable", true, string);
        }
        if (!(string = this.checkTableName(string)).equals(this._tableName)) {
            this.clearCriteria();
            if (this._tableName != null) {
                this._recalcCount = true;
            }
            this._tableName = string;
            this._recalcDistinct = true;
            if (this._recalcCount) {
                this.executeListeners();
            }
        }
    }

    public String getTable() {
        return this._tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDistinctColumn(String string) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "setDistinctColumn", true, string);
        }
        this.checkTableName();
        if (string != null) {
            string = string.trim();
        }
        if (string == null) {
            if (this._distinctColumn == null) {
                return;
            }
        } else {
            if (string.equals(this._distinctColumn)) {
                return;
            }
            string = this.checkColumnName(string);
        }
        this._distinctColumn = string;
        this._recalcDistinct = true;
        LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
        synchronized (linkedHashMap) {
            for (ValueList valueList : this._columns.values()) {
                valueList.setDistinctColumn(this._distinctColumn);
            }
        }
        this.executeListeners();
    }

    public String getDistinctColumn() {
        return this._distinctColumn;
    }

    public ValueList getValueList(String string) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "getValueList", true, string);
        }
        return this.createValueList(string, ACTIVECOUNT_KEY);
    }

    public ValueList getValueList(String string, int n, int n2, int n3) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "getValueList", true, string, n, n2, n3);
        }
        return this.createValueList(string, n, n2, n3, SQL_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValueList(ValueList valueList) {
        if (this.isTrace()) {
            this.trace(this, "removeValueList", true, valueList);
        }
        try {
            LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
            synchronized (linkedHashMap) {
                this._columns.remove(valueList.getKey());
            }
            valueList.setActive(false);
            this._recalcDistinct = true;
            this._recalcCount = true;
            this.setCountChanged(null);
            this.executeListeners();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RangeValues getRangeValues(String string) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "getRangeValues", true, string);
        }
        return (RangeValues)this.createValueList(string, RANGECOUNT_KEY);
    }

    public RangeValues getRangeValues(String string, int n, int n2, int n3) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "getRangeValues", true, string, n, n2, n3);
        }
        return (RangeValues)this.createValueList(string, n, n2, n3, RANGESQL_KEY);
    }

    public void removeRangeValues(RangeValues rangeValues) {
        if (this.isTrace()) {
            this.trace(this, "removeRangeValues", true, rangeValues);
        }
        this.removeValueList(rangeValues);
    }

    public void addCriteria(String string) throws SQLException {
        ValueList valueList;
        if (this.isTrace()) {
            this.trace(this, "addCriteria", true, string);
        }
        if ((valueList = this.createValueList(string = this.checkString(string, "criteria."), CRITERIA_KEY)) != null) {
            this._recalcDistinct = true;
            this._recalcCount = true;
            valueList.addCriteria(string);
        }
    }

    public void removeCriteria(String string) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "removeCriteria", true, string);
        }
        string = this.checkString(string, "criteria.");
        String string2 = CRITERIA_KEY + string;
        ValueList valueList = this._columns.get(string2);
        if (valueList != null) {
            this.removeValueList(valueList);
        }
    }

    public void setCriteria(String string, String string2) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "setCriteria", true, string, string2);
        }
        string2 = this.checkString(string2, "criteria.");
        ValueList valueList = this.createValueList(string, KWDSEARCH_KEY);
        if (valueList != null) {
            this._recalcDistinct = true;
            this._recalcCount = true;
            valueList.addCriteria(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCriteria(String string) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "clearCriteria", true, string);
        }
        string = this.checkColumnName(string);
        String string2 = KWDSEARCH_KEY + string;
        ValueList valueList = null;
        LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
        synchronized (linkedHashMap) {
            valueList = this._columns.get(string2);
        }
        if (valueList != null) {
            valueList.clearCriteria(true);
            this._recalcDistinct = true;
            this._recalcCount = true;
            this.executeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCriteria() throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "clearCriteria", true);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
        synchronized (linkedHashMap) {
            for (ValueList object : this._columns.values()) {
                if (object.getKey().startsWith(CRITERIA_KEY)) continue;
                object.setActive(false);
                arrayList.add(object.getKey());
            }
            for (String string : arrayList) {
                this._columns.remove(string);
            }
            bl = this._columns.size() != 0;
        }
        this._distinctCount = 0L;
        this._count = 0L;
        this._recalcCount = this._recalcDistinct = bl;
        this.executeListeners();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.isTrace()) {
            this.trace(this, "addChangeListener", true, changeListener);
        }
        if (changeListener != null && !this._listeners.contains(changeListener)) {
            this._listeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.isTrace()) {
            this.trace(this, "removeChangeListener", true, changeListener);
        }
        if (changeListener != null) {
            this._listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) throws IOException {
        if (this.isTrace()) {
            this.trace(this, "save", true, string);
        }
        try (BufferedWriter bufferedWriter = null;){
            bufferedWriter = new BufferedWriter(new FileWriter(string, false));
            bufferedWriter.write(this.save());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save() {
        if (this.isTrace()) {
            this.trace(this, "save", true);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(OMNISEARCH_TAG);
        stringBuilder.append(":{");
        if (this._tableName != null) {
            this.setEntry(stringBuilder, TABLE_TAG, this._tableName, null);
        }
        if (this._distinctColumn != null) {
            this.setEntry(stringBuilder, DISTINCT_TAG, this._distinctColumn, ",");
        }
        LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
        synchronized (linkedHashMap) {
            if (this._columns.size() != 0) {
                this.setEntry(stringBuilder, VALUELIST_TAG, null, ",");
                stringBuilder.append("[");
                boolean bl = true;
                for (ValueList valueList : this._columns.values()) {
                    String string = valueList.save();
                    if (string == null) continue;
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                }
                stringBuilder.append("]");
            }
        }
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string) throws SQLException, IOException {
        Object object;
        if (this.isTrace()) {
            this.trace(this, "open", true, string);
        }
        this.initialize();
        Object object2 = this._columns;
        synchronized (object2) {
            for (ValueList valueList : this._columns.values()) {
                valueList.setActive(false);
            }
            this._columns.clear();
        }
        string = this.checkString(string, "query.");
        if (!string.startsWith("{")) {
            object2 = null;
            try {
                object2 = new BufferedReader(new FileReader(string));
                object = new StringBuilder();
                ((StringBuilder)object).append(object2);
                string = ((StringBuilder)object).toString();
            }
            finally {
                if (object2 != null) {
                    ((BufferedReader)object2).close();
                }
            }
        }
        object2 = string.toCharArray();
        object = new int[]{0, ((Object)object2).length - 1};
        this.checkBraces((char[])object2, (int[])object);
        if (!this.compareTag((char[])object2, (int[])object, OMNISEARCH_TAG)) {
            throw new SQLException("Missing omniSearch name tag.");
        }
        this.checkBraces((char[])object2, (int[])object);
        if (this.entryExist((char[])object2, (int[])object, TABLE_TAG)) {
            this.setTable(this.getString((char[])object2, (int[])object));
        }
        if (this.entryExist((char[])object2, (int[])object, DISTINCT_TAG)) {
            this.setDistinctColumn(this.getString((char[])object2, (int[])object));
        }
        if (this.entryExist((char[])object2, (int[])object, VALUELIST_TAG)) {
            this.checkArray((char[])object2, (int[])object);
            this.skipLastSpaces((char[])object2, (int[])object);
            Object object3 = object[1];
            while (true) {
                object[1] = object[0] + this.getEntryLength((char[])object2, (int[])object);
                reference var5_7 = object[1] + true;
                ValueList.create(this, (char[])object2, (int[])object);
                while (object2[var5_7] == 32) {
                    ++var5_7;
                }
                if (object2[var5_7] != 44) break;
                object[0] = var5_7 + true;
                object[1] = object3;
                this.skipSpaces((char[])object2, (int[])object);
            }
        }
        this._recalcDistinct = true;
        this._recalcCount = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement getStatement() throws SQLException {
        if (this._jdbcStatement == null) {
            OmniSearch omniSearch = this;
            synchronized (omniSearch) {
                if (this._jdbcStatement == null) {
                    this._jdbcStatement = this._jdbcConnection.createStatement(1004, 1007);
                }
            }
        }
        if (this._jdbcConnection.isClosed()) {
            throw new SQLException("Connection is closed.");
        }
        return this._jdbcStatement;
    }

    protected String getSql(String string, String string2, boolean bl) {
        if (this.isTrace()) {
            this.trace(this, "getSql", false, string, string2, bl);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        if (this._distinctColumn != null) {
            stringBuilder.append("count(distinct ");
            stringBuilder.append(this._distinctColumn);
            stringBuilder.append("), ");
        }
        if (bl) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        } else {
            stringBuilder.append("count(*)");
            if (string != null) {
                stringBuilder.append(", ");
                stringBuilder.append(string);
            }
        }
        stringBuilder.append(" from ");
        stringBuilder.append(this._tableName);
        if (string2 != null) {
            stringBuilder.append(" where ");
            stringBuilder.append(string2);
        }
        if (string != null) {
            stringBuilder.append(" group by ");
            stringBuilder.append(string);
        }
        String string3 = stringBuilder.toString();
        if (this.isTrace()) {
            this.trace(this, "getSql", false, string3);
        }
        return string3;
    }

    protected String getRangeSql(String string, String string2) {
        if (this.isTrace()) {
            this.trace(this, "getRangeSql", false, string, string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select min(");
        stringBuilder.append(string);
        stringBuilder.append("), max(");
        stringBuilder.append(string);
        stringBuilder.append(") from ");
        stringBuilder.append(this._tableName);
        if (string2 != null) {
            stringBuilder.append(" where ");
            stringBuilder.append(string2);
        }
        String string3 = stringBuilder.toString();
        if (this.isTrace()) {
            this.trace(this, "getRangeSql", false, string3);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCriteria(ValueList valueList) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "getCriteria", false, valueList);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this._columns;
        synchronized (object) {
            for (ValueList valueList2 : this._columns.values()) {
                String string;
                if (valueList2 == valueList || (string = valueList2.getCriteria()) == null) continue;
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append(string);
            }
        }
        Object object2 = object = stringBuilder.length() == 0 ? null : stringBuilder.toString();
        if (this.isTrace()) {
            this.trace(this, "getCriteria", false, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCountChanged(ValueList valueList) {
        if (this.isTrace()) {
            this.trace(this, "setCountChanged", false, valueList);
        }
        this._recalcDistinct = true;
        LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
        synchronized (linkedHashMap) {
            for (ValueList valueList2 : this._columns.values()) {
                if (valueList2 == valueList) continue;
                valueList2.setCountChanged(true);
            }
        }
        if (valueList != null) {
            if (valueList.isDistinctReliable()) {
                this.updateCounts(valueList.getCount(), valueList.getDistinctCount());
            } else {
                this.setCount(valueList.getCount());
            }
        }
    }

    protected void setCount(long l) {
        if (this.isTrace()) {
            this.trace(this, "setCount", false, l);
        }
        this._count = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCounts(long l, long l2) {
        if (this.isTrace()) {
            this.trace(this, "updateCounts", false, l, l2);
        }
        LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
        synchronized (linkedHashMap) {
            for (ValueList valueList : this._columns.values()) {
                valueList.updateCounts(l, l2);
            }
        }
        this._count = l;
        this._distinctCount = l2;
        this._recalcDistinct = false;
    }

    protected void setRecalcCount(boolean bl) {
        if (this.isTrace()) {
            this.trace(this, "setRecalcCount", false, bl);
        }
        this._recalcCount = bl;
    }

    protected void executeListeners() {
        if (this.isTrace()) {
            this.trace(this, "executeListeners", false);
        }
        for (ValueList object : this._columns.values()) {
            object.executeListeners();
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this._listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueList createValueList(String string, String string2) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "createValueList", false, string, string2);
        }
        if (!string2.equals(CRITERIA_KEY)) {
            string = this.checkColumnName(string);
        }
        String string3 = string2 + string;
        ValueList valueList = null;
        LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
        synchronized (linkedHashMap) {
            valueList = this._columns.get(string3);
            if (valueList == null) {
                if (string2.equals(ACTIVECOUNT_KEY)) {
                    valueList = new ValueList(string3, this, string, this._distinctColumn, false);
                } else if (string2.equals(RANGECOUNT_KEY)) {
                    valueList = new RangeValues(string3, this, string, this._distinctColumn);
                } else if (string2.equals(KWDSEARCH_KEY)) {
                    valueList = new ValueList(string3, this, string, this._distinctColumn, true);
                } else if (string2.equals(CRITERIA_KEY)) {
                    valueList = new ValueList(string3, this, null, this._distinctColumn, true);
                }
                if (valueList != null) {
                    this._columns.put(string3, valueList);
                }
            }
        }
        if (this.isTrace()) {
            this.trace(this, "createValueList", false, valueList);
        }
        return valueList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueList createValueList(String string, int n, int n2, int n3, String string2) throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "createValueList", false, string, n, n2, n3, string2);
        }
        this.checkTableName();
        string = this.checkString(string, "sql statement.");
        String string3 = string2 + string;
        ValueList valueList = null;
        LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
        synchronized (linkedHashMap) {
            valueList = this._columns.get(string3);
            if (valueList == null) {
                if (string2.equals(SQL_KEY)) {
                    valueList = new ValueList(string3, this, string, this._distinctColumn, n + 1, n2 + 1, n3 + 1);
                } else if (string2.equals(RANGESQL_KEY)) {
                    valueList = new RangeValues(string3, this, string, this._distinctColumn, n + 1, n2 + 1, n3 + 1);
                }
                if (valueList != null) {
                    this._columns.put(string3, valueList);
                }
            }
        }
        if (this.isTrace()) {
            this.trace(this, "createValueList", false, valueList);
        }
        return valueList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseMetaData getMetaData() throws SQLException {
        if (this._jdbcMetaData == null) {
            OmniSearch omniSearch = this;
            synchronized (omniSearch) {
                if (this._jdbcMetaData == null) {
                    this._jdbcMetaData = this._jdbcConnection.getMetaData();
                }
            }
        }
        if (this._jdbcConnection.isClosed()) {
            throw new SQLException("Connection is closed.");
        }
        return this._jdbcMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkTableName(String string) throws SQLException {
        DatabaseMetaData databaseMetaData;
        if (this.isTrace()) {
            this.trace(this, "checkTableName", false, string);
        }
        string = this.checkString(string, "table name.");
        String[] stringArray = string.split("[.]");
        String string2 = null;
        if (stringArray.length > 1) {
            string2 = stringArray[0];
            string = stringArray[1];
        }
        DatabaseMetaData databaseMetaData2 = databaseMetaData = this.getMetaData();
        synchronized (databaseMetaData2) {
            try (ResultSet resultSet = null;){
                if (this.isTrace()) {
                    this.trace(this, "DatabaseMetaData.getTables", false, string2, string);
                }
                if (!(resultSet = databaseMetaData.getTables(null, string2, string, null)).next()) {
                    throw new SQLException("Unknown table name (" + string + ").");
                }
                string = resultSet.getString(3);
                if (string2 != null && (string2 = resultSet.getString(2)) != null && string2.length() != 0) {
                    string = string2 + "." + string;
                }
            }
        }
        if (this.isTrace()) {
            this.trace(this, "checkTableName", false, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkColumnName(String string) throws SQLException {
        DatabaseMetaData databaseMetaData;
        if (this.isTrace()) {
            this.trace(this, "checkColumnName", false, string);
        }
        this.checkTableName();
        string = this.checkString(string, "column name.");
        String[] stringArray = string.split("[.]");
        String string2 = null;
        if (stringArray.length > 2) {
            string2 = this.checkTableName(stringArray[0] + "." + stringArray[1]);
            string = stringArray[2];
        } else if (stringArray.length > 1) {
            string2 = this.checkTableName(stringArray[0]);
            string = stringArray[1];
        }
        if (string2 != null && !string2.equals(this._tableName)) {
            throw new SQLException("Incorrect table name specified (" + string + ").");
        }
        DatabaseMetaData databaseMetaData2 = databaseMetaData = this.getMetaData();
        synchronized (databaseMetaData2) {
            try (ResultSet resultSet = null;){
                if (this.isTrace()) {
                    this.trace(this, "DatabaseMetaData.getColumns", false, this._tableName, string);
                }
                if (!(resultSet = databaseMetaData.getColumns(null, null, this._tableName, string)).next()) {
                    throw new SQLException("Unknown column name (" + string + ").");
                }
                string = resultSet.getString(4);
                if (string2 != null) {
                    string = this._tableName + "." + string;
                }
            }
        }
        if (this.isTrace()) {
            this.trace(this, "checkColumnName", false, string);
        }
        return string;
    }

    private String checkString(String string, String string2) throws SQLException {
        if (string == null) {
            throw new SQLException("NULL " + string2);
        }
        if ((string = string.trim()).length() == 0) {
            throw new SQLException("Blank " + string2);
        }
        return string;
    }

    private void checkTableName() throws SQLException {
        if (this._tableName == null) {
            throw new SQLException("TableName is not yet specified.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateCount() throws SQLException {
        if (this.isTrace()) {
            this.trace(this, "calculateCount", false);
        }
        boolean bl = false;
        LinkedHashMap<String, ValueList> linkedHashMap = this._columns;
        synchronized (linkedHashMap) {
            for (ValueList valueList : this._columns.values()) {
                if (!valueList.calculateCount()) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            linkedHashMap = this._columns;
            synchronized (linkedHashMap) {
                for (ValueList valueList : this._columns.values()) {
                    if (valueList.getValues() == null) continue;
                    this.setCount(valueList.getCount());
                    break;
                }
            }
        }
        this._recalcCount = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcDistinctCount() throws SQLException {
        Statement statement;
        if (this.isTrace()) {
            this.trace(this, "calcDistinctCount", false);
        }
        this._distinctCount = 0L;
        String string = this.getSql(null, this.getCriteria(null), true);
        Statement statement2 = statement = this.getStatement();
        synchronized (statement2) {
            try (ResultSet resultSet = null;){
                if (this.isTrace()) {
                    this.trace(this, "Statement.executeQuery", false, string);
                }
                if ((resultSet = statement.executeQuery(string)).next()) {
                    this._distinctCount = resultSet.getLong(1);
                }
            }
        }
        this._recalcDistinct = false;
    }

    protected void skipSpaces(char[] cArray, int[] nArray) {
        while (nArray[0] < nArray[1] && cArray[nArray[0]] == ' ') {
            nArray[0] = nArray[0] + 1;
        }
    }

    protected void skipLastSpaces(char[] cArray, int[] nArray) {
        while (nArray[0] < nArray[1] && cArray[nArray[1]] == ' ') {
            nArray[1] = nArray[1] - 1;
        }
    }

    protected void checkBraces(char[] cArray, int[] nArray) throws SQLException {
        this.skipSpaces(cArray, nArray);
        this.skipLastSpaces(cArray, nArray);
        int n = nArray[0];
        nArray[0] = n + 1;
        if (cArray[n] != '{') {
            throw new SQLException("Missing left brace.");
        }
        int n2 = nArray[1];
        nArray[1] = n2 - 1;
        if (cArray[n2] != '}') {
            throw new SQLException("Missing right brace.");
        }
    }

    protected void checkArray(char[] cArray, int[] nArray) throws SQLException {
        this.skipSpaces(cArray, nArray);
        this.skipLastSpaces(cArray, nArray);
        int n = nArray[0];
        nArray[0] = n + 1;
        if (cArray[n] != '[') {
            throw new SQLException("Missing left bracket.");
        }
        int n2 = nArray[1];
        nArray[1] = n2 - 1;
        if (cArray[n2] != ']') {
            throw new SQLException("Missing right bracket.");
        }
    }

    protected boolean compareTag(char[] cArray, int[] nArray, String string) throws SQLException {
        boolean bl = this.compareString(cArray, nArray, string);
        if (bl) {
            this.skipSpaces(cArray, nArray);
            int n = nArray[0];
            nArray[0] = n + 1;
            if (cArray[n] != ':') {
                throw new SQLException("Missing ':' after " + string + " tag.");
            }
        }
        return bl;
    }

    protected String getString(char[] cArray, int[] nArray) throws SQLException {
        String string = null;
        this.skipSpaces(cArray, nArray);
        int n = nArray[0];
        nArray[0] = n + 1;
        if (cArray[n] != '\"') {
            throw new SQLException("Missing starting quote.");
        }
        int n2 = 0;
        while (cArray[nArray[0] + n2] != '\"' && nArray[0] + n2 < nArray[1]) {
            ++n2;
        }
        if (cArray[nArray[0] + n2] != '\"') {
            throw new SQLException("Missing ending quote.");
        }
        string = new String(cArray, nArray[0], n2);
        nArray[0] = nArray[0] + (n2 + 1);
        return string;
    }

    protected int getInt(char[] cArray, int[] nArray) throws SQLException {
        int n = 0;
        this.skipSpaces(cArray, nArray);
        while (Character.isDigit(cArray[nArray[0] + n])) {
            ++n;
        }
        if (n == 0) {
            throw new SQLException("Missing numeric entry value.");
        }
        int n2 = Integer.parseInt(new String(cArray, nArray[0], n));
        nArray[0] = nArray[0] + n;
        return n2;
    }

    protected boolean getBoolean(char[] cArray, int[] nArray) throws SQLException {
        boolean bl;
        char[] cArray2 = new char[]{'T', 'R', 'U', 'E'};
        char[] cArray3 = new char[]{'F', 'A', 'L', 'S', 'E'};
        this.skipSpaces(cArray, nArray);
        int n = 0;
        while (cArray2 != null && cArray3 != null) {
            char c = Character.toUpperCase(cArray[nArray[0] + n]);
            if (cArray2 != null) {
                if (n >= cArray2.length) break;
                if (cArray2[n] != c) {
                    cArray2 = null;
                }
            }
            if (cArray3 != null) {
                if (n >= cArray3.length) break;
                if (cArray3[n] != c) {
                    cArray3 = null;
                }
            }
            ++n;
        }
        if (cArray2 != null) {
            bl = true;
            nArray[0] = nArray[0] + cArray2.length;
        } else if (cArray3 != null) {
            bl = false;
            nArray[0] = nArray[0] + cArray3.length;
        } else {
            throw new SQLException("Missing boolean entry value.");
        }
        return bl;
    }

    protected void setEntry(StringBuilder stringBuilder, String string, String string2, String string3) {
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        stringBuilder.append(string);
        stringBuilder.append(":");
        if (string2 != null) {
            stringBuilder.append("\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
    }

    protected void setEntry(StringBuilder stringBuilder, String string, int n, String string2) {
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(n);
    }

    protected void setEntry(StringBuilder stringBuilder, String string, long l, String string2) {
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(l);
    }

    protected void setEntry(StringBuilder stringBuilder, String string, boolean bl, String string2) {
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(bl);
    }

    protected boolean entryExist(char[] cArray, int[] nArray, String string) throws SQLException {
        this.skipSpaces(cArray, nArray);
        if (cArray[nArray[0]] == ',') {
            nArray[0] = nArray[0] + 1;
        }
        return this.compareTag(cArray, nArray, string);
    }

    protected int getEntryLength(char[] cArray, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (nArray[0] + n3 < nArray[1]) {
            if (cArray[nArray[0] + n3] == '{') {
                ++n;
            } else if (cArray[nArray[0] + n3] == '}') {
                ++n2;
            }
            if (n != 0 && n == n2) break;
            ++n3;
        }
        return n3;
    }

    private boolean compareString(char[] cArray, int[] nArray, String string) {
        this.skipSpaces(cArray, nArray);
        if (nArray[0] + string.length() > nArray[1]) {
            return false;
        }
        boolean bl = true;
        char[] cArray2 = string.toCharArray();
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray[nArray[0] + i] == cArray2[i]) continue;
            bl = false;
            break;
        }
        if (bl) {
            nArray[0] = nArray[0] + cArray2.length;
        }
        return bl;
    }

    protected void trace(Object object, String string, boolean bl) {
        OmniSearch.writeTrace(OmniSearch.formatTrace(object, string, bl));
    }

    protected void trace(Object object, String string, boolean bl, Object object2) {
        StringBuilder stringBuilder = OmniSearch.formatTrace(object, string, bl);
        OmniSearch.traceObject(stringBuilder, "[ ", object2, " ]");
        OmniSearch.writeTrace(stringBuilder);
    }

    protected void trace(Object object, String string, boolean bl, Object object2, Object object3) {
        StringBuilder stringBuilder = OmniSearch.formatTrace(object, string, bl);
        OmniSearch.traceObject(stringBuilder, "[ ", object2, null);
        OmniSearch.traceObject(stringBuilder, " , ", object3, " ]");
        OmniSearch.writeTrace(stringBuilder);
    }

    protected void trace(Object object, String string, boolean bl, Object object2, Object object3, Object object4) {
        StringBuilder stringBuilder = OmniSearch.formatTrace(object, string, bl);
        OmniSearch.traceObject(stringBuilder, "[ ", object2, null);
        OmniSearch.traceObject(stringBuilder, " , ", object3, null);
        OmniSearch.traceObject(stringBuilder, " , ", object4, " ]");
        OmniSearch.writeTrace(stringBuilder);
    }

    protected void trace(Object object, String string, boolean bl, Object object2, Object object3, Object object4, Object object5) {
        StringBuilder stringBuilder = OmniSearch.formatTrace(object, string, bl);
        OmniSearch.traceObject(stringBuilder, "[ ", object2, null);
        OmniSearch.traceObject(stringBuilder, " , ", object3, null);
        OmniSearch.traceObject(stringBuilder, " , ", object4, null);
        OmniSearch.traceObject(stringBuilder, " , ", object5, " ]");
        OmniSearch.writeTrace(stringBuilder);
    }

    protected void trace(Object object, String string, boolean bl, Object object2, Object object3, Object object4, Object object5, Object object6) {
        StringBuilder stringBuilder = OmniSearch.formatTrace(object, string, bl);
        OmniSearch.traceObject(stringBuilder, "[ ", object2, null);
        OmniSearch.traceObject(stringBuilder, " , ", object3, null);
        OmniSearch.traceObject(stringBuilder, " , ", object4, null);
        OmniSearch.traceObject(stringBuilder, " , ", object5, null);
        OmniSearch.traceObject(stringBuilder, " , ", object6, " ]");
        OmniSearch.writeTrace(stringBuilder);
    }

    private static StringBuilder formatTrace(Object object, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("T");
        stringBuilder.append(Thread.currentThread().getId());
        stringBuilder.append(" ");
        stringBuilder.append(new SimpleDateFormat("HH:mm:ss.S").format(new Date()));
        OmniSearch.traceObject(stringBuilder, " [", object, "] ");
        if (!bl) {
            stringBuilder.append("_");
        }
        stringBuilder.append(string);
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTrace(StringBuilder stringBuilder) {
        PrintWriter printWriter = _logWriter;
        synchronized (printWriter) {
            _logWriter.println(stringBuilder.toString());
            _logWriter.flush();
        }
    }

    private static void traceObject(StringBuilder stringBuilder, String string, Object object, String string2) {
        String string3;
        if (object == null) {
            string3 = "null";
        } else {
            string3 = object.toString();
            if (string3.startsWith("omnidex.java.")) {
                string3 = string3.substring(13);
            }
        }
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(string3);
        if (string2 != null) {
            stringBuilder.append(string2);
        }
    }

    protected boolean isTrace() {
        return _logWriter != null;
    }

    static {
        ACTIVECOUNT_KEY = "$AC_";
        KWDSEARCH_KEY = "$KS_";
        SQL_KEY = "$SQL_";
        RANGECOUNT_KEY = "$RAC_";
        RANGESQL_KEY = "$RSQL_";
        CRITERIA_KEY = "$CRIT_";
        OMNISEARCH_TAG = "\"omniSearch\"";
        TABLE_TAG = "\"table\"";
        DISTINCT_TAG = "\"distinct\"";
        VALUELIST_TAG = "\"valueList\"";
    }
}

