/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import omnidex.client.OdxCLJConnectionMgr;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCConnection;
import omnidex.jdbc.OdxJDBCRouterConnection;

public final class OdxJDBCDriver
implements Driver {
    private static String SUBNAME_PREFIX = "jdbc:omnidex:";
    private static String DRIVER_PREFIX = "jdbc:omnidex:driver:";
    private static String ROUTER_PREFIX = "jdbc:omnidex:router:";
    private static boolean DEFAULT_STRICT_CHECK = false;
    private boolean m_strictCheck = DEFAULT_STRICT_CHECK;

    public Connection connect(String string, Properties properties) throws SQLException {
        OdxCLJTrace.print("OdxJDBCDriver.connect(" + string + ")");
        if (string != null) {
            String string2 = string.toLowerCase();
            if (string2.startsWith(ROUTER_PREFIX)) {
                string = this.checkForConnectOptions(string.substring(ROUTER_PREFIX.length()));
                OdxJDBCRouterConnection odxJDBCRouterConnection = new OdxJDBCRouterConnection();
                odxJDBCRouterConnection.open(OdxJDBCDriver.translatePath(string), properties, this.m_strictCheck);
                return odxJDBCRouterConnection;
            }
            if (string2.startsWith(DRIVER_PREFIX)) {
                string = this.checkForConnectOptions(string.substring(DRIVER_PREFIX.length()));
                OdxJDBCConnection odxJDBCConnection = new OdxJDBCConnection();
                odxJDBCConnection.open(OdxJDBCDriver.translatePath(string), properties, this.m_strictCheck);
                return odxJDBCConnection;
            }
            if (string2.startsWith(SUBNAME_PREFIX)) {
                string = this.checkForConnectOptions(string.substring(SUBNAME_PREFIX.length()));
                OdxJDBCConnection odxJDBCConnection = new OdxJDBCConnection();
                odxJDBCConnection.open(OdxJDBCDriver.translatePath(string), properties, this.m_strictCheck);
                return odxJDBCConnection;
            }
        }
        return null;
    }

    public boolean acceptsURL(String string) {
        OdxCLJTrace.print("Driver.acceptsURL(" + string + ")");
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).startsWith(DRIVER_PREFIX) || string.startsWith(ROUTER_PREFIX) || string.startsWith(SUBNAME_PREFIX);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        OdxCLJTrace.print("Driver.getPropertyInfo(" + string + ")");
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 4;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static void closeConnectionPooling() throws SQLException {
        OdxCLJConnectionMgr.close();
    }

    protected static String translatePath(String string) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf("${", n2)) != -1) {
            int n3 = string.indexOf(125, n);
            if (n3 != -1) {
                String string2 = string.substring(n + 2, n3);
                String string3 = System.getenv(string2);
                OdxCLJTrace.print("Translating: " + string);
                if (string3 != null) {
                    string = string.substring(0, n) + string3 + string.substring(n3 + 1);
                }
                OdxCLJTrace.print("Environment: " + string2 + " = " + string3);
                OdxCLJTrace.print("Translation: " + string);
            }
            n2 = n + 1;
        }
        return string;
    }

    private String checkForConnectOptions(String string) throws SQLException {
        this.m_strictCheck = DEFAULT_STRICT_CHECK;
        boolean bl = false;
        int n = 0;
        while ((n = string.indexOf(59, n)) >= 0) {
            int n2;
            String string2;
            String string3 = string2 = (n2 = string.indexOf(59, ++n)) < 0 ? string.substring(n) : string.substring(n, n2);
            if (string2.compareToIgnoreCase("strict") == 0) {
                if (bl) {
                    throw OdxCLJException.error(11104);
                }
                this.m_strictCheck = true;
                bl = true;
            } else if (string2.compareToIgnoreCase("relaxed") == 0) {
                if (bl) {
                    throw OdxCLJException.error(11104);
                }
                this.m_strictCheck = false;
                bl = true;
            } else {
                String string4;
                int n3 = string2.indexOf(61);
                if (n3 < 0 || (string4 = string2.substring(0, n3)).compareToIgnoreCase("clienttracefile") != 0) continue;
                OdxCLJTrace.setLogWriter(string2.substring(n3 + 1).trim(), true);
                OdxCLJTrace.print("OdxJDBCDriver.connect(" + string + ")");
            }
            if (n2 < 0) {
                string = string.substring(0, n - 1);
                break;
            }
            string = string.substring(0, n - 1) + string.substring(n2);
            --n;
        }
        return string;
    }

    static {
        try {
            OdxCLJTrace.print("Loading OdxJDBC class...");
            DriverManager.registerDriver(new OdxJDBCDriver());
        }
        catch (SQLException sQLException) {
            OdxCLJTrace.print("Unable to load or register OdxJDBC driver");
            OdxCLJTrace.print(sQLException);
        }
    }
}

