/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import omnidex.client.OdxCLJNative;
import omnidex.client.OdxCLJTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jdbcsql
implements Runnable {
    private String[] m_versions;
    private String m_omnidexVersion;
    private String m_userName;
    private String m_osName;
    private String m_licensee;
    private Connection m_conn;
    private Statement m_stmt;
    private int m_testCount;
    private int m_stmtCount;
    private int m_totalCount;
    private boolean m_testDirExist;
    private List<String> m_columnHeader;
    private int m_pageLength = 23;
    private int m_lineNumber;
    private boolean m_skipPrompt;
    private boolean m_qaMode;
    private boolean m_helpMode;
    private String m_connectionString;
    private List<File> m_useFiles = new ArrayList<File>();
    private List<String> m_commands = new ArrayList<String>();
    private int m_useThreadCount = 1;
    private int m_fileThreadCount = 1;
    private boolean m_benchmark;
    private int m_progress = 1;
    private boolean m_exit;
    private boolean m_error;
    private boolean m_termination = true;
    private int m_onError = 1;
    private int m_odxnet = 7555;
    private boolean m_timer;
    private boolean m_timerOnly;
    private boolean m_skipInput;
    private long m_startTimer;
    private long m_stopTimer;
    private long m_jdbcStart;
    private long m_jdbcElapsed;
    private File m_useFile;
    private File m_logFile;
    private long m_startRunTime;
    private long m_stopRunTime;
    private Semaphore m_semaphore;
    private PrintWriter m_output;
    private int m_runType;
    private jdbcsql m_parent;
    private int[][] m_lines;
    private String m_useCommand;
    private boolean m_interactive;
    private Hashtable<String, ConnectionPool> m_pools;
    private static final String PROGRAM_NAME = "Omnidex JDBC SQL program";
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final int LINEWIDTH = 78;
    private static final int GRAPHWIDTH = 40;
    private static final int TIMEOUT = 500;
    private static final int ON_ERROR_CONTINUE = 1;
    private static final int ON_ERROR_ABORT = 2;
    private static final int ON_ERROR_EXIT = 3;
    private static final int PROGRESS_DEFAULT = 1;
    private static final int PROGRESS_FULL = 2;
    private static final int PROGRESS_SIMPLE = 3;
    private static final int CMD_INCOMPLETE = 0;
    private static final int CMD_COMMENT = 1;
    private static final int CMD_DIR_TEST = 2;
    private static final int CMD_DIR_TEST_CLEANUP = 3;
    private static final int CMD_DIR_COMMON = 4;
    private static final int CMD_DIR_END_COMMON = 5;
    private static final int CMD_EXIT = 6;
    private static final int CMD_CONNECT = 7;
    private static final int CMD_DISCONNECT = 8;
    private static final int CMD_SET = 9;
    private static final int CMD_USE = 10;
    private static final int CMD_VERSIONS = 11;
    private static final int CMD_HELP = 12;
    private static final int CMD_SQL = 13;
    private static final int RUN_USE_FILE = 1;
    private static final int RUN_COMMANDS = 2;
    private static final String USE_SYNTAX = "Invalid USE syntax";
    private static final String[] SETTINGS = new String[]{"AUTOPSEUDOCOLUMNS", "AUTORESET", "CHAR", "OPT", "OPTIMIZATION", "POWERSEARCH", "PREPROCESSOR", "PSEUDO_COLUMNS", "PSEUDOCOLUMNS", "QUALIFY_MODE", "REDEF_ROWIDS", "REDEFROWIDS", "REQUIRED_OPTIMIZATIONS", "SQL_SYNTAX", "TIMEOUT", "TIMEZONE", "TOP"};
    private static final String[] COMMANDS = new String[]{"ATTACH", "CLOSE CURSOR", "CONNECT", "CREATE", "DELETE", "DETACH", "DISCONNECT", "DROP", "EXPORT", "EXTRACT", "INSERT", "JOIN", "LOAD OFX", "OPEN CURSOR", "PARTITION", "QUALIFY", "SELECT", "SET", "SETENV", "UPDATE", "USE"};
    private static final String[] FULLCOMMANDS = new String[]{"E", "EXIT", "HELP", "Q", "QUIT", "VERSIONS"};
    private static final String[] COMMANDLINES = new String[]{"syntax:", " ", "  java jdbcsql [connection_string] [options]", " ", "  connection_string:", "    A standard Omnidex connection string, such as:", "        simple.xml", "        c:\\db\\simple.xml", "        [host:port]c:\\db\\simple.xml", "    A connection pool properties file, such as:", "        simple.properties", " ", "  options:", "    -use=\"file [, file ...]\"", "    -use=\"(filelist)\"", "    -pool=\"connection_pool=connection_pool_properties_file\"", "    -files=n", "    -threads=n", "    -benchmark", "    -simpleprogress", "    -fullprogress", "    -errors=<abort|exit|continue>", "    -timer", "    -timeronly", "    -exit", "    -help", " "};
    private static final String[] HELPS = new String[]{"                                JdbcSQL Help", "                                ------------", " ", "JdbcSQL provides an interactive, console-based testing and benchmarking", "interface to Omnidex databases using the Omnidex JDBC Driver.", " ", "Commands processed on the server:", " ", "  ATTACH DATABASE     * Attach a database", "  ATTACH SEGMENT      * Attach a segment", "  ATTACH TABLE        * Attach a table", "  CLOSE CURSOR        * Close a cursor", "  CONNECT             * Connect to an environment file", "  CREATE DATABASE     * Create a database", "  CREATE ENVIRONMENT  * Create an environment file", "  CREATE INDEX        * Create an index or index group", "  CREATE SEGMENT      * Create a segment", "  CREATE TABLE        * Create a table", "  DELETE              * Issue an SQL delete statement", "  DETACH DATABASE     * Detach a previously attached database", "  DETACH SEGMENT      * Detach a previously attached segment", "  DETACH TABLE        * Detach a previously attached table", "  DISCONNECT          * Disconnect from an environment file", "  DROP DATABASE       * Drop a database", "  DROP ENVIRONMENT    * Drop an environment", "  DROP INDEX          * Drop an index or index group", "  DROP SEGMENT        * Drop a segment", "  DROP TABLE          * Drop a table", "  EXPORT              * Export records to a file", "  EXTRACT             * Extract SQL statements for database", "  INSERT              * Issue an SQL insert statement", "  JOIN                * Join tables using Omnidex", "  LOAD OFX            * Load indexes for a table", "  OPEN CURSOR         * Open a cursor", "  PARTITION           * Partition a table", "  QUALIFY             * Qualify rows using Omnidex", "  SELECT              * Issue an SQL select statement", "  SETENV              * Set an environment variable", "  UPDATE              * Issue an SQL update statement", "  UPDATE INDEXES      * Update Omnidex indexes", "  UPDATE ROLLUP       * Update rollup table", "  UPDATE ROLLUPS      * Update rollup tables", "  UPDATE STATISTICS   * Update statistical information", "  UPDATE TEXT         * Update textual statistics", " ", "Commands processed on the client:", " ", "  ;                     Comment line", "  EXIT                  Exit Omnidex SQL", "  HELP                  Help", "  QUIT                  Quit JDBC SQL", "  SET                   Set an option (some options are sent to server)", "  USE                   Use one or more files containing statements", "  VERSIONS              Show version information", " ", "CONNECT command syntax:", " ", "  CONNECT connection_string", "  CONNECT connection_pool", "  CONNECT connection_pool_properties_file", " ", "  connection_string:", "      user/password@ [ host : port : pool ] filename [ node ] &options", " ", "  connection_pool:", "      name of connection pool, as specified in SET POOL command", " ", "  connection_pool_properties_file:", "      name of connection pool .properties file for connection pooling module", " ", "USE command syntax:", " ", "  USE file [, file ...] WITH options", "  USE (filelist) WITH options", " ", "  options:", "    FILES=n             Process n files at a time", "    THREADS=n           Process statements in files using n threads each", "    BENCHMARK           Benchmark by avoiding logging and displaying results", "    SIMPLEPROGRESS      Display a simple, one-line progress display", "    FULLPROGRESS        Display a full-screen, multi-line progress display", "    TIMER               Log the timer and the data output", "    TIMERONLY           Log the timer only, no data output", " ", "  file:", "    A text file containing Omnidex statements to process, with each statement", "      terminated by a semicolon, and optionally spanning multiple lines.", " ", "  filelist:", "    A text file containing filenames to process, with one filename per line.", " ", "SET command options:", " ", "  SET option value", " ", "      Settings processed on the server:", " ", "      [AUTOPSEUDOCOLUMNS <ON | OFF>]", "      [AUTORESET <ON | OFF>]", "      [CHAR <AUTO | n>]", "      [OPTIMIZATION options]", "      [POWERSEARCH <ON | OFF | list>]", "      [PREPROCESSOR <ON | OFF>]", "      [PSEUDOCOLUMNS <ON | OFF>]", "      [QUALIFY_MODE <PARSER | ODXFIND | OX_FIND>]", "      [REDEFROWIDS <ON | OFF>]", "      [REQUIRED_OPTIMIZATION options]", "      [SQL_SYNTAX <OMNIDEX | ORACLE | SQLSERVER>]", "      [TIMEOUT <seconds | OFF>]", "      [TIMEZONE timezone]", "      [TOP n]", " ", "      Settings processed on the client:", " ", "      [BENCHMARK <ON | OFF>]", "      [DEBUG <ON | OFF> [FILE=filename]]", "      [ERRORS <ABORT | CONTINUE | EXIT>]", "      [FILES n]", "      [FULLPROGRESS <ON | OFF>]", "      [PAGELENGTH n]", "      [POOL connection_pool=connection_pool_properties_file]", "      [SIMPLEPROGRESS <ON | OFF>]", "      [TERMINATION <ON | OFF>]", "      [TIMER <ON | OFF>]", "      [TIMERONLY <ON | OFF>]", "      [THREADS n]", " ", "Command line options:", " ", "  java jdbcsql [connection_string] [options]", " ", "  connection_string:", "    A standard Omnidex connection string, such as:", "        simple.xml", "        c:\\db\\simple.xml", "        [host:port]c:\\db\\simple.xml", "    A connection pool properties file, such as:", "        simple.properties", " ", "  options:", "    -use=\"file [, file ...]\"", "    -use=\"(filelist)\"", "    -pool=\"connection_pool=connection_pool_properties_file\"", "    -files=n", "    -threads=n", "    -benchmark", "    -simpleprogress", "    -fullprogress", "    -errors=<abort|exit|continue>", "    -timer", "    -timeronly", "    -exit", "    -help", " "};

    public static void main(String[] stringArray) {
        jdbcsql jdbcsql2 = new jdbcsql();
        if (!jdbcsql2.initialize()) {
            return;
        }
        boolean bl = false;
        try {
            jdbcsql2.parseCommandLine(stringArray);
            jdbcsql2.getVersionInformation();
            System.out.println(jdbcsql2.formatHeader(PROGRAM_NAME));
            bl = true;
            if (jdbcsql2.helpMode()) {
                for (String string : COMMANDLINES) {
                    System.out.println(string);
                }
            } else {
                jdbcsql2.runInteractive();
            }
        }
        catch (Exception exception) {
            if (!bl) {
                System.out.println(jdbcsql2.formatHeader(PROGRAM_NAME));
            }
            System.out.println("*E* " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block26: {
            block24: {
                if (!this.m_benchmark && this.m_logFile != null) {
                    this.m_output = new PrintWriter((Writer)new FileWriter(this.m_logFile, false), true);
                    this.printString(this.formatHeader("Omnidex JDBC SQL program"), new Object[0]);
                    this.printString("%s%n", new Object[]{this.m_useFile.getAbsolutePath()});
                    if (this.m_timer) {
                        this.printString("Start time: %s%n", new Object[]{new SimpleDateFormat("HH:mm:ss.SSS").format(Calendar.getInstance().getTime())});
                        this.m_jdbcStart = 0L;
                    }
                }
                switch (this.m_runType) {
                    case 1: {
                        try {
                            if (this.m_fileThreadCount == 1) {
                                this.runUseFileSingleThread(true);
                            } else {
                                this.runUseFileMultiThread();
                            }
                            var2_1 = null;
                            this.stopJdbcTimer();
                            if (this.m_semaphore == null) ** GOTO lbl42
                            this.m_semaphore.release();
                            this.m_semaphore = null;
                        }
                        catch (Throwable var1_3) {
                            var2_2 = null;
                            this.stopJdbcTimer();
                            if (this.m_semaphore != null) {
                                this.m_semaphore.release();
                                this.m_semaphore = null;
                            }
                            this.m_stopRunTime = System.currentTimeMillis();
                            if (!this.m_benchmark && this.m_logFile != null && this.m_timer) {
                                this.printString("Stop time: %s%n", new Object[]{new SimpleDateFormat("HH:mm:ss.SSS").format(Calendar.getInstance().getTime())});
                                this.printString("Total elapsed: %s%n", new Object[]{this.formatElapsed(this.m_stopRunTime - this.m_startRunTime, true)});
                                this.printString("Total JDBC elapsed: %s%n", new Object[]{this.formatElapsed(this.m_jdbcElapsed, true)});
                            }
                            throw var1_3;
                        }
lbl42:
                        // 2 sources

                        this.m_stopRunTime = System.currentTimeMillis();
                        if (!this.m_benchmark && this.m_logFile != null && this.m_timer) {
                            this.printString("Stop time: %s%n", new Object[]{new SimpleDateFormat("HH:mm:ss.SSS").format(Calendar.getInstance().getTime())});
                            this.printString("Total elapsed: %s%n", new Object[]{this.formatElapsed(this.m_stopRunTime - this.m_startRunTime, true)});
                            this.printString("Total JDBC elapsed: %s%n", new Object[]{this.formatElapsed(this.m_jdbcElapsed, true)});
                        }
                        break;
                    }
                    case 2: {
                        this.runCommands();
                    }
                }
                var4_5 = null;
                if (this.m_output == null) break block24;
                try {
                    this.m_output.close();
                }
                catch (Exception var5_8) {
                    // empty catch block
                }
                this.m_output = null;
            }
            this.m_exit = true;
            {
                break block26;
                catch (Exception var1_4) {
                    this.printError(var1_4.getMessage(), new Object[0]);
                    var4_6 = null;
                    if (this.m_output != null) {
                        try {
                            this.m_output.close();
                        }
                        catch (Exception var5_9) {
                            // empty catch block
                        }
                        this.m_output = null;
                    }
                    this.m_exit = true;
                }
            }
            catch (Throwable var3_11) {
                var4_7 = null;
                if (this.m_output != null) {
                    try {
                        this.m_output.close();
                    }
                    catch (Exception var5_10) {
                        // empty catch block
                    }
                    this.m_output = null;
                }
                this.m_exit = true;
                throw var3_11;
            }
        }
    }

    public String[] versions() {
        return this.m_versions;
    }

    public String omnidexVersion() {
        return this.m_omnidexVersion;
    }

    public String userName() {
        return this.m_userName;
    }

    public String osName() {
        return this.m_osName;
    }

    public String licensee() {
        return this.m_licensee;
    }

    public int count() {
        return this.m_testDirExist ? this.m_testCount : this.m_stmtCount;
    }

    public int totalCount() {
        return this.m_totalCount;
    }

    public void qaMode(boolean bl) {
        this.m_qaMode = bl;
        if (bl) {
            this.m_termination = false;
        }
    }

    public boolean helpMode() {
        return this.m_helpMode;
    }

    public String connectionString() {
        return this.m_connectionString;
    }

    public void exit(boolean bl) {
        this.m_exit = bl;
    }

    public boolean exit() {
        return this.m_exit;
    }

    public boolean error() {
        return this.m_error;
    }

    public void error(boolean bl) {
        this.m_error = bl;
    }

    public boolean termination() {
        return this.m_termination;
    }

    public int onError() {
        return this.m_onError;
    }

    public void useFile(File file, File file2, jdbcsql jdbcsql2, boolean bl, int n, boolean bl2, boolean bl3) {
        this.m_useFile = file;
        this.m_logFile = file2;
        this.m_connectionString = jdbcsql2.connectionString();
        this.m_benchmark = bl;
        this.m_termination = jdbcsql2.termination();
        this.m_pageLength = 0;
        this.m_skipPrompt = true;
        this.m_onError = jdbcsql2.onError();
        this.m_fileThreadCount = n;
        this.m_timer = bl2;
        this.m_timerOnly = bl3;
        this.m_parent = jdbcsql2;
        this.m_pools = jdbcsql2.pools();
        if (!this.m_benchmark) {
            this.m_omnidexVersion = jdbcsql2.omnidexVersion();
            this.m_userName = jdbcsql2.userName();
            this.m_osName = jdbcsql2.osName();
            this.m_licensee = jdbcsql2.licensee();
        }
    }

    public File logFile() {
        return this.m_logFile;
    }

    public void logFile(File file) {
        this.m_logFile = file;
    }

    public long startRunTime() {
        return this.m_startRunTime;
    }

    public void startRunTime(long l) {
        this.m_startRunTime = l;
    }

    public long stopRunTime() {
        return this.m_stopRunTime;
    }

    public void semaphore(Semaphore semaphore) {
        this.m_semaphore = semaphore;
    }

    public void runType(int n) {
        this.m_runType = n;
    }

    public void parent(jdbcsql jdbcsql2) {
        this.m_parent = jdbcsql2;
    }

    public int[][] lines() {
        return this.m_lines;
    }

    public Hashtable<String, ConnectionPool> pools() {
        return this.m_pools;
    }

    private boolean initialize() {
        boolean bl = false;
        try {
            Class.forName("omnidex.jdbc.OdxJDBCDriver");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Unable to find Omnidex JDBC driver.");
        }
        return bl;
    }

    public String formatHeader(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%-54.54s%s%n%s", string, new SimpleDateFormat("EEE, MMM dd, yyyy hh:mmaa").format(Calendar.getInstance().getTime()), "(c) Dynamic Information Systems Corp. 1981-2015"));
        if (this.m_omnidexVersion != null) {
            stringBuilder.append(String.format("%32.32s", this.m_omnidexVersion));
        }
        stringBuilder.append(NEWLINE);
        if (this.m_osName != null) {
            stringBuilder.append(this.m_osName);
            if (this.m_userName != null) {
                int n = 78 - this.m_osName.length() + 1;
                stringBuilder.append(String.format("%" + n + "." + n + "s", this.m_userName));
            }
            stringBuilder.append(NEWLINE);
        }
        if (this.m_licensee != null) {
            stringBuilder.append(String.format("%s%n", this.m_licensee));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void getVersionInformation() {
        block34: {
            int n;
            int n2;
            CharSequence charSequence;
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = String.format("jdbc:omnidex:[localhost:%d]omnidex", this.m_odxnet);
            connection = DriverManager.getConnection(string);
            statement = connection.createStatement(1004, 1007);
            resultSet = statement.executeQuery("SELECT $TAG, $PRODUCT, $VERSION FROM $VERSIONS");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                String string7 = resultSet.getString(3);
                if (((String)charSequence).equals("OMNIDEX")) {
                    string2 = string7;
                } else if (((String)charSequence).equals("LIC_TYPE")) {
                    string3 = string7;
                } else if (((String)charSequence).equals("OS_NAME")) {
                    this.m_osName = string7;
                } else if (((String)charSequence).equals("NODENAME")) {
                    string4 = string7;
                } else if (((String)charSequence).equals("FULL_USERNAME")) {
                    string5 = string7;
                } else if (((String)charSequence).equals("LICENSEE")) {
                    this.m_licensee = string7;
                }
                this.formatVersionInfo(arrayList, string6, string7);
            }
            this.m_versions = arrayList.toArray(new String[arrayList.size()]);
            charSequence = new StringBuilder();
            if (string3 != null && (n2 = string3.indexOf(32)) != -1 && (n = string3.indexOf(32, n2 + 1)) != -1) {
                ((StringBuilder)charSequence).append(string3.substring(n2, n));
                ((StringBuilder)charSequence).append(" ");
            }
            if (string2 != null) {
                ((StringBuilder)charSequence).append(string2);
            }
            this.m_omnidexVersion = ((StringBuilder)charSequence).toString();
            ((StringBuilder)charSequence).setLength(0);
            if (string4 != null) {
                ((StringBuilder)charSequence).append(string4);
            }
            if (string5 != null) {
                if (((StringBuilder)charSequence).length() != 0) {
                    ((StringBuilder)charSequence).append(" / ");
                }
                ((StringBuilder)charSequence).append(string5);
            }
            this.m_userName = ((StringBuilder)charSequence).toString();
            Object var14_16 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block34;
            }
            catch (Exception exception) {}
            break block34;
            {
                catch (Exception exception) {
                    Object var14_17 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block34;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void cancel() {
        Thread.currentThread().interrupt();
    }

    public void incrementTestCount() {
        ++this.m_testCount;
    }

    public void incrementStmtCount() {
        ++this.m_stmtCount;
    }

    private void startJdbcTimer() {
        if (this.m_timer) {
            this.m_jdbcStart = System.currentTimeMillis();
        }
    }

    private void stopJdbcTimer() {
        if (this.m_timer && this.m_jdbcStart != 0L) {
            this.m_jdbcElapsed += System.currentTimeMillis() - this.m_jdbcStart;
            this.m_jdbcStart = 0L;
        }
    }

    private void formatVersionInfo(List<String> list, String string, String string2) {
        String string3 = String.format("%-32.32s ", string);
        String string4 = String.format("%33s", " ");
        int n = 45;
        while (string2.length() > n) {
            int n2;
            for (n2 = n - 1; n2 >= 0 && string2.charAt(n2) != ' '; --n2) {
            }
            if (n2 <= 0) {
                n2 = n;
            }
            list.add(string3 + string2.substring(0, n2).trim());
            string2 = string2.substring(n2).trim();
            string3 = string4;
        }
        list.add(string3 + string2);
    }

    private void parseCommandLine(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            if (string.charAt(0) == '-') {
                String string2;
                String string3;
                String string4 = string.substring(1).toUpperCase();
                int n = string.indexOf(61);
                if (n == -1) {
                    string3 = string4;
                    string2 = null;
                } else {
                    string3 = string.substring(1, n).trim().toUpperCase();
                    string2 = string.substring(n + 1).trim();
                    if (string2.length() == 0) {
                        string2 = null;
                    } else if (string2.charAt(0) == '\"') {
                        string2 = string2.substring(1, string2.length() - 1).trim();
                    }
                }
                if (string3.equals("USE")) {
                    if (string2 == null) {
                        throw new Exception(USE_SYNTAX);
                    }
                    this.m_useCommand = string2;
                    this.parseUse(string2);
                    continue;
                }
                if (string3.equals("FILES")) {
                    this.m_useThreadCount = this.parseThreads(string2);
                    continue;
                }
                if (string3.equals("THREADS")) {
                    this.m_fileThreadCount = this.parseThreads(string2);
                    continue;
                }
                if (string4.equals("BENCHMARK")) {
                    this.m_benchmark = true;
                    continue;
                }
                if (string4.equals("SIMPLEPROGRESS")) {
                    this.m_progress = 3;
                    continue;
                }
                if (string4.equals("FULLPROGRESS")) {
                    this.m_progress = 2;
                    continue;
                }
                if (string4.equals("EXIT") || string4.equals("E")) {
                    this.m_exit = true;
                    continue;
                }
                if (string3.equals("CMD")) {
                    if (string2 == null) {
                        throw new Exception("Invalid CMD syntax");
                    }
                    String[] stringArray2 = string2.split(";");
                    if (stringArray2.length == 0) {
                        throw new Exception("Invalid CMD syntax");
                    }
                    Collections.addAll(this.m_commands, stringArray2);
                    continue;
                }
                if (string3.equals("TERMINATION")) {
                    this.m_termination = this.parseOnOff(string2, "termination");
                    continue;
                }
                if (string3.equals("ERRORS")) {
                    this.parseErrors(string2);
                    continue;
                }
                if (string3.equals("ODXNET")) {
                    if (string2 == null) {
                        throw new Exception("Invalid ODXNET syntax");
                    }
                    try {
                        this.m_odxnet = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new Exception("Invalid port number");
                    }
                    if (this.m_odxnet > 0) continue;
                    throw new Exception("Port number cannot be a negative number");
                }
                if (string4.equals("HELP") || string4.equals("?")) {
                    this.m_helpMode = true;
                    continue;
                }
                if (string4.equals("TIMER")) {
                    this.m_timer = true;
                    continue;
                }
                if (string4.equals("TIMERONLY")) {
                    this.m_timer = true;
                    this.m_timerOnly = true;
                    if (this.m_progress != 1) continue;
                    this.m_progress = 3;
                    continue;
                }
                if (string3.equals("POOL")) {
                    this.parsePool(string2);
                    continue;
                }
                throw new Exception("Unknown command line: " + string);
            }
            if (this.m_connectionString != null) {
                throw new Exception("Multiple connection string is not allowed.");
            }
            this.m_connectionString = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseUse(String string) throws Exception {
        String string2;
        Object object;
        ArrayList<String> arrayList;
        block14: {
            String string3 = null;
            arrayList = new ArrayList<String>();
            this.m_useFiles.clear();
            if (string == null) {
                throw new Exception(USE_SYNTAX);
            }
            if (string.charAt(0) == '(') {
                if (string.charAt(string.length() - 1) != ')') {
                    throw new Exception(USE_SYNTAX);
                }
                object = null;
                try {
                    string3 = string.substring(1, string.length() - 1);
                    object = new BufferedReader(new FileReader(string3));
                    while ((string2 = ((BufferedReader)object).readLine()) != null) {
                        if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == ';') continue;
                        arrayList.add(string2);
                    }
                    Object var7_6 = null;
                    if (object == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (object != null) {
                        ((BufferedReader)object).close();
                    }
                    throw throwable;
                }
                ((BufferedReader)object).close();
            } else {
                object = string.split(",");
                if (((String[])object).length != 0) {
                    Collections.addAll(arrayList, object);
                }
            }
        }
        if (arrayList.size() == 0) {
            throw new Exception(USE_SYNTAX);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            File file = new File(string2 = string2.trim());
            if (!file.isFile()) {
                throw new Exception(string2 + " doesn't exist");
            }
            if (!file.canRead()) {
                throw new Exception("No read access on " + string2);
            }
            this.m_useFiles.add(file);
        }
        return;
    }

    private int parseThreads(String string) throws Exception {
        if (string == null) {
            throw new Exception("Invalid thread count");
        }
        try {
            int n = Integer.parseInt(string);
            if (n <= 0) {
                throw new Exception("Invalid thread count: " + string);
            }
            return n;
        }
        catch (Exception exception) {
            throw new Exception("Invalid thread count");
        }
    }

    private boolean parseOnOff(String string, String string2) throws Exception {
        if (string == null) {
            throw new Exception(String.format("Invalid %s syntax", string2));
        }
        boolean bl = false;
        if ((string = string.toUpperCase()).equals("OFF")) {
            bl = false;
        } else if (string.equals("ON")) {
            bl = true;
        } else {
            throw new Exception(String.format("Invalid %s syntax", string2));
        }
        return bl;
    }

    private void parseErrors(String string) throws Exception {
        if (string == null) {
            throw new Exception("Invalid errors syntax");
        }
        if ((string = string.toUpperCase()).equals("CONTINUE")) {
            this.m_onError = 1;
        } else if (string.equals("ABORT")) {
            this.m_onError = 2;
        } else if (string.equals("EXIT")) {
            this.m_onError = 3;
        } else {
            throw new Exception("Invalid errors syntax");
        }
    }

    private void parsePool(String string) throws Exception {
        if (string == null) {
            throw new Exception("Invalid pool syntax");
        }
        int n = string.indexOf(61);
        if (n == -1) {
            throw new Exception("Invalid pool syntax");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        if (string2.length() == 0 || string3.length() == 0) {
            throw new Exception("Invalid pool syntax");
        }
        File file = new File(string3);
        if (!file.isFile()) {
            throw new Exception(string3 + " doesn't exist");
        }
        ConnectionPool connectionPool = null;
        if (this.m_pools == null) {
            this.m_pools = new Hashtable();
        } else {
            connectionPool = this.m_pools.get(string2);
        }
        if (connectionPool == null) {
            connectionPool = new ConnectionPool(string3);
            this.m_pools.put(string2, connectionPool);
        } else if (!connectionPool.isSame(string3)) {
            connectionPool.propertyFile(string3);
            this.m_pools.remove(string2);
            this.m_pools.put(string2, connectionPool);
        }
    }

    private boolean printString() {
        boolean bl = false;
        if (!this.m_benchmark) {
            if (this.m_output == null) {
                System.out.println();
                if (!this.m_skipPrompt) {
                    bl = this.promptToContinue();
                }
            } else {
                this.m_output.println();
            }
        }
        return bl;
    }

    private boolean printString(String string, Object ... objectArray) {
        boolean bl = false;
        if (!this.m_benchmark) {
            if (this.m_output == null) {
                if (objectArray.length == 0) {
                    System.out.println(string);
                } else {
                    System.out.printf(string + NEWLINE, objectArray);
                }
                if (!this.m_skipPrompt) {
                    bl = this.promptToContinue();
                }
            } else if (objectArray.length == 0) {
                this.m_output.println(string);
            } else {
                this.m_output.printf(string + NEWLINE, objectArray);
            }
        }
        return bl;
    }

    private boolean printError(String string, Object ... objectArray) {
        boolean bl = false;
        if (!this.m_benchmark) {
            String string2;
            String string3 = string2 = objectArray.length == 0 ? string : String.format(string, objectArray);
            if (this.m_output == null) {
                System.out.printf("*E* %s%n", string2);
                if (!this.m_skipPrompt) {
                    bl = this.promptToContinue();
                }
            } else {
                this.m_output.printf("*E* %s%n", string2);
            }
        }
        return bl;
    }

    private void printUntilEndOfPage(int n) {
        if (this.m_output == null) {
            while (this.m_lineNumber + n + 1 < this.m_pageLength) {
                this.printString();
            }
        }
    }

    private String prompt(String string) {
        System.out.print(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            n = System.in.read(byArray);
        }
        catch (IOException iOException) {
            this.printError(iOException.getMessage(), new Object[0]);
        }
        while (n != 0 && (byArray[n - 1] == 10 || byArray[n - 1] == 13)) {
            --n;
        }
        return n != 0 ? new String(byArray, 0, n) : null;
    }

    private boolean promptToContinue() {
        boolean bl = false;
        ++this.m_lineNumber;
        if (this.m_lineNumber == this.m_pageLength) {
            String string = this.prompt("Press <RETURN> to continue, 'Q' to quit or '/' to stop paging ...");
            if (string != null) {
                char c = string.charAt(0);
                if (c == 'Q' || c == 'q') {
                    bl = true;
                } else if (c == '/') {
                    this.m_skipPrompt = true;
                }
            }
            if (!bl && !this.m_skipPrompt) {
                this.m_lineNumber = 0;
                if (this.m_columnHeader != null) {
                    for (String string2 : this.m_columnHeader) {
                        this.printString(string2, new Object[0]);
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInteractive() {
        try {
            try {
                this.m_interactive = true;
                if (this.m_connectionString != null) {
                    boolean bl = this.m_benchmark;
                    this.m_benchmark = false;
                    if (this.executeConnect(this.m_connectionString)) {
                        Object var6_4 = null;
                        this.executeDisconnect(true);
                        return;
                    }
                    this.m_benchmark = bl;
                }
                if (this.m_useFiles.size() != 0) {
                    if (this.m_useFiles.size() == 1 && !this.m_benchmark && this.m_useThreadCount == 1 && this.m_fileThreadCount == 1 && this.m_progress == 1) {
                        this.runUseFileInteractive(null);
                    } else {
                        this.executeUse(this.m_benchmark, this.m_progress, this.m_useThreadCount, this.m_fileThreadCount, this.m_timer, this.m_timerOnly);
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean[] blArray = new boolean[]{false};
                for (String string : this.m_commands) {
                    this.executeInput(stringBuilder, string, blArray);
                }
                while (!this.m_exit) {
                    Object object = this.prompt(blArray[0] ? ">> " : "> ");
                    if (object == null || ((String)(object = ((String)object).trim())).length() == 0) continue;
                    this.executeInput(stringBuilder, (String)object, blArray);
                }
            }
            catch (Exception exception) {
                this.printError(exception.getMessage(), new Object[0]);
                Object var6_6 = null;
                this.executeDisconnect(true);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.executeDisconnect(true);
            throw throwable;
        }
        Object var6_5 = null;
        this.executeDisconnect(true);
    }

    private int parseInput(StringBuilder stringBuilder, String string, boolean[] blArray, boolean bl) throws Exception {
        if (string.equals(";")) {
            if (!blArray[0]) {
                return 1;
            }
        } else if (string.startsWith(";")) {
            if (string.contains("<TEST=")) {
                return 2;
            }
            if (string.contains("<TEST_CLEANUP>")) {
                return 3;
            }
            if (string.contains("<COMMON>")) {
                return 4;
            }
            if (string.contains("<END_COMMON>")) {
                return 5;
            }
            return 1;
        }
        if (!blArray[0]) {
            stringBuilder.setLength(0);
        }
        boolean bl2 = false;
        if (string.endsWith("\\")) {
            blArray[0] = true;
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith(";")) {
            bl2 = true;
            blArray[0] = false;
            string = string.substring(0, string.length() - 1);
        } else if (!this.m_termination) {
            bl2 = true;
            blArray[0] = false;
        }
        if (stringBuilder.length() == 0) {
            if (!bl && !this.isValidCommand(string)) {
                throw new Exception(String.format("Unrecognized command [%s].  Type HELP for list of commands", string));
            }
        } else {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string);
        if (!blArray[0]) {
            String string2 = stringBuilder.toString();
            int n = string2.indexOf(32);
            String string3 = n == -1 ? string2.toUpperCase() : string2.substring(0, n).toUpperCase();
            if (string3.equals("EXIT") || string3.equals("E") || string3.equals("QUIT") || string3.equals("Q")) {
                return 6;
            }
            if (string3.equals("CONNECT")) {
                return 7;
            }
            if (string3.equals("DISCONNECT")) {
                return 8;
            }
            if (string3.equals("SET")) {
                return 9;
            }
            if (string3.equals("USE")) {
                return 10;
            }
            if (string3.equals("VERSIONS")) {
                return 11;
            }
            if (string3.equals("HELP")) {
                return 12;
            }
            if (bl2) {
                return 13;
            }
            blArray[0] = true;
        }
        return 0;
    }

    private void executeInput(StringBuilder stringBuilder, String string, boolean[] blArray) {
        boolean bl = this.m_benchmark;
        try {
            int n = this.parseInput(stringBuilder, string, blArray, false);
            switch (n) {
                case 1: {
                    return;
                }
                case 2: {
                    ++this.m_testCount;
                    this.m_skipInput = false;
                    return;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.m_skipInput = false;
                    return;
                }
            }
            if (this.m_skipInput || n == 0) {
                return;
            }
            if (n == 6) {
                this.m_exit = true;
                return;
            }
            String string2 = stringBuilder.toString();
            String string3 = null;
            int n2 = string2.indexOf(32);
            if (n2 != -1) {
                string3 = string2.substring(n2 + 1).trim();
            }
            this.m_lineNumber = 0;
            this.m_skipPrompt = true;
            if (!this.m_benchmark && this.m_timerOnly) {
                this.m_benchmark = true;
            }
            switch (n) {
                case 7: {
                    if (string3 == null) {
                        this.printError("Invalid connect syntax", new Object[0]);
                        break;
                    }
                    ++this.m_stmtCount;
                    String string4 = string3.toUpperCase();
                    n2 = string4.lastIndexOf("WITH ");
                    if (n2 != -1) {
                        String string5 = string3.substring(n2 + 5).trim();
                        string3 = string3.substring(0, n2).trim() + "&" + string5;
                    }
                    if (string4.startsWith("TO ")) {
                        string3 = string3.substring(3).trim();
                    }
                    this.executeConnect(string3);
                    break;
                }
                case 8: {
                    ++this.m_stmtCount;
                    if (this.m_timer) {
                        this.m_startTimer = System.currentTimeMillis();
                    }
                    this.executeDisconnect(false);
                    if (!this.m_timer) break;
                    this.m_stopTimer = System.currentTimeMillis();
                    break;
                }
                case 9: {
                    if (string3 == null) {
                        this.printError("Unrecognized SET option.  Type HELP for list of SET options", new Object[0]);
                        break;
                    }
                    this.executeSet(string3);
                    break;
                }
                case 10: {
                    String[] stringArray;
                    if (string3 == null) {
                        this.printError(USE_SYNTAX, new Object[0]);
                        break;
                    }
                    boolean bl2 = bl;
                    int n3 = this.m_progress;
                    int n4 = this.m_useThreadCount;
                    int n5 = this.m_fileThreadCount;
                    boolean bl3 = this.m_timer;
                    boolean bl4 = this.m_timerOnly;
                    String string6 = string3.toUpperCase();
                    n2 = string6.lastIndexOf("WITH ");
                    if (n2 != -1) {
                        string3 = string3.substring(0, n2).trim();
                        string6 = string6.substring(n2 + 5).trim();
                        stringArray = string6.replace(' ', ',').split(",");
                        boolean bl5 = false;
                        for (String string7 : stringArray) {
                            if (string7 == null || string7.length() == 0) continue;
                            if (string7.equals("BENCHMARK")) {
                                bl2 = true;
                                if (n3 != 1) continue;
                                n3 = 3;
                                continue;
                            }
                            if (string7.equals("SIMPLEPROGRESS")) {
                                n3 = 3;
                                continue;
                            }
                            if (string7.equals("FULLPROGRESS")) {
                                n3 = 2;
                                continue;
                            }
                            if (string7.equals("TIMER")) {
                                bl3 = true;
                                if (n3 != 1) continue;
                                n3 = 3;
                                continue;
                            }
                            if (string7.equals("TIMERONLY")) {
                                bl3 = true;
                                bl4 = true;
                                if (n3 != 1) continue;
                                n3 = 3;
                                continue;
                            }
                            n2 = string7.indexOf(61);
                            if (n2 != -1) {
                                String string8 = string7.substring(0, n2).toUpperCase();
                                String string9 = string7.substring(n2 + 1);
                                if (string8.equals("FILES")) {
                                    n4 = this.parseThreads(string9);
                                    continue;
                                }
                                if (string8.equals("THREADS")) {
                                    n5 = this.parseThreads(string9);
                                    continue;
                                }
                                this.printError("Invalid option %s specified", string8);
                                bl5 = true;
                                break;
                            }
                            this.printError("Invalid option %s specified", string7);
                            bl5 = true;
                            break;
                        }
                        if (bl5) break;
                    }
                    if (this.m_interactive) {
                        this.m_useCommand = string3;
                        this.parseUse(string3);
                        if (this.m_useFiles.size() == 1 && !bl2 && n4 == 1 && n5 == 1 && n3 == 1) {
                            this.runUseFileInteractive(null);
                            break;
                        }
                        this.executeUse(bl2, n3, n4, n5, bl3, bl4);
                        break;
                    }
                    stringArray = new jdbcsql();
                    stringArray.parseUse(string3);
                    stringArray.useFile(null, null, this, bl2, 1, bl3, bl4);
                    stringArray.exit(true);
                    super.runUseFileInteractive(this.m_output);
                    break;
                }
                case 11: {
                    if (this.m_versions == null) {
                        this.printError("Unable to get version information", new Object[0]);
                        break;
                    }
                    this.printWithPrompt(this.m_versions);
                    break;
                }
                case 12: {
                    this.printWithPrompt(HELPS);
                    break;
                }
                case 13: {
                    ++this.m_stmtCount;
                    if (this.m_conn == null) {
                        this.printError("This statement requires a connection to an environment file", new Object[0]);
                        break;
                    }
                    this.executeSql(string2);
                }
            }
        }
        catch (Exception exception) {
            this.stopJdbcTimer();
            this.printError(exception.getMessage(), new Object[0]);
        }
        this.m_benchmark = bl;
        if (this.m_timer && this.m_startTimer != 0L) {
            if (this.m_stopTimer == 0L) {
                this.m_stopTimer = System.currentTimeMillis();
            }
            this.printString("Elapsed %s", this.formatElapsed(this.m_stopTimer - this.m_startTimer, true));
            this.m_stopTimer = 0L;
            this.m_startTimer = 0L;
        }
    }

    private void printWithPrompt(String[] stringArray) {
        String string;
        boolean bl = false;
        this.m_skipPrompt = this.m_pageLength == 0;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n && !(bl = this.printString(string = stringArray2[i], new Object[0])); ++i) {
        }
        if (!this.m_skipPrompt && !bl) {
            this.printUntilEndOfPage(0);
        }
        this.m_skipPrompt = true;
    }

    private boolean isValidCommand(String string) {
        int n = 0;
        while (string.charAt(n) == '(' || string.charAt(n) == ' ') {
            ++n;
        }
        if (n != 0) {
            string = string.substring(n);
        }
        boolean bl = false;
        String string2 = string.toUpperCase();
        for (String string3 : FULLCOMMANDS) {
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return bl;
        }
        n = string.indexOf(32);
        string2 = n != -1 ? string.substring(0, n).toUpperCase() : string.toUpperCase();
        for (String string3 : COMMANDS) {
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        if (bl || n == -1) {
            return bl;
        }
        string2 = (n = (string = string.substring(n + 1).trim()).indexOf(32)) != -1 ? string2 + " " + string.substring(0, n).toUpperCase() : string2 + " " + string.toUpperCase();
        for (String string3 : COMMANDS) {
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private ConnectionPool getConnectionPool(String string) {
        ConnectionPool connectionPool;
        ConnectionPool connectionPool2 = connectionPool = this.m_pools == null ? null : this.m_pools.get(string);
        if (connectionPool == null && string.charAt(0) != '[' && string.endsWith(".properties")) {
            if (this.m_pools != null) {
                Enumeration<ConnectionPool> enumeration = this.m_pools.elements();
                while (enumeration.hasMoreElements() && !(connectionPool = enumeration.nextElement()).isSame(string)) {
                    connectionPool = null;
                }
            }
            if (connectionPool == null) {
                connectionPool = new ConnectionPool(string);
            }
        }
        return connectionPool;
    }

    private boolean executeConnect(String string) {
        if (this.m_timer) {
            this.m_startTimer = System.currentTimeMillis();
        }
        boolean bl = false;
        try {
            this.executeDisconnect(false);
            ConnectionPool connectionPool = this.getConnectionPool(string);
            if (connectionPool == null) {
                string = this.parseConnectionString(string);
                this.startJdbcTimer();
                this.m_conn = DriverManager.getConnection("jdbc:omnidex:" + string, null);
            } else {
                this.startJdbcTimer();
                this.m_conn = connectionPool.getConnection();
            }
            this.m_stmt = this.m_conn.createStatement(1004, 1007);
            this.stopJdbcTimer();
            this.printString("Connected to %s", string);
        }
        catch (Exception exception) {
            this.stopJdbcTimer();
            this.setErrorsFlag();
            this.printError(exception.getMessage(), new Object[0]);
            this.executeDisconnect(true);
            bl = true;
        }
        if (this.m_timer) {
            this.m_stopTimer = System.currentTimeMillis();
        }
        return bl;
    }

    private void executeDisconnect(boolean bl) {
        if (this.m_stmt != null) {
            this.startJdbcTimer();
            try {
                this.m_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stopJdbcTimer();
            this.m_stmt = null;
        }
        if (this.m_conn != null) {
            block7: {
                try {
                    this.startJdbcTimer();
                    this.m_conn.close();
                    this.stopJdbcTimer();
                    if (!bl) {
                        this.printString("Disconnected", new Object[0]);
                    }
                }
                catch (Exception exception) {
                    this.stopJdbcTimer();
                    if (bl) break block7;
                    this.printError(exception.getMessage(), new Object[0]);
                }
            }
            this.m_conn = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeSet(String string) throws Exception {
        String string2;
        String string3;
        int n = string.indexOf(32);
        if (n == -1) {
            n = string.indexOf(61);
        }
        if (n == -1) {
            string3 = string.toUpperCase();
            string2 = null;
        } else {
            string3 = string.substring(0, n).trim().toUpperCase();
            if (string.charAt(n) == '=') {
                ++n;
            }
            if ((string2 = string.substring(n).trim()).charAt(0) == '\"') {
                string2 = string2.substring(1, string2.length() - 1).trim();
            }
        }
        if (string3.equals("FILES")) {
            this.m_useThreadCount = this.parseThreads(string2);
            return;
        } else if (string3.equals("THREADS")) {
            this.m_fileThreadCount = this.parseThreads(string2);
            return;
        } else if (string3.equals("TERMINATION")) {
            this.m_termination = this.parseOnOff(string2, "termination");
            return;
        } else if (string3.equals("ERRORS")) {
            this.parseErrors(string2);
            return;
        } else if (string3.equals("BENCHMARK")) {
            this.m_benchmark = this.parseOnOff(string2, "benchmark");
            return;
        } else if (string3.equals("TIMER")) {
            this.m_timer = this.parseOnOff(string2, "timer");
            return;
        } else if (string3.equals("TIMERONLY")) {
            this.m_timerOnly = this.parseOnOff(string2, "timeronly");
            return;
        } else if (string3.equals("SIMPLEPROGRESS")) {
            this.m_progress = this.parseOnOff(string2, "simpleprogress") ? 3 : 2;
            return;
        } else if (string3.equals("FULLPROGRESS")) {
            this.m_progress = this.parseOnOff(string2, "fullprogress") ? 2 : 3;
            return;
        } else if (string3.equals("POOL")) {
            this.parsePool(string2);
            return;
        } else if (string3.equals("PAGELENGTH")) {
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 < 0 || n2 > 256) {
                    throw new Exception("PAGELENTH must be set to a value between 0 and 256");
                }
                this.m_pageLength = n2;
                return;
            }
            catch (Exception exception) {
                throw new Exception("PAGELENTH must be set to a value between 0 and 256");
            }
        } else if (string3.equals("DEBUG")) {
            Object object;
            String string4 = null;
            n = string2.indexOf(32);
            if (n == -1) {
                string2 = string2.toUpperCase();
            } else {
                object = string2.substring(n).trim();
                string2 = string2.substring(0, n).trim().toUpperCase();
                n = ((String)object).indexOf(61);
                if (n == -1) {
                    throw new Exception("Invalid set debug syntax");
                }
                string4 = ((String)object).substring(n + 1).trim();
                if (!((String)(object = ((String)object).substring(0, n).trim().toUpperCase())).equals("FILE")) {
                    throw new Exception("Invalid set debug syntax");
                }
            }
            if (string2.equals("ON")) {
                object = new File(string4 == null ? "jdbcdebug.log" : string4);
                OdxCLJTrace.setLogWriter(new PrintWriter(new FileWriter(((File)object).getAbsolutePath(), true)));
                return;
            } else {
                if (!string2.equals("OFF")) throw new Exception("Invalid set debug syntax");
                OdxCLJTrace.setLogWriter(null);
            }
            return;
        } else {
            boolean bl = false;
            for (String string5 : SETTINGS) {
                if (!string3.equals(string5)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new Exception(String.format("Unrecognized SET option [%s].  Type HELP for list of SET options", string));
            }
            if (this.m_conn == null) {
                throw new Exception("This statement requires a connection to an environment file");
            }
            this.startJdbcTimer();
            this.m_stmt.execute("set " + string);
            this.stopJdbcTimer();
        }
    }

    private void executeUse(boolean bl, int n, int n2, int n3, boolean bl2, boolean bl3) {
        int n4;
        Object object;
        Thread[] threadArray;
        long l = System.currentTimeMillis();
        int n5 = this.m_useFiles.size();
        jdbcsql[] jdbcsqlArray = new jdbcsql[n5];
        char[] cArray = new char[78];
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n5);
        for (int i = 0; i < n5; ++i) {
            threadArray = this.m_useFiles.get(i);
            String string = "log" + File.separator + threadArray.getName();
            Integer n6 = (Integer)hashMap.get(string);
            if (n6 == null) {
                n6 = 1;
            } else {
                Integer n7 = n6;
                n6 = n6 + 1;
                object = n6;
            }
            hashMap.put(string, n6);
            if (n6 != 1) {
                string = String.format("%s(%d)", string, n6);
            }
            jdbcsqlArray[i] = new jdbcsql();
            jdbcsqlArray[i].useFile((File)threadArray, new File(string), this, bl, n3, bl2, bl3);
            jdbcsqlArray[i].runType(1);
            if (i != 0 || bl) continue;
            jdbcsqlArray[i].logFile().getParentFile().mkdirs();
        }
        Semaphore semaphore = new Semaphore(n2, true);
        threadArray = new Thread[n5];
        int n8 = 0;
        boolean bl4 = OdxCLJNative.isTTY(1);
        boolean bl5 = false;
        object = this.formatUseCommand(bl, n2, n3);
        if (n != 2) {
            this.printProgressHeader(cArray);
        }
        while (!bl5 && n8 < n5) {
            try {
                if (!semaphore.tryAcquire(500L, TimeUnit.MILLISECONDS)) {
                    if (bl4) {
                        if (n == 2) {
                            this.printFullProgress((String)object, jdbcsqlArray, l, n5, n8, n3, cArray);
                        } else {
                            this.printSimpleProgress(jdbcsqlArray, l, n5, n8, cArray);
                        }
                    }
                    if (this.m_onError != 3) continue;
                    bl5 = this.checkForError(jdbcsqlArray, n8);
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            jdbcsqlArray[n8].semaphore(semaphore);
            jdbcsqlArray[n8].startRunTime(System.currentTimeMillis());
            threadArray[n8] = new Thread(jdbcsqlArray[n8]);
            threadArray[n8++].start();
            if (bl4) {
                if (n == 2) {
                    this.printFullProgress((String)object, jdbcsqlArray, l, n5, n8, n3, cArray);
                } else {
                    this.printSimpleProgress(jdbcsqlArray, l, n5, n8, cArray);
                }
            }
            if (this.m_onError != 3) continue;
            bl5 = this.checkForError(jdbcsqlArray, n8);
        }
        while (!bl5) {
            n4 = -1;
            for (int i = 0; i < n8; ++i) {
                if (threadArray[i] == null) continue;
                if (jdbcsqlArray[i].exit()) {
                    threadArray[i] = null;
                    continue;
                }
                n4 = i;
            }
            if (n4 == -1) break;
            if (bl4) {
                if (n == 2) {
                    this.printFullProgress((String)object, jdbcsqlArray, l, n5, n8, n3, cArray);
                } else {
                    this.printSimpleProgress(jdbcsqlArray, l, n5, n8, cArray);
                }
            }
            try {
                threadArray[n4].join(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_onError != 3) continue;
            bl5 = this.checkForError(jdbcsqlArray, n8);
        }
        if (bl5) {
            for (n4 = 0; n4 < n8; ++n4) {
                if (threadArray[n4] == null) continue;
                try {
                    threadArray[n4].join();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_exit = true;
        } else {
            this.printSummary(bl4, n, (String)object, jdbcsqlArray, l, n5, n2, n3, cArray);
        }
    }

    private String formatUseCommand(boolean bl, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder("> use ");
        stringBuilder.append(this.m_useCommand);
        if (bl || n != 1 || n2 != 1) {
            stringBuilder.append(" with ");
            if (bl) {
                stringBuilder.append("benchmark,");
            }
            if (n != 1) {
                stringBuilder.append(String.format("files=%d,", n));
            }
            if (n2 != 1) {
                stringBuilder.append(String.format("threads=%d,", n2));
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private boolean checkForError(jdbcsql[] jdbcsqlArray, int n) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!jdbcsqlArray[i].error()) continue;
            bl = true;
            for (int j = 0; j < n; ++j) {
                if (j == i || jdbcsqlArray[j].exit()) continue;
                jdbcsqlArray[j].cancel();
            }
            break;
        }
        return bl;
    }

    private void printProgressHeader(char[] cArray) {
        System.out.println();
        System.out.println(" File          Progress                                         Count   Elapsed");
        System.out.print(' ');
        Arrays.fill(cArray, '-');
        System.out.println(cArray);
    }

    private void printSimpleProgress(jdbcsql[] jdbcsqlArray, long l, int n, int n2, char[] cArray) {
        Object object;
        Arrays.fill(cArray, ' ');
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            object = jdbcsqlArray[i];
            n4 += ((jdbcsql)object).count();
            if (((jdbcsql)object).exit()) {
                cArray[i] = 61;
                ++n3;
                continue;
            }
            cArray[i] = 42;
        }
        String string = String.format("(%d/%d)", n3, n);
        object = String.format("[%s]", String.valueOf(cArray, 0, n));
        System.out.printf("\r %-13.13s%-42s%,13d%10s", string, object, n4, this.formatElapsed(System.currentTimeMillis() - l, false));
    }

    private void printFullProgress(String string, jdbcsql[] jdbcsqlArray, long l, int n, int n2, int n3, char[] cArray) {
        OdxCLJNative.clearScreen();
        System.out.println(string);
        this.printProgressHeader(cArray);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            jdbcsql jdbcsql2 = jdbcsqlArray[i];
            if (jdbcsql2.exit()) {
                ++n4;
                continue;
            }
            int n5 = 0;
            int n6 = 0;
            if (jdbcsql2.totalCount() != 0) {
                n5 = Math.round((float)jdbcsql2.count() / (float)jdbcsql2.totalCount() * 40.0f);
                n6 = jdbcsql2.count();
            }
            if (n5 == 0) {
                n5 = 1;
            }
            if (n6 == 0) {
                n6 = 1;
            }
            Arrays.fill(cArray, ' ');
            Arrays.fill(cArray, 0, n5, '=');
            if (jdbcsql2.totalCount() != 0) {
                int n7 = (int)((float)n6 / (float)jdbcsql2.totalCount() * 100.0f);
                String string2 = String.format(" %2d%% ", n7);
                string2.getChars(0, string2.length(), cArray, n7 == 100 ? 18 : 19);
            }
            System.out.printf(" %-13s|%-40s|%,13d %9s%n", jdbcsql2.logFile().getName(), String.valueOf(cArray, 0, 40), n6, this.formatElapsed(System.currentTimeMillis() - jdbcsql2.startRunTime(), false));
        }
        String string3 = String.format("Completed: %d   Running: %d   Queued: %d   Threads: %d", n4, n2 - n4, n - n2, (n2 - n4) * n3);
        System.out.print(' ');
        Arrays.fill(cArray, '-');
        System.out.println(cArray);
        System.out.printf(" %-63s     %10s%n", string3, this.formatElapsed(System.currentTimeMillis() - l, false));
        System.out.println();
    }

    private void printSummary(boolean bl, int n, String string, jdbcsql[] jdbcsqlArray, long l, int n2, int n3, int n4, char[] cArray) {
        if (n == 2) {
            if (bl) {
                OdxCLJNative.clearScreen();
            }
            System.out.println(string);
            this.printProgressHeader(cArray);
        } else {
            System.out.print("\r");
        }
        long l2 = System.currentTimeMillis() - l;
        float f = (float)l2 / 40.0f;
        int n5 = 0;
        long l3 = 0L;
        for (jdbcsql jdbcsql2 : jdbcsqlArray) {
            long l4 = jdbcsql2.startRunTime() - l;
            long l5 = jdbcsql2.stopRunTime() - l;
            long l6 = jdbcsql2.stopRunTime() - jdbcsql2.startRunTime();
            int n6 = (int)((float)l4 / f);
            int n7 = (int)((float)l5 / f);
            Arrays.fill(cArray, ' ');
            if (n6 == n7) {
                cArray[n6] = 45;
            } else {
                Arrays.fill(cArray, n6, n7, '=');
            }
            System.out.printf(" %-13s %-40s %,13d %9s%n", jdbcsql2.logFile().getName(), new String(cArray, 0, 40), jdbcsql2.count(), this.formatElapsed(l6, false));
            n5 += jdbcsql2.count();
            l3 += l6 * (long)n4;
        }
        String string2 = String.format("Total (%d files)", n2);
        String string3 = String.format("%,d", Math.round((float)n5 / ((float)l2 / 1000.0f)));
        String string4 = String.format(String.format("%%,%dd", string3.length()), Math.round((float)n5 / ((float)l3 / 1000.0f)));
        System.out.print(' ');
        Arrays.fill(cArray, '-');
        System.out.println(cArray);
        System.out.printf(" %-53s  %,13d %9s%n", string2, n5, this.formatElapsed(l2, false));
        System.out.println();
        System.out.printf(" %s per second%n", string3);
        System.out.printf(" %s per second per thread%n%n", string4);
    }

    public String formatElapsed(long l, boolean bl) {
        if (l < 0L) {
            return bl ? "0.000" : "0:00";
        }
        if (!bl) {
            l += 500L;
        }
        int n = (int)(l / 3600000L);
        int n2 = (int)((l %= 3600000L) / 60000L);
        int n3 = (int)((l %= 60000L) / 1000L);
        int n4 = (int)(l % 1000L);
        if (n > 0) {
            return String.format("%d:%02d:%02d", n, n2, n3);
        }
        if (n2 > 0) {
            return bl ? String.format("%d:%02d.%03d", n2, n3, n4) : String.format("%d:%02d", n2, n3);
        }
        return bl ? String.format("%d.%03d", n3, n4) : String.format("0:%02d", n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeSql(String string) throws Exception {
        ResultSet resultSet = null;
        try {
            block16: {
                try {
                    if (this.m_timer) {
                        this.m_startTimer = System.currentTimeMillis();
                    }
                    this.startJdbcTimer();
                    if (this.m_stmt.execute(string)) {
                        resultSet = this.m_stmt.getResultSet();
                    }
                    this.stopJdbcTimer();
                    String string2 = this.getQualifyTable(string);
                    if (string2 != null) {
                        this.startJdbcTimer();
                        int n = this.m_stmt.getUpdateCount();
                        this.stopJdbcTimer();
                        if (n == 1) {
                            this.printString("1 %s record qualifies", string2);
                        } else {
                            this.printString("%,d %s records qualify", n, string2);
                        }
                        if (this.m_timer) {
                            this.m_stopTimer = System.currentTimeMillis();
                        }
                        break block16;
                    }
                    if (resultSet == null) {
                        this.startJdbcTimer();
                        int n = this.m_stmt.getUpdateCount();
                        this.stopJdbcTimer();
                        if (n == 1) {
                            this.printString("1 row affected", new Object[0]);
                        } else if (n != -1) {
                            this.printString("%d rows affected", n);
                        } else {
                            this.printString("No result set.", new Object[0]);
                        }
                        if (this.m_timer) {
                            this.m_stopTimer = System.currentTimeMillis();
                        }
                        break block16;
                    }
                    this.m_skipPrompt = this.m_pageLength == 0;
                    this.printResultSet(resultSet);
                    this.m_skipPrompt = true;
                }
                catch (Exception exception) {
                    this.stopJdbcTimer();
                    this.setErrorsFlag();
                    this.printError(exception.getMessage(), new Object[0]);
                    Object var6_8 = null;
                    if (resultSet == null) return;
                    this.startJdbcTimer();
                    resultSet.close();
                    this.stopJdbcTimer();
                    return;
                }
            }
            Object var6_7 = null;
            if (resultSet == null) return;
            this.startJdbcTimer();
            resultSet.close();
            this.stopJdbcTimer();
            return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (resultSet == null) throw throwable;
            this.startJdbcTimer();
            resultSet.close();
            this.stopJdbcTimer();
            throw throwable;
        }
    }

    private void setErrorsFlag() {
        if (this.m_onError == 3 || this.m_onError == 2) {
            this.m_error = true;
        } else if (this.m_testDirExist) {
            this.m_skipInput = true;
        }
    }

    private String getQualifyTable(String string) {
        if ((string = string.trim().toUpperCase()).startsWith("QUALIFY ")) {
            string = string.substring(8).trim();
            return string.substring(0, string.indexOf(32));
        }
        return null;
    }

    private void printResultSet(ResultSet resultSet) throws Exception {
        this.startJdbcTimer();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.stopJdbcTimer();
        int[] nArray = new int[n];
        int n2 = this.getRowSize(resultSetMetaData, n, nArray);
        int n3 = 0;
        char[] cArray = new char[n2];
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        this.m_columnHeader = new ArrayList<String>();
        this.formatColumnHeader(resultSetMetaData, n, n2, nArray, this.m_columnHeader);
        if (!this.m_qaMode) {
            this.printString();
        }
        for (String string : this.m_columnHeader) {
            this.printString(string, new Object[0]);
        }
        while (true) {
            this.startJdbcTimer();
            boolean bl2 = resultSet.next();
            this.stopJdbcTimer();
            if (!bl2) break;
            if (this.m_timer && this.m_stopTimer == 0L && this.m_interactive) {
                this.m_stopTimer = System.currentTimeMillis();
            }
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                this.startJdbcTimer();
                String string = resultSet.getString(i + 1);
                if (resultSet.wasNull()) {
                    string = "~";
                }
                this.stopJdbcTimer();
                if (nArray[i] > 78 && (string = string.trim()).length() > 78) {
                    string = string.substring(0, 74) + "...";
                }
                n4 = this.writeOutput(arrayList, cArray, null, string, Math.min(78, nArray[i]), n4);
            }
            arrayList.add(new String(cArray, 0, n4));
            if (!this.m_skipPrompt && this.m_lineNumber + arrayList.size() > this.m_pageLength) {
                this.printUntilEndOfPage(0);
                bl = this.printString();
            }
            if (!bl) {
                for (String string : arrayList) {
                    if (!this.printString(string, new Object[0])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) break;
            ++n3;
            arrayList.clear();
        }
        if (!bl) {
            if (!this.m_skipPrompt) {
                this.printUntilEndOfPage(1);
            }
            if (n3 < 2) {
                this.printString("%d row returned", n3);
            } else {
                this.printString("%d rows returned", n3);
            }
        }
        this.m_columnHeader = null;
        if (!this.m_interactive && this.m_timer) {
            this.m_stopTimer = System.currentTimeMillis();
        }
    }

    private int getRowSize(ResultSetMetaData resultSetMetaData, int n, int[] nArray) throws Exception {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.startJdbcTimer();
            nArray[i] = resultSetMetaData.getColumnDisplaySize(i + 1);
            this.stopJdbcTimer();
            n2 += nArray[i] + 2;
        }
        return n2;
    }

    private int writeOutput(List<String> list, char[] cArray, char[] cArray2, String string, int n, int n2) {
        if (n2 != 0) {
            if (n2 + n + 2 >= 78) {
                list.add(new String(cArray, 0, n2));
                if (cArray2 != null) {
                    list.add(new String(cArray2, 0, n2));
                }
                n2 = 0;
            } else {
                n2 += 2;
            }
        }
        if (n2 == 0) {
            Arrays.fill(cArray, ' ');
            if (cArray2 != null) {
                Arrays.fill(cArray2, ' ');
            }
        }
        string.getChars(0, Math.min(string.length(), n), cArray, n2);
        if (cArray2 != null) {
            Arrays.fill(cArray2, n2, n2 + n, '-');
        }
        return n2 + n;
    }

    private void formatColumnHeader(ResultSetMetaData resultSetMetaData, int n, int n2, int[] nArray, List<String> list) throws Exception {
        char[] cArray = new char[78];
        char[] cArray2 = new char[78];
        if (this.m_qaMode) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder.append("[SELECT_ITEMS=");
            for (int i = 0; i < n; ++i) {
                stringBuilder2.setLength(0);
                this.startJdbcTimer();
                String string = resultSetMetaData.getCatalogName(i + 1);
                this.stopJdbcTimer();
                if (string.length() == 0) {
                    this.startJdbcTimer();
                    string = resultSetMetaData.getColumnLabel(i + 1);
                    this.stopJdbcTimer();
                    if (string.length() != 0) {
                        string = string.replaceAll("[^\\p{Print}]", " ");
                    }
                    stringBuilder2.append(string);
                } else {
                    this.startJdbcTimer();
                    String string2 = resultSetMetaData.getSchemaName(i + 1);
                    String string3 = resultSetMetaData.getTableName(i + 1);
                    String string4 = resultSetMetaData.getColumnName(i + 1);
                    this.stopJdbcTimer();
                    stringBuilder2.append(string);
                    stringBuilder2.append(".");
                    stringBuilder2.append(string2);
                    stringBuilder2.append(".");
                    stringBuilder2.append(string3);
                    stringBuilder2.append(".");
                    stringBuilder2.append(string4);
                }
                stringBuilder.append(String.format("%n%d,,\"%s\",,,,STRING(%d)", i + 1, stringBuilder2, Math.min(78, nArray[i]) + 1));
            }
            stringBuilder.append("]");
            this.printString(stringBuilder.toString(), new Object[0]);
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 = this.writeOutput(list, cArray, cArray2, resultSetMetaData.getColumnLabel(i + 1), Math.min(78, nArray[i]), n3);
        }
        list.add(new String(cArray, 0, n3));
        list.add(new String(cArray2, 0, n3));
    }

    private String parseConnectionString(String string) {
        File file;
        int n;
        String string2 = string;
        String string3 = null;
        String string4 = null;
        if (string.charAt(0) == '[' && (n = string.indexOf(93)) != -1) {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1);
        }
        if ((n = string2.indexOf(38)) != -1) {
            string4 = string2.substring(n);
            string2 = string2.substring(0, n);
        }
        if (!string2.equalsIgnoreCase("omnidex") && !(file = new File(string2)).isAbsolute()) {
            n = file.getName().lastIndexOf(46);
            if (n == -1 && !(file = new File(string2 + ".dsn")).exists() && !(file = new File(string2 + ".xml")).exists()) {
                file = new File(string2);
            }
            string = string3 != null ? string3 + file.getAbsolutePath() : file.getAbsolutePath();
            if (string4 != null) {
                string = string + string4;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void countTests(boolean bl) throws Exception {
        BufferedReader bufferedReader = null;
        try {
            int n;
            String string;
            int n2 = 0;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_useFile.getAbsolutePath()), "ISO-8859-1"));
            int n3 = 0;
            int n4 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            boolean[] blArray = new boolean[]{false};
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            while (!Thread.currentThread().isInterrupted() && (string = bufferedReader.readLine()) != null) {
                ++n2;
                if ((string = string.trim()).length() == 0 || (n = this.parseInput(stringBuilder, string, blArray, true)) == 0) continue;
                switch (n) {
                    case 2: {
                        ++n3;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 13: {
                        ++n4;
                    }
                }
                if (!bl || n == 1) continue;
                arrayList.add(n2);
                arrayList2.add(n);
            }
            this.m_testDirExist = n3 != 0;
            int n5 = this.m_totalCount = this.m_testDirExist ? n3 : n4;
            if (bl) {
                this.m_lines = new int[2][arrayList.size()];
                n = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.m_lines[0][n++] = (Integer)iterator.next();
                }
                n = 0;
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    this.m_lines[1][n++] = (Integer)iterator.next();
                }
            }
            Object var14_13 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {}
    }

    private void runUseFileInteractive(PrintWriter printWriter) throws Exception {
        if (!this.m_benchmark && printWriter != null) {
            this.m_output = printWriter;
        }
        Iterator<File> iterator = this.m_useFiles.iterator();
        while (iterator.hasNext()) {
            File file;
            this.m_useFile = file = iterator.next();
            this.runUseFileSingleThread(false);
        }
        this.m_output = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runUseFileSingleThread(boolean bl) throws Exception {
        BufferedReader bufferedReader = null;
        try {
            String string;
            if (bl) {
                this.countTests(false);
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean[] blArray = new boolean[]{false};
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_useFile.getAbsolutePath()), "ISO-8859-1"));
            this.m_exit = false;
            while (!(Thread.currentThread().isInterrupted() || this.m_exit || this.m_error || (string = bufferedReader.readLine()) == null)) {
                if (blArray[0]) {
                    this.printString(">> %s", string);
                } else {
                    this.printString("> %s", string);
                }
                if ((string = string.trim()).length() == 0) continue;
                this.executeInput(stringBuilder, string, blArray);
            }
            Object var7_6 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {}
    }

    private void runUseFileMultiThread() throws Exception {
        int n;
        this.countTests(true);
        Thread[] threadArray = new Thread[this.m_fileThreadCount];
        for (n = 0; n < this.m_fileThreadCount; ++n) {
            jdbcsql jdbcsql2 = new jdbcsql();
            jdbcsql2.useFile(this.m_useFile, new File(String.format("%s.%d", this.m_logFile.getAbsolutePath(), n + 1)), this, this.m_benchmark, 1, this.m_timer, this.m_timerOnly);
            jdbcsql2.runType(2);
            threadArray[n] = new Thread(jdbcsql2);
            threadArray[n].start();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (threadArray[i].isAlive()) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        for (n = 0; n < this.m_fileThreadCount; ++n) {
            if (threadArray[n] == null) continue;
            threadArray[n].join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runCommands() throws Exception {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_useFile.getAbsolutePath()), "ISO-8859-1"));
            StringBuilder stringBuilder = new StringBuilder();
            boolean[] blArray = new boolean[]{false};
            String string = null;
            int n = 0;
            int n2 = 0;
            int[][] nArray = this.m_parent.lines();
            while (!(Thread.currentThread().isInterrupted() || this.m_exit || this.m_error)) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n3 = 0;
                int n4 = 0;
                jdbcsql jdbcsql2 = this.m_parent;
                synchronized (jdbcsql2) {
                    while (n < nArray[0].length) {
                        int n5 = nArray[1][n];
                        if (n5 == 2) {
                            if (bl) {
                                n4 = nArray[0][n - 1];
                                break;
                            }
                            n3 = nArray[0][n];
                            bl = true;
                            bl2 = true;
                            this.m_parent.incrementTestCount();
                        } else if (n5 == 4) {
                            if (bl) {
                                n4 = nArray[0][n - 1];
                                break;
                            }
                            n3 = nArray[0][n];
                            bl = true;
                            bl3 = true;
                        } else {
                            if (n5 == 5) {
                                if (!bl3) {
                                    this.printError("Unmatched END_COMMON directive", new Object[0]);
                                    this.m_exit = true;
                                    this.m_error = true;
                                    break;
                                }
                                n4 = nArray[0][n];
                                ++n;
                                break;
                            }
                            if (n5 != 0 && !bl2 && !bl3) {
                                if (bl) {
                                    n4 = nArray[0][n - 1];
                                    break;
                                }
                                n3 = nArray[0][n];
                                bl = true;
                            }
                        }
                        if (n5 == 7 || n5 == 8 || n5 == 13) {
                            this.m_parent.incrementStmtCount();
                        }
                        if (bl2 || n5 == 13) {
                            nArray[1][n] = 0;
                        }
                        ++n;
                    }
                    if (bl && n4 == 0) {
                        n4 = nArray[0][n - 1];
                    }
                    if (this.m_error) {
                        this.m_parent.error(this.m_error);
                    } else {
                        this.m_error = this.m_parent.error();
                    }
                }
                if (!bl || this.m_exit || this.m_error) break;
                blArray[0] = false;
                while (!Thread.currentThread().isInterrupted() && !this.m_exit && n2 < n4) {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        this.m_exit = true;
                        continue;
                    }
                    if (++n2 < n3) continue;
                    if (blArray[0]) {
                        this.printString(">> %s", string);
                    } else {
                        this.printString("> %s", string);
                    }
                    if ((string = string.trim()).length() == 0) continue;
                    this.executeInput(stringBuilder, string, blArray);
                }
            }
            Object var17_16 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {}
    }

    public class ConnectionPool {
        private String m_propertyFile;
        private DataSource m_dataSource;

        private ConnectionPool(String string) {
            this.propertyFile(string);
        }

        private void propertyFile(String string) {
            this.m_propertyFile = string;
            if (this.m_dataSource != null) {
                this.m_dataSource = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection getConnection() throws Exception {
            if (this.m_dataSource == null) {
                ConnectionPool connectionPool = this;
                synchronized (connectionPool) {
                    if (this.m_dataSource == null) {
                        this.createDataSource();
                    }
                }
            }
            return this.m_dataSource.getConnection();
        }

        private void createDataSource() throws Exception {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                Object object;
                String string;
                fileInputStream = new FileInputStream(this.m_propertyFile);
                properties.load(fileInputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = properties.getProperty(string);
                    if (((String)object).charAt(0) != '\"' || ((String)object).charAt(((String)object).length() - 1) != '\"') continue;
                    object = ((String)object).substring(1, ((String)object).length() - 1);
                    properties.setProperty(string, (String)object);
                }
                string = properties.getProperty("factory");
                if (string == null || string.length() == 0) {
                    throw new SQLException("Factory attribute not found in the property file");
                }
                object = Class.forName(string);
                Object t = ((Class)object).newInstance();
                Method method = ((Class)object).getMethod("createDataSource", Properties.class);
                this.m_dataSource = (DataSource)method.invoke(t, properties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Exception(classNotFoundException.getMessage() + " not found.");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new Exception(invocationTargetException.getCause().getMessage());
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private boolean isSame(String string) {
            return string.equals(this.m_propertyFile);
        }
    }
}

