/************** OmniAccess Information API Header file - oainfo.h ************/
/*   This C language header file describes the OmniAccess selection and      */
/*   criteria items for the OmniAccess information routines.                 */
/*                                                                           */
/*                      (c) 1996, Dynamic Information Systems Corporation    */
/*****************************************************************************/
/* All structures in here must be 4-byte aligned:                            */
/* Reason: When someone does an info call, and gets the info structure in    */
/*         memory, they directly reference the structure members.  The ints  */
/*         need to be 4-byte aligned to be accessed.                         */
/*         We use that in most of the oal code.                              */
/*****************************************************************************/

#ifndef OAINFO_H_DEFINED
#define OAINFO_H_DEFINED

#ifdef int32
#undef int32
#endif

#ifdef uint32
#undef uint32
#endif

#if defined (__hpux)
#  define int32    int
#  define uint32   unsigned int
#  define OAINFO_ENDIAN_OPTION_STRING "BIG_ENDIAN"
#elif defined (__osf__)
#  define int32    int
#  define uint32   unsigned int
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#elif defined (__sun)
#  define int32    int
#  define uint32   unsigned int
#  define OAINFO_ENDIAN_OPTION_STRING "BIG_ENDIAN"
#elif defined (_SEQUENT_)
#  define int32    int
#  define uint32   unsigned int
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#elif defined (_AIX)
#  include <sys/types.h>
#  define int32    int
#  define uint32   unsigned int
#  define OAINFO_ENDIAN_OPTION_STRING "BIG_ENDIAN"
#elif defined (i386) || defined(__linux__)
#  define int32    int
#  define uint32   unsigned int
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#elif defined (_WIN32)
#  define int32    int
#  define uint32   unsigned int
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#elif defined (_WINDOWS) || defined (__MSDOS__) || defined (_MSDOS)
#  define int32    long
#  define uint32   unsigned long
#  define OAINFO_ENDIAN_OPTION_STRING "LITTLE_ENDIAN"
#endif

#define OAINFO_VERSION_OPTION_STRING ""   /* no more VERSION OPTION STRING */

/* The following structures may be used if desired for referencing
   arrays of names.  For example, the list of db_names returned by
   an oaenvironmentinfo ALL or DATABASES call.
*/
typedef struct oadbname
{
  char                     name[36];
  char                     full_name[36];
} oadbname_t;

typedef struct oatblname
{
  char                     name[68];
  char                     full_name[108];
} oatblname_t;

typedef struct oacolname
{
  char                     name[36];
} oacolname_t;

typedef struct oaidxname
{
  char                     primary_tbl_name[68];
  char                     primary_tbl_full_name[108];
  char                     name[36];
} oaidxname_t;

/* Note:  Any offset returned in the structures below is relative
   to the beginning of the structure in which it is defined.
   A 0-valued offset indicates the information was not returned,
   either because it was not requested or does not exist.
*/

/* The "oaenv" structure is the base structure used in oaenvironmentinfo.
   It starts at the beginning of the passed buffer.
*/
typedef struct oaenv
{
  int32                    number;
  char                     name[36];
  char                     physical[256];
  char                     node[36];
  char                     title[84];
  char                     version[36];
  char                     ox_version[8];

  int32                    type;
  char                     type_desc[36];  /* Env, Xml, etc. */

  int32                    max_concurrent_connections;
  int32                    max_concurrent_threads;
  uint32                   max_rows_per_tbl;

  char                     scope[36];  /* OA, IA, DA, NA */
  char                     access[36]; /* Read-only, update, exclusive, etc */
  char                     env_access[36]; /* '' */

  char                     user[36];
  char                     password[36];

  int32                    wildcard_any_char;
  int32                    wildcard_single_char;
  int32                    wildcard_single_digit;
  int32                    escape_char;
  int32                    odx_sentinel;

  int32                    interpretation;
  int32                    sql_syntax;
  int32                    century_threshold;
  int32                    preintersect;
  int32                    prep_state;
  int32                    data_cache; /* MB */
  int32                    metadata_cache;
  char                     powersearch[36];

  char                     default_pool[36];
  int32                    default_port;
  int32                    maxthreads;

  int32                    description_offset;
  int32                    description_size;
  int32                    userdata1_offset;
  int32                    userdata1_size;
  int32                    userdata2_offset;
  int32                    userdata2_size;
  int32                    userdata3_offset;
  int32                    userdata3_size;

  int32                    total_size;

  int32                    num_partition_tbls;
  int32                    num_view_tbls;
  int32                    num_rollup_tbls;

  int32                    num_nodes;
  int32                    nodes_offset;
  int32                    node_size; /* == sizeof( struct oaenv_node) */

  int32                    num_segments;
  int32                    segments_offset;
  int32                    segment_size; /* == sizeof( struct oasegment) */

  int32                    num_db_names;
  int32                    db_names_offset;
  int32                    db_name_size; /* == sizeof( struct oadbname) */

} oaenv_t;

/* The "oaenv_node" structure is an optional detail returned from an
   oaenvironmentinfo call when passed the ALL.
   It starts at the address specified by the address of the "oaenv"
   structure plus the "nodes_offset" element of "oaenv".
*/
typedef struct oaenv_node
{
  int32                    number;
  char                     name[36];

  int32                    type;
  char                     type_desc[36];

  char                     connection_string[1024];

  int32                    local;
} oaenv_node_t;

typedef struct oasegment
{
  char                     name[36];
  char                     physical[256];

  char                     primary_tbl_name[68];
  char                     primary_tbl_full_name[108];
  char                     owner_tbl_name[68];
  char                     owner_tbl_full_name[108];

  int32                    persistence;
  char                     persistence_desc[36];

  int32                    purpose;
  char                     purpose_desc[36];

  int32                    format;
  char                     format_desc[36];

  int32                    cardinality;
  int32                    sort_order; /* 'A' = ascending, 'D' = descending, or 0 */
  int32                    reclen;
} oasegment_t;

/* The "oadb" structure is the base structure used in oadatabaseinfo.
   It starts at the beginning of the passed buffer.
*/
typedef struct oadb
{
  int32                    number;
  char                     env_name[36];
  char                     name[36];
  char                     full_name[36];
  char                     physical[256];
  char                     index_prefix[256];
  char                     long_index_prefix[256];
  char                     index_directory[256];
  int32                    system_db;
  int32                    parent_rowids;
  int32                    num_odx_idxs;
  uint32                   checksum;

  int32                    metadata_type;
  char                     metadata_type_desc[36];

  int32                    type;
  char                     type_desc[36];  /* Oracle, Image, etc. */

  int32                    subtype;
  char                     subtype_desc[36];

  int32                    classification;
  char                     classification_desc[36]; /* SQL or Table */

  int32                    access_flag;
  int32                    locking_flag;
  int32                    autopseudocolumns;

  int32                    indexmaintenance;
  char                     indexmaintenance_desc[36];

  char                     version[36];
  char                     def_uclass_user[36];
  char                     def_uclass_password[36];
  int32                    total_size;

  int32                    description_offset;
  int32                    description_size;
  int32                    userdata1_offset;
  int32                    userdata1_size;
  int32                    userdata2_offset;
  int32                    userdata2_size;
  int32                    userdata3_offset;
  int32                    userdata3_size;

  int32                    num_partition_tbls;
  int32                    num_view_tbls;
  int32                    num_rollup_tbls;

  int32                    num_nodes;
  int32                    nodes_offset;
  int32                    node_size; /* == sizeof( struct oadb_node) */

  int32                    num_idx_groups;
  int32                    idx_groups_offset;
  int32                    idx_group_size; /* == sizeof( struct oaidx_group) */

  int32                    num_tbl_names;
  int32                    tbl_names_offset;
  int32                    tbl_name_size; /* == sizeof( struct oatblname) */
} oadb_t;

/* The "oadb_node" structure is an optional detail returned from an
   oadatabaseinfo call when passed the ALL.
   It starts at the address specified by the address of the "oadb"
   structure plus the "nodes_offset" element of "oadb".
*/
typedef struct oadb_node
{
  int32                    node_number;
  char                     node_name[36];

  char                     index_directory[256];

  int32                    type;
  char                     type_desc[36];

  int32                    subtype;
  char                     subtype_desc[36];

  int32                    classification;
  char                     classification_desc[36]; /* SQL or Table */

  char                     version[36];
  char                     user[36];
  char                     password[36];

  char                     physical[256];

  int32                    indexmaintenance;
  char                     indexmaintenance_desc[36];

  int32                    odx_idxs_version;
  int32                    odx_idxs_size; /* in Kbytes */
  char                     odx_idxs_date_installed[24];
} oadb_node_t;


/* The "oaidx_group" structure is an optional detail returned from an
   oadatabaseinfo call when passed the ALL.
   It starts at the address specified by the address of the "oadb"
   structure plus the "idx_groups_offset" element of "oadb".
*/
typedef struct oaidx_group
{
  int32                    number;
  char                     env_name[36];
  char                     db_name[36];
  char                     name[36];

  char                     owner_tbl_name[68];
  char                     owner_tbl_full_name[108];

  char                     master_tbl_name[68];
  char                     master_tbl_full_name[108];
  char                     master_idx_name[36];

  int32                    num_idx_names;
  int32                    idx_names_offset;
  int32                    idx_name_size; /* oaidxname_t */
} oaidx_group_t;


/* The "oatbl" structure is the base structure used in oatableinfo.
   It starts at the beginning of the passed buffer.

   It is also used as an optional detail in oacursorinfo when the
   ALL or TABLE option is passed.
   In this case it starts at the address specified by the address of
   the "oacursor" structure plus the "tbl_offset" element of "oacursor".
*/
typedef struct oatbl
{
  int32                    number;
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[36]; /* table or partition, not table[partition] */
  char                     name[68]; /* table or table[partition] */
  char                     full_name[108];
  char                     options[260];/* added in 3.6 */
  int32                    temporary;   /* new in 3.6,
                                           Values: 0=permanent table
                                                   1=temporary table
                                        */
  int32                    persistence;
  char                     persistence_desc[36];
  int32                    metadata_type;
  char                     metadata_type_desc[36];
  int32                    type;
  char                     type_desc[36]; /* Relational, Indexed, etc */

  int32                    role;
  char                     role_desc[36]; /* Partition, View, etc */

  int32                    record_length;

  int32                    num_key_cols;
  int32                    rowid_datatype;
  int32                    rowid_length;

  int32                    uk_is_seq_asc;      /* 1 if seqential ascending uk */
  int32                    mdk_data_retrieval; /* 1 if MDK useable for data retrvl */
  int32                    ask_data_retrieval; /* 1 if ASK useable for data retrvl */
  int32                    well_behaved_id;    /* 1 if Omnidex ID well behaved */
  int32                    intersected_aggs;   /* 1 if MDK and ASK compatible */
  int32                    intersected_aggs_reason; /* Located in omnidex.env */

  int32                    num_native_cols;  /* non pseudo-columns */
  int32                    native_record_length;

  int32                    odx_installed; /* non-zero if any Omnidex MDK or ASK
                              indexes were installed, or if table is part of an
                              MDK domain through a link field */
  int32                    odx_record_length;
  int32                    odx_differs; /* non-zero if any columns have
                              different Omnidex datatypes or lengths */
  int32                    odx_table_type;
  char                     odx_table_type_desc[36]; /* Possible values:
                              IDSI, TR, or TRR for MDK parents;
                              CHILD for linked child, DR for unlinked child,
                              HYBRID_DR for linked and $DR child,
                              ASK for ASK-only installations, or
                              NONE when no Omnidex was installed. */
  int32                    rec_installed; /* non-zero if ;REC option used in
                              ASK installation */

  uint32                   cardinality;

  int32                    indexmaintenance;
  char                     indexmaintenance_desc[36];
  int32                    data_caching;
  char                     data_caching_desc[36];

  int32                    total_native_idxs;
  int32                    total_mdk_idxs; /* subset of total_mdkdomain_idxs */
  int32                    total_mdkdomain_idxs;
  int32                    total_ask_idxs;

  int32                    total_size;

  int32                    num_nodes;
  int32                    nodes_offset;
  int32                    node_size; /* == sizeof( struct oatbl_node) */

  int32                    num_consts;
  int32                    consts_offset;
  int32                    const_size; /* == sizeof( struct oaconst) */

  int32                    num_parent_tbl_names;
  int32                    parent_tbl_names_offset;
  int32                    parent_tbl_name_size;/* ==sizeof(struct oatblname) */

  int32                    num_child_tbl_names;
  int32                    child_tbl_names_offset;
  int32                    child_tbl_name_size;/* == sizeof(struct oatblname) */

  /* Future enhancement:  add flag for whether it's basic or regular cols */
  int32                    num_cols;
  int32                    cols_offset;
  int32                    col_size; /* == sizeof( struct oacol) or
                                           sizeof( struct oabasic_col) */

  int32                    num_idxs; /* if any subset of indexes are requested,
                              this is the actual number returned; otherwise,
                              it is the total number of indexes that would be
                              returned with an "INDEXES" option. */
  int32                    idxs_offset;
  int32                    idx_size; /* == sizeof( struct oaidx) */

  int32                    physical_offset;
  int32                    physical_size;

  int32                    partition_offset;
  int32                    partition_size;

  int32                    view_flag;     /* Set to 1 if there is an AS
                                             clause, 0 otherwise.
                                             This way we can check in
                                             advance to see if we need to
                                             get the AS clause.
                                             Obselete - check role or
                                             as_table_offset instead.
                                          */
  int32                    as_table_offset;
  int32                    as_table_size;

  int32                    autofilter_offset;
  int32                    autofilter_size;

  int32                    xmltag_offset;
  int32                    xmltag_size;

  int32                    xmldtd_offset;
  int32                    xmldtd_size;

  int32                    xmloptions_offset;
  int32                    xmloptions_size;

  int32                    description_offset;
  int32                    description_size;
  int32                    userdata1_offset;
  int32                    userdata1_size;
  int32                    userdata2_offset;
  int32                    userdata2_size;
  int32                    userdata3_offset;
  int32                    userdata3_size;

  int32                    num_view_tbl_names;
  int32                    view_tbl_names_offset;
  int32                    view_tbl_name_size;/* ==sizeof(struct oatblname) */

  int32                    num_source_tbl_names;
  int32                    source_tbl_names_offset;
  int32                    source_tbl_name_size;/* ==sizeof(struct oatblname) */
} oatbl_t;


/* The "oatbl_node" structure is an optional detail returned from an
   oatableinfo call when passed the ALL option.
   It starts at the address specified by the address of the "oatbl"
   structure plus the "nodes_offset" element of "oatbl".
*/
typedef struct oatbl_node
{
  int32                    node_number;
  char                     node_name[36];

  int32                    physical_offset;
  int32                    physical_size;

  int32                    partition_offset;
  int32                    partition_size;

  char                     options[260];

  int32                    table_type;
  char                     table_type_desc[36];

  int32                    file_size; /* in Kbytes */
  uint32                   cardinality;
  char                     date_modified[24];

  int32                    indexmaintenance;
  char                     indexmaintenance_desc[36];
  int32                    data_caching;
  char                     data_caching_desc[36];

  int32                    partitioned;
  int32                    unindexed;

  int32                    autofilter_offset;
  int32                    autofilter_size;
} oatbl_node_t;


/* The "oaconst" structure is an optional detail returned from an
   oatableinfo call when passed the ALL or CONSTRAINTS option.
   It starts at the address specified by the address of the "oatbl"
   structure plus the "consts_offset" element of "oatbl".

   It is also part of the "oaidx" structure, occurring directly within
   the "oaidx".
*/
typedef struct oaconst
{
  int32                    number;
  char                     name[36];

  int32                    type;
  char                     type_desc[36];

  int32                    ref_const;  /* if this is a foreign key const. */
  char                     ref_tbl_name[68];
  char                     ref_tbl_full_name[108];
  int32                    odx_domain_type;
  char                     odx_domain_type_desc[36];
  int32                    idx_no; /* offset into the array of oaidx_t
                                      described in oatbl_t */

  int32                    num_col_names;
  int32                    col_names_offset;
  int32                    col_name_size; /* oacolname_t */
} oaconst_t;


/* The "oacols" structure is the base structure used in oacolumlistinfo.
   It starts at the beginning of the passed buffer.
*/
typedef struct oacols
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     tbl_full_name[108];

  char                     collist[1024]; /* list of passed columns */

  int32                    total_size;

  int32                    fetch_bufflen;
  int32                    fetch_char_bufflen; /* This represents the
                           length of the buffer on a CHAR update or select.
                           If the CHAR=n option is passed to oacolumnlistinfo,
                           "n" is used instead of the default. */
  int32                    fetch_cstring_bufflen; /* This represents the
                           length of the buffer on a C_STRING update or select.
                           If the C_STRING=n option is passed to oacolumnlistinfo
                           "n" is used instead of the default. */

  /* Future enhancement:  add flag for whether it's basic or regular cols */
  int32                    num_cols;
  int32                    cols_offset;
  int32                    col_size;
} oacols_t;


/* The "oacol_node" structure is an optional detail returned from an
   oatableinfo or oacolumnlistinfo call when passed the STATISTICS option.
   It starts at the address specified by the address of the "oacol"
   structure plus the "nodes_offset" element of "oacol".
*/
typedef struct oacol_node
{
  int32                    node_number;
  char                     node_name[36];

  uint32                   cardinality;
  char                     cardinality_type[36];
} oacol_node_t;


/* The "oacol" structure is an optional detail returned from an
   oatableinfo call when passed the ALL or COLUMNS option.
   It starts at the address specified by the address of the "oatbl"
   structure plus the "cols_offset" element of "oatbl".

   It is also an optional detail returned from an oacolumnlistinfo call
   when passed the ALL or COLUMNS option.
   It starts at the address specified by the address of the "oacols"
   structure plus the "cols_offset" element of "oacols".
*/
typedef struct oacol
{
  int32                    number;
  char                     name[36];

  int32                    type;
  char                     type_desc[36];

  char                     physical[256];

  uint32                   cardinality;
  char                     cardinality_type[36];

  int32                    datatype;
  char                     datatype_desc[36];

  int32                    length;
  int32                    offset;
  int32                    occurs;
  int32                    scale;
  int32                    precision;
  int32                    usage;
  char                     usage_desc[36];
  char                     options[36];
  char                     format[36];

  int32                    native_offset;

  int32                    odx_datatype;
  char                     odx_datatype_desc[36];
  int32                    odx_length;
  int32                    odx_offset;
  int32                    odx_occurs;
  int32                    odx_scale;
  int32                    odx_precision;
  char                     odx_options[36];
  char                     odx_format[36];

  int32                    ext_datatype;
  char                     ext_datatype_desc[36];
  int32                    ext_length;
  int32                    ext_offset;
  int32                    ext_occurs;
  int32                    ext_scale;
  int32                    ext_precision;
  int32                    ext_usage;
  char                     ext_usage_desc[36];
  char                     ext_options[36];
  char                     ext_format[36];

  char                     prompt[36];
  char                     heading[36];
  char                     label[36];

  int32                    century_threshold;

  int32                    num_simple_mdk_keys;
  int32                    num_simple_ask_keys;
  int32                    num_simple_native_keys;
  int32                    num_composite_mdk_keys;
  int32                    num_composite_ask_keys;
  int32                    num_composite_native_keys;

  int32                    sql_select_offset;
  int32                    sql_select_size;

  int32                    sql_insert_offset;
  int32                    sql_insert_size;

  int32                    as_column_offset;    /* pseudo-column */
  int32                    as_column_size;

  int32                    forms;
  int32                    forms_offset;
  int32                    forms_size;

  int32                    synonyms;
  int32                    synonyms_offset;
  int32                    synonyms_size;

  int32                    stopwords;
  int32                    stopwords_offset;
  int32                    stopwords_size;

  int32                    spellcheck;
  int32                    spellcheck_offset;
  int32                    spellcheck_size;

  int32                    phonetic;
  int32                    phonetic_offset;
  int32                    phonetic_size;

  int32                    misspellings;
  int32                    misspellings_offset;
  int32                    misspellings_size;

  int32                    included_tags_offset;
  int32                    included_tags_size;

  int32                    excluded_tags_offset;
  int32                    excluded_tags_size;

  int32                    unique_tags;

  int32                    xmltag_offset;
  int32                    xmltag_size;

  int32                    xmloptions_offset;
  int32                    xmloptions_size;

  int32                    proximity_offset;
  int32                    proximity_size;

  int32                    description_offset;
  int32                    description_size;
  int32                    userdata1_offset;
  int32                    userdata1_size;
  int32                    userdata2_offset;
  int32                    userdata2_size;
  int32                    userdata3_offset;
  int32                    userdata3_size;

  int32                    num_nodes;
  int32                    nodes_offset;
  int32                    node_size; /* == sizeof( struct oacol_node) */
} oacol_t;

/* The "oabasic_col" structure is an optional detail returned from an
   oatableinfo call when passed the ALL or COLUMNS option and the BASIC_COLUMNS
   option.
   It starts at the address specified by the address of the "oatbl"
   structure plus the "cols_offset" element of "oatbl".

   It is also an optional detail returned from an oacolumnlistinfo call
   when passed the ALL or COLUMNS option and the BASIC_COLUMNS option.
   It starts at the address specified by the address of the "oacols"
   structure plus the "cols_offset" element of "oacols".
*/
typedef struct oabasic_col
{
  int32                    number;
  char                     name[36];

  int32                    type;
  char                     type_desc[36];

  uint32                   cardinality;

  int32                    datatype;
  char                     datatype_desc[36];

  int32                    length;
  int32                    offset;
  int32                    occurs;
  int32                    scale;
  int32                    precision;
  int32                    usage;
  char                     usage_desc[36];
  char                     options[36];
  char                     format[36];

  int32                    native_offset;

  int32                    odx_datatype;
  char                     odx_datatype_desc[36];
  int32                    odx_length;
  int32                    odx_offset;
  int32                    odx_occurs;
  int32                    odx_scale;
  int32                    odx_precision;
  char                     odx_options[36];
  char                     odx_format[36];

  int32                    ext_datatype;
  char                     ext_datatype_desc[36];
  int32                    ext_length;
  int32                    ext_offset;
  int32                    ext_occurs;
  int32                    ext_scale;
  int32                    ext_precision;
  int32                    ext_usage;
  char                     ext_usage_desc[36];
  char                     ext_options[36];
  char                     ext_format[36];

  int32                    num_simple_mdk_keys;
  int32                    num_simple_ask_keys;
  int32                    num_simple_native_keys;
  int32                    num_composite_mdk_keys;
  int32                    num_composite_ask_keys;
  int32                    num_composite_native_keys;
} oabasic_col_t;

/* The "oaidxs" structure is the base structure used in oaindexinfo.
   It starts at the beginning of the passed buffer.
*/

typedef struct oaidxs
{
  char                     env_name[36];
  char                     db_name[36];

  int32                    num_native_idxs;
  int32                    num_mdk_idxs;
  int32                    num_ask_idxs;

  int32                    total_size;

  int32                    num_idxs;
  int32                    idxs_offset;
  int32                    idx_size;
} oaidxs_t;


/* The "oaidx" structure is an optional detail returned from an
   oatableinfo call when passed the ALL, INDEXES, NATIVE, MDK,
   MDKDOMAIN, or ASK option.
   It starts at the address specified by the address of the "oatbl"
   structure plus the "idxs_offset" element of "oatbl".

   It is also an optional detail returned from oacursorinfo when
   passed the ALL or INDEX option.
   In this case it starts at the address specified by the address of
   the "oacursor" structure plus the "idx_offset" element of "oacursor".
*/
typedef struct oaidx
{
  int32                    number;
  char                     name[36];
  int32                    type;
  char                     type_desc[36];   /* NATIVE, BASIC, CUSTOM, etc */
  int32                    method;
  char                     method_desc[36]; /* NATIVE, MDK, ASK */
  int32                    odx_domain_type;
  char                     odx_domain_type_desc[36];
  char                     prompt[36];
  char                     physical[256];

  int32                    field_number;
  int32                    primary_tbl_number;
  char                     primary_tbl_name[68];
  char                     primary_tbl_full_name[108];
  int32                    primary_odx_table_type;
  int32                    owner_tbl_number;
  char                     owner_tbl_name[68];
  char                     owner_tbl_full_name[108];
  int32                    owner_odx_table_type;
  oaconst_t                odxsi;
  int32                    rowid_available;
  int32                    master_search_item;
  int32                    implicit;

  int32                    dataclass;
  char                     dataclass_desc[36];

  int32                    length;

  uint32                   cardinality;
  uint32                   total_entries;
  uint32                   num_searches;

  /* The following are all flags:  0 means false, non-zero means true. */
  int32                    sorted;
  int32                    composite;
  int32                    excluded_words;
  int32                    translate;
  int32                    parsed;
  int32                    soundex;
  int32                    synonym;
  int32                    plurality;
  int32                    typecasting;
  int32                    record_complex;
  int32                    record_specific;
  int32                    blob;              /* ;bb option in dbinstal */
  int32                    batch_indexing;
  int32                    unique;
  int32                    bitmap;            /* ;bm */
  int32                    proximity;         /* ;px */
  int32                    external_indexing; /* ;ex */
  int32                    distributed_index; /* ;di */
  int32                    retrieval_key;     /* ;rk */
  /* end flag section */

  char                     optimization[256];
  int32                    intersected_aggs;
  int32                    intersected_aggs_reason;

  int32                    group_number;
  char                     group_name[36];
  int32                    group_master_tbl_number;
  char                     group_master_tbl_name[68];
  char                     group_master_tbl_full_name[108];
  int32                    group_master_idx_number;
  char                     group_master_idx_name[36];

  int32                    num_idx_components;
  int32                    idx_components_offset;
  int32                    idx_component_size;

  int32                    num_nodes;
  int32                    nodes_offset;
  int32                    node_size; /* == sizeof( struct oaidx_node) */
} oaidx_t;


/* The "oaidx_node" structure is an optional detail returned from an
   oatableinfo call when passed the STATISTICS option.

   It starts at the address specified by the address of the "oaidx"
   structure plus the "nodes_offset" element of "oaidx".
*/
typedef struct oaidx_node
{
  int32                    node_number;
  char                     node_name[36];

  int32                    index_size; /* in Kbytes */
  char                     index_filename[256];

  uint32                   cardinality;
  uint32                   total_entries;
  uint32                   num_searches;
  char                     date_built[24];
  char                     state[36];
} oaidx_node_t;


/* The "oaidx_component" structure is present whenever the "oaidx"
   is present.
   It starts at the address specified by the address of the "oaidx" plus
   the "idx_components_offset" element of "oaidx".
*/
typedef struct oaidx_component
{
  int32                    number;
  int32                    type;
  char                     type_desc[36];
  int32                    start_byte;
  int32                    length;
  int32                    idx_offset;
  int32                    datatype;
  char                     datatype_desc[36];
  int32                    typecasting;
  int32                    tbl_number;
  char                     tbl_name[68];
  char                     tbl_full_name[108];
  int32                    col_number;
  char                     col_name[36];
} oaidx_component_t;



/* The "oacursor" structure is the base structure used in oacursorinfo.
   It starts at the beginning of the buffer.
*/
typedef struct oacursor
{
  int32                    instance;
  char                     scope[36];
  char                     access[36];

  char                     requested_optimization[256];
  char                     required_optimization[256];

  int32                    total_size;

  int32                    most_recent_count;
  int32                    count_up_to_date;

  int32                    cursor_state;
  char                     cursor_state_desc[36];
  int32                    explain_function; /* OAFUNCTION_ #define */

  int32                    escape_char; /* 0 if disabled */
  int32                    sql_syntax;

  /* The select_list elements reference oaselect_list_t structures identical
     to oadescribe.  These are used to describe both FETCH and FETCHKEYS
     buffers */
  int32                    num_select_list;
  int32                    select_list_offset;
  int32                    select_list_size;
  int32                    bufflen;  /* Length of buffer to be returned */

  int32                    idx_offset; /* Index used (qualify/join) */
  int32                    cur_idx_offset; /* Current index of cursor */

  /* The summary structure outlines a SELECT statement */
  int32                    summary_offset;


  /* The new DETAIL section replaces/combines the old qualification and retrieval sections */
  int32                    num_detail_items;
  int32                    detail_items_offset;
  int32                    detail_item_size;


  int32                    select_profile_offset;

  int32                    notes_offset;
  int32                    notes_size;
  /* notes is a char string of length notes_size describing
     certain optimization decisions */

  int32                    addin_explain_only;
  /* addin_explain_only is set to 1 if the addin pre-processes the SQL and
     performs multiple selects, therefore regular explain is not available */

  int32                    addin_notes_offset;
  int32                    addin_notes_size;
  /* addin_notes is a char string of length addin_notes_size describing
     addin pre-process steps. */
} oacursor_t;


/* auxiliary structures */
typedef struct oatbl_alias
{
  char                     tbl_name[68];
  char                     alias[36];
} oatbl_alias_t;

typedef struct oafilter
{
  char                     filter[256];
} oafilter_t;

typedef struct oadata_item
{
  char                     description[128];
  char                     alias[36]; /* for RETURN_DATA */
} oadata_item_t;

typedef struct oasort_item
{
  char                     description[128];
  int32                    sort_order; /* 'A' = ascending, 'D' = descending */
} oasort_item_t;

typedef struct oafilename
{
  char                     filename[256];
} oafilename_t;

typedef struct oaqueuename
{
  char                     queuename[36];
} oaqueuename_t;


/* aggregation can only use simple column names, not expressions:
   SUM(COL1) is ok, but not SUM(COL1 * COL2 / 100) */
/* Note that a GROUP implies an ORDER.  If both GROUP and ORDER were requested
   on the same column, only the GROUP will show up.   ORDERs on non-group
   columns are handled outside of the aggregation index step. */
typedef struct oaaggregation
{
  char                     operation[8]; /* SUM, AVG, MIN, MAX, COUNT, GROUP */
  int32                    distinct;     /* is this a COUNT(distinct col) ? */
  char                     col_name[36];
  int32                    offset;
  int32                    length;
} oaaggregation_t;

/* Used in oacsr_create_tbl */
typedef struct oacreate_col
{
  char                     name[36];
  int32                    datatype;
  char                     datatype_desc[36];
  int32                    length;
} oacreate_col_t;



typedef struct oacsr_join_col
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     col_name[36];
} oacsr_join_col_t;

typedef struct oacsr_criteria_col
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     col_name[36];
} oacsr_criteria_col_t;

typedef struct oacsr_groupby_col
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     col_name[36];
  int                      select_item;
} oacsr_groupby_col_t;

typedef struct oacsr_having_col
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     col_name[36];
  int                      select_item;
} oacsr_having_col_t;

#define OA_DIRECTION_ASCENDING  1
#define OA_DIRECTION_DESCENDING 2
typedef struct oacsr_orderby_col
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     col_name[36];
  int                      select_item;
  int                      direction;
  int                      unique;
} oacsr_orderby_col_t;

typedef struct oacsr_tbl
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
} oacsr_tbl_t;

/* SELECT PROFILE option */
typedef struct oacsr_sel_profile
{
  /* The tbls structures are used to describe the tables of a SELECT
     statement.  This uses oacsr_tbl_t. */
  int32                    num_tbls;
  int32                    tbls_offset;
  int32                    tbl_size;

  /* The join columns structures are used to describe the columns used in
     join clauses or predicates of a SELECT statement.
     This uses oacsr_join_col_t */
  int32                    num_join_cols;
  int32                    join_cols_offset;
  int32                    join_col_size;

  /* The criteria columns structures are used to describe the columns used in
     criteria predicates of a SELECT statement. This uses oacsr_criteria_col_t*/
  int32                    num_criteria_cols;
  int32                    criteria_cols_offset;
  int32                    criteria_col_size;

  /* The groupby structures are used to describe the GROUP BY elements
     of a SELECT statement. This uses oacsr_groupby_col_t */
  int32                    num_groupby_cols;
  int32                    groupby_cols_offset;
  int32                    groupby_col_size;

  /* The having structures are used to describe the HAVING elements
     of a SELECT statement. This uses oacsr_having_col_t */
  int32                    num_having_cols;
  int32                    having_cols_offset;
  int32                    having_col_size;

  /* The orderby structures are used to describe the ORDER BY elements
     of a SELECT statement. This uses oacsr_orderby_col_t */
  int32                    num_orderby_cols;
  int32                    orderby_cols_offset;
  int32                    orderby_col_size;
} oacsr_sel_profile_t;


typedef struct oacsr_summary
{
  /* The original sql statement: */
  int32                    sql_stmt_function; /* OAFUNCTION_ #define for statement */
  int32                    sql_stmt_offset;
  int32                    sql_stmt_size;
  /* then the sql stmt is just a char string of length sql_stmt_size */

  int32                    text_offset;
  int32                    text_size;

  /* The requested optimization options for this select */
  char                     requested_optimization[260];

  /* The REQUIRED_OPTIMIZATION options for this select */
  char                     required_optimization[260];

  /* The actual optimizations used for this select */
  char                     actual_optimization[260];

  /* The into structures describe a SELECT ... INTO table clause */
  char                     into_env_name[36];
  char                     into_db_name[36];
  char                     into_tbl_name[68];
  char                     into_physical[256];

#define OA_VALUES_BUFFER       1
#define OA_VALUES_COLUMN       2

  int32                    expected_count; /* after where_clause optimization */
  int32                    count_is_reliable;
  int32                    values_type;
  int32                    multiple_cursors;

#define OA_USER_EXPLAIN_ONLY   1
#define OA_FORCED_EXPLAIN_ONLY 2

  /* Flags indicating reasons for unreliable counts */
  int32                    explain_only; /* No actual qualifies were done */
  int32                    multiple_tables;
  int32                    having_clause;
  /* Next three also indicate potentially slow query */
  int32                    xref_files; /* cross-reference file(s) involved */
  int32                    unoptimized_criteria;
  int32                    cartesian_product;

  /* Flags indicating reasons for potentially slow queries: */
  int32                    unoptimized_aggregation; /* Not using agg index */
  int32                    unoptimized_sort;  /* Order by, group by, distinct*/
  int32                    sequential_scan;   /* Serial read on table(s) */
  int32                    sequential_table_join; /* No index on table join */

} oacsr_summary_t;



/* DETAIL option */

typedef struct oacsr_build_xref
{
  int32                    cursor;
  char                     options[260];
  char                     xref_filename[256];

  int32                    current_odxid_list;
  int32                    num_export_files;
  int32                    export_files_offset;
  int32                    export_file_size; /* oafilename_t */
} oacsr_build_xref_t;

typedef struct oacsr_export
{
  int32                    cursor;
  char                     options[260];
  char                     filename[256];

  int32                    function; /* OAFUNCTION_ #define for statement */
  int32                    odx_list_type; /* OA_ODX_TYPE_... */
  int32                    segment;
  char                     segment_type_desc[36];

  /* For a DATA export, this was the select: */
  char                     select_options[260];
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  /* The column(s) selected for export: */
  int32                    num_cols;
  int32                    cols_offset;
  int32                    col_size; /* oacolname_t */
} oacsr_export_t;

typedef struct oacsr_join
{
  int32                    cursor;
  char                     options[260];
  char                     from_env_name[36];
  char                     from_db_name[36];
  char                     from_tbl_name[68];
  char                     to_owner_tbl_name[68];
  char                     to_nature_tbl_name[68];
  char                     to_env_name[36];
  char                     to_db_name[36];
  char                     to_tbl_name[68];
  char                     to_idx_name[36];

  int32                    parent_count;
  int32                    preintersect_count;
  int32                    odx_list_type;

  int32                    num_from_cols;
  int32                    from_cols_offset;
  int32                    from_col_size; /* oacolname_t */
  int32                    num_to_cols;
  int32                    to_cols_offset;
  int32                    to_col_size; /* oacolname_t */
} oacsr_join_t;

/* When joining tables using an ASK key (native key unavailable), a qualify
   is done for each join value; the criteria shows the table.column
   that we're joining from, if that's the case.  */
#define OACSR_CRITERIA_LITERAL   1
#define OACSR_CRITERIA_COLUMN    2
#define OACSR_CRITERIA_OTHER     3
#define OA_QUALIFY_MODE_PARSER   1
#define OA_QUALIFY_MODE_ODXFIND  2
#define OA_QUALIFY_MODE_OX_FIND  3
typedef struct oacsr_qualify
{
  int32                    cursor;
  char                     options[260];
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     owner_tbl_name[68];
  char                     nature_tbl_name[68];
  char                     idx_name[36];

  int32                    parent_count;
  int32                    preintersect_count;
  int32                    idx_type; /* OA_INDEXTYPE_OMNIDEX_MDK, ..._ASK, ...*/
  int32                    odx_list_type; /* OA_ODX_TYPE_... */
  int32                    user_filenames;
  int32                    qualify_mode;
  int32                    odxlink;

  int32                    criteria_type;
  int32                    criteria_offset;
  int32                    criteria_size;

  int32                    text_offset;
  int32                    text_size;
} oacsr_qualify_t;

typedef struct oacsr_sample_key
{
  int32                    cursor;

  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];

  int32                    quantity;
  int32                    sort_order; /* 'A' = ascending, 'D' = descending, or 0 */

  int32                    num_idx_names;
  int32                    idx_names_offset;
  int32                    idx_name_size; /* oaidxname_t */

  int32                    num_aggregations;
  int32                    aggregations_offset;
  int32                    aggregation_size; /* oaaggregation_t */
} oacsr_sample_key_t;


/* ASK-optimized aggregations, groups, etc. */
typedef struct oacsr_aggregation_index
{
  int32                    cursor;

  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];

  int32                    odx_list_type; /* OA_ODX_TYPE_... */
  int32                    alt_sort; /* are the columns grouped in a
                                        different order than installed? */
  int32                    sort_order; /* 'A' = ascending, 'D' = descending, or 0 */

  int32                    num_idx_names;
  int32                    idx_names_offset;
  int32                    idx_name_size; /* oaidxname_t */

  int32                    num_aggregations;
  int32                    aggregations_offset;
  int32                    aggregation_size; /* oaaggregation_t */

  /* ASK-optimized "having" clauses.
     Note: more than 1 "having" indicates implied "AND" */
  int32                    num_havings;
  int32                    havings_offset;
  int32                    having_size; /* oafilter_t */

  /* Partitioned-qualify columns */
  int32                    num_pq_columns;
  int32                    pq_columns_offset;
  int32                    pq_columns_size; /* oacolname_t */

  int32                    pq_values_offset;
  int32                    pq_values_size;
} oacsr_aggregation_index_t;


typedef struct oacsr_ask_retrieval
{
  int32                    cursor;

  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];

  int32                    odx_list_type; /* OA_ODX_TYPE_... */
  int32                    at_a_time;
  int32                    sort_order; /* 'A' = ascending, 'D' = descending, or 0 */

  int32                    num_idx_names;
  int32                    idx_names_offset;
  int32                    idx_name_size; /* oaidxname_t */

  /* The column(s) brought back by oafetchkeys */
  int32                    num_cols;
  int32                    cols_offset;
  int32                    col_size; /* oacolname_t */

  int32                    num_pq_columns;
  int32                    pq_columns_offset;
  int32                    pq_columns_size; /* oacolname_t */

  int32                    pq_values_offset;
  int32                    pq_values_size;

  char                     skip_rlm_options[36];
} oacsr_ask_retrieval_t;


typedef struct oacsr_build_cache
{
  int32                    cursor;

  char                     tbl_name[68];
  char                     alias[36];

  int32                    sql_stmt_offset;
  int32                    sql_stmt_size;
} oacsr_build_cache_t;


/* Describes table created on a "select col_list INTO .." */
typedef struct oacsr_create_tbl
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     physical[256];
  int32                    num_create_cols;
  int32                    create_cols_offset;
  int32                    create_col_size;
} oacsr_create_tbl_t;


typedef struct oacsr_fetchkeys
{
  int32                    cursor;
  char                     options[36];

  int32                    odx_list_type; /* OA_ODX_TYPE_... */
  int32                    at_a_time;
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];

  int32                    sort_order; /* 'A' = ascending, 'D' = descending, or 0 */
  char                     order_by_idx_name[36]; /* ASKORDERBY optimization */

  /* The column(s) brought back by oafetchkeys */
  int32                    num_cols;
  int32                    cols_offset;
  int32                    col_size; /* oacolname_t */

  char                     skip_rlm_options[36];
} oacsr_fetchkeys_t;


typedef struct oacsr_filter_row
{
  int32                    else_NULLs; /* if no matches with any row, return row of NULLs for outer join, etc */
  int32                    num_filters;
  int32                    filters_offset;
  int32                    filter_size; /* oafilter_t */
} oacsr_filter_row_t;


/* Describes table insert for a "select col_list INTO .." */
typedef struct oacsr_insert
{
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  int32                    num_data_items;
  int32                    data_items_offset;
  int32                    data_item_size; /* oadata_item_t */
} oacsr_insert_t;


/* Lists data items inserted into a queue for later processing */
typedef struct oacsr_pass_to_queue
{
  char                     queue_name[36];

  int32                    rows_per_call; /* how many passed at a time? */

  int32                    num_data_items;
  int32                    data_items_offset;
  int32                    data_item_size; /* oadata_item_t */
} oacsr_pass_to_queue_t;


/* "xref" is a "cross-reference file" created when multiple omnidex-able
   filters cannot be combined into a single odxid list.  */
typedef struct oacsr_read_xref
{
  char                     xref_filename[256];
  int32                    sequential; /* 1 or 0 */
  char                     search_value[68]; /* blank if sequential is 1 */
  char                     retrieved_value[68];
} oacsr_read_xref_t;


#define OAMETHOD_SEQUENTIAL 1
#define OAMETHOD_INDEXED    2
#define OAMETHOD_ROWID      3

typedef struct oacsr_retrieve_row
{
  char                     env_name[36];
  char                     db_name[36]; /* each new db must have its own step */

  int32                    num_tbls;
  int32                    tbls_offset;
  int32                    tbl_size; /* oatbl_alias_t */

  int32                    else_NULLs; /* return row of NULLs if no match -- for outer join, etc */

  /* use db_class to decide which struct of "details" to reference */
  int32                    db_class; /* OA_DATABASECLASS_SQL, _TABLE */
  union
  {
     struct
     {
        /* For TABLE databases: */
        /* Access describes how we get a row from the table:  could be
           sequential, indexed, or by rowid. */
        int32              access_method;
        char               access_method_desc[36];
        char               access_idx_name[36]; /* if access_method is INDEXED */
        char               access_operator[8];  /* =, <, >=, BETWEEN, etc */
        int32              access_value_offset; /* could be list of columns */
        int32              access_value_size;
     } table_db;
     struct
     {
        /* for SQL databases: */
        /* sql_stmt is a character string of length "sql_stmt_size" */
        int32              sql_stmt_offset; /* relative to retrieval_step */
        int32              sql_stmt_size;
        /* Is the native database handling . . . */
        int32              distinct;
        int32              aggregation;
        int32              table_join;
        int32              filters;
        int32              group_by;
        int32              order_by;
        int32              having;
     } sql_db;
  } details;
} oacsr_retrieve_row_t;

/* Lists select items returned to user: */
typedef struct oacsr_return_data
{
  char                     select_modifier[64]; /* TOP/SKIP/RANDOM/EVERY */
  int32                    num_data_items;
  int32                    data_items_offset;
  int32                    data_item_size; /* oadata_item_t */
} oacsr_return_data_t;

/* reasons for sorting: */
#define OACSR_GROUP_SORT                    1
#define OACSR_ORDER_SORT                    2
#define OACSR_DISTINCT_SORT                 3
#define OACSR_MERGE_SORT                    4
#define OACSR_QUALIFY_SORT                  5
typedef struct oacsr_sort
{
  int32                    sort_type;  /* GROUP, ORDER, DISTINCT, MERGE, QUALIFY */
  char                     sort_type_desc[36];
  char                     queue_name[36];

  int32                    sort_by_all;
  int32                    memcmp_option;

  /* The table is sorted in the order of the sort items.  Note the table could
     have more columns that are used as data but not as sort items. */
  int32                    num_sort_items;
  int32                    sort_items_offset;
  int32                    sort_item_size; /* oasort_item_t */
} oacsr_sort_t;

/* oacsr_sorted_merge.type: */
#define OACSR_MERGETYPE_UNION               1
#define OACSR_MERGETYPE_UNION_ALL           2
#define OACSR_MERGETYPE_INTERSECT           3
#define OACSR_MERGETYPE_INTERSECT_ALL       4
#define OACSR_MERGETYPE_EXCEPT              5
#define OACSR_MERGETYPE_EXCEPT_ALL          6
#define OACSR_MERGETYPE_JOIN                7
#define OACSR_MERGETYPE_LEFT_JOIN           8
/* The following not yet implemented in oa: */
#define OACSR_MERGETYPE_RIGHT_JOIN          9
#define OACSR_MERGETYPE_FULL_JOIN           10

/* oacsr_sorted_merge.destination: */
#define OACSR_MERGEDEST_MERGE                1
#define OACSR_MERGEDEST_INTERMEDIATE_BUFFER  2
#define OACSR_MERGEDEST_USER_BUFFER          3
#define OACSR_MERGEDEST_TABLE                4


typedef struct oacsr_sorted_merge
{
  int32                    type; /* union, union_all, intersect, etc. */
  char                     type_desc[36];
  int32                    memcmp_option;

  int32                    num_queues;
  int32                    queues_offset;
  int32                    queue_size; /* oaqueuename_t */

  int32                    destination;
  char                     dest_desc[36];
} oacsr_sorted_merge_t;

typedef struct oacsr_subquery
{
  int32                    subquery_num; /* number from left to right */
  char                     select_modifier[64]; /* TOP/SKIP/RANDOM/EVERY */
} oacsr_subquery_t;

typedef struct oacsr_ox_find
{
  int32                    cursor;
  char                     options[260];
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     owner_tbl_name[68];
  char                     nature_tbl_name[68];
  char                     idx_name[36];

  int32                    parent_count;
  int32                    preintersect_count;
  int32                    odx_list_type; /* OA_ODX_TYPE_... */
  int32                    user_filenames;
  int32                    show_idx;

  int32                    criteria_offset;
  int32                    criteria_size;
} oacsr_ox_find_t;

typedef struct oacsr_ox_get
{
  int32                    cursor;
  char                     options[260];
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     owner_tbl_name[68];
  char                     idx_name[36];

  int32                    odxidsi;
  int32                    sort_order;
} oacsr_ox_get_t;

typedef struct oacsr_ox_getkeys
{
  int32                    cursor;
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];

  int32                    fetchkeys;
  int32                    show_idx;

  int32                    num_idx_names;
  int32                    idx_names_offset;
  int32                    idx_name_size; /* oaidxname_t */

  int32                    options_offset;
  int32                    options_size;

  int32                    criteria_offset;
  int32                    criteria_size;
} oacsr_ox_getkeys_t;

typedef struct oacsr_ox_getword
{
  int32                    cursor;
  char                     options[260];
  char                     filename[256];
  char                     env_name[36];
  char                     db_name[36];
  char                     tbl_name[68];
  char                     owner_tbl_name[68];
  char                     idx_name[36];

  int32                    fetchkeys;
  int32                    num_file_args;
} oacsr_ox_getword_t;

typedef struct oacsr_ox_transfer
{
  int32                    cursor;
  char                     options[260];
  char                     filename[256];

  int32                    odx_list_type; /* OA_ODX_TYPE_... */
} oacsr_ox_transfer_t;

/* oacsr_detail_item.type */
#define OACSR_QUALIFY          1
#define OACSR_JOIN             2
#define OACSR_EXPORT           3
#define OACSR_BUILD_XREF       4
#define OACSR_FETCHKEYS        5
#define OACSR_READ_XREF        6
#define OACSR_RETRIEVE_ROW     7
#define OACSR_FILTER_ROW       8
#define OACSR_SORT             9
#define OACSR_AGG_IDX          10
#define OACSR_ASK_RETRIEVAL    11
#define OACSR_RETURN_DATA      12
#define OACSR_PASS_TO_QUEUE    13
#define OACSR_CREATE_TBL       14
#define OACSR_INSERT           15
#define OACSR_SORTED_MERGE     16
#define OACSR_SUBQUERY_START   17
#define OACSR_SUBQUERY_END     18
#define OACSR_OX_FIND          19
#define OACSR_OX_TRANSFER      20
#define OACSR_OX_GETWORD       21
#define OACSR_OX_GETKEYS       22
#define OACSR_OX_GET           23
#define OACSR_BLANK_LINE       24
#define OACSR_SAMPLE_KEY       25
#define OACSR_BUILD_CACHE      26


typedef struct oacsr_detail_item
{
  int32                    type; /* OACSR_QUALIFY, JOIN, RETRIEVE_ROW, SORT, etc. */
  union
  {
    struct oacsr_build_xref         build_xref;
    struct oacsr_export             exprt;   /* export is a reserved word in MSVC */
    struct oacsr_join               join;
    struct oacsr_qualify            qualify;
    struct oacsr_sample_key         sample_key;

    struct oacsr_aggregation_index  agg_idx;
    struct oacsr_ask_retrieval      ask_retrieval;
    struct oacsr_build_cache        build_cache;
    struct oacsr_create_tbl         create_tbl;
    struct oacsr_fetchkeys          fetchkeys;
    struct oacsr_filter_row         filter_row;
    struct oacsr_insert             insert;
    struct oacsr_pass_to_queue      pass_to_queue;
    struct oacsr_read_xref          read_xref;
    struct oacsr_retrieve_row       retrieve_row;
    struct oacsr_return_data        return_data;
    struct oacsr_sort               sort;
    struct oacsr_sorted_merge       sorted_merge;
    struct oacsr_subquery           subquery;

    struct oacsr_ox_find            ox_find;
    struct oacsr_ox_get             ox_get;
    struct oacsr_ox_getkeys         ox_getkeys;
    struct oacsr_ox_getword         ox_getword;
    struct oacsr_ox_transfer        ox_transfer;
  } step;

  int32                    indent;
  int32                    loop_level;

  int32                    next_step;
  /* next step tells where to go after current step is done (0-relative).
     -1 indicates return to the user.  When multiple "loops" exist,
     an end-of-data condition from a fetch or fetchkeys will trigger the
     next loop to begin. */

  int32                    counts_valid;
  int32                    loops;
  int32                    cached;
  int32                    count;
  int32                    error;
  int32                    warn;
  int32                    info;
  int32                    status_offset;
  int32                    status_size;

  char                     clock[40];
} oacsr_detail_item_t;

/*** End of oacursorinfo section ***/



/* The start of structures used in oastatementinfo(). */

typedef struct oastmt_assign
{
  char                   label[12];
  int                    num_values;
} oastmt_assign_t;

typedef struct oastmt_attachdb
{
  oadb_t                 db;
} oastmt_attachdb_t;

typedef struct oastmt_attachtbl
{
  oatbl_t                tbl;
} oastmt_attachtbl_t;

typedef struct oastmt_command
{
  int                    output_offset;
  int                    output_size;
} oastmt_command_t;

typedef struct oastmt_connect
{
  oaenv_t                env;
} oastmt_connect_t;

typedef struct oastmt_ddldb
{
  oadbname_t             db_name;
  int                    exists;
  char                   filename[256];
} oastmt_ddldb_t;

typedef struct oastmt_ddlenv
{
  char                   env_name[36];
  int                    exists;
  char                   filename[256];
} oastmt_ddlenv_t;

typedef struct oastmt_ddlidx
{
  oatblname_t            tbl_name;
  oatblname_t            owner_tbl_name;
  char                   idx_name[36];
  int                    type;
  char                   type_desc[36];
  int                    exists;
  char                   filename[256];
} oastmt_ddlidx_t;

typedef struct oastmt_ddlidxgrp
{
  oadbname_t             db_name;
  oatblname_t            owner_tbl_name;
  char                   group_name[36];
  int                    exists;
  char                   filename[256];
} oastmt_ddlidxgrp_t;

typedef struct oastmt_ddlidxs
{
  oaenv_t                env;
  oadb_t                 db;
} oastmt_ddlidxs_t;

typedef struct oastmt_ddlseg
{
  /* Use oadescribe and oacursorinfo to determine characteristics of select */
  char                   segment_name[36];
  int                    persistence;
  char                   persistence_desc[36];
  char                   physical[256];
  int                    num_rows;
  int                    exists;
} oastmt_ddlseg_t;

typedef struct oastmt_ddltbl
{
  oatblname_t            tbl_name;
  int                    persistence;
  char                   persistence_desc[36];
  int                    exists;
  char                   filename[256];
} oastmt_ddltbl_t;

typedef struct oastmt_delete
{
  oatbl_t                tbl;
  int                    num_rows;
  int                    rowid_offset;  /* offset of rowid value */
  int                    rowid_size;    /* length of rowid value */
} oastmt_delete_t;

typedef struct oastmt_delidx
{
  oatbl_t                tbl;
  oacols_t               cols;
  int                    num_rows;
} oastmt_delidx_t;

typedef struct oastmt_detachdb
{
  oaenv_t                env;
  oadbname_t             db_name;
} oastmt_detachdb_t;

typedef struct oastmt_detachtbl
{
  oadb_t                 db;
  oatblname_t            tbl_name;
} oastmt_detachtbl_t;

typedef struct oastmt_disconnect
{
  int                    all;
  int                    num_instances;
} oastmt_disconnect_t;

typedef struct oastmt_export
{
  /* Use oadescribe and oacursorinfo to determine characteristics of select */
  char                   filename[256];
  char                   node[36];
  int                    num_rows;
} oastmt_export_t;

typedef struct oastmt_extract
{
  oaenv_t                env;
  oadb_t                 db;
  char                   db_type_desc[36];
  char                   filename[256];
  uint32                 count;
  int32                  num_tbl_names;
  int32                  tbl_names_offset;
  int32                  tbl_name_size; /* == sizeof( struct oatblname) */
} oastmt_extract_t;

typedef struct oastmt_helper
{
  char                   msg[1024];
} oastmt_helper_t;

typedef struct oastmt_insert
{
  oatbl_t                tbl;
  oacols_t               cols;
  int                    num_rows;
  int                    rowid_offset;  /* offset of rowid value */
  int                    rowid_size;    /* length of rowid value */
} oastmt_insert_t;

typedef struct oastmt_insidx
{
  oatbl_t                tbl;
  oacols_t               cols;
  int                    num_rows;
} oastmt_insidx_t;

typedef struct oastmt_join
{
  oacols_t               from_cols;
  oacols_t               to_cols;
  oaidx_t                to_idx;
  oatblname_t            to_nature_tbl_name;
  int                    count;
  int                    parent_count;
  int                    preintersect_count;
  int                    explain_only;
  int                    orphans;
  int                    deferred;
  int                    odx_list_type; /* OA_ODX_TYPE_... */
} oastmt_join_t;

typedef struct oastmt_loadofx
{
  oaenv_t                env;
  oadb_t                 db;
  oatbl_t                tbl;
  int                    num_tbls;
  int                    num_rows;
} oastmt_loadofx_t;

typedef struct oastmt_open
{
  oacursor_t             cursor;
} oastmt_open_t;

typedef struct oastmt_partition
{
  oatbl_t                tbl;
  int                    num_rows;
  int                    num_partitions;
} oastmt_partition_t;

typedef struct oastmt_qualify
{
  oaidx_t                idx;
  oatblname_t            nature_tbl_name;
  int                    count;
  int                    parent_count;
  int                    preintersect_count;
  int                    max_key_length;
  int                    si_length;
  int                    explain_only;
  int                    orphans;
  int                    odx_list_type; /* OA_ODX_TYPE_... */
} oastmt_qualify_t;

typedef struct oastmt_remove
{
  char                   name[256];    /* filename */
  int                    num_files;
  int                    size; /* in Kbytes */
} oastmt_remove_t;

typedef struct oastmt_select_value
{
  int                    value_length;
} oastmt_select_value_t;

typedef struct oastmt_select
{
  /* Use oadescribe and oacursorinfo to determine characteristics of select */
  int                    bufflen;
  int                    num_cols;
  int                    num_values_clauses;
  int                    values_lengths_offset; /* beginning of oastmt_select_value_t */
  int                    values_lengths_size; /* sizeof oastmt_select_value_t */
} oastmt_select_t;

typedef struct oastmt_select_bench
{
  int                    num_rows;
  char                   clock[40];
} oastmt_select_bench_t;

typedef struct oastmt_select_into
{
  oatbl_t                tbl;
  oacols_t               cols;
  int                    num_rows;
} oastmt_select_into_t;

typedef struct oastmt_update
{
  oatbl_t                tbl;
  oacols_t               cols;
  int                    num_rows;
  int                    rowid_offset;  /* offset of rowid value */
  int                    rowid_size;    /* length of rowid value */
} oastmt_update_t;

typedef struct oastmt_updfor
{
  oaenv_t                env;
  oaenv_node_t           node;
  oadb_t                 db;
  oatbl_t                tbl;
  oacol_t                col;
  oaidx_t                idx;
  char                   command[128];
  int                    num_tbls;
  int                    num_rows;
} oastmt_updfor_t;

typedef struct oastmt_updidx
{
  oatbl_t                tbl;
  oacols_t               cols;
  int                    num_rows;
} oastmt_updidx_t;

typedef struct oastmt_version
{
  int                    oa_version;
  int                    build_no;
} oastmt_version_t;

typedef struct oastmt_detail
{
  union
  {
    oastmt_assign_t      assign_stmt;
    oastmt_attachdb_t    attachdb_stmt;
    oastmt_attachtbl_t   attachtbl_stmt;
    oastmt_command_t     command_stmt;
    oastmt_connect_t     connect_stmt;
    oastmt_ddldb_t       ddldb_stmt;
    oastmt_ddlenv_t      ddlenv_stmt;
    oastmt_ddlidx_t      ddlidx_stmt;
    oastmt_ddlidxgrp_t   ddlidxgrp_stmt;
    oastmt_ddlidxs_t     ddlidxs_stmt;
    oastmt_ddlseg_t      ddlseg_stmt;
    oastmt_ddltbl_t      ddltbl_stmt;
    oastmt_delete_t      delete_stmt;
    oastmt_delidx_t      delidx_stmt;
    oastmt_detachdb_t    detachdb_stmt;
    oastmt_detachtbl_t   detachtbl_stmt;
    oastmt_disconnect_t  disconnect_stmt;
    oastmt_export_t      export_stmt;
    oastmt_extract_t     extract_stmt;
    oastmt_helper_t      helper_stmt;
    oastmt_insert_t      insert_stmt;
    oastmt_insidx_t      insidx_stmt;
    oastmt_join_t        join_stmt;
    oastmt_loadofx_t     loadofx_stmt;
    oastmt_open_t        open_stmt;
    oastmt_partition_t   partition_stmt;
    oastmt_qualify_t     qualify_stmt;
    oastmt_remove_t      remove_stmt;
    oastmt_select_t      select_stmt;
    oastmt_select_bench_t select_bench_stmt;
    oastmt_select_into_t select_into_stmt;
    oastmt_update_t      update_stmt;
    oastmt_updfor_t      updfor_stmt;
    oastmt_updidx_t      updidx_stmt;
    oastmt_version_t     version_stmt;
  } stmt;
  int                    statement_offset;
  int                    statement_length;
  int                    options_offset;
  int                    options_length;
} oastmt_detail_t;


/* The "oastmt_t" structure is the base structure used in oastatementinfo().
   It starts at the beginning of the passed buffer.
*/

typedef struct oastmt
{
  int                    statement_id;     /* OASTATEMENT_ #define for last statement */

  int                    total_size;

  int                    instance;
  int                    cursor;

  int                    detail_offset;
  int                    detail_size;   /* sizeof oastmt_detail_t */
} oastmt_t;


/* The "oasettings_t" structure is the structure used in oasettingsinfo().
   It starts at the beginning of the passed buffer.
*/

typedef struct oasettings
{
  char                   optimization[256];
  char                   required_optimization[256];
  char                   timeout[256];
  char                   char_size[256];
  char                   redefrowids[256];
  char                   pseudocolumns[256];
  char                   qualify_mode[256];
  char                   progress[256];
  char                   autopseudocolumns[256];
  char                   preprocessor[256];
  char                   timezone[256];
  char                   sql_syntax[256];
  char                   powersearch[256];
  char                   autoreset[256];
} oasettings_t;




/* routines and options: */

/* Actual function prototypes are contained in oa.h */
/*
int32 oaenvironmentinfo(int32 instance, char *options, oastatus_t *status,
                        char *environment, int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
ALL
DATABASES

int32 oadatabaseinfo(int32 instance, char *options, oastatus_t *status,
                        char *database, int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
ALL
TABLES

int32 oatableinfo(int32 instance, char *options, oastatus_t *status,
                        char *table, int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
ALL
CONSTRAINTS
PARENTS
CHILDREN
COLUMNS
BASIC_COLUMNS
INDEXES
NATIVE
MDK[=owner]
MDKDOMAIN[=owner]
ASK

int32 oaindexinfo(int32 instance, char *options, oastatus_t *status,
                  char *database, int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
ALL
NATIVE
MDK
ASK

int32 oacursorinfo(int32 cursor, char *options, oastatus_t *status,
                   int32 buffsize, void *buffer);
 options:
BIG_ENDIAN
LITTLE_ENDIAN
CHARFILL
ALL
SUMMARY
QUALIFICATION
RETRIEVAL

int32 oacolumnlistinfo(int32 instance, char *options, oastatus_t *status,
                       char *table_name, char *column_names,
                       int32 buffer_length, void *buffer);

options:
CHARFILL
BIG_ENDIAN
LITTLE_ENDIAN
ALL
COLUMNS
BASIC_COLUMNS
CHAR[=n]

int oastatementinfo(char *options, oastatus_t *status, int size, void *buffer);

OPTIONS:

CHARFILL
BIG_ENDIAN
LITTLE_ENDIAN
ALL
HOOK
PREP

*/


#endif  /* OAINFO_H_DEFINED */
