;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;:                                                                           ::
;: This script builds OFXs and Omnidex indexes for the CONFIG directory      ::
;:                                                                           ::
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
set errors exit
set pagelength 0

; Create environment file
use Omnidex.sql

; Connect to environment files
connect omnidex

; Remove existing OFX files

set errors continue
remove english/lists/*.ofx
remove english/phonetic/*.ofx
remove english/stopwords/*.ofx
remove english/synonyms/*.ofx
remove english/usages/*.ofx

remove english/lists/tdferr.tdf
remove english/phonetic/tdferr.tdf
remove english/stopwords/tdferr.tdf
remove english/synonyms/tdferr.tdf
remove english/usages/tdferr.tdf

; Load OFX's for each table

set errors exit
load ofx for table $LISTS
load ofx for table $STOPWORDS
load ofx for table $SYNONYMS
load ofx for table $PHONETIC
load ofx for table $USAGES
;don't load ofx for table $MESSAGES

; Update indexes

update indexes

; Update statsitics for each table

update statistics for table $LISTS
update statistics for table $STOPWORDS
update statistics for table $SYNONYMS
update statistics for table $PHONETIC
update statistics for table $USAGES
update statistics for table $MESSAGES

disconnect
