#!/bin/sh
#********************************************************************
#*                 Omnidex Utilities install script.
#*    (C) COPYRIGHT DYNAMIC INFORMATION SYSTEMS CORPORATION
#*              -----   ALL RIGHTS RESERVED  -----
#*    The use, duplication, or distribution of this software without
#*    the express written consent of Dynamic Information Systems Corp.
#*    is prohibited.
#********************************************************************
#
   set -e
#
# get system date
#
   SYS_ADAY=`date | cut -d" " -f1`
   SYS_MNTH=`date | cut -d" " -f2`
   SYS_NDAY=`date | cut -d" " -f3`
#
# The numeric day may be a single digit.
#
   if [ -z $SYS_NDAY ]; then
      SYS_NDAY=`date | cut -d" " -f4`
      SYS_YEAR=`date | cut -d" " -f7`
   else
      SYS_YEAR=`date | cut -d" " -f6`
   fi
   SYS_DATE="$SYS_ADAY $SYS_MNTH $SYS_NDAY $SYS_YEAR"
#
#  get system type
#
   SYS_TYPE=`uname -s`
   case $SYS_TYPE in
      AIX)       SYS_VERS=`uname -v`"."`uname -r`;;
      SunOS)     SYS_VERS=`uname -r | cut -c1-3`;;
      HP-UX)     SYS_VERS=`uname -r | cut -c3-4`;;
      OSF1)      SYS_VERS=`uname -r | cut -c2-4`;;
      DYNIX/ptx) SYS_VERS=`uname -v`;SYS_VERS=${SYS_VERS#V};SYS_VERS=${SYS_VERS%.*};;
      Linux)     SYS_VERS=`uname -r | cut -c1-3`;;
      *)         SYS_VERS=" ";;
   esac
#
# header
#
   echo ""
   echo "Omnidex Installer for $SYS_TYPE($SYS_VERS)                 $SYS_DATE"
   echo "(c)Dynamic Information Systems Corporation             1985-$SYS_YEAR"
   echo ""
   echo "Welcome to DISC's Omnidex software installation system.  If "
   echo "you have any problems with this utility please contact our Technical "
   echo "Support staff at:"
   echo ""
   echo "  In the U.S.:      Phone:      303-444-6610"
   echo "                    Fax:        303-444-0208"
   echo "                    Email:      support@disc.com"
   echo "                    Internet:   http://www.omnidex.com"
   echo "  In Europe:        Phone:      +44-1372-362777"
   echo "                    Fax:        +44-1372-386418"
   echo "                    Email:      support@disceurope.co.uk"
   echo ""
   echo "Thank you for using Omnidex."
   echo ""
   echo "This utility installs Omnidex software into /opt/omnidex directory."
   echo "It creates symbolic links in /usr/bin for main programs located in"
   echo "  /opt/omnidex/bin directory."
   echo "Finally, it creates omnidex.conf that contains the path to the "
   echo "  Omnidex libraries, places it into /etc/ld.so.conf.d directory, "
   echo "  and runs ldconfig to load it into the cache."
   echo ""
   echo ""
   echo "Available responses to prompts are in parentheses () and default"
   echo "responses are in square brackets []."
   echo ""
#
   while true; do
      read -p "Do you wish to continue (Y/[N])? " reply
      case ${reply:=N} in
         [Yy]* ) break;;
         [Nn]* ) echo ""; exit;;
      esac
   done
#
   echo ""
   echo "Creating /opt/omnidex directory..."
   mkdir -p    /opt/omnidex/logs
#
   echo "Copying files into /opt/omnidex directory..."
   cp -f  odxuninstall.sh /opt/omnidex
   cp -f  odxset.sh    /opt/omnidex
   rm -rf /opt/omnidex/bin
   cp -rf bin          /opt/omnidex
   rm -rf /opt/omnidex/include
   cp -rf include      /opt/omnidex
   rm -rf /opt/omnidex/src
   cp -rf src          /opt/omnidex
   rm -rf /opt/omnidex/config
   cp -rf config       /opt/omnidex
   rm -rf /opt/omnidex/lib
   cp -rf lib          /opt/omnidex
#
   chmod a=rwx         /opt/omnidex
   chmod a=rwx         /opt/omnidex/logs
   chmod a=rwx         /opt/omnidex/config
   chmod u=rx,go-rwx   /opt/omnidex/odxuninstall.sh
   chmod a=rx          /opt/omnidex/odxset.sh
   chmod a=rw          /opt/omnidex/bin/*.cfg
   chmod u=rw,go=r     /opt/omnidex/config/*
   chmod a=rw          /opt/omnidex/config/Omnidex.xml
   chmod u=rwx,go=rx   /opt/omnidex/config/sudoers
   chmod a=rw          /opt/omnidex/include/*
   chmod a=rx          /opt/omnidex/lib/lib*
   chmod a=rx          /opt/omnidex/lib/Omnidex.jar
   chmod a=rw          /opt/omnidex/src/*
   find /opt/omnidex/config -type d -exec chmod a=rwx {} \;
   find /opt/omnidex/config/english -type f -exec chmod a=rw {} \;
   find /opt/omnidex/config/idx -type f -exec chmod a=rw {} \;
#
   echo "Creating omnidex.conf in /etc/ld.so.conf.d"
   echo /opt/omnidex/lib > /etc/ld.so.conf.d/omnidex.conf
   ldconfig
#
   echo "Copying /opt/omnidex/bin/omnidexd to /etc/init.d"
   cp -rf /opt/omnidex/bin/omnidexd /etc/init.d/omnidexd
   chmod 755 /etc/init.d/omnidexd
#
   echo "Creating symbolic links in /usr/bin"
   rm -f /usr/bin/odxsql
   rm -f /usr/bin/odxnet
   rm -f /usr/bin/omnidex
   rm -f /usr/bin/odxversions
   ln -s /opt/omnidex/bin/odxsql      /usr/bin
   ln -s /opt/omnidex/bin/odxnet      /usr/bin
   ln -s /opt/omnidex/bin/omnidex     /usr/bin
   ln -s /opt/omnidex/bin/odxversions /usr/bin
#
   LIC_STATUS=`odxversions -versiononly lic_status`
   if [[ "${LIC_STATUS##License is valid}" == "${LIC_STATUS}" ]]; then
      echo " "
      echo "Omnidex requires a license to create or access indexes on a server."
      echo "Omnidex does not require a license to act as an ODBC or JDBC client"
      echo "to another server."
      echo " "

      while true; do
         read -p "Do you wish to request an Omnidex license (Y/[N])? " reply
         case ${reply:=N} in
            [Yy]* ) REQ_LICENSE=true; break;;
            [Nn]* ) REQ_LICENSE=false; break;;
         esac
      done

      if $REQ_LICENSE; then
         odxsql -cmd="REQUEST TRIAL LICENSE" -exit
      fi
   else
      odxsql -cmd='validate license with type=install' -exit -exit_on_error -nobanner > /dev/null 2>&1
   fi
#
   ODXV=`odxversions -versiononly omnidex`
   echo ""
   echo "Omnidex $ODXV has been installed successfully."
   echo ""
#
#
#********************************************************************
#***       End of the Omnidex install utility script.
#********************************************************************

