/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import omnidex.client.OdxCLJColumnInfo;
import omnidex.client.OdxCLJDatabaseInfo;
import omnidex.client.OdxCLJEnvironmentInfo;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJIndexComponentInfo;
import omnidex.client.OdxCLJIndexInfo;
import omnidex.client.OdxCLJPoolArray;
import omnidex.client.OdxCLJPrimaryKeys;
import omnidex.client.OdxCLJResultSet;
import omnidex.client.OdxCLJStatement;
import omnidex.client.OdxCLJStatus;
import omnidex.client.OdxCLJTableInfo;
import omnidex.client.OdxCLJTableTypes;
import omnidex.client.OdxCLJTrace;

public final class OdxCLJConnection {
    private String m_url;
    private Properties m_options;
    private OdxCLJPoolArray<OdxCLJConnection> m_connections;
    private ArrayList<OdxCLJStatement> m_statements;
    private OdxCLJStatus m_status;
    private boolean m_strictCheck;

    private void checkConnection() throws SQLException {
        if (this.m_status == null) {
            throw OdxCLJException.error(25502);
        }
    }

    private void connect(String string, Properties properties) throws SQLException {
        this.trace("connect");
        if (this.m_status != null) {
            this.m_status.disconnect();
            this.m_status = null;
        }
        this.m_status = new OdxCLJStatus();
        this.m_status.connect(string, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OdxCLJConnection lockConnection() throws SQLException {
        OdxCLJConnection odxCLJConnection;
        this.trace("lockConnection");
        OdxCLJPoolArray<OdxCLJConnection> odxCLJPoolArray = this.m_connections;
        synchronized (odxCLJPoolArray) {
            odxCLJConnection = this.m_connections.lock();
        }
        if (odxCLJConnection == null) {
            odxCLJConnection = new OdxCLJConnection();
            odxCLJConnection.connect(this.m_url, this.m_options);
            odxCLJPoolArray = this.m_connections;
            synchronized (odxCLJPoolArray) {
                this.m_connections.addLock(odxCLJConnection);
            }
        }
        return odxCLJConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockConnection(OdxCLJConnection odxCLJConnection) throws SQLException {
        this.trace("unlockConnection");
        OdxCLJPoolArray<OdxCLJConnection> odxCLJPoolArray = this.m_connections;
        synchronized (odxCLJPoolArray) {
            this.m_connections.unlock(odxCLJConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeStatement(OdxCLJStatement odxCLJStatement) {
        this.trace("freeStatement");
        ArrayList<OdxCLJStatement> arrayList = this.m_statements;
        synchronized (arrayList) {
            this.m_statements.remove(odxCLJStatement);
        }
    }

    protected int getEndian() throws SQLException {
        this.checkConnection();
        return this.m_status.getEndian();
    }

    protected OdxCLJStatus getStatus() {
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() throws SQLException {
        this.trace("release");
        ArrayList<OdxCLJStatement> arrayList = this.m_statements;
        synchronized (arrayList) {
            Iterator<OdxCLJStatement> iterator = this.m_statements.iterator();
            while (iterator.hasNext()) {
                iterator.next().clear();
            }
            this.m_statements.clear();
        }
        if (this.m_status != null) {
            this.m_status.disconnect();
            this.m_status = null;
        }
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    public OdxCLJConnection() {
        this.trace(null);
        this.m_connections = new OdxCLJPoolArray();
        this.m_statements = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string, Properties properties, boolean bl) throws SQLException {
        this.trace("open");
        this.connect(string, properties);
        this.m_url = string;
        this.m_strictCheck = bl;
        this.m_options = new Properties(properties);
        OdxCLJPoolArray<OdxCLJConnection> odxCLJPoolArray = this.m_connections;
        synchronized (odxCLJPoolArray) {
            this.m_connections.add(this);
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.checkConnection();
        return this.m_status.getReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OdxCLJStatement createStatement(int n, int n2, boolean bl) throws SQLException {
        this.trace("createStatement");
        this.checkConnection();
        OdxCLJStatement odxCLJStatement = new OdxCLJStatement(this);
        odxCLJStatement.setResultSetType(n);
        odxCLJStatement.setResultSetConcurrency(n2);
        odxCLJStatement.setNoThread(bl);
        ArrayList<OdxCLJStatement> arrayList = this.m_statements;
        synchronized (arrayList) {
            this.m_statements.add(odxCLJStatement);
        }
        return odxCLJStatement;
    }

    public OdxCLJResultSet createResultSet(int n) throws SQLException {
        this.trace("createResultSet");
        this.checkConnection();
        OdxCLJResultSet odxCLJResultSet = new OdxCLJResultSet();
        odxCLJResultSet.setRowCount(0);
        odxCLJResultSet.setColumnCount(n);
        return odxCLJResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.trace("close");
        OdxCLJPoolArray<OdxCLJConnection> odxCLJPoolArray = this.m_connections;
        synchronized (odxCLJPoolArray) {
            Iterator<OdxCLJConnection> iterator = this.m_connections.iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
            this.m_connections.clear();
        }
    }

    public String getURL() {
        return this.m_url;
    }

    public String getUserName() {
        return this.m_options != null ? this.m_options.getProperty("user") : "";
    }

    public void setCheck(boolean bl) {
        this.m_strictCheck = bl;
    }

    public boolean isStrict() {
        return this.m_strictCheck;
    }

    public String getVersion() throws SQLException {
        this.checkConnection();
        return this.m_status.getVersion();
    }

    public String getEnvironmentFile() throws SQLException {
        this.checkConnection();
        return this.m_status.getEnvironmentFile();
    }

    public OdxCLJResultSet getEnvironment() throws SQLException {
        this.checkConnection();
        return new OdxCLJEnvironmentInfo().initialize(this.m_status);
    }

    public OdxCLJResultSet getDatabases() throws SQLException {
        this.checkConnection();
        return new OdxCLJDatabaseInfo().initialize(this.m_status);
    }

    public OdxCLJResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.checkConnection();
        return new OdxCLJTableInfo().initialize(this.m_status, string, string2, string3, stringArray);
    }

    public OdxCLJResultSet getTableTypes() throws SQLException {
        this.checkConnection();
        return new OdxCLJTableTypes().initialize();
    }

    public OdxCLJResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.checkConnection();
        return new OdxCLJColumnInfo().initialize(this.m_status, string, string2, string3, string4);
    }

    public OdxCLJResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        this.checkConnection();
        return new OdxCLJPrimaryKeys().initialize(this.m_status, string, string2, string3);
    }

    public OdxCLJResultSet getIndexes(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.checkConnection();
        return new OdxCLJIndexInfo().initialize(this.m_status, string, string2, string3, bl, bl2);
    }

    public OdxCLJResultSet getIndexComponents(String string, String string2, String string3, String string4) throws SQLException {
        this.checkConnection();
        return new OdxCLJIndexComponentInfo().initialize(this.m_status, string, string2, string3, string4);
    }

    public char parseSqlEscapeOption(String string) throws SQLException {
        this.checkConnection();
        return this.m_status.parseSqlEscapeOption(string);
    }
}

