/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCRouterServer;
import omnidex.xml.OdxJDBCIR.ConfigType;
import omnidex.xml.OdxJDBCIR.ConnectionPoolingType;
import omnidex.xml.OdxJDBCIR.RulesType;
import omnidex.xml.OdxJDBCIR.ServersType;
import omnidex.xml.OdxJDBCIR.WhenExhaustedActionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdxJDBCRouterConfig {
    private static String XML_PACKAGE_NAME = "omnidex.xml.OdxJDBCIR";
    private static int MAX_ACTIVE_CONFIG = 8;
    private static HashMap<String, OdxJDBCRouterConfig> m_configList;
    private static Unmarshaller m_jaxbUnmarshaller;
    private String m_filename;
    private ConfigType m_config;
    private HashMap<String, OdxJDBCRouterServer> m_serverList;
    private long m_lastModified;
    private long m_lastAccessed;

    public OdxJDBCRouterConfig(String string, ConfigType configType) {
        this.m_filename = string;
        this.m_config = configType;
        this.m_lastAccessed = System.currentTimeMillis();
        this.m_lastModified = new File(string).lastModified();
    }

    public static synchronized OdxJDBCRouterConfig getConfig(String string) throws SQLException {
        OdxCLJTrace.print("Getting config: " + string);
        OdxJDBCRouterConfig odxJDBCRouterConfig = null;
        if (m_configList == null) {
            m_configList = new HashMap();
        } else {
            odxJDBCRouterConfig = m_configList.get(string);
        }
        if (odxJDBCRouterConfig == null) {
            OdxCLJTrace.print("New config file: " + string);
            odxJDBCRouterConfig = new OdxJDBCRouterConfig(string, OdxJDBCRouterConfig.parseConfig(string));
            odxJDBCRouterConfig.init();
            if (m_configList.size() == MAX_ACTIVE_CONFIG) {
                OdxJDBCRouterConfig odxJDBCRouterConfig2 = null;
                Collection<OdxJDBCRouterConfig> collection = m_configList.values();
                for (OdxJDBCRouterConfig odxJDBCRouterConfig3 : collection) {
                    if (odxJDBCRouterConfig2 != null && odxJDBCRouterConfig3.m_lastAccessed >= odxJDBCRouterConfig2.m_lastAccessed) continue;
                    odxJDBCRouterConfig2 = odxJDBCRouterConfig3;
                }
                OdxCLJTrace.print("Removing oldest config: " + odxJDBCRouterConfig2.m_filename);
                m_configList.remove(odxJDBCRouterConfig2.m_filename);
                OdxCLJTrace.print("Config List size: " + m_configList.size());
            }
            m_configList.put(string, odxJDBCRouterConfig);
        } else if (odxJDBCRouterConfig.isModified()) {
            OdxCLJTrace.print("Config is modified, refreshing...");
            odxJDBCRouterConfig.refresh();
        }
        return odxJDBCRouterConfig;
    }

    public boolean isModified() {
        this.m_lastAccessed = System.currentTimeMillis();
        return this.m_lastModified != new File(this.m_filename).lastModified();
    }

    public void refresh() throws SQLException {
        this.m_lastModified = new File(this.m_filename).lastModified();
        this.m_config = OdxJDBCRouterConfig.parseConfig(this.m_filename);
        this.init();
    }

    public RulesType getRules() {
        return this.m_config.getRules();
    }

    public HashMap<String, OdxJDBCRouterServer> getServerList() {
        return this.m_serverList;
    }

    public OdxJDBCRouterServer getServer(String string) {
        return this.m_serverList.get(string.toUpperCase());
    }

    private static ConfigType parseConfig(String string) throws SQLException {
        ConfigType configType = null;
        FileInputStream fileInputStream = null;
        try {
            JAXBContext jAXBContext;
            if (m_jaxbUnmarshaller == null) {
                OdxCLJTrace.print("Creating JAXBContext");
                jAXBContext = JAXBContext.newInstance((String)XML_PACKAGE_NAME);
                OdxCLJTrace.print("Creating Unmarshaller");
                m_jaxbUnmarshaller = jAXBContext.createUnmarshaller();
            }
            fileInputStream = new FileInputStream(string);
            OdxCLJTrace.print("Unmarshal config file");
            jAXBContext = (JAXBElement)m_jaxbUnmarshaller.unmarshal((InputStream)fileInputStream);
            OdxCLJTrace.print("Get config object");
            configType = (ConfigType)jAXBContext.getValue();
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
        catch (JAXBException jAXBException) {
            throw OdxCLJException.error((Exception)((Object)jAXBException));
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return configType;
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    private void init() {
        this.trace("Getting server list");
        this.m_serverList = new HashMap();
        List<ServersType.Server> list = this.m_config.getServers().getServer();
        for (ServersType.Server server : list) {
            OdxJDBCRouterServer odxJDBCRouterServer = new OdxJDBCRouterServer(server.getName(), server.getDescription(), server.getJdbcDriver(), server.getConnectionString());
            this.m_serverList.put(odxJDBCRouterServer.getName().toUpperCase(), odxJDBCRouterServer);
            this.saveConnectionPoolingInfo(odxJDBCRouterServer, server.getConnectionPooling());
        }
    }

    private void saveConnectionPoolingInfo(OdxJDBCRouterServer odxJDBCRouterServer, ConnectionPoolingType connectionPoolingType) {
        ConnectionPoolingType connectionPoolingType2 = this.m_config.getGlobal() == null ? null : this.m_config.getGlobal().getConnectionPooling();
        Integer n = null;
        Integer n2 = null;
        Long l = null;
        WhenExhaustedActionType whenExhaustedActionType = null;
        if (connectionPoolingType != null) {
            n = connectionPoolingType.getMaxActive();
            whenExhaustedActionType = connectionPoolingType.getWhenExhaustedAction();
            l = connectionPoolingType.getMaxWait();
            n2 = connectionPoolingType.getMaxIdle();
        }
        if (connectionPoolingType2 != null) {
            if (n == null) {
                n = connectionPoolingType2.getMaxActive();
            }
            if (whenExhaustedActionType == null) {
                whenExhaustedActionType = connectionPoolingType2.getWhenExhaustedAction();
            }
            if (l == null) {
                l = connectionPoolingType2.getMaxWait();
            }
            if (n2 == null) {
                n2 = connectionPoolingType2.getMaxIdle();
            }
        }
        if (n != null) {
            odxJDBCRouterServer.setMaxActive(n);
        }
        if (whenExhaustedActionType != null) {
            if (whenExhaustedActionType == WhenExhaustedActionType.BLOCK) {
                odxJDBCRouterServer.setWhenExhaustedAction((byte)1);
            } else if (whenExhaustedActionType == WhenExhaustedActionType.FAIL) {
                odxJDBCRouterServer.setWhenExhaustedAction((byte)0);
            } else if (whenExhaustedActionType == WhenExhaustedActionType.GROW) {
                odxJDBCRouterServer.setWhenExhaustedAction((byte)2);
            }
        }
        if (l != null) {
            odxJDBCRouterServer.setMaxWait(l);
        }
        if (n2 != null) {
            odxJDBCRouterServer.setMaxIdle(n2);
        }
    }
}

