;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;:                                                                           ::
;: This script updates delimited and Omnidex indexes for the CONFIG directory :
;:                                                                           ::
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
set errors exit
set pagelength 0

; Create environment file
use Omnidex.sql

; Connect to environment files
connect omnidex

; Create OmnidexKernel.txt

copy {$OMNIDEX_LANG/messages/odxerror} {$TMPDIR/odxerror.tdf} with delete
copy {$OMNIDEX_LANG/messages/odxerror_aux} {$TMPDIR/odxerror_aux.tdf} with delete
attach table odxerror
 options "DELIMITED"
 physical "{$TMPDIR/odxerror.tdf},{$TMPDIR/odxerror_aux.tdf}" (
  line     string(80),
  message  string(80)  as "substring(line from 6)",
  num      integer     as "cast(((case substring(line from 1 for 1) when 'D' then 7000 when 'O' then 8000 when 'I' then 9000 else 0 end) +
                                 abs(cast(substring(line from 2 for 4) as integer))) *
                                 (case when cast(substring(line from 2 for 4) as integer) < 0 then -1 else 1 end)
                                as integer)");

export (select case when num < 0 then $convert(num, 'string(6)',, 'ZF')
                    else $convert(num, 'string(5)',, 'ZF') end, message
        from odxerror order by num)
  to {$OMNIDEX_LANG/messages/OmnidexKernel.txt} with delimited, delete;

detach table odxerror;
remove {$TMPDIR/odxerror.tdf} {$TMPDIR/odxerror_aux.tdf}

; Remove existing OFX files

set errors continue
remove english/lists/*.ofx
remove english/phonetic/*.ofx
remove english/stopwords/*.ofx
remove english/synonyms/*.ofx
remove english/usages/*.ofx

; Update delimited for each table

set errors exit
update delimited for table $LISTS
update delimited for table $STOPWORDS
update delimited for table $SYNONYMS
update delimited for table $PHONETIC
update delimited for table $USAGES
;don't update delimited for table $MESSAGES

; Update indexes

update indexes

; Update statistics for each table

update statistics for table $LISTS
update statistics for table $STOPWORDS
update statistics for table $SYNONYMS
update statistics for table $PHONETIC
update statistics for table $USAGES
update statistics for table $MESSAGES

disconnect
