;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;:                                                                           ::
;: This script updates delimited and Omnidex indexes for the CONFIG directory :
;:                                                                           ::
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
set errors exit
set pagelength 0

; Create environment file
use Omnidex.sql

; Connect to environment files
connect omnidex

; Create OmnidexKernel.txt

attach table odxerror
 options "DELIMITED"
 physical "{$OMNIDEX_LANG/messages/odxerror},{$OMNIDEX_LANG/messages/odxerror_aux}" (
  line     string(80),
  message  string(80)  as "substring(line from 6)",
  num      integer     as "cast(((case substring(line from 1 for 1) when 'D' then 7000 when 'O' then 8000 when 'I' then 9000 else 0 end) +
                                 abs(cast(substring(line from 2 for 4) as integer))) *
                                 (case when cast(substring(line from 2 for 4) as integer) < 0 then -1 else 1 end)
                                as integer)");

export (select case when num < 0 then $convert(num, 'string(6)',, 'ZF')
                    else $convert(num, 'string(5)',, 'ZF') end, message
        from odxerror order by num)
  to {$OMNIDEX_LANG/messages/OmnidexKernel.txt} with delimited, delete;

detach table odxerror;

; Remove existing OFX files

set errors continue
remove english/lists/*.odx
remove english/phonetic/*.odx
remove english/stopwords/*.odx
remove english/synonyms/*.odx
remove english/usages/*.odx

; Update delimited for each table

set errors exit
update delimited for table $LISTS
update delimited for table $STOPWORDS
update delimited for table $SYNONYMS
update delimited for table $PHONETIC
update delimited for table $USAGES
;don't update delimited for table $MESSAGES

; Update indexes

update indexes

; Update statistics for each table

update statistics for table $LISTS
update statistics for table $STOPWORDS
update statistics for table $SYNONYMS
update statistics for table $PHONETIC
update statistics for table $USAGES
update statistics for table $MESSAGES

disconnect
