/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import omnidex.client.OdxCLJException;
import omnidex.jdbc.OdxJDBCRouterConnection;
import omnidex.jdbc.OdxJDBCRouterStatement;

public final class OdxJDBCRouterPreparedStatement
extends OdxJDBCRouterStatement
implements PreparedStatement {
    private String m_sql;

    protected OdxJDBCRouterPreparedStatement(OdxJDBCRouterConnection odxJDBCRouterConnection) {
        super(odxJDBCRouterConnection);
    }

    protected void initialize(String string) throws SQLException {
        this.m_sql = this.processRule(string);
        this.createStatement(this.m_sql);
    }

    protected void initialize(String string, int n, int n2) throws SQLException {
        this.m_sql = this.processRule(string);
        this.initialize(n, n2);
        this.createStatement(this.m_sql);
    }

    protected void initialize(String string, int n, int n2, int n3) throws SQLException {
        this.m_sql = this.processRule(string);
        this.initialize(n, n2, n3);
        this.createStatement(this.m_sql);
    }

    private void checkStatement() throws SQLException {
        if (this.m_statement == null) {
            throw OdxCLJException.error(25504);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkStatement();
        ResultSet resultSet = null;
        try {
            resultSet = ((PreparedStatement)this.m_statement).executeQuery();
        }
        catch (SQLException sQLException) {
            String string = null;
            if (this.m_onTimeoutRule != null && this.isTimeoutError(sQLException)) {
                string = this.processRule(this.m_sql, this.m_onTimeoutRule);
            } else {
                if (this.m_onErrorRule == null) {
                    throw sQLException;
                }
                this.trace(sQLException);
                string = this.processRule(this.m_sql, this.m_onErrorRule);
            }
            this.createStatement(string);
            resultSet = ((PreparedStatement)this.m_statement).executeQuery();
        }
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        this.checkStatement();
        int n = 0;
        try {
            n = ((PreparedStatement)this.m_statement).executeUpdate();
        }
        catch (SQLException sQLException) {
            String string = null;
            if (this.m_onTimeoutRule != null && this.isTimeoutError(sQLException)) {
                string = this.processRule(this.m_sql, this.m_onTimeoutRule);
            } else {
                if (this.m_onErrorRule == null) {
                    throw sQLException;
                }
                this.trace(sQLException);
                string = this.processRule(this.m_sql, this.m_onErrorRule);
            }
            this.createStatement(string);
            n = ((PreparedStatement)this.m_statement).executeUpdate();
        }
        return n;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBigDecimal(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBytes(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setTimestamp(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setAsciiStream(n, inputStream, n2);
    }

    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setUnicodeStream(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBinaryStream(n, inputStream, n2);
    }

    public void clearParameters() throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).clearParameters();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setObject(n, object, n2, n3);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setObject(n, object, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setObject(n, object);
    }

    public boolean execute() throws SQLException {
        this.checkStatement();
        boolean bl = false;
        try {
            bl = ((PreparedStatement)this.m_statement).execute();
        }
        catch (SQLException sQLException) {
            String string = null;
            if (this.m_onTimeoutRule != null && this.isTimeoutError(sQLException)) {
                string = this.processRule(this.m_sql, this.m_onTimeoutRule);
            } else {
                if (this.m_onErrorRule == null) {
                    throw sQLException;
                }
                this.trace(sQLException);
                string = this.processRule(this.m_sql, this.m_onErrorRule);
            }
            this.createStatement(string);
            bl = ((PreparedStatement)this.m_statement).execute();
        }
        return bl;
    }

    public void addBatch() throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).addBatch();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setCharacterStream(n, reader, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setRef(n, ref);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBlob(n, blob);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setClob(n, clob);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setArray(n, array);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkStatement();
        return ((PreparedStatement)this.m_statement).getMetaData();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setDate(n, date, calendar);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setTimestamp(n, timestamp, calendar);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setNull(n, n2, string);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setURL(n, uRL);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkStatement();
        return ((PreparedStatement)this.m_statement).getParameterMetaData();
    }
}

