/*
 * Decompiled with CFR 0.152.
 */
package omnidex.java;

import java.sql.SQLException;
import omnidex.java.OmniSearch;
import omnidex.java.ValueList;

public class Value {
    private ValueList _valueList;
    private String _text;
    private String _value;
    private long _count;
    private long _distinctCount;
    private boolean _selected;
    private boolean _active;
    private boolean _countChanged;
    private boolean _range;
    private int _index;
    private static String TEXT_TAG = "\"text\"";
    private static String VALUE_TAG = "\"value\"";

    protected Value(ValueList valueList, boolean bl) {
        this.initialize(valueList, null, null, 0L, 0L, false, bl);
    }

    protected Value(ValueList valueList, String string, String string2, long l, long l2, boolean bl, boolean bl2) {
        this.initialize(valueList, string, string2, l, l2, bl, bl2);
    }

    private void initialize(ValueList valueList, String string, String string2, long l, long l2, boolean bl, boolean bl2) {
        this._valueList = valueList;
        this._index = 0;
        this._text = string;
        this._value = string2;
        this._count = l;
        this._distinctCount = l2;
        this._selected = bl;
        this._active = true;
        this._countChanged = false;
        this._range = bl2;
    }

    public OmniSearch getOmniSearch() {
        return this._valueList.getOmniSearch();
    }

    public ValueList getValueList() {
        return this._valueList;
    }

    public String getText() {
        return this._text;
    }

    public String getValue() {
        return this._value;
    }

    public long getCount(int n) throws SQLException {
        this.checkForActive();
        this.checkForCountChanged();
        switch (n) {
            case 1: {
                return this._count;
            }
            case 2: 
            case 3: {
                if (this._valueList.getDistinctColumn() == null) {
                    if (n == 2) {
                        throw new SQLException("There is no distinct column.");
                    }
                    this._distinctCount = this._count;
                }
                return this._distinctCount;
            }
        }
        throw new SQLException("Unknown count type.");
    }

    public void setSelected(boolean bl) throws SQLException {
        OmniSearch omniSearch = this.getOmniSearch();
        if (omniSearch.isTrace()) {
            omniSearch.trace(this, "setSelected", true, this._index, bl);
        }
        this.checkForActive();
        if (this._range) {
            throw new SQLException("Selected value cannot be changed");
        }
        if (this._selected != bl) {
            this._selected = bl;
            omniSearch.setCountChanged(this._valueList);
            omniSearch.executeListeners();
        }
    }

    public boolean isSelected() throws SQLException {
        this.checkForActive();
        return this._selected;
    }

    protected boolean selected() {
        return this._selected;
    }

    protected void selected(boolean bl) {
        this._selected = bl;
    }

    protected long count() {
        return this._count;
    }

    protected long distinctCount() {
        return this._distinctCount;
    }

    protected void active(boolean bl) {
        this._active = bl;
    }

    protected void index(int n) {
        this._index = n;
    }

    protected void countChanged(boolean bl) {
        this._countChanged = bl;
    }

    protected String save() {
        OmniSearch omniSearch = this.getOmniSearch();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        omniSearch.setEntry(stringBuilder, TEXT_TAG, this._text, null);
        omniSearch.setEntry(stringBuilder, VALUE_TAG, this._value, ",");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected void open(char[] cArray, int[] nArray) throws SQLException {
        OmniSearch omniSearch = this.getOmniSearch();
        omniSearch.checkBraces(cArray, nArray);
        if (omniSearch.entryExist(cArray, nArray, TEXT_TAG)) {
            this._text = omniSearch.getString(cArray, nArray);
        }
        if (omniSearch.entryExist(cArray, nArray, VALUE_TAG)) {
            this._value = omniSearch.getString(cArray, nArray);
        }
        this._selected = true;
        this._countChanged = true;
    }

    private void checkForActive() throws SQLException {
        if (!this._active) {
            throw new SQLException("The Value object is no longer valid.");
        }
    }

    private void checkForCountChanged() throws SQLException {
        if (this._countChanged) {
            throw new SQLException("The count on this Value object is no longer valid.");
        }
    }
}

