/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import omnidex.client.OdxCLJNative;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jdbcsql
implements Runnable {
    private String[] m_versions;
    private String m_omnidexVersion;
    private String m_userName;
    private String m_osName;
    private String m_licensee;
    private Connection m_conn;
    private Statement m_stmt;
    private ResultSet m_rs;
    private int m_testCount;
    private int m_stmtCount;
    private int m_totalCount;
    private boolean m_testDirExist;
    private List<String> m_columnHeader;
    private List<String> m_setCommands;
    private boolean m_autoFetch = true;
    private int m_pageLength = 23;
    private int m_lineNumber;
    private boolean m_skipPrompt;
    private boolean m_qaMode;
    private boolean m_helpMode;
    private boolean m_preintersectCount;
    private boolean m_parentCount = true;
    private boolean m_parentCountSpecified;
    private String m_connectionString;
    private List<File> m_useFiles = new ArrayList<File>();
    private List<String> m_commands = new ArrayList<String>();
    private int m_useThreadCount = 1;
    private int m_fileThreadCount = 1;
    private int m_useRepeat = 1;
    private boolean m_benchmark;
    private int m_progress = 1;
    private boolean m_exit;
    private boolean m_error;
    private boolean m_termination = true;
    private int m_onError = 2;
    private int m_odxnet = 0;
    private boolean m_timer;
    private boolean m_timerOnly;
    private int m_hexMode = 1;
    private String m_nullIndicators = null;
    private int m_multiLine = 1;
    private String m_explain;
    private boolean m_autoexplain;
    private boolean m_skipInput;
    private long m_startTimer;
    private long m_stopTimer;
    private long m_jdbcStart;
    private long m_jdbcElapsed;
    private File m_useFile;
    private File m_logFile;
    private long m_startRunTime;
    private long m_stopRunTime;
    private Semaphore m_semaphore;
    private PrintWriter m_output;
    private BufferedReader m_reader;
    private int m_runType;
    private jdbcsql m_parent;
    private int[][] m_lines;
    private String m_useCommand;
    private boolean m_interactive;
    private String m_encoding = System.getProperty("file.encoding");
    private Hashtable<String, ConnectionPool> m_pools;
    private static final String PROGRAM_NAME = "Omnidex JDBC SQL program";
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final int LINEWIDTH = 77;
    private static final int GRAPHWIDTH = 40;
    private static final int TIMEOUT = 500;
    private static final String ENCODING_VAR = "OMNIDEX_JDBC_FILE_ENCODING";
    private static final int DEFAULT_PORT = 7555;
    private static final String DEFAULT_NULL_INDICATORS = "<NULL>";
    private static final int DEFAULT_PAGELENGTH = 23;
    private static final int DEFAULT_MULTILINE = 3;
    private static final int HEX_OFF = 1;
    private static final int HEX_ON = 2;
    private static final int HEX_ONLY = 3;
    private static final int ON_ERROR_CONTINUE = 1;
    private static final int ON_ERROR_ABORT = 2;
    private static final int ON_ERROR_EXIT = 3;
    private static final int PROGRESS_DEFAULT = 1;
    private static final int PROGRESS_FULL = 2;
    private static final int PROGRESS_SIMPLE = 3;
    private static final int CMD_INCOMPLETE = 0;
    private static final int CMD_COMMENT = 1;
    private static final int CMD_DIR_TEST = 2;
    private static final int CMD_DIR_TEST_CLEANUP = 3;
    private static final int CMD_DIR_COMMON = 4;
    private static final int CMD_DIR_END_COMMON = 5;
    private static final int CMD_EXIT = 6;
    private static final int CMD_CONNECT = 7;
    private static final int CMD_DISCONNECT = 8;
    private static final int CMD_SET = 9;
    private static final int CMD_USE = 10;
    private static final int CMD_VERSIONS = 11;
    private static final int CMD_HELP = 12;
    private static final int CMD_SQL = 13;
    private static final int CMD_SHELL_COMMAND = 14;
    private static final int CMD_CD = 15;
    private static final int CMD_FETCH = 16;
    private static final int CMD_SLEEP = 17;
    private static final int CMD_PWD = 18;
    private static final int RUN_USE_FILE = 1;
    private static final int RUN_COMMANDS = 2;
    private static final String USE_SYNTAX = "Invalid USE syntax";
    private static final String[] SETTINGS = new String[]{"AUTOFETCH", "AUTOPSEUDOCOLUMNS", "AUTORESET", "CHAR", "OPT", "OPTIMIZATION", "POWERSEARCH", "PREPROCESSOR", "PSEUDO_COLUMNS", "PSEUDOCOLUMNS", "QUALIFY_MODE", "REDEF_ROWIDS", "REDEFROWIDS", "REQUIRED_OPTIMIZATIONS", "SQL_SYNTAX", "TIMEOUT", "TIMEZONE", "TOP"};
    private static final String[] COMMANDS = new String[]{"ATTACH", "CD", "CONNECT", "CREATE", "DELETE", "DETACH", "DISCONNECT", "DROP", "EXPLAIN", "EXPORT", "EXTRACT", "FETCH", "INSERT", "JOIN", "PARTITION", "PWD", "QUALIFY", "REMOVE", "SELECT", "SET", "SETENV", "SLEEP", "UPDATE", "USE"};
    private static final String[] FULLCOMMANDS = new String[]{"E", "EXIT", "HELP", "Q", "QUIT", "VERSIONS"};
    private static final String[] COMMANDLINES = new String[]{"syntax:", " ", "  java jdbcsql [connection_string] [options]", " ", "  connection_string:", "    A standard Omnidex connection string, such as:", "        simple.xml", "        c:\\db\\simple.xml", "        [host:port]c:\\db\\simple.xml", "    A connection pool properties file, such as:", "        simple.properties", " ", "  options:", "    -use=\"file [, file ...]\"", "    -use=\"(filelist)\"", "    -pool=\"connection_pool=connection_pool_properties_file\"", "    -files=n", "    -threads=n", "    -benchmark", "    -simpleprogress", "    -fullprogress", "    -errors=<abort|exit|continue>", "    -timer", "    -timeronly", "    -exit", "    -help", " "};
    private static final String[] HELPS = new String[]{"                                JdbcSQL Help", "                                ------------", " ", "JdbcSQL provides an interactive, console-based testing and benchmarking", "interface to Omnidex databases using the Omnidex JDBC Driver.", " ", "Commands processed on the server:", " ", "  !                     Execute a shell command", "  ATTACH DATABASE       Attach a database", "  ATTACH SEGMENT        Attach a segment", "  ATTACH TABLE          Attach a table", "  CD                    Change directories", "  CONNECT               Connect to an environment file", "  CREATE DATABASE       Create a database", "  CREATE ENVIRONMENT    Create an environment file", "  CREATE INDEX          Create an index or index group", "  CREATE SEGMENT        Create a segment", "  CREATE TABLE          Create a table", "  DELETE                Issue an SQL delete statement", "  DETACH DATABASE       Detach a previously attached database", "  DETACH SEGMENT        Detach a previously attached segment", "  DETACH TABLE          Detach a previously attached table", "  DISCONNECT            Disconnect from an environment file", "  DROP DATABASE         Drop a database", "  DROP ENVIRONMENT      Drop an environment", "  DROP INDEX            Drop an index or index group", "  DROP SEGMENT          Drop a segment", "  DROP TABLE            Drop a table", "  EXPLAIN               Explain a SQL statement", "  EXPORT                Export records to a file", "  EXTRACT               Extract SQL statements for database", "  FETCH                 Explicitly fetch data from a database", "  INSERT                Issue an SQL insert statement", "  JOIN                  Join tables using Omnidex", "  PARTITION             Partition a table", "  QUALIFY               Qualify rows using Omnidex", "  REMOVE                Remove one or more files", "  SELECT                Issue an SQL select statement", "  SETENV                Set an environment variable", "  SLEEP                 Sleep for a specified number of seconds", "  UPDATE                Issue an SQL update statement", "  UPDATE DELIMITED      Update delimited indexes", "  UPDATE INDEXES        Update Omnidex indexes", "  UPDATE POWERSEARCH    Update powersearch data", "  UPDATE ROLLUP         Update rollup table", "  UPDATE ROLLUPS        Update rollup tables", "  UPDATE STATISTICS     Update statistical information", " ", "Commands processed on the client:", " ", "  ;                     Comment line", "  EXIT                  Exit Omnidex SQL", "  HELP                  Help", "  QUIT                  Quit JDBC SQL", "  SET                   Set an option (some options are sent to server)", "  USE                   Use one or more files containing statements", "  VERSIONS              Show version information", " ", "CONNECT command syntax:", " ", "  CONNECT connection_string", "  CONNECT connection_pool", "  CONNECT connection_pool_properties_file", " ", "  connection_string:", "      user/password@ [ host : port : pool ] filename [ node ] &options", " ", "  connection_pool:", "      name of connection pool, as specified in SET POOL command", " ", "  connection_pool_properties_file:", "      name of connection pool .properties file for connection pooling module", " ", "USE command syntax:", " ", "  USE file [, file ...] WITH options", "  USE (filelist) WITH options", " ", "  options:", "    FILES=n             Process n files at a time", "    THREADS=n           Process statements in files using n threads each", "    BENCHMARK           Benchmark by avoiding logging and displaying results", "    SIMPLEPROGRESS      Display a simple, one-line progress display", "    FULLPROGRESS        Display a full-screen, multi-line progress display", "    TIMER               Log the timer and the data output", "    TIMERONLY           Log the timer only, no data output", " ", "  file:", "    A text file containing Omnidex statements to process, with each statement", "      terminated by a semicolon, and optionally spanning multiple lines.", " ", "  filelist:", "    A text file containing filenames to process, with one filename per line.", " ", "SET command options:", " ", "  SET option value", " ", "      Settings processed on the server:", " ", "      [AUTOPSEUDOCOLUMNS <ON | OFF>]", "      [AUTORESET <ON | OFF>]", "      [CHAR <AUTO | n>]", "      [OPTIMIZATION options]", "      [POWERSEARCH <ON | OFF | list>]", "      [PREPROCESSOR <ON | OFF>]", "      [PSEUDOCOLUMNS <ON | OFF>]", "      [QUALIFY_MODE <PARSER | ODXFIND | OX_FIND>]", "      [REDEFROWIDS <ON | OFF>]", "      [REQUIRED_OPTIMIZATION options]", "      [SQL_SYNTAX <OMNIDEX | ORACLE | SQLSERVER>]", "      [TIMEOUT <seconds | OFF>]", "      [TIMEZONE timezone]", "      [TOP n]", " ", "      Settings processed on the client:", " ", "      [AUTOFETCH <ON | OFF>]", "      [BENCHMARK <ON | OFF>]", "      [DEBUG <ON | OFF> [FILE=filename]]", "      [ERRORS <ABORT | CONTINUE | EXIT>]", "      [FILES n]", "      [FULLPROGRESS <ON | OFF>]", "      [HEX <ON | OFF | ONLY>]", "      [MULTILINE <ON | OFF | value>]", "      [NULL_INDICATORS <ON | OFF | value>]", "      [PAGELENGTH n]", "      [POOL connection_pool=connection_pool_properties_file]", "      [QUALIFY_COUNTS [<PARENT | NOPARENT>] [<PREINTERSECT | NOPREINTERSECT>]]", "      [SIMPLEPROGRESS <ON | OFF>]", "      [TERMINATION <ON | OFF>]", "      [TIMER <ON | OFF>]", "      [TIMERONLY <ON | OFF>]", "      [THREADS n]", " ", "Command line options:", " ", "  java jdbcsql [connection_string] [options]", " ", "  connection_string:", "    A standard Omnidex connection string, such as:", "        simple.xml", "        c:\\db\\simple.xml", "        [host:port]c:\\db\\simple.xml", "    A connection pool properties file, such as:", "        simple.properties", " ", "  options:", "    -use=\"file [, file ...]\"", "    -use=\"(filelist)\"", "    -pool=\"connection_pool=connection_pool_properties_file\"", "    -files=n", "    -threads=n", "    -benchmark", "    -simpleprogress", "    -fullprogress", "    -errors=<abort|exit|continue>", "    -timer", "    -timeronly", "    -exit", "    -help", " "};

    public static void main(String[] stringArray) {
        jdbcsql jdbcsql2 = new jdbcsql();
        if (!jdbcsql2.initialize()) {
            return;
        }
        boolean bl = false;
        try {
            jdbcsql2.parseCommandLine(stringArray);
            jdbcsql2.getVersionInformation();
            System.out.println(jdbcsql2.formatHeader(PROGRAM_NAME));
            bl = true;
            if (jdbcsql2.helpMode()) {
                for (String string : COMMANDLINES) {
                    System.out.println(string);
                }
            } else {
                jdbcsql2.runInteractive();
            }
        }
        catch (Exception exception) {
            if (!bl) {
                System.out.println(jdbcsql2.formatHeader(PROGRAM_NAME));
            }
            System.out.println("*E* " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block26: {
            block24: {
                if (!this.m_benchmark && this.m_logFile != null) {
                    this.m_output = new PrintWriter((Writer)new FileWriter(this.m_logFile, false), true);
                    this.printString(this.formatHeader("Omnidex JDBC SQL program"), new Object[0]);
                    this.printString("%s%n", new Object[]{this.m_useFile.getAbsolutePath()});
                    if (this.m_timer) {
                        this.printString("Start time: %s%n", new Object[]{new SimpleDateFormat("HH:mm:ss.SSS").format(Calendar.getInstance().getTime())});
                        this.m_jdbcStart = 0L;
                    }
                }
                switch (this.m_runType) {
                    case 1: {
                        try {
                            if (this.m_fileThreadCount == 1) {
                                this.runUseFileSingleThread(true);
                            } else {
                                this.runUseFileMultiThread();
                            }
                            var2_1 = null;
                            this.stopJdbcTimer();
                            if (this.m_semaphore == null) ** GOTO lbl42
                            this.m_semaphore.release();
                            this.m_semaphore = null;
                        }
                        catch (Throwable var1_3) {
                            var2_2 = null;
                            this.stopJdbcTimer();
                            if (this.m_semaphore != null) {
                                this.m_semaphore.release();
                                this.m_semaphore = null;
                            }
                            this.m_stopRunTime = System.currentTimeMillis();
                            if (!this.m_benchmark && this.m_logFile != null && this.m_timer) {
                                this.printString("Stop time: %s%n", new Object[]{new SimpleDateFormat("HH:mm:ss.SSS").format(Calendar.getInstance().getTime())});
                                this.printString("Total elapsed: %s%n", new Object[]{this.formatElapsed(this.m_stopRunTime - this.m_startRunTime, true)});
                                this.printString("Total JDBC elapsed: %s%n", new Object[]{this.formatElapsed(this.m_jdbcElapsed, true)});
                            }
                            throw var1_3;
                        }
lbl42:
                        // 2 sources

                        this.m_stopRunTime = System.currentTimeMillis();
                        if (!this.m_benchmark && this.m_logFile != null && this.m_timer) {
                            this.printString("Stop time: %s%n", new Object[]{new SimpleDateFormat("HH:mm:ss.SSS").format(Calendar.getInstance().getTime())});
                            this.printString("Total elapsed: %s%n", new Object[]{this.formatElapsed(this.m_stopRunTime - this.m_startRunTime, true)});
                            this.printString("Total JDBC elapsed: %s%n", new Object[]{this.formatElapsed(this.m_jdbcElapsed, true)});
                        }
                        break;
                    }
                    case 2: {
                        this.runCommands();
                    }
                }
                var4_5 = null;
                if (this.m_output == null) break block24;
                try {
                    this.m_output.close();
                }
                catch (Exception var5_8) {
                    // empty catch block
                }
                this.m_output = null;
            }
            this.m_exit = true;
            {
                break block26;
                catch (Exception var1_4) {
                    this.printException(var1_4);
                    var4_6 = null;
                    if (this.m_output != null) {
                        try {
                            this.m_output.close();
                        }
                        catch (Exception var5_9) {
                            // empty catch block
                        }
                        this.m_output = null;
                    }
                    this.m_exit = true;
                }
            }
            catch (Throwable var3_11) {
                var4_7 = null;
                if (this.m_output != null) {
                    try {
                        this.m_output.close();
                    }
                    catch (Exception var5_10) {
                        // empty catch block
                    }
                    this.m_output = null;
                }
                this.m_exit = true;
                throw var3_11;
            }
        }
    }

    public String[] versions() {
        return this.m_versions;
    }

    public String omnidexVersion() {
        return this.m_omnidexVersion;
    }

    public String userName() {
        return this.m_userName;
    }

    public String osName() {
        return this.m_osName;
    }

    public String licensee() {
        return this.m_licensee;
    }

    public int count() {
        return this.m_testDirExist ? this.m_testCount : this.m_stmtCount;
    }

    public int totalCount() {
        return this.m_totalCount;
    }

    public void qaMode(boolean bl) throws Exception {
        if (bl) {
            this.m_qaMode = true;
            this.m_termination = true;
            this.m_pageLength = 0;
            this.m_onError = 1;
            this.m_nullIndicators = "~";
        } else {
            this.setDefaults();
        }
    }

    public void setDefaults() throws Exception {
        this.m_qaMode = false;
        this.m_nullIndicators = DEFAULT_NULL_INDICATORS;
        this.m_termination = true;
        this.m_onError = 2;
        this.m_timer = false;
        this.m_timerOnly = false;
        this.m_hexMode = 1;
        this.m_multiLine = 1;
        this.m_explain = null;
        this.m_autoexplain = false;
        this.m_pageLength = 23;
        this.m_parentCount = true;
        this.m_parentCountSpecified = false;
        this.m_preintersectCount = false;
        this.m_autoFetch = true;
        if (this.m_setCommands != null) {
            this.m_setCommands.clear();
        }
        if (this.m_conn != null) {
            this.startJdbcTimer();
            this.m_stmt.execute("set AUTOFETCH ON");
            this.m_stmt.execute("set AUTOPSEUDOCOLUMNS OFF");
            this.m_stmt.execute("set AUTORESET OFF");
            this.m_stmt.execute("set CHAR AUTO");
            this.m_stmt.execute("set OPTIMIZATION DEFAULT");
            this.m_stmt.execute("set POWERSEARCH OFF");
            this.m_stmt.execute("set PREPROCESSOR ON");
            this.m_stmt.execute("set PSEUDOCOLUMNS ON");
            this.m_stmt.execute("set QUALIFY_MODE DEFAULT");
            this.m_stmt.execute("set REDEFROWIDS ON");
            this.m_stmt.execute("set REQUIRED_OPTIMIZATION DEFAULT");
            this.m_stmt.execute("set SQL_SYNTAX OMNIDEX");
            this.m_stmt.execute("set TIMEOUT OFF");
            this.m_stmt.execute("set TIMEZONE DEFAULT");
            this.m_stmt.execute("set TOP OFF");
            this.stopJdbcTimer();
        }
    }

    public boolean helpMode() {
        return this.m_helpMode;
    }

    public String connectionString() {
        return this.m_connectionString;
    }

    public void exit(boolean bl) {
        this.m_exit = bl;
    }

    public boolean exit() {
        return this.m_exit;
    }

    public boolean error() {
        return this.m_error;
    }

    public void error(boolean bl) {
        this.m_error = bl;
    }

    public boolean termination() {
        return this.m_termination;
    }

    public int onError() {
        return this.m_onError;
    }

    public void useFile(File file, File file2, jdbcsql jdbcsql2, boolean bl, int n, boolean bl2, boolean bl3) {
        this.m_useFile = file;
        this.m_logFile = file2;
        this.m_connectionString = jdbcsql2.connectionString();
        this.m_benchmark = bl;
        this.m_termination = jdbcsql2.termination();
        this.m_pageLength = 0;
        this.m_skipPrompt = true;
        this.m_onError = jdbcsql2.onError();
        this.m_fileThreadCount = n;
        this.m_timer = bl2;
        this.m_timerOnly = bl3;
        this.m_parent = jdbcsql2;
        this.m_pools = jdbcsql2.pools();
        if (!this.m_benchmark) {
            this.m_omnidexVersion = jdbcsql2.omnidexVersion();
            this.m_userName = jdbcsql2.userName();
            this.m_osName = jdbcsql2.osName();
            this.m_licensee = jdbcsql2.licensee();
        }
    }

    public File logFile() {
        return this.m_logFile;
    }

    public void logFile(File file) {
        this.m_logFile = file;
    }

    public long startRunTime() {
        return this.m_startRunTime;
    }

    public void startRunTime(long l) {
        this.m_startRunTime = l;
    }

    public long stopRunTime() {
        return this.m_stopRunTime;
    }

    public void semaphore(Semaphore semaphore) {
        this.m_semaphore = semaphore;
    }

    public void runType(int n) {
        this.m_runType = n;
    }

    public void parent(jdbcsql jdbcsql2) {
        this.m_parent = jdbcsql2;
    }

    public int[][] lines() {
        return this.m_lines;
    }

    public Hashtable<String, ConnectionPool> pools() {
        return this.m_pools;
    }

    private boolean initialize() {
        boolean bl = false;
        try {
            Class.forName("omnidex.jdbc.OdxJDBCDriver");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Unable to find Omnidex JDBC driver.");
        }
        this.m_reader = new BufferedReader(new InputStreamReader(System.in));
        return bl;
    }

    public String formatHeader(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%-54.54s%s%n%s", string, new SimpleDateFormat("EEE, MMM dd, yyyy hh:mmaa").format(Calendar.getInstance().getTime()), "(c) Dynamic Information Systems Corp. 1981-2019"));
        if (this.m_omnidexVersion != null) {
            stringBuilder.append(String.format("%32.32s", this.m_omnidexVersion));
        }
        stringBuilder.append(NEWLINE);
        if (this.m_osName != null) {
            stringBuilder.append(this.m_osName);
            if (this.m_userName != null) {
                int n = 77 - this.m_osName.length() + 1;
                stringBuilder.append(String.format("%" + n + "." + n + "s", this.m_userName));
            }
            stringBuilder.append(NEWLINE);
        }
        if (this.m_licensee != null) {
            stringBuilder.append(String.format("%s%n", this.m_licensee));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void getVersionInformation() {
        block39: {
            int n;
            int n2;
            CharSequence charSequence;
            Object object;
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            if (this.m_odxnet == 0) {
                object = System.getenv("OMNIDEX_PORT");
                if (object != null) {
                    try {
                        this.m_odxnet = Integer.parseInt((String)object);
                    }
                    catch (Exception exception) {
                        throw new JdbcsqlException("Invalid port number");
                    }
                } else {
                    this.m_odxnet = 7555;
                }
            }
            object = new ArrayList();
            String string = String.format("jdbc:omnidex:[localhost:%d]omnidex", this.m_odxnet);
            connection = DriverManager.getConnection(string);
            statement = connection.createStatement(1004, 1007);
            resultSet = statement.executeQuery("select $TAG, $PRODUCT, $VERSION from $VERSIONS");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                String string7 = resultSet.getString(3);
                if (((String)charSequence).equals("OMNIDEX")) {
                    string2 = string7;
                } else if (((String)charSequence).equals("LIC_TYPE")) {
                    string3 = string7;
                } else if (((String)charSequence).equals("OS_NAME")) {
                    this.m_osName = string7;
                } else if (((String)charSequence).equals("NODENAME")) {
                    string4 = string7;
                } else if (((String)charSequence).equals("FULL_USERNAME")) {
                    string5 = string7;
                } else if (((String)charSequence).equals("LICENSEE")) {
                    this.m_licensee = string7;
                }
                this.formatVersionInfo((List<String>)object, string6, string7);
            }
            this.m_versions = object.toArray(new String[object.size()]);
            charSequence = new StringBuilder();
            if (string3 != null && (n2 = string3.indexOf(32)) != -1 && (n = string3.indexOf(32, n2 + 1)) != -1) {
                ((StringBuilder)charSequence).append(string3.substring(n2, n));
                ((StringBuilder)charSequence).append(" ");
            }
            if (string2 != null) {
                ((StringBuilder)charSequence).append(string2);
            }
            this.m_omnidexVersion = ((StringBuilder)charSequence).toString();
            ((StringBuilder)charSequence).setLength(0);
            if (string4 != null) {
                ((StringBuilder)charSequence).append(string4);
            }
            if (string5 != null) {
                if (((StringBuilder)charSequence).length() != 0) {
                    ((StringBuilder)charSequence).append(" / ");
                }
                ((StringBuilder)charSequence).append(string5);
            }
            this.m_userName = ((StringBuilder)charSequence).toString();
            Object var14_17 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block39;
            }
            catch (Exception exception) {}
            break block39;
            {
                catch (Exception exception) {
                    Object var14_18 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block39;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void cancel() {
        Thread.currentThread().interrupt();
    }

    public void incrementTestCount() {
        ++this.m_testCount;
    }

    public void incrementStmtCount() {
        ++this.m_stmtCount;
    }

    private void startJdbcTimer() {
        if (this.m_timer) {
            this.m_jdbcStart = System.currentTimeMillis();
        }
    }

    private void stopJdbcTimer() {
        if (this.m_timer && this.m_jdbcStart != 0L) {
            this.m_jdbcElapsed += System.currentTimeMillis() - this.m_jdbcStart;
            this.m_jdbcStart = 0L;
        }
    }

    private void formatVersionInfo(List<String> list, String string, String string2) {
        String string3 = String.format("%-32.32s ", string);
        String string4 = String.format("%33s", " ");
        int n = 44;
        while (string2.length() > n) {
            int n2;
            for (n2 = n - 1; n2 >= 0 && string2.charAt(n2) != ' '; --n2) {
            }
            if (n2 <= 0) {
                n2 = n;
            }
            list.add(string3 + string2.substring(0, n2).trim());
            string2 = string2.substring(n2).trim();
            string3 = string4;
        }
        list.add(string3 + string2);
    }

    private void parseCommandLine(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            if (string.charAt(0) == '-') {
                String string2;
                String string3;
                String string4 = string.substring(1).toUpperCase();
                int n = string.indexOf(61);
                if (n == -1) {
                    string3 = string4;
                    string2 = null;
                } else {
                    string3 = string.substring(1, n).trim().toUpperCase();
                    string2 = string.substring(n + 1).trim();
                    if (string2.length() == 0) {
                        string2 = null;
                    } else if (string2.charAt(0) == '\"') {
                        string2 = string2.substring(1, string2.length() - 1).trim();
                    }
                }
                if (string3.equals("USE")) {
                    if (string2 == null) {
                        throw new JdbcsqlException(USE_SYNTAX);
                    }
                    this.m_useCommand = string2;
                    this.parseUse(string2);
                    continue;
                }
                if (string3.equals("FILES")) {
                    this.m_useThreadCount = this.parseThreads(string2);
                    continue;
                }
                if (string3.equals("THREADS")) {
                    this.m_fileThreadCount = this.parseThreads(string2);
                    continue;
                }
                if (string3.equals("REPEAT")) {
                    this.m_useRepeat = this.parseRepeat(string2);
                    continue;
                }
                if (string4.equals("BENCHMARK")) {
                    this.m_benchmark = true;
                    continue;
                }
                if (string4.equals("SIMPLEPROGRESS")) {
                    this.m_progress = 3;
                    continue;
                }
                if (string4.equals("FULLPROGRESS")) {
                    this.m_progress = 2;
                    continue;
                }
                if (string4.equals("EXIT") || string4.equals("E")) {
                    this.m_exit = true;
                    continue;
                }
                if (string3.equals("CMD")) {
                    if (string2 == null) {
                        throw new JdbcsqlException("Invalid CMD syntax");
                    }
                    String[] stringArray2 = string2.split(";");
                    if (stringArray2.length == 0) {
                        throw new JdbcsqlException("Invalid CMD syntax");
                    }
                    Collections.addAll(this.m_commands, stringArray2);
                    continue;
                }
                if (string3.equals("TERMINATION")) {
                    this.m_termination = this.parseOnOff(string2, "TERMINATION");
                    continue;
                }
                if (string3.equals("ERRORS")) {
                    this.parseErrors(string2);
                    continue;
                }
                if (string3.equals("ODXNET")) {
                    if (string2 == null) {
                        throw new JdbcsqlException("Invalid ODXNET syntax");
                    }
                    try {
                        this.m_odxnet = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new JdbcsqlException("Invalid port number");
                    }
                    if (this.m_odxnet > 0) continue;
                    throw new JdbcsqlException("Port number cannot be a negative number");
                }
                if (string4.equals("HELP") || string4.equals("?")) {
                    this.m_helpMode = true;
                    continue;
                }
                if (string4.equals("TIMER")) {
                    this.m_timer = true;
                    continue;
                }
                if (string4.equals("TIMERONLY")) {
                    this.m_timer = true;
                    this.m_timerOnly = true;
                    if (this.m_progress != 1) continue;
                    this.m_progress = 3;
                    continue;
                }
                if (string3.equals("POOL")) {
                    this.parsePool(string2);
                    continue;
                }
                if (string3.equals("QA")) {
                    this.qaMode(true);
                    continue;
                }
                throw new JdbcsqlException("Unknown command line: " + string);
            }
            if (this.m_connectionString != null) {
                throw new JdbcsqlException("Multiple connection string is not allowed.");
            }
            this.m_connectionString = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseUse(String string) throws Exception {
        Object object;
        String string2;
        Object object2;
        ArrayList<String> arrayList;
        block14: {
            String string3 = null;
            arrayList = new ArrayList<String>();
            this.m_useFiles.clear();
            if (string == null) {
                throw new JdbcsqlException(USE_SYNTAX);
            }
            if (string.charAt(0) == '(') {
                if (string.charAt(string.length() - 1) != ')') {
                    throw new JdbcsqlException(USE_SYNTAX);
                }
                object2 = null;
                try {
                    string3 = string.substring(1, string.length() - 1);
                    object2 = new BufferedReader(new FileReader(string3));
                    while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                        object = string2.trim();
                        if (((String)object).length() == 0 || ((String)object).charAt(0) == ';') continue;
                        arrayList.add(string2);
                    }
                    Object var8_7 = null;
                    if (object2 == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (object2 != null) {
                        ((BufferedReader)object2).close();
                    }
                    throw throwable;
                }
                ((BufferedReader)object2).close();
            } else {
                object2 = string.split(",");
                if (((String[])object2).length != 0) {
                    Collections.addAll(arrayList, object2);
                }
            }
        }
        if (arrayList.size() == 0) {
            throw new JdbcsqlException(USE_SYNTAX);
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            string2 = (String)object2.next();
            object = new File(string2 = string2.trim());
            if (!((File)object).isFile()) {
                throw new JdbcsqlException(string2 + " doesn't exist");
            }
            if (!((File)object).canRead()) {
                throw new JdbcsqlException("No read access on " + string2);
            }
            this.m_useFiles.add((File)object);
        }
        return;
    }

    private int parseThreads(String string) throws Exception {
        if (string == null) {
            throw new JdbcsqlException("Invalid thread count");
        }
        try {
            int n = Integer.parseInt(string);
            if (n <= 0) {
                throw new JdbcsqlException("Invalid thread count: " + string);
            }
            return n;
        }
        catch (Exception exception) {
            throw new JdbcsqlException("Invalid thread count");
        }
    }

    private int parseRepeat(String string) throws Exception {
        if (string == null) {
            throw new JdbcsqlException("Invalid repeat count");
        }
        try {
            int n = Integer.parseInt(string);
            if (n <= 0) {
                throw new JdbcsqlException("Invalid repeat count: " + string);
            }
            return n;
        }
        catch (Exception exception) {
            throw new JdbcsqlException("Invalid repeat count");
        }
    }

    private boolean parseOnOff(String string, String string2) throws Exception {
        if (string == null) {
            throw new JdbcsqlException(String.format("Invalid %s syntax", string2));
        }
        boolean bl = false;
        if ((string = string.toUpperCase()).equals("OFF")) {
            bl = false;
        } else if (string.equals("ON")) {
            bl = true;
        } else {
            throw new JdbcsqlException(String.format("%s must be set to either ON or OFF", string2));
        }
        return bl;
    }

    private void parseQualifyCounts(String string) {
        while (string != null) {
            String string2;
            int n = string.indexOf(32);
            if (n == -1) {
                string2 = string.toUpperCase();
                string = null;
            } else {
                string2 = string.substring(0, n).trim().toUpperCase();
                if ((string = string.substring(n + 1).trim()).length() == 0) {
                    string = null;
                }
            }
            if (string2.equals("PARENT")) {
                this.m_parentCount = true;
                this.m_parentCountSpecified = true;
                continue;
            }
            if (string2.equals("NOPARENT")) {
                this.m_parentCount = false;
                continue;
            }
            if (string2.equals("PREINTERSECT")) {
                this.m_preintersectCount = true;
                continue;
            }
            if (string2.equals("NOPREINTERSECT")) {
                this.m_preintersectCount = false;
                continue;
            }
            this.printString("QUALIFY_COUNTS settings are [NO]PARENT or [NO]PREINTERSECT", new Object[0]);
            break;
        }
    }

    private void parseErrors(String string) throws Exception {
        if (string == null) {
            throw new JdbcsqlException("Invalid errors syntax");
        }
        if ((string = string.toUpperCase()).equals("CONTINUE")) {
            this.m_onError = 1;
        } else if (string.equals("ABORT")) {
            this.m_onError = 2;
        } else if (string.equals("EXIT")) {
            this.m_onError = 3;
        } else {
            throw new JdbcsqlException("Invalid errors syntax");
        }
    }

    private void parseHex(String string) throws Exception {
        if (string == null) {
            throw new JdbcsqlException("Invalid hex syntax");
        }
        if ((string = string.toUpperCase()).equals("OFF")) {
            this.m_hexMode = 1;
        } else if (string.equals("ON")) {
            this.m_hexMode = 2;
        } else if (string.equals("ONLY")) {
            this.m_hexMode = 3;
        } else {
            throw new JdbcsqlException("Invalid hex syntax");
        }
    }

    private void parseNullIndicators(String string) throws Exception {
        if (string == null) {
            throw new JdbcsqlException("Invalid null_indicators syntax");
        }
        this.m_nullIndicators = string.equalsIgnoreCase("ON") ? DEFAULT_NULL_INDICATORS : (string.equalsIgnoreCase("OFF") ? null : string);
    }

    private void parseMultiLine(String string) throws Exception {
        if (string == null) {
            throw new JdbcsqlException("Invalid multiline syntax");
        }
        if ((string = string.toUpperCase()).equals("OFF")) {
            this.m_multiLine = 1;
        } else if (string.equals("ON")) {
            this.m_multiLine = 3;
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n < 1 || n > 1000) {
                    throw new JdbcsqlException("MULTILINE must be set to a value between 1 and 1000");
                }
                this.m_multiLine = n;
            }
            catch (Exception exception) {
                throw new JdbcsqlException("MULTILINE must be set to a value between 1 and 1000");
            }
        }
    }

    private void parseExplain(String string) throws Exception {
        if (string == null) {
            throw new JdbcsqlException("Invalid explain syntax");
        }
        this.m_explain = string.equalsIgnoreCase("ON") ? "" : (string.equalsIgnoreCase("OFF") ? null : string);
    }

    private void parsePool(String string) throws Exception {
        if (string == null) {
            throw new JdbcsqlException("Invalid pool syntax");
        }
        int n = string.indexOf(61);
        if (n == -1) {
            throw new JdbcsqlException("Invalid pool syntax");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        if (string2.length() == 0 || string3.length() == 0) {
            throw new JdbcsqlException("Invalid pool syntax");
        }
        File file = new File(string3);
        if (!file.isFile()) {
            throw new JdbcsqlException(string3 + " doesn't exist");
        }
        ConnectionPool connectionPool = null;
        if (this.m_pools == null) {
            this.m_pools = new Hashtable();
        } else {
            connectionPool = this.m_pools.get(string2);
        }
        if (connectionPool == null) {
            connectionPool = new ConnectionPool(string3);
            this.m_pools.put(string2, connectionPool);
        } else if (!connectionPool.isSame(string3)) {
            connectionPool.propertyFile(string3);
            this.m_pools.remove(string2);
            this.m_pools.put(string2, connectionPool);
        }
    }

    private boolean printString() {
        boolean bl = false;
        if (!this.m_benchmark) {
            if (this.m_output == null) {
                System.out.println();
                if (!this.m_skipPrompt) {
                    bl = this.promptToContinue();
                }
            } else {
                this.m_output.println();
            }
        }
        return bl;
    }

    private boolean printString(String string, Object ... objectArray) {
        boolean bl = false;
        if (!this.m_benchmark) {
            if (this.m_output == null) {
                if (objectArray.length == 0) {
                    System.out.println(string);
                } else {
                    System.out.printf(string + NEWLINE, objectArray);
                }
                if (!this.m_skipPrompt) {
                    bl = this.promptToContinue();
                }
            } else if (objectArray.length == 0) {
                this.m_output.println(string);
            } else {
                this.m_output.printf(string + NEWLINE, objectArray);
            }
        }
        return bl;
    }

    private boolean printError(String string, Object ... objectArray) {
        boolean bl = false;
        if (!this.m_benchmark) {
            String string2;
            String string3 = string2 = objectArray.length == 0 ? string : String.format(string, objectArray);
            if (this.m_output == null) {
                System.out.printf("*E* %s%n", string2);
                if (!this.m_skipPrompt) {
                    bl = this.promptToContinue();
                }
            } else {
                this.m_output.printf("*E* %s%n", string2);
            }
        }
        return bl;
    }

    private boolean printException(Exception exception) {
        String string;
        if (exception instanceof SQLException || exception instanceof JdbcsqlException) {
            string = exception.getMessage();
        } else {
            StackTraceElement[] stackTraceElementArray;
            string = exception.toString();
            if (this.m_qaMode && (stackTraceElementArray = exception.getStackTrace()).length > 0) {
                string = string + ": " + stackTraceElementArray[0].toString();
            }
        }
        return this.printError(string, new Object[0]);
    }

    private void printUntilEndOfPage(int n) {
        if (this.m_output == null) {
            while (this.m_lineNumber + n + 1 < this.m_pageLength) {
                this.printString();
            }
        }
    }

    private String prompt(String string) {
        String string2 = null;
        System.out.print(string);
        try {
            string2 = this.m_reader.readLine();
        }
        catch (IOException iOException) {
            this.printException(iOException);
        }
        if (string2 == null) {
            System.exit(0);
        }
        return string2.length() == 0 ? null : string2;
    }

    private boolean promptToContinue() {
        boolean bl = false;
        ++this.m_lineNumber;
        if (this.m_lineNumber == this.m_pageLength) {
            String string = this.prompt("Press <RETURN> to continue, 'Q' to quit or '/' to stop paging ...");
            if (string != null) {
                char c = string.charAt(0);
                if (c == 'Q' || c == 'q') {
                    bl = true;
                } else if (c == '/') {
                    this.m_skipPrompt = true;
                }
            }
            if (!bl && !this.m_skipPrompt) {
                this.m_lineNumber = 0;
                if (this.m_columnHeader != null) {
                    for (String string2 : this.m_columnHeader) {
                        this.printString(string2, new Object[0]);
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInteractive() {
        try {
            try {
                this.m_interactive = true;
                if (this.m_connectionString != null) {
                    boolean bl = this.m_benchmark;
                    this.m_benchmark = false;
                    if (this.executeConnect(this.m_connectionString)) {
                        Object var6_4 = null;
                        this.executeDisconnect(true);
                        return;
                    }
                    this.m_benchmark = bl;
                }
                if (this.m_useFiles.size() != 0) {
                    if (this.m_useFiles.size() == 1 && !this.m_benchmark && this.m_useThreadCount == 1 && this.m_fileThreadCount == 1 && this.m_progress == 1) {
                        this.runUseFileInteractive(null);
                    } else {
                        this.executeUse(this.m_benchmark, this.m_progress, this.m_useThreadCount, this.m_fileThreadCount, this.m_useRepeat, this.m_timer, this.m_timerOnly);
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean[] blArray = new boolean[]{false};
                for (String string : this.m_commands) {
                    this.executeInput(stringBuilder, string, blArray);
                }
                while (!this.m_exit) {
                    String string = this.prompt(blArray[0] ? ">> " : "> ");
                    if (string == null) continue;
                    this.executeInput(stringBuilder, string, blArray);
                }
            }
            catch (Exception exception) {
                this.printException(exception);
                Object var6_6 = null;
                this.executeDisconnect(true);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.executeDisconnect(true);
            throw throwable;
        }
        Object var6_5 = null;
        this.executeDisconnect(true);
    }

    private String trimTrailing(String string, boolean bl) {
        int n;
        if (string == null) {
            return string;
        }
        for (n = string.length(); !(n <= 0 || bl && !Character.isWhitespace(string.charAt(n - 1)) || !bl && string.charAt(n - 1) != ' '); --n) {
        }
        return string.substring(0, n);
    }

    private String parseCommand(String string) {
        int n = (string = string.trim().toUpperCase()).indexOf(32);
        if (n != -1) {
            String string2;
            int n2;
            String string3 = string.substring(0, n);
            if ((string3.equals("EXPLAIN") || string3.equals("UPDATE")) && (n2 = (string2 = string.substring(n).trim()).indexOf(32)) != -1) {
                string2 = string2.substring(0, n2);
                if (string3.equals("EXPLAIN")) {
                    string3 = string3 + " SELECT";
                } else if (string2.equals("DELIMITED") || string2.equals("INDEXES") || string2.equals("POWERSEARCH") || string2.equals("ROLLUP") || string2.equals("ROLLUPS") || string2.equals("STATISTICS")) {
                    string3 = string3 + " FOR";
                }
            }
            string = string3;
        }
        return string;
    }

    private int parseInput(StringBuilder stringBuilder, String string, boolean[] blArray, boolean bl) throws Exception {
        String string2 = null;
        String string3 = (string = this.trimTrailing(string, true)).trim();
        if (string3.length() == 0) {
            return 1;
        }
        if (string3.equals(";")) {
            if (!blArray[0]) {
                return 1;
            }
        } else if (string3.startsWith(";")) {
            if (string3.contains("<TEST=")) {
                return 2;
            }
            if (string3.contains("<TEST_CLEANUP>")) {
                return 3;
            }
            if (string3.contains("<COMMON>")) {
                return 4;
            }
            if (string3.contains("<END_COMMON>")) {
                return 5;
            }
            return 1;
        }
        if (!blArray[0]) {
            stringBuilder.setLength(0);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (string3.endsWith("\\")) {
            blArray[0] = true;
            string = string.substring(0, string.length() - 1);
            bl3 = true;
        } else if (string3.endsWith(";")) {
            bl2 = true;
            blArray[0] = false;
            string = string.substring(0, string.length() - 1);
        } else if (!this.m_termination) {
            bl2 = true;
            blArray[0] = false;
        } else {
            string2 = this.parseCommand(stringBuilder.length() == 0 ? string : stringBuilder.toString());
            if (string2.equals("EXPLAIN") || string2.equals("REMOVE") || string2.equals("SETENV") || string2.equals("UPDATE FOR")) {
                bl2 = true;
                blArray[0] = false;
            }
        }
        if (stringBuilder.length() == 0 && !bl && !this.isValidCommand(string3)) {
            if (string2 == null) {
                string2 = this.parseCommand(string3);
            }
            throw new JdbcsqlException(String.format("Unrecognized command [%s].  Type HELP for list of commands", string2));
        }
        stringBuilder.append(string);
        if (!blArray[0]) {
            if (string2 == null) {
                string2 = this.parseCommand(stringBuilder.toString());
            }
            if (string2.equals("EXIT") || string2.equals("E") || string2.equals("QUIT") || string2.equals("Q")) {
                return 6;
            }
            if (string2.charAt(0) == '!') {
                return 14;
            }
            if (string2.equals("CD")) {
                return 15;
            }
            if (string2.equals("CONNECT")) {
                return 7;
            }
            if (string2.equals("DISCONNECT")) {
                return 8;
            }
            if (string2.equals("FETCH")) {
                return 16;
            }
            if (string2.equals("HELP")) {
                return 12;
            }
            if (string2.equals("PWD")) {
                return 18;
            }
            if (string2.equals("SET")) {
                return 9;
            }
            if (string2.equals("SLEEP")) {
                return 17;
            }
            if (string2.equals("USE")) {
                return 10;
            }
            if (string2.equals("VERSIONS")) {
                return 11;
            }
            if (bl2) {
                return 13;
            }
            blArray[0] = true;
        }
        if (!bl3) {
            stringBuilder.append(" ");
        }
        return 0;
    }

    private void executeInput(StringBuilder stringBuilder, String string, boolean[] blArray) {
        boolean bl = this.m_benchmark;
        try {
            int n = this.parseInput(stringBuilder, string, blArray, false);
            switch (n) {
                case 1: {
                    return;
                }
                case 2: {
                    ++this.m_testCount;
                    this.m_skipInput = false;
                    return;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.m_skipInput = false;
                    return;
                }
            }
            if (this.m_skipInput || n == 0) {
                return;
            }
            if (n == 6) {
                this.m_exit = true;
                return;
            }
            String string2 = stringBuilder.toString().trim();
            String string3 = null;
            int n2 = string2.indexOf(32);
            if (n2 != -1) {
                string3 = string2.substring(n2 + 1).trim();
            }
            this.m_lineNumber = 0;
            this.m_skipPrompt = true;
            if (!this.m_benchmark && this.m_timerOnly) {
                this.m_benchmark = true;
            }
            switch (n) {
                case 15: {
                    this.executeCD(string3);
                    break;
                }
                case 7: {
                    this.executeConnect(string3);
                    break;
                }
                case 8: {
                    if (this.m_timer) {
                        this.m_startTimer = System.currentTimeMillis();
                    }
                    this.executeDisconnect(false);
                    if (!this.m_timer) break;
                    this.m_stopTimer = System.currentTimeMillis();
                    break;
                }
                case 16: {
                    this.executeFetch(string3);
                    break;
                }
                case 12: {
                    this.printWithPrompt(HELPS);
                    break;
                }
                case 18: {
                    this.executePWD();
                    break;
                }
                case 9: {
                    if (string3 == null) {
                        this.printError("Unrecognized SET option.  Type HELP for list of SET options", new Object[0]);
                        break;
                    }
                    this.executeSet(string3);
                    break;
                }
                case 17: {
                    if (string3 == null) {
                        this.printString("Parse error: Expected seconds after SLEEP", new Object[0]);
                        break;
                    }
                    this.executeSleep(string3);
                    break;
                }
                case 11: {
                    if (this.m_versions == null) {
                        this.printError("Unable to get version information", new Object[0]);
                        break;
                    }
                    this.printWithPrompt(this.m_versions);
                    break;
                }
                case 13: {
                    ++this.m_stmtCount;
                    if (this.m_conn == null) {
                        this.printError("This statement requires a connection to an environment file", new Object[0]);
                        break;
                    }
                    this.executeSql(string2);
                    break;
                }
                case 14: {
                    this.executeShellCommand(string2.substring(1));
                    break;
                }
                case 10: {
                    String[] stringArray;
                    if (string3 == null) {
                        this.printError(USE_SYNTAX, new Object[0]);
                        break;
                    }
                    boolean bl2 = bl;
                    int n3 = this.m_progress;
                    int n4 = this.m_useThreadCount;
                    int n5 = this.m_fileThreadCount;
                    int n6 = this.m_useRepeat;
                    boolean bl3 = this.m_timer;
                    boolean bl4 = this.m_timerOnly;
                    String string4 = string3.toUpperCase();
                    n2 = string4.lastIndexOf("WITH ");
                    if (n2 != -1) {
                        string3 = string3.substring(0, n2).trim();
                        string4 = string4.substring(n2 + 5).trim();
                        stringArray = string4.replace(' ', ',').split(",");
                        boolean bl5 = false;
                        for (String string5 : stringArray) {
                            if (string5 == null || string5.length() == 0) continue;
                            if (string5.equals("BENCHMARK")) {
                                bl2 = true;
                                if (n3 != 1) continue;
                                n3 = 3;
                                continue;
                            }
                            if (string5.equals("SIMPLEPROGRESS")) {
                                n3 = 3;
                                continue;
                            }
                            if (string5.equals("FULLPROGRESS")) {
                                n3 = 2;
                                continue;
                            }
                            if (string5.equals("TIMER")) {
                                bl3 = true;
                                if (n3 != 1) continue;
                                n3 = 3;
                                continue;
                            }
                            if (string5.equals("TIMERONLY")) {
                                bl3 = true;
                                bl4 = true;
                                if (n3 != 1) continue;
                                n3 = 3;
                                continue;
                            }
                            n2 = string5.indexOf(61);
                            if (n2 != -1) {
                                String string6 = string5.substring(0, n2).toUpperCase();
                                String string7 = string5.substring(n2 + 1);
                                if (string6.equals("FILES")) {
                                    n4 = this.parseThreads(string7);
                                    continue;
                                }
                                if (string6.equals("THREADS")) {
                                    n5 = this.parseThreads(string7);
                                    continue;
                                }
                                if (string6.equals("REPEAT")) {
                                    n6 = this.parseRepeat(string7);
                                    continue;
                                }
                                this.printError("Invalid option %s specified", string6);
                                bl5 = true;
                                break;
                            }
                            this.printError("Invalid option %s specified", string5);
                            bl5 = true;
                            break;
                        }
                        if (bl5) break;
                    }
                    if (this.m_interactive) {
                        this.m_useCommand = string3;
                        this.parseUse(string3);
                        if (this.m_useFiles.size() == 1 && !bl2 && n4 == 1 && n5 == 1 && n3 == 1) {
                            this.runUseFileInteractive(null);
                            break;
                        }
                        this.executeUse(bl2, n3, n4, n5, n6, bl3, bl4);
                        break;
                    }
                    stringArray = new jdbcsql();
                    stringArray.parseUse(string3);
                    stringArray.useFile(null, null, this, bl2, 1, bl3, bl4);
                    stringArray.exit(true);
                    super.runUseFileInteractive(this.m_output);
                }
            }
        }
        catch (Exception exception) {
            this.stopJdbcTimer();
            this.printException(exception);
        }
        this.m_benchmark = bl;
        if (this.m_timer && this.m_startTimer != 0L) {
            if (this.m_stopTimer == 0L) {
                this.m_stopTimer = System.currentTimeMillis();
            }
            this.printString("Elapsed %s", this.formatElapsed(this.m_stopTimer - this.m_startTimer, true));
            this.m_stopTimer = 0L;
            this.m_startTimer = 0L;
        }
    }

    private void printWithPrompt(String[] stringArray) {
        String string;
        boolean bl = false;
        this.m_skipPrompt = this.m_pageLength == 0;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n && !(bl = this.printString(string = stringArray2[i], new Object[0])); ++i) {
        }
        if (!this.m_skipPrompt && !bl) {
            this.printUntilEndOfPage(0);
        }
        this.m_skipPrompt = true;
    }

    private boolean isValidCommand(String string) {
        if (string.charAt(0) == '!') {
            return true;
        }
        int n = 0;
        while (string.charAt(n) == '(' || string.charAt(n) == ' ') {
            ++n;
        }
        if (n != 0) {
            string = string.substring(n);
        }
        boolean bl = false;
        String string2 = string.toUpperCase();
        for (String string3 : FULLCOMMANDS) {
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return bl;
        }
        n = string.indexOf(32);
        string2 = n != -1 ? string.substring(0, n).toUpperCase() : string.toUpperCase();
        for (String string3 : COMMANDS) {
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        if (bl || n == -1) {
            return bl;
        }
        string2 = (n = (string = string.substring(n + 1).trim()).indexOf(32)) != -1 ? string2 + " " + string.substring(0, n).toUpperCase() : string2 + " " + string.toUpperCase();
        for (String string3 : COMMANDS) {
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private ConnectionPool getConnectionPool(String string) {
        ConnectionPool connectionPool;
        ConnectionPool connectionPool2 = connectionPool = this.m_pools == null ? null : this.m_pools.get(string);
        if (connectionPool == null && string.charAt(0) != '[' && string.endsWith(".properties")) {
            if (this.m_pools != null) {
                Enumeration<ConnectionPool> enumeration = this.m_pools.elements();
                while (enumeration.hasMoreElements() && !(connectionPool = enumeration.nextElement()).isSame(string)) {
                    connectionPool = null;
                }
            }
            if (connectionPool == null) {
                connectionPool = new ConnectionPool(string);
            }
        }
        return connectionPool;
    }

    private void executeCD(String string) {
        byte[] byArray = new byte[1024];
        if (string == null) {
            string = System.getProperty("HOME");
        }
        if (string == null) {
            this.printError("Path is required since HOME environment variable is not set", new Object[0]);
        } else {
            if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            if (!OdxCLJNative.getCurrentDir(byArray)) {
                this.printError("Unable to read current directory", new Object[0]);
            } else if (!OdxCLJNative.changeDir(string.getBytes())) {
                this.printError("Unable to change directories", new Object[0]);
            } else if (!OdxCLJNative.getCurrentDir(byArray)) {
                this.printError("Unable to read new directory", new Object[0]);
            } else {
                String string2 = new String(byArray).trim();
                this.printString("%s", this.m_qaMode ? "<cwd>" : string2);
                System.setProperty("user.dir", string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean executeConnect(String string) {
        String string2 = null;
        if (string == null) {
            this.printError("Invalid connect syntax", new Object[0]);
            return true;
        }
        String string3 = string.toUpperCase();
        int n = string3.lastIndexOf("WITH ");
        if (n != -1) {
            string2 = string.substring(n + 5).trim();
            string = string.substring(0, n).trim();
        }
        if (string3.startsWith("TO ")) {
            string = string.substring(3).trim();
        }
        if (this.m_timer) {
            this.m_startTimer = System.currentTimeMillis();
        }
        boolean bl = false;
        try {
            Object object;
            this.executeDisconnect(false);
            ConnectionPool connectionPool = this.getConnectionPool(string);
            if (connectionPool == null) {
                object = new StringBuilder();
                string = this.parseConnectionString(string, (StringBuilder)object);
                if (((StringBuilder)object).length() != 0) {
                    if (string2 != null) {
                        ((StringBuilder)object).append(" ").append(string2);
                    }
                    string2 = ((StringBuilder)object).toString();
                }
                StringBuilder charSequence2 = new StringBuilder();
                charSequence2.append("jdbc:omnidex:");
                charSequence2.append(string);
                if (string2 != null) {
                    charSequence2.append("&").append(string2);
                }
                this.startJdbcTimer();
                this.m_conn = DriverManager.getConnection(charSequence2.toString(), null);
            } else {
                this.startJdbcTimer();
                this.m_conn = connectionPool.getConnection();
            }
            this.m_stmt = this.m_conn.createStatement(1004, 1007);
            if (this.m_setCommands != null) {
                for (String string4 : this.m_setCommands) {
                    this.m_stmt.execute(string4);
                }
            }
            this.stopJdbcTimer();
            if (this.m_qaMode) {
                CharSequence charSequence;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                stringBuilder.append("[NODES=");
                this.startJdbcTimer();
                if (this.m_rs != null) {
                    this.m_rs.close();
                    this.m_rs = null;
                }
                object = "select $NAME, $TYPE, $CONNECTION_STRING from $ENVIRONMENT_NODES";
                try {
                    this.m_rs = this.m_stmt.executeQuery((String)object);
                }
                catch (Exception exception) {
                    object = "select $NAME, $TYPE_DESC, $HOST, $PORT, $ENVIRONMENT, $OPTIONS from $ENVIRONMENT_NODES";
                    this.m_rs = this.m_stmt.executeQuery((String)object);
                    bl2 = true;
                }
                while (this.m_rs.next()) {
                    void var8_15;
                    string9 = this.m_rs.getString(1).trim();
                    string8 = this.m_rs.getString(2).trim();
                    if (bl2) {
                        string7 = this.m_rs.getString(3).trim();
                        string6 = this.m_rs.getString(5).trim();
                        string5 = this.m_rs.getString(6).trim();
                        int n2 = this.m_rs.getInt(4);
                        charSequence = new StringBuilder();
                        if (string7.length() != 0 || n2 != 0) {
                            charSequence.append("[");
                            if (string7.length() != 0) {
                                charSequence.append(string7);
                            }
                            if (n2 != 0) {
                                charSequence.append(":");
                                charSequence.append(n2);
                            }
                            charSequence.append("]");
                        }
                        if (string6.length() != 0) {
                            charSequence.append(string6);
                        }
                        if (string5.length() != 0) {
                            charSequence.append("&");
                            charSequence.append(string5);
                        }
                        String string10 = charSequence.toString();
                    } else {
                        String string11 = this.m_rs.getString(3).trim();
                    }
                    stringBuilder.append(String.format("%n%s,%s,%s,%s", string9, "<local>", string8, var8_15));
                }
                this.stopJdbcTimer();
                stringBuilder.append("]");
                this.printString(stringBuilder.toString(), new Object[0]);
                stringBuilder = new StringBuilder();
                stringBuilder.append("[DATABASES=");
                this.startJdbcTimer();
                if (this.m_rs != null) {
                    this.m_rs.close();
                    this.m_rs = null;
                }
                if (bl2) {
                    object = "select $NAME, $TYPE_DESC, $SUBTYPE_DESC, $VERSION,       $DEFAULT_DB_USER, $DEFAULT_DB_PASSWORD from $DATABASES";
                    this.m_rs = this.m_stmt.executeQuery((String)object);
                    while (this.m_rs.next()) {
                        string9 = this.m_rs.getString(1).trim();
                        string8 = this.m_rs.getString(2).trim();
                        string7 = this.m_rs.getString(3).trim();
                        string6 = this.m_rs.getString(4).trim();
                        string5 = this.m_rs.getString(5).trim();
                        String string12 = this.m_rs.getString(6).trim();
                        stringBuilder.append(String.format("%n%s,%s,%s%s%s,%s,%s,%s", string9, "<physical>", string8, string7.length() != 0 ? "/" : "", string7, string6, string5, string12));
                    }
                } else {
                    object = "select $DATABASES.$NAME, $DATABASE_NODES.$TYPE,       $DATABASE_NODES.$SUBTYPE, $DATABASE_NODES.$VERSION,       $DATABASE_NODES.$USER, $DATABASE_NODES.$PASSWORD from $DATABASES join $DATABASE_NODES on      $DATABASES.$NUMBER = $DATABASE_NODES.$DATABASE_NUMBER";
                    this.m_rs = this.m_stmt.executeQuery((String)object);
                    string9 = null;
                    string8 = null;
                    while (this.m_rs.next()) {
                        string7 = this.m_rs.getString(1).trim();
                        string6 = this.m_rs.getString(2).trim();
                        string5 = this.m_rs.getString(3).trim();
                        String string13 = this.m_rs.getString(4).trim();
                        charSequence = this.m_rs.getString(5).trim();
                        String string14 = this.m_rs.getString(6).trim();
                        if (string7 != string9) {
                            string9 = string7;
                            if (string8 != null) {
                                stringBuilder.append(string8);
                            }
                            string8 = String.format("%n%s,%s,%s%s%s,%s,%s,%s", string7, "<physical>", string6, string5.length() != 0 ? "/" : "", string5, string13, charSequence, string14);
                            continue;
                        }
                        string8 = String.format("%n%s,%s,%s,%s,%s,%s", string7, "<physical>", "GRID_CONTROLLER", string13, charSequence, string14);
                    }
                    if (string8 != null) {
                        stringBuilder.append(string8);
                    }
                }
                this.stopJdbcTimer();
                stringBuilder.append("]");
                this.printString(stringBuilder.toString(), new Object[0]);
            }
            this.printString("Connected to %s", this.m_qaMode ? "<filename>" : string);
        }
        catch (Exception exception) {
            this.stopJdbcTimer();
            this.setErrorsFlag();
            this.printException(exception);
            this.executeDisconnect(true);
            bl = true;
        }
        if (this.m_timer) {
            this.m_stopTimer = System.currentTimeMillis();
        }
        return bl;
    }

    private void executeDisconnect(boolean bl) {
        if (this.m_stmt != null) {
            this.startJdbcTimer();
            if (this.m_rs != null) {
                try {
                    this.m_rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_rs = null;
            }
            try {
                this.m_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_stmt = null;
            this.stopJdbcTimer();
        }
        if (this.m_conn != null) {
            block10: {
                try {
                    this.startJdbcTimer();
                    this.m_conn.close();
                    this.stopJdbcTimer();
                    if (!bl) {
                        this.printString("Disconnected", new Object[0]);
                    }
                }
                catch (Exception exception) {
                    this.stopJdbcTimer();
                    if (bl) break block10;
                    this.printException(exception);
                }
            }
            this.m_conn = null;
        }
    }

    private void executePWD() {
        byte[] byArray = new byte[1024];
        if (!OdxCLJNative.getCurrentDir(byArray)) {
            this.printError("Unable to read current directory", new Object[0]);
        } else {
            String string = new String(byArray).trim();
            this.printString("%s", this.m_qaMode ? "<cwd>" : string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeSet(String string) throws Exception {
        String string2;
        String string3;
        int n = string.indexOf(32);
        if (n == -1) {
            n = string.indexOf(61);
        }
        if (n == -1) {
            string3 = string.toUpperCase();
            string2 = null;
        } else {
            string3 = string.substring(0, n).trim().toUpperCase();
            if (string.charAt(n) == '=') {
                ++n;
            }
            if ((string2 = string.substring(n).trim()).charAt(0) == '\"') {
                string2 = string2.substring(1, string2.length() - 1).trim();
            }
        }
        if (string3.equals("FILES")) {
            this.m_useThreadCount = this.parseThreads(string2);
            return;
        } else if (string3.equals("THREADS")) {
            this.m_fileThreadCount = this.parseThreads(string2);
            return;
        } else if (string3.equals("TERMINATION")) {
            this.m_termination = this.parseOnOff(string2, "TERMINATION");
            return;
        } else if (string3.equals("ERRORS")) {
            this.parseErrors(string2);
            return;
        } else if (string3.equals("BENCHMARK")) {
            this.m_benchmark = this.parseOnOff(string2, "BENCHMARK");
            return;
        } else if (string3.equals("TIMER")) {
            this.m_timer = this.parseOnOff(string2, "TIMER");
            return;
        } else if (string3.equals("TIMERONLY")) {
            this.m_timerOnly = this.parseOnOff(string2, "TIMERONLY");
            return;
        } else if (string3.equals("SIMPLEPROGRESS")) {
            this.m_progress = this.parseOnOff(string2, "SIMPLEPROGRESS") ? 3 : 2;
            return;
        } else if (string3.equals("FULLPROGRESS")) {
            this.m_progress = this.parseOnOff(string2, "FULLPROGRESS") ? 2 : 3;
            return;
        } else if (string3.equals("POOL")) {
            this.parsePool(string2);
            return;
        } else if (string3.equals("PAGELENGTH")) {
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 < 0 || n2 > 256) {
                    throw new JdbcsqlException("PAGELENTH must be set to a value between 0 and 256");
                }
                this.m_pageLength = n2;
                return;
            }
            catch (Exception exception) {
                throw new JdbcsqlException("PAGELENTH must be set to a value between 0 and 256");
            }
        } else if (string3.equals("DEBUG")) {
            Object object;
            String string4 = null;
            n = string2.indexOf(32);
            if (n == -1) {
                string2 = string2.toUpperCase();
            } else {
                object = string2.substring(n).trim();
                string2 = string2.substring(0, n).trim().toUpperCase();
                n = ((String)object).indexOf(61);
                if (n == -1) {
                    throw new JdbcsqlException("Invalid set debug syntax");
                }
                string4 = ((String)object).substring(n + 1).trim();
                if (!((String)(object = ((String)object).substring(0, n).trim().toUpperCase())).equals("FILE")) {
                    throw new JdbcsqlException("Invalid set debug syntax");
                }
            }
            if (string2.equals("ON")) {
                object = new File(string4 == null ? "jdbcdebug.log" : string4);
                OdxCLJTrace.setLogWriter(new PrintWriter(new FileWriter(((File)object).getAbsolutePath(), true)));
                return;
            } else {
                if (!string2.equals("OFF")) throw new JdbcsqlException("Invalid set debug syntax");
                OdxCLJTrace.setLogWriter(null);
            }
            return;
        } else if (string3.equals("$QA")) {
            this.qaMode(this.parseOnOff(string2, "$QA"));
            return;
        } else if (string3.equals("DEFAULTS")) {
            this.setDefaults();
            return;
        } else if (string3.equals("QUALIFY_COUNTS")) {
            this.parseQualifyCounts(string2);
            return;
        } else if (string3.equals("HEX")) {
            this.parseHex(string2);
            return;
        } else if (string3.equals("NULL_INDICATORS")) {
            this.parseNullIndicators(string2);
            return;
        } else if (string3.equals("MULTILINE")) {
            this.parseMultiLine(string2);
            return;
        } else if (string3.equals("EXPLAIN")) {
            this.parseExplain(string2);
            return;
        } else if (string3.equals("AUTOEXPLAIN")) {
            this.m_autoexplain = this.parseOnOff(string2, "AUTOEXPLAIN");
            return;
        } else {
            boolean bl = false;
            for (String string5 : SETTINGS) {
                if (!string3.equals(string5)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new JdbcsqlException(String.format("Unrecognized SET option [%s].  Type HELP for list of SET options", string));
            }
            if (string3.equals("AUTOFETCH")) {
                this.m_autoFetch = this.parseOnOff(string2, "AUTOFETCH");
            }
            if (this.m_conn != null) {
                this.startJdbcTimer();
                this.m_stmt.execute("set " + string);
                this.stopJdbcTimer();
            }
            if (this.m_setCommands == null) {
                this.m_setCommands = new ArrayList<String>();
            }
            this.m_setCommands.add("set " + string);
        }
    }

    private void executeUse(boolean bl, int n, int n2, int n3, int n4, boolean bl2, boolean bl3) {
        int n5;
        Object object;
        int n6;
        long l = System.currentTimeMillis();
        int n7 = this.m_useFiles.size() * n4;
        jdbcsql[] jdbcsqlArray = new jdbcsql[n7];
        char[] cArray = new char[77];
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n7);
        List<File> list = this.m_useFiles;
        if (n4 > 1) {
            list = new ArrayList<File>();
            for (n6 = 0; n6 < n4; ++n6) {
                for (int i = 0; i < this.m_useFiles.size(); ++i) {
                    list.add(this.m_useFiles.get(i));
                }
            }
        }
        for (n6 = 0; n6 < n7; ++n6) {
            File file = list.get(n6);
            String string = "log" + File.separator + file.getName();
            Integer n8 = (Integer)hashMap.get(string);
            if (n8 == null) {
                n8 = 1;
            } else {
                Integer n9 = n8;
                n8 = n8 + 1;
                object = n8;
            }
            hashMap.put(string, n8);
            if (n8 != 1) {
                string = String.format("%s%d", string, n8);
            }
            jdbcsqlArray[n6] = new jdbcsql();
            jdbcsqlArray[n6].useFile(file, new File(string), this, bl, n3, bl2, bl3);
            jdbcsqlArray[n6].runType(1);
            if (n6 != 0 || bl) continue;
            jdbcsqlArray[n6].logFile().getParentFile().mkdirs();
        }
        Semaphore semaphore = new Semaphore(n2, true);
        Thread[] threadArray = new Thread[n7];
        int n10 = 0;
        boolean bl4 = OdxCLJNative.isTTY(1);
        boolean bl5 = false;
        object = this.formatUseCommand(bl, n2, n3);
        if (n != 2) {
            this.printProgressHeader(cArray);
        }
        while (!bl5 && n10 < n7) {
            try {
                if (!semaphore.tryAcquire(500L, TimeUnit.MILLISECONDS)) {
                    if (bl4) {
                        if (n == 2) {
                            this.printFullProgress((String)object, jdbcsqlArray, l, n7, n10, n3, cArray);
                        } else {
                            this.printSimpleProgress(jdbcsqlArray, l, n7, n10, cArray);
                        }
                    }
                    if (this.m_onError != 3) continue;
                    bl5 = this.checkForError(jdbcsqlArray, n10);
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            jdbcsqlArray[n10].semaphore(semaphore);
            jdbcsqlArray[n10].startRunTime(System.currentTimeMillis());
            threadArray[n10] = new Thread(jdbcsqlArray[n10]);
            threadArray[n10++].start();
            if (bl4) {
                if (n == 2) {
                    this.printFullProgress((String)object, jdbcsqlArray, l, n7, n10, n3, cArray);
                } else {
                    this.printSimpleProgress(jdbcsqlArray, l, n7, n10, cArray);
                }
            }
            if (this.m_onError != 3) continue;
            bl5 = this.checkForError(jdbcsqlArray, n10);
        }
        while (!bl5) {
            n5 = -1;
            for (int i = 0; i < n10; ++i) {
                if (threadArray[i] == null) continue;
                if (jdbcsqlArray[i].exit()) {
                    threadArray[i] = null;
                    continue;
                }
                n5 = i;
            }
            if (n5 == -1) break;
            if (bl4) {
                if (n == 2) {
                    this.printFullProgress((String)object, jdbcsqlArray, l, n7, n10, n3, cArray);
                } else {
                    this.printSimpleProgress(jdbcsqlArray, l, n7, n10, cArray);
                }
            }
            try {
                threadArray[n5].join(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_onError != 3) continue;
            bl5 = this.checkForError(jdbcsqlArray, n10);
        }
        if (bl5) {
            for (n5 = 0; n5 < n10; ++n5) {
                if (threadArray[n5] == null) continue;
                try {
                    threadArray[n5].join();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_exit = true;
        } else {
            if (n != 2) {
                this.printSimpleProgress(jdbcsqlArray, l, n7, n10, cArray);
            }
            this.printSummary(bl4, n, (String)object, jdbcsqlArray, l, n7, n2, n3, cArray);
        }
    }

    private void executeFetch(String string) throws Exception {
        if (this.m_rs == null) {
            throw new JdbcsqlException("The requested option is not valid for oacursorinfo (No active select on cursor)");
        }
        int n = 1;
        if (string != null && string.length() != 0) {
            if ((string = string.toUpperCase()).equals("ALL")) {
                n = 0;
            } else {
                try {
                    n = Integer.parseInt(string);
                    if (n < 0) {
                        throw new JdbcsqlException("Parse error: Expected number or ALL after FETCH");
                    }
                }
                catch (Exception exception) {
                    throw new JdbcsqlException("Parse error: Expected number or ALL after FETCH");
                }
            }
        }
        this.printResultSet(n);
    }

    private void executeSleep(String string) throws Exception {
        try {
            int n = Integer.parseInt(string);
            if (n != 0) {
                Thread.sleep(n * 1000);
            }
            this.printString("Slept %d second%s", n, n != 1 ? "s" : "");
        }
        catch (Exception exception) {
            this.printString("Parse error: Expected seconds after SLEEP", new Object[0]);
        }
    }

    private void executeShellCommand(String string) throws Exception {
        String[] stringArray = new String[3];
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            stringArray[0] = "cmd.exe";
            stringArray[1] = "/C";
            stringArray[2] = string;
        } else {
            stringArray[0] = "/bin/sh";
            stringArray[1] = "-c";
            stringArray[2] = string;
        }
        Process process = Runtime.getRuntime().exec(stringArray);
        Thread thread = new Thread(new ShellOutputConsumer(process.getInputStream()));
        thread.start();
        process.waitFor();
        thread.join();
    }

    private String formatUseCommand(boolean bl, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder("> use ");
        stringBuilder.append(this.m_useCommand);
        if (bl || n != 1 || n2 != 1) {
            stringBuilder.append(" with ");
            if (bl) {
                stringBuilder.append("benchmark,");
            }
            if (n != 1) {
                stringBuilder.append(String.format("files=%d,", n));
            }
            if (n2 != 1) {
                stringBuilder.append(String.format("threads=%d,", n2));
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private boolean checkForError(jdbcsql[] jdbcsqlArray, int n) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!jdbcsqlArray[i].error()) continue;
            bl = true;
            for (int j = 0; j < n; ++j) {
                if (j == i || jdbcsqlArray[j].exit()) continue;
                jdbcsqlArray[j].cancel();
            }
            break;
        }
        return bl;
    }

    private void printProgressHeader(char[] cArray) {
        System.out.println();
        System.out.println(" File          Progress                                         Count   Elapsed");
        System.out.print(' ');
        Arrays.fill(cArray, '-');
        System.out.println(cArray);
    }

    private void printSimpleProgress(jdbcsql[] jdbcsqlArray, long l, int n, int n2, char[] cArray) {
        Object object;
        Arrays.fill(cArray, ' ');
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            object = jdbcsqlArray[i];
            boolean n3 = ((jdbcsql)object).exit();
            n5 += ((jdbcsql)object).count();
            if (n3) {
                ++n4;
            }
            if (n > 40) continue;
            cArray[i] = n3 ? 61 : 42;
        }
        String string = String.format("(%d/%d)", n4, n);
        if (n <= 40) {
            object = String.format("[%s]", String.valueOf(cArray, 0, n));
        } else {
            int n3;
            int n6 = Math.round((float)n4 / (float)n * 40.0f);
            if (n6 == 0) {
                n3 = 1;
            }
            Arrays.fill(cArray, 0, n3, '=');
            int n7 = (int)((float)n4 / (float)n * 100.0f);
            String string2 = String.format(" %2d%% ", n7);
            string2.getChars(0, string2.length(), cArray, n7 == 100 ? 18 : 19);
            object = String.format("[%s]", String.valueOf(cArray, 0, 40));
        }
        System.out.printf("\r %-13.13s%-42s%,13d%10s", string, object, n5, this.formatElapsed(System.currentTimeMillis() - l, false));
    }

    private void printFullProgress(String string, jdbcsql[] jdbcsqlArray, long l, int n, int n2, int n3, char[] cArray) {
        OdxCLJNative.clearScreen();
        System.out.println(string);
        this.printProgressHeader(cArray);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            jdbcsql jdbcsql2 = jdbcsqlArray[i];
            if (jdbcsql2.exit()) {
                ++n4;
                continue;
            }
            int n5 = 0;
            int n6 = 0;
            if (jdbcsql2.totalCount() != 0) {
                n5 = Math.round((float)jdbcsql2.count() / (float)jdbcsql2.totalCount() * 40.0f);
                n6 = jdbcsql2.count();
            }
            if (n5 == 0) {
                n5 = 1;
            }
            if (n6 == 0) {
                n6 = 1;
            }
            Arrays.fill(cArray, ' ');
            Arrays.fill(cArray, 0, n5, '=');
            if (jdbcsql2.totalCount() != 0) {
                int n7 = (int)((float)n6 / (float)jdbcsql2.totalCount() * 100.0f);
                String string2 = String.format(" %2d%% ", n7);
                string2.getChars(0, string2.length(), cArray, n7 == 100 ? 18 : 19);
            }
            System.out.printf(" %-13s|%-40s|%,13d %9s%n", jdbcsql2.logFile().getName(), String.valueOf(cArray, 0, 40), n6, this.formatElapsed(System.currentTimeMillis() - jdbcsql2.startRunTime(), false));
        }
        String string3 = String.format("Completed: %d   Running: %d   Queued: %d   Threads: %d", n4, n2 - n4, n - n2, (n2 - n4) * n3);
        System.out.print(' ');
        Arrays.fill(cArray, '-');
        System.out.println(cArray);
        System.out.printf(" %-63s     %10s%n", string3, this.formatElapsed(System.currentTimeMillis() - l, false));
        System.out.println();
    }

    private void printSummary(boolean bl, int n, String string, jdbcsql[] jdbcsqlArray, long l, int n2, int n3, int n4, char[] cArray) {
        if (n == 2) {
            if (bl) {
                OdxCLJNative.clearScreen();
            }
            System.out.println(string);
            this.printProgressHeader(cArray);
        } else if (n2 <= 40) {
            System.out.print("\r");
        } else {
            System.out.println();
        }
        long l2 = System.currentTimeMillis() - l;
        float f = (float)l2 / 40.0f;
        int n5 = 0;
        long l3 = 0L;
        for (jdbcsql jdbcsql2 : jdbcsqlArray) {
            long l4 = jdbcsql2.startRunTime() - l;
            long l5 = jdbcsql2.stopRunTime() - l;
            long l6 = jdbcsql2.stopRunTime() - jdbcsql2.startRunTime();
            int n6 = (int)((float)l4 / f);
            int n7 = (int)((float)l5 / f);
            if (n2 <= 40) {
                Arrays.fill(cArray, ' ');
                if (n6 == n7) {
                    cArray[n6] = 45;
                } else {
                    Arrays.fill(cArray, n6, n7, '=');
                }
                System.out.printf(" %-13s %-40s %,13d %9s%n", jdbcsql2.logFile().getName(), new String(cArray, 0, 40), jdbcsql2.count(), this.formatElapsed(l6, false));
            }
            n5 += jdbcsql2.count();
            l3 += l6 * (long)n4;
        }
        String string2 = String.format("Total (%d files)", n2);
        String string3 = String.format("%,d", Math.round((float)n5 / ((float)l2 / 1000.0f)));
        String string4 = String.format(String.format("%%,%dd", string3.length()), Math.round((float)n5 / ((float)l3 / 1000.0f)));
        System.out.print(' ');
        Arrays.fill(cArray, '-');
        System.out.println(cArray);
        System.out.printf(" %-53s  %,13d %9s%n", string2, n5, this.formatElapsed(l2, false));
        System.out.println();
        System.out.printf(" %s per second%n", string3);
        System.out.printf(" %s per second per thread%n%n", string4);
    }

    public String formatElapsed(long l, boolean bl) {
        if (l < 0L) {
            return bl ? "0.000" : "0:00";
        }
        if (!bl) {
            l += 500L;
        }
        int n = (int)(l / 3600000L);
        int n2 = (int)((l %= 3600000L) / 60000L);
        int n3 = (int)((l %= 60000L) / 1000L);
        int n4 = (int)(l % 1000L);
        if (n > 0) {
            return String.format("%d:%02d:%02d", n, n2, n3);
        }
        if (n2 > 0) {
            return bl ? String.format("%d:%02d.%03d", n2, n3, n4) : String.format("%d:%02d", n2, n3);
        }
        return bl ? String.format("%d.%03d", n3, n4) : String.format("0:%02d", n3);
    }

    private String removeColumnOption(String string) {
        String string2;
        String string3 = string.toUpperCase();
        int n = string3.lastIndexOf("WITH ");
        if (n != -1 && (string2 = string3.substring(n + 5).trim()).equals("COLUMN")) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String addOptions(String string, String string2) {
        String string3 = string.toUpperCase();
        string = string3.lastIndexOf("WITH ") == -1 ? string + " with " : string + " ";
        string = string + string2;
        return string;
    }

    private void displayExplain() throws Exception {
        while (true) {
            this.startJdbcTimer();
            boolean bl = this.m_rs.next();
            this.stopJdbcTimer();
            if (!bl) break;
            String string = this.m_rs.getString(1);
            if (this.m_rs.wasNull()) {
                string = "";
            }
            this.printString(string, new Object[0]);
        }
    }

    private void displayCountResult(SqlStmt sqlStmt) throws Exception {
        this.startJdbcTimer();
        int n = this.m_stmt.getUpdateCount();
        this.stopJdbcTimer();
        if (n < 0) {
            this.printString("No result set.", new Object[0]);
        } else {
            switch (sqlStmt.Type) {
                case SQL_CREATE_SEGMENT: {
                    this.printString("Segment %s created with %,d row%s", sqlStmt.Table, n, n != 1 ? "s" : "");
                    break;
                }
                case SQL_DELETE: {
                    this.printString("%,d row%s deleted from %s", n, n != 1 ? "s" : "", sqlStmt.Table);
                    break;
                }
                case SQL_EXPORT: {
                    this.printString("%,d row%s exported to %s", n, n != 1 ? "s" : "", this.m_qaMode ? "<filename>" : sqlStmt.Table);
                    break;
                }
                case SQL_INSERT: {
                    this.printString("%,d row%s inserted into %s", n, n != 1 ? "s" : "", sqlStmt.Table);
                    break;
                }
                case SQL_QUALIFY: 
                case SQL_JOIN: {
                    long l;
                    boolean bl = sqlStmt.Type == StmtType.SQL_QUALIFY;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(String.format("%,d %s", n, sqlStmt.Table));
                    if (this.m_parentCount) {
                        this.startJdbcTimer();
                        l = ((OdxJDBCStatement)this.m_stmt).getParentCount();
                        this.stopJdbcTimer();
                        if (this.m_parentCountSpecified && (sqlStmt.OwnerTable == null || !sqlStmt.OwnerTable.equals(sqlStmt.Table) || (long)n != l) || sqlStmt.OwnerTable != null && !sqlStmt.OwnerTable.equals(sqlStmt.Table) && ((long)n != l || n == 0)) {
                            stringBuilder.append(String.format(" (%,d %s)", l, sqlStmt.OwnerTable == null ? "Parent" : sqlStmt.OwnerTable));
                        }
                    }
                    if (this.m_preintersectCount) {
                        this.startJdbcTimer();
                        l = ((OdxJDBCStatement)this.m_stmt).getPreIntersectCount();
                        this.stopJdbcTimer();
                        stringBuilder.append(String.format(" (%,d Pre-intersect)", l));
                    }
                    if (n == 1) {
                        this.printString("%s record %s", stringBuilder.toString(), bl ? "qualifies" : "joins");
                        break;
                    }
                    this.printString("%s records %s", stringBuilder.toString(), bl ? "qualify" : "join");
                    break;
                }
                case SQL_SELECT_INTO: {
                    this.printString("%,d row%s inserted into %s", n, n != 1 ? "s" : "", sqlStmt.Table);
                    break;
                }
                case SQL_UPDATE: {
                    this.printString("%,d row%s updated in %s", n, n != 1 ? "s" : "", sqlStmt.Table);
                    break;
                }
                default: {
                    this.printString("%,d row%s affected", n, n != 1 ? "s" : "");
                }
            }
        }
    }

    private void executeSql(String string) throws Exception {
        try {
            if (this.m_timer) {
                this.m_startTimer = System.currentTimeMillis();
            }
            SqlStmt sqlStmt = new SqlStmt(string);
            if (sqlStmt.Type == StmtType.SQL_SELECT) {
                string = this.removeColumnOption(string);
            }
            if (this.m_autoexplain && (sqlStmt.Type == StmtType.SQL_CREATE_SEGMENT || sqlStmt.Type == StmtType.SQL_EXPORT || sqlStmt.Type == StmtType.SQL_JOIN || sqlStmt.Type == StmtType.SQL_QUALIFY || sqlStmt.Type == StmtType.SQL_SELECT || sqlStmt.Type == StmtType.SQL_SELECT_INTO)) {
                sqlStmt.Type = StmtType.SQL_EXPLAIN;
                string = "EXPLAIN " + string;
            }
            if (sqlStmt.Type == StmtType.SQL_EXPLAIN) {
                String string2 = String.format("oaexplainplan:PAGEWIDTH=%d oaexplainplan:TERMINATION=%s %s%s", 80, this.m_termination ? "ON" : "OFF", this.m_explain == null ? "" : this.m_explain, this.m_qaMode ? " oaexplainplan:$QA DETAILS ADDIN" : "");
                string = this.addOptions(string, string2);
                string = "$EXPLAINPLAN" + string.trim().substring(7);
            }
            this.startJdbcTimer();
            if (this.m_rs != null) {
                this.m_rs.close();
                this.m_rs = null;
            }
            if (this.m_stmt.execute(string)) {
                this.m_rs = this.m_stmt.getResultSet();
            }
            this.stopJdbcTimer();
            switch (sqlStmt.Type) {
                case SQL_CREATE_SEGMENT: 
                case SQL_DELETE: 
                case SQL_EXPORT: 
                case SQL_INSERT: 
                case SQL_QUALIFY: 
                case SQL_JOIN: 
                case SQL_SELECT_INTO: 
                case SQL_UPDATE: {
                    this.displayCountResult(sqlStmt);
                    break;
                }
                case SQL_ATTACH_DATABASE: {
                    this.printString("Database %s attached", sqlStmt.Table);
                    break;
                }
                case SQL_ATTACH_SEGMENT: {
                    this.printString("Segment %s attached", sqlStmt.Table);
                    break;
                }
                case SQL_ATTACH_TABLE: {
                    this.printString("Table %s attached", sqlStmt.Table);
                    break;
                }
                case SQL_CREATE_TABLE: {
                    this.printString("%s table %s created", sqlStmt.Permanent ? "Permanent" : "Temporary", sqlStmt.Table);
                    break;
                }
                case SQL_DETACH_DATABASE: {
                    this.printString("Database %s detached", sqlStmt.Table);
                    break;
                }
                case SQL_DETACH_SEGMENT: {
                    this.printString("Segment %s detached", sqlStmt.Table);
                    break;
                }
                case SQL_DETACH_TABLE: {
                    this.printString("Table %s detached", sqlStmt.Table);
                    break;
                }
                case SQL_DROP_SEGMENT: {
                    this.printString("Segment %s dropped", sqlStmt.Table);
                    break;
                }
                case SQL_DROP_TABLE: {
                    this.printString("%s table %s dropped", sqlStmt.Permanent ? "Permanent" : "Temporary", sqlStmt.Table);
                    break;
                }
                case SQL_EXPLAIN: {
                    if (this.m_rs == null) {
                        this.displayCountResult(sqlStmt);
                        break;
                    }
                    this.displayExplain();
                    break;
                }
                case SQL_REMOVE: {
                    this.printString("File %s removed", this.m_qaMode ? "<filename>" : sqlStmt.Table);
                    break;
                }
                case SQL_SELECT: {
                    if (!this.m_autoFetch) {
                        this.printString("Select statement processed", new Object[0]);
                        break;
                    }
                    if (this.m_rs == null) {
                        this.displayCountResult(sqlStmt);
                        break;
                    }
                    this.m_skipPrompt = this.m_pageLength == 0;
                    this.printResultSet(0);
                    break;
                }
                case SQL_SETENV: {
                    this.printString("Environment variable set", new Object[0]);
                    break;
                }
                default: {
                    if (this.m_rs == null) {
                        this.displayCountResult(sqlStmt);
                        break;
                    }
                    this.m_skipPrompt = this.m_pageLength == 0;
                    this.printResultSet(0);
                }
            }
            if (this.m_timer) {
                this.m_stopTimer = System.currentTimeMillis();
            }
        }
        catch (Exception exception) {
            this.stopJdbcTimer();
            this.setErrorsFlag();
            this.printException(exception);
        }
    }

    private void setErrorsFlag() {
        if (this.m_onError == 3 || this.m_onError == 2) {
            this.m_error = true;
        } else if (this.m_testDirExist) {
            this.m_skipInput = true;
        }
    }

    private void printResultSet(int n) throws Exception {
        this.startJdbcTimer();
        ResultSetMetaData resultSetMetaData = this.m_rs.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        this.stopJdbcTimer();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = this.getRowSize(resultSetMetaData, n2, nArray2, nArray);
        int n4 = 0;
        char[] cArray = new char[Math.min(77, n3) + 2];
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        this.m_columnHeader = new ArrayList<String>();
        this.formatColumnHeader(resultSetMetaData, n2, nArray2, nArray, this.m_columnHeader);
        if (!this.m_qaMode) {
            this.printString();
        }
        for (String string : this.m_columnHeader) {
            this.printString(string, new Object[0]);
        }
        do {
            int n5;
            StringBuilder stringBuilder;
            byte[] byArray;
            String string2;
            int n6;
            this.startJdbcTimer();
            boolean bl2 = this.m_rs.next();
            this.stopJdbcTimer();
            if (!bl2) break;
            if (this.m_timer && this.m_stopTimer == 0L && this.m_interactive) {
                this.m_stopTimer = System.currentTimeMillis();
            }
            int n7 = 0;
            for (n6 = 0; n6 < n2; ++n6) {
                if (this.m_hexMode == 1) {
                    string2 = this.getString(n6, nArray2);
                } else {
                    byArray = this.getBytes(n6, nArray2);
                    stringBuilder = new StringBuilder();
                    for (n5 = 0; n5 < byArray.length; ++n5) {
                        stringBuilder.append(String.format("%02x", byArray[n5]));
                    }
                    string2 = stringBuilder.toString();
                }
                n7 = this.writeOutput(arrayList, cArray, null, string2, nArray[n6], n7);
            }
            arrayList.add(new String(cArray, 0, n7 + 2));
            if (this.m_hexMode == 2) {
                n7 = 0;
                for (n6 = 0; n6 < n2; ++n6) {
                    byArray = this.getBytes(n6, nArray2);
                    stringBuilder = new StringBuilder();
                    for (n5 = 0; n5 < byArray.length; ++n5) {
                        stringBuilder.append(String.format(" %c", Character.valueOf(byArray[n5] >= 32 && byArray[n5] <= 126 ? (char)byArray[n5] : (char)'.')));
                    }
                    string2 = stringBuilder.toString();
                    n7 = this.writeOutput(arrayList, cArray, null, string2, nArray[n6], n7);
                }
                arrayList.add(new String(cArray, 0, n7 + 2));
            }
            if (!this.m_skipPrompt && this.m_lineNumber + arrayList.size() > this.m_pageLength) {
                this.printUntilEndOfPage(0);
                bl = this.printString();
            }
            if (!bl) {
                for (String string2 : arrayList) {
                    if (!this.printString(string2, new Object[0])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) break;
            arrayList.clear();
        } while (n == 0 || n != ++n4);
        if (!bl) {
            if (!this.m_skipPrompt) {
                this.printUntilEndOfPage(1);
            }
            this.printString("%d row%s returned", n4, n4 == 1 ? "" : "s");
        }
        this.m_columnHeader = null;
        if (!this.m_interactive && this.m_timer) {
            this.m_stopTimer = System.currentTimeMillis();
        }
    }

    private String getString(int n, int[] nArray) throws Exception {
        int n2 = n + 1;
        this.startJdbcTimer();
        String string = this.m_rs.getString(n2);
        if (this.m_rs.wasNull()) {
            string = this.m_nullIndicators != null ? this.m_nullIndicators : "";
        } else if (nArray[n] == 1) {
            string = this.trimTrailing(string, false);
        } else if (nArray[n] == 12 || nArray[n] == 2005) {
            string = string.replace('\u0000', ' ');
        }
        this.stopJdbcTimer();
        return string;
    }

    private byte[] getBytes(int n, int[] nArray) throws Exception {
        byte[] byArray = new byte[]{};
        int n2 = n + 1;
        this.startJdbcTimer();
        switch (nArray[n]) {
            case 1: 
            case 12: {
                String string = this.m_rs.getString(n2);
                if (this.m_rs.wasNull()) break;
                byArray = string.getBytes();
                break;
            }
            case 2005: {
                Clob clob = this.m_rs.getClob(n2);
                if (this.m_rs.wasNull()) break;
                byArray = clob.getSubString(0L, (int)clob.length()).getBytes();
                break;
            }
            case 2004: {
                Blob blob = this.m_rs.getBlob(n2);
                if (this.m_rs.wasNull()) break;
                byArray = blob.getBytes(0L, (int)blob.length());
                break;
            }
            case -6: {
                byte by = this.m_rs.getByte(n2);
                byArray = ByteBuffer.allocate(1).order(ByteOrder.nativeOrder()).put(by).array();
                break;
            }
            case 5: {
                short s = this.m_rs.getShort(n2);
                byArray = ByteBuffer.allocate(2).order(ByteOrder.nativeOrder()).putShort(s).array();
                break;
            }
            case 4: {
                int n3 = this.m_rs.getInt(n2);
                byArray = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(n3).array();
                break;
            }
            case -5: {
                long l = this.m_rs.getLong(n2);
                byArray = ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(l).array();
                break;
            }
            case 7: {
                float f = this.m_rs.getFloat(n2);
                byArray = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putFloat(f).array();
                break;
            }
            case 6: 
            case 8: {
                double d = this.m_rs.getDouble(n2);
                byArray = ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putDouble(d).array();
                break;
            }
            default: {
                byArray = this.m_rs.getBytes(n2);
            }
        }
        this.stopJdbcTimer();
        return byArray;
    }

    private int getRowSize(ResultSetMetaData resultSetMetaData, int n, int[] nArray, int[] nArray2) throws Exception {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.startJdbcTimer();
            nArray[i] = resultSetMetaData.getColumnType(i + 1);
            if (this.m_hexMode == 1) {
                nArray2[i] = resultSetMetaData.getColumnDisplaySize(i + 1);
            } else {
                switch (nArray[i]) {
                    case -6: {
                        nArray2[i] = 1;
                        break;
                    }
                    case 5: {
                        nArray2[i] = 2;
                        break;
                    }
                    case 4: 
                    case 7: {
                        nArray2[i] = 4;
                        break;
                    }
                    case -5: 
                    case 6: 
                    case 8: {
                        nArray2[i] = 8;
                        break;
                    }
                    default: {
                        nArray2[i] = resultSetMetaData.getPrecision(i + 1);
                    }
                }
                int n3 = i;
                nArray2[n3] = nArray2[n3] * 2;
            }
            this.stopJdbcTimer();
            if (nArray2[i] == 0) {
                nArray2[i] = 1;
                if (this.m_hexMode != 1) {
                    int n4 = i;
                    nArray2[n4] = nArray2[n4] + 1;
                }
            }
            n2 += nArray2[i] + 2;
        }
        return n2;
    }

    private int writeOutput(List<String> list, char[] cArray, char[] cArray2, String string, int n, int n2) {
        int n3 = 77;
        if (this.m_hexMode != 1 && n3 % 2 != 0) {
            --n3;
        }
        int n4 = cArray2 == null ? this.m_multiLine : 1;
        int n5 = Math.min(string.length(), n);
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            if (n2 != 0 && (n2 += 2) + (n8 = i > 0 ? n5 - n6 : n - n6) >= n3) {
                list.add(new String(cArray, 0, n2));
                if (cArray2 != null) {
                    list.add(new String(cArray2, 0, n2));
                }
                n2 = 0;
            }
            if (n2 == 0) {
                Arrays.fill(cArray, ' ');
                if (cArray2 != null) {
                    Arrays.fill(cArray2, ' ');
                }
            }
            if (i > 0) {
                cArray[0] = 62;
                cArray[1] = 62;
                cArray[2] = 32;
                n2 += 3;
            }
            int n9 = Math.min(n3 - n2, n5 - n6);
            int n10 = string.indexOf(10, n6);
            if (n10 != -1 && n10 >= n6 && n10 < n6 + n9) {
                n9 = n10 - n6;
            }
            n8 = i > 0 ? n3 - n2 : Math.min(n3 - n2, n - n6);
            if (i < n4 - 1 && n6 + n9 < n5 && n10 == -1 && (n7 = string.lastIndexOf(32, n6 + n9)) != -1 && n7 > n6 && n7 < n6 + n9) {
                n9 -= n6 + n9 - n7 - 1;
            }
            string.getChars(n6, n6 + n9, cArray, n2);
            if (cArray2 != null) {
                Arrays.fill(cArray2, n2, n2 + n8, '-');
            }
            int n11 = n10 != -1 ? 1 : 0;
            n2 += n8;
            if ((n6 += n9 + n11) == n5) break;
            if (i != n4 - 1 || cArray2 != null || this.m_hexMode != 1 || n < 3) continue;
            n7 = i > 0 ? Math.min(n9 + 3, n3 - 3) : Math.min(n2 - n8 + n9, n2 - 3);
            Arrays.fill(cArray, n7, n7 + 3, '.');
        }
        return n2;
    }

    private String replaceNonPrintable(String string) {
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            cArray[i] = string.charAt(i);
            if (!Character.isISOControl(cArray[i])) continue;
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    private void formatColumnHeader(ResultSetMetaData resultSetMetaData, int n, int[] nArray, int[] nArray2, List<String> list) throws Exception {
        char[] cArray = new char[79];
        char[] cArray2 = new char[79];
        if (this.m_qaMode) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder.append("[SELECT_ITEMS=");
            for (int i = 0; i < n; ++i) {
                String string;
                stringBuilder2.setLength(0);
                this.startJdbcTimer();
                String string2 = resultSetMetaData.getCatalogName(i + 1);
                this.stopJdbcTimer();
                if (string2.length() == 0) {
                    this.startJdbcTimer();
                    string2 = resultSetMetaData.getColumnLabel(i + 1);
                    this.stopJdbcTimer();
                    if (string2.length() != 0) {
                        string2 = this.replaceNonPrintable(string2);
                    }
                    stringBuilder2.append(string2);
                } else {
                    this.startJdbcTimer();
                    string = resultSetMetaData.getSchemaName(i + 1);
                    String string3 = resultSetMetaData.getTableName(i + 1);
                    String string4 = resultSetMetaData.getColumnName(i + 1);
                    this.stopJdbcTimer();
                    stringBuilder2.append(string2);
                    stringBuilder2.append(".");
                    stringBuilder2.append(string);
                    stringBuilder2.append(".");
                    stringBuilder2.append(string3);
                    stringBuilder2.append(".");
                    stringBuilder2.append(string4);
                }
                this.startJdbcTimer();
                string = resultSetMetaData.getColumnTypeName(i + 1);
                this.stopJdbcTimer();
                int n2 = Math.min(77 * this.m_multiLine, nArray2[i]) + 1;
                if (string == "CHAR" || string == "VARCHAR") {
                    string = string + String.format("(%d)", this.m_hexMode == 1 ? nArray2[i] : nArray2[i] / 2);
                }
                stringBuilder.append(String.format("%n%d,,\"%s\",,%s,,", i + 1, stringBuilder2, string));
                if (this.m_hexMode == 1) {
                    stringBuilder.append(String.format("STRING(%d)", n2));
                    continue;
                }
                stringBuilder.append(String.format("HEX(%d)", nArray2[i]));
            }
            stringBuilder.append(String.format("]%n", new Object[0]));
            this.printString(stringBuilder.toString(), new Object[0]);
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 = this.writeOutput(list, cArray, cArray2, this.replaceNonPrintable(resultSetMetaData.getColumnLabel(i + 1)), Math.min(77, nArray2[i]), n3);
        }
        list.add(new String(cArray, 0, n3 + 2));
        list.add(new String(cArray2, 0, n3 + 2));
    }

    private String parseConnectionString(String string, StringBuilder stringBuilder) throws IOException {
        int n;
        String string2 = string;
        String string3 = null;
        if (string.charAt(0) == '[' && (n = string.indexOf(93)) != -1) {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1);
        }
        if ((n = string2.indexOf(38)) != -1) {
            stringBuilder.append(string2.substring(n + 1));
            string2 = string2.substring(0, n);
        }
        File file = new File(string2);
        if (string2.charAt(0) != '{' && !file.isAbsolute() && !string2.equalsIgnoreCase("omnidex")) {
            n = file.getName().lastIndexOf(46);
            if (n == -1 && !(file = new File(string2 + ".dsn")).exists() && !(file = new File(string2 + ".xml")).exists()) {
                file = new File(string2);
            }
            string = string3 != null ? string3 + file.getAbsolutePath() : file.getAbsolutePath();
        }
        return string;
    }

    private void trace(String string) {
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter("jdbcsql.log", true), true);
            printWriter.printf(string, new Object[0]);
            printWriter.println();
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void countTests(boolean bl) throws Exception {
        BufferedReader bufferedReader = null;
        try {
            int n;
            String string;
            int n2 = 0;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_useFile.getAbsolutePath()), this.m_encoding));
            int n3 = 0;
            int n4 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            boolean[] blArray = new boolean[]{false};
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            while (!Thread.currentThread().isInterrupted() && (string = bufferedReader.readLine()) != null) {
                ++n2;
                if ((string = string.trim()).length() == 0 || (n = this.parseInput(stringBuilder, string, blArray, true)) == 0) continue;
                switch (n) {
                    case 2: {
                        ++n3;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 13: {
                        ++n4;
                    }
                }
                if (!bl || n == 1) continue;
                arrayList.add(n2);
                arrayList2.add(n);
            }
            this.m_testDirExist = n3 != 0;
            int n5 = this.m_totalCount = this.m_testDirExist ? n3 : n4;
            if (bl) {
                this.m_lines = new int[2][arrayList.size()];
                n = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.m_lines[0][n++] = (Integer)iterator.next();
                }
                n = 0;
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    this.m_lines[1][n++] = (Integer)iterator.next();
                }
            }
            Object var14_13 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {}
    }

    private void runUseFileInteractive(PrintWriter printWriter) throws Exception {
        boolean bl = this.m_exit;
        this.m_exit = false;
        if (!this.m_benchmark && printWriter != null) {
            this.m_output = printWriter;
        }
        Iterator<File> iterator = this.m_useFiles.iterator();
        while (iterator.hasNext()) {
            File file;
            this.m_useFile = file = iterator.next();
            this.runUseFileSingleThread(false);
        }
        this.m_output = null;
        this.m_exit = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runUseFileSingleThread(boolean bl) throws Exception {
        BufferedReader bufferedReader = null;
        try {
            String string;
            if (bl) {
                this.countTests(false);
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean[] blArray = new boolean[]{false};
            String string2 = System.getenv(ENCODING_VAR);
            bufferedReader = string2 == null ? new BufferedReader(new FileReader(this.m_useFile.getAbsolutePath())) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_useFile.getAbsolutePath()), string2));
            while (!(Thread.currentThread().isInterrupted() || this.m_exit || this.m_error || (string = bufferedReader.readLine()) == null)) {
                if (blArray[0]) {
                    this.printString(">> %s", string);
                } else {
                    this.printString("> %s", string);
                }
                this.executeInput(stringBuilder, string, blArray);
            }
            Object var8_7 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {}
    }

    private void runUseFileMultiThread() throws Exception {
        int n;
        this.countTests(true);
        Thread[] threadArray = new Thread[this.m_fileThreadCount];
        for (n = 0; n < this.m_fileThreadCount; ++n) {
            jdbcsql jdbcsql2 = new jdbcsql();
            jdbcsql2.useFile(this.m_useFile, new File(String.format("%s.%d", this.m_logFile.getAbsolutePath(), n + 1)), this, this.m_benchmark, 1, this.m_timer, this.m_timerOnly);
            jdbcsql2.runType(2);
            threadArray[n] = new Thread(jdbcsql2);
            threadArray[n].start();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (threadArray[i].isAlive()) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        for (n = 0; n < this.m_fileThreadCount; ++n) {
            if (threadArray[n] == null) continue;
            threadArray[n].join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runCommands() throws Exception {
        BufferedReader bufferedReader = null;
        try {
            String string = System.getenv(ENCODING_VAR);
            bufferedReader = string == null ? new BufferedReader(new FileReader(this.m_useFile.getAbsolutePath())) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_useFile.getAbsolutePath()), string));
            StringBuilder stringBuilder = new StringBuilder();
            boolean[] blArray = new boolean[]{false};
            String string2 = null;
            int n = 0;
            int n2 = 0;
            int[][] nArray = this.m_parent.lines();
            while (!(Thread.currentThread().isInterrupted() || this.m_exit || this.m_error)) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n3 = 0;
                int n4 = 0;
                jdbcsql jdbcsql2 = this.m_parent;
                synchronized (jdbcsql2) {
                    while (n < nArray[0].length) {
                        int n5 = nArray[1][n];
                        if (n5 == 2) {
                            if (bl) {
                                n4 = nArray[0][n - 1];
                                break;
                            }
                            n3 = nArray[0][n];
                            bl = true;
                            bl2 = true;
                            this.m_parent.incrementTestCount();
                        } else if (n5 == 4) {
                            if (bl) {
                                n4 = nArray[0][n - 1];
                                break;
                            }
                            n3 = nArray[0][n];
                            bl = true;
                            bl3 = true;
                        } else {
                            if (n5 == 5) {
                                if (!bl3) {
                                    this.printError("Unmatched END_COMMON directive", new Object[0]);
                                    this.m_exit = true;
                                    this.m_error = true;
                                    break;
                                }
                                n4 = nArray[0][n];
                                ++n;
                                break;
                            }
                            if (n5 != 0 && !bl2 && !bl3) {
                                if (bl) {
                                    n4 = nArray[0][n - 1];
                                    break;
                                }
                                n3 = nArray[0][n];
                                bl = true;
                            }
                        }
                        if (n5 == 7 || n5 == 8 || n5 == 13) {
                            this.m_parent.incrementStmtCount();
                        }
                        if (bl2 || n5 == 13) {
                            nArray[1][n] = 0;
                        }
                        ++n;
                    }
                    if (bl && n4 == 0) {
                        n4 = nArray[0][n - 1];
                    }
                    if (this.m_error) {
                        this.m_parent.error(this.m_error);
                    } else {
                        this.m_error = this.m_parent.error();
                    }
                }
                if (!bl || this.m_exit || this.m_error) break;
                blArray[0] = false;
                while (!Thread.currentThread().isInterrupted() && !this.m_exit && n2 < n4) {
                    string2 = bufferedReader.readLine();
                    if (string2 == null) {
                        this.m_exit = true;
                        continue;
                    }
                    if (++n2 < n3) continue;
                    if (blArray[0]) {
                        this.printString(">> %s", string2);
                    } else {
                        this.printString("> %s", string2);
                    }
                    this.executeInput(stringBuilder, string2, blArray);
                }
            }
            Object var18_17 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {}
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SqlStmt {
        public StmtType Type = StmtType.SQL_OTHER;
        public String OwnerTable;
        public String Table;
        public boolean Permanent;
        private String m_origSql;

        public SqlStmt(String string) {
            this.m_origSql = string;
            string = string.trim().toUpperCase();
            int n = 0;
            for (n = 0; n < string.length() && string.charAt(n) == '('; ++n) {
            }
            if (n != 0) {
                string = string.substring(n);
            }
            String string2 = (n = string.indexOf(32)) != -1 ? string.substring(0, n).trim() : string;
            this.Type = StmtType.SQL_OTHER;
            if (string2.equals("ATTACH")) {
                this.parseAttach(string);
            } else if (string2.equals("CREATE")) {
                this.parseCreate(string);
            } else if (string2.equals("DELETE")) {
                this.parseDelete(string);
            } else if (string2.equals("DETACH")) {
                this.parseDetach(string);
            } else if (string2.equals("DROP")) {
                this.parseDrop(string);
            } else if (string2.equals("EXPLAIN")) {
                this.parseExplain(string);
            } else if (string2.equals("EXPORT")) {
                this.parseExport(string);
            } else if (string2.equals("INSERT")) {
                this.parseInsert(string);
            } else if (string2.equals("JOIN")) {
                this.parseJoin(string);
            } else if (string2.equals("QUALIFY")) {
                this.parseQualify(string);
            } else if (string2.equals("REMOVE")) {
                this.parseRemove(string);
            } else if (string2.equals("SELECT")) {
                this.parseSelect(string);
            } else if (string2.equals("SETENV")) {
                this.Type = StmtType.SQL_SETENV;
            } else if (string2.equals("UPDATE")) {
                this.parseUpdate(string);
            }
        }

        private void parseAttach(String string) {
            string = string.substring(7).trim();
            List<String> list = this.parseKeywords(string);
            int n = list.size();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                String string2 = list.get(n2);
                switch (n3) {
                    case 0: {
                        if (string2.equals("INDEX")) {
                            ++n2;
                        } else if (string2.equals("DATA")) {
                            ++n2;
                        }
                        ++n3;
                        break;
                    }
                    case 1: {
                        if (string2.equals("SEGMENT")) {
                            this.Type = StmtType.SQL_ATTACH_SEGMENT;
                            ++n2;
                        } else if (string2.equals("TABLE")) {
                            this.Type = StmtType.SQL_ATTACH_TABLE;
                            ++n2;
                        } else if (string2.equals("DATABASE") || string2.equals("OST")) {
                            if (string2.equals("DATABASE")) {
                                this.Type = StmtType.SQL_ATTACH_DATABASE;
                                string = string.substring(9).trim();
                            } else {
                                this.Type = StmtType.SQL_ATTACH_TABLE;
                                string = string.substring(4).trim();
                            }
                            int n4 = 32;
                            if (string.charAt(0) == '\"') {
                                n4 = 34;
                            }
                            if ((n2 = string.indexOf(n4)) == -1) {
                                return;
                            }
                            if (!(string = string.substring(n2 + 1).trim()).startsWith("AS ")) {
                                return;
                            }
                            this.Table = this.removeDBName(this.parseTable(string.substring(3).trim()));
                            n2 = n;
                        } else {
                            n2 = n;
                        }
                        ++n3;
                        break;
                    }
                    case 2: {
                        this.Table = this.removeDBName(string2);
                        n2 = n;
                    }
                }
            }
        }

        private void parseCreate(String string) {
            string = string.substring(7).trim();
            List<String> list = this.parseKeywords(string);
            int n = list.size();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                String string2 = list.get(n2);
                switch (n3) {
                    case 0: {
                        if (string2.equals("PERMANENT")) {
                            this.Permanent = true;
                            ++n2;
                        } else if (string2.equals("TEMPORARY")) {
                            this.Permanent = false;
                            ++n2;
                        }
                        ++n3;
                        break;
                    }
                    case 1: {
                        if (string2.equals("INDEX")) {
                            ++n2;
                        } else if (string2.equals("DATA")) {
                            ++n2;
                        }
                        ++n3;
                        break;
                    }
                    case 2: {
                        if (string2.equals("SEGMENT")) {
                            this.Type = StmtType.SQL_CREATE_SEGMENT;
                            ++n2;
                        } else if (string2.equals("TABLE")) {
                            this.Type = StmtType.SQL_CREATE_TABLE;
                            ++n2;
                        } else {
                            n2 = n;
                        }
                        ++n3;
                        break;
                    }
                    case 3: {
                        this.Table = this.removeDBName(string2);
                        n2 = n;
                    }
                }
            }
        }

        private void parseDelete(String string) {
            if ((string = string.substring(7).trim()).startsWith("FROM ")) {
                this.Table = this.parseTable(string.substring(5).trim());
                this.Type = StmtType.SQL_DELETE;
            }
        }

        private void parseDetach(String string) {
            if ((string = string.substring(7).trim()).startsWith("DATABASE ")) {
                this.Table = string.substring(9).trim();
                this.Type = StmtType.SQL_DETACH_DATABASE;
            } else if (string.startsWith("SEGMENT ")) {
                this.Table = string.substring(8).trim();
                this.Type = StmtType.SQL_DETACH_SEGMENT;
            } else if (string.startsWith("TABLE ")) {
                this.Table = this.parseTable(string.substring(6).trim());
                this.Type = StmtType.SQL_DETACH_TABLE;
            } else if (string.startsWith("OST ")) {
                this.Table = this.parseTable(string.substring(4).trim());
                this.Type = StmtType.SQL_DETACH_TABLE;
            }
        }

        private void parseDrop(String string) {
            string = string.substring(5).trim();
            List<String> list = this.parseKeywords(string);
            int n = list.size();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                String string2 = list.get(n2);
                switch (n3) {
                    case 0: {
                        if (string2.equals("PERMANENT")) {
                            this.Permanent = true;
                            ++n2;
                        } else if (string2.equals("TEMPORARY")) {
                            this.Permanent = false;
                            ++n2;
                        }
                        ++n3;
                        break;
                    }
                    case 1: {
                        if (string2.equals("SEGMENT")) {
                            this.Type = StmtType.SQL_DROP_SEGMENT;
                            ++n2;
                        } else if (string2.equals("TABLE")) {
                            this.Type = StmtType.SQL_DROP_TABLE;
                            ++n2;
                        } else {
                            n2 = n;
                        }
                        ++n3;
                        break;
                    }
                    case 2: {
                        if (string2.equals("IF")) {
                            ++n2;
                            ++n3;
                            break;
                        }
                        n3 += 2;
                        break;
                    }
                    case 3: {
                        n2 = string2.equals("EXISTS") ? ++n2 : n;
                        ++n3;
                        break;
                    }
                    case 4: {
                        this.Table = this.removeDBName(string2);
                        n2 = n;
                    }
                }
            }
        }

        private void parseExplain(String string) {
            this.Type = StmtType.SQL_EXPLAIN;
        }

        private void parseExport(String string) {
            string = this.m_origSql.toUpperCase();
            int n = string.lastIndexOf("TO ");
            if (n == -1) {
                return;
            }
            string = this.m_origSql.substring(n + 3).trim();
            if (string.charAt(0) == '\"') {
                n = string.indexOf(34, 1);
                if (n != -1) {
                    this.Table = string.substring(1, n);
                }
            } else {
                n = string.indexOf(32);
                this.Table = n == -1 ? string : string.substring(0, n);
            }
            this.Type = StmtType.SQL_EXPORT;
        }

        private void parseInsert(String string) {
            if ((string = string.substring(7).trim()).startsWith("INTO ")) {
                this.Table = this.parseTable(string.substring(5).trim());
                this.Type = StmtType.SQL_INSERT;
            }
        }

        private void parseJoin(String string) {
            string = string.substring(5).trim();
            List<String> list = this.parseKeywords(string);
            int n = list.size();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                String string2 = list.get(n2);
                switch (n3) {
                    case 0: {
                        if (string2.equals("FROM")) {
                            ++n2;
                        }
                        ++n3;
                        break;
                    }
                    case 1: {
                        ++n2;
                        ++n3;
                        break;
                    }
                    case 2: {
                        n2 = string2.equals("USING") ? ++n2 : n;
                        ++n3;
                        break;
                    }
                    case 3: {
                        ++n2;
                        ++n3;
                        break;
                    }
                    case 4: {
                        n2 = string2.equals("TO") ? ++n2 : n;
                        ++n3;
                        break;
                    }
                    case 5: {
                        if (string2.charAt(0) == '(') {
                            if (string2.endsWith(")")) {
                                this.OwnerTable = string2.substring(1, string2.length() - 1);
                                ++n2;
                            } else {
                                int n4 = string2.indexOf(41);
                                if (n4 != -1) {
                                    this.OwnerTable = string2.substring(1, n4);
                                    this.Table = string2.substring(n4 + 1);
                                    this.Type = StmtType.SQL_JOIN;
                                }
                                n2 = n;
                            }
                        } else {
                            this.Table = string2;
                            this.Type = StmtType.SQL_JOIN;
                            n2 = n;
                        }
                        ++n3;
                        break;
                    }
                    case 6: {
                        this.Table = string2;
                        n2 = n;
                    }
                }
            }
        }

        private void parseQualify(String string) {
            int n = (string = string.substring(8).trim()).indexOf(32);
            if (n == -1) {
                this.Table = string;
            } else {
                String string2 = string.substring(0, n).trim();
                if (string2.charAt(0) == '(') {
                    if (string2.endsWith(")")) {
                        this.OwnerTable = string2.substring(1, string2.length() - 1);
                        string2 = string.substring(n).trim();
                        this.Table = string2.substring(0, string2.indexOf(32)).trim();
                    } else {
                        n = string2.indexOf(41);
                        if (n != -1) {
                            this.OwnerTable = string2.substring(1, n);
                            this.Table = string2.substring(n + 1);
                        }
                    }
                } else {
                    this.Table = string2;
                }
            }
            this.Type = StmtType.SQL_QUALIFY;
        }

        private void parseRemove(String string) {
            this.Table = this.parseTable(string.substring(7).trim());
            this.Type = StmtType.SQL_REMOVE;
        }

        private void parseSelect(String string) {
            this.Type = StmtType.SQL_SELECT;
            List<String> list = this.parseKeywords(string);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!list.get(i).equals("INTO")) continue;
                if (i + 1 >= n) break;
                this.Type = StmtType.SQL_SELECT_INTO;
                this.OwnerTable = list.get(i + 1);
                this.Table = this.removeDBName(list.get(i + 1));
                break;
            }
        }

        private void parseUpdate(String string) {
            if (!((string = string.substring(7).trim()).startsWith("DELIMITED ") || string.startsWith("INDEXES ") || string.startsWith("POWERSEARCH ") || string.startsWith("ROLLUP ") || string.startsWith("ROLLUPS ") || string.startsWith("STATISTICS "))) {
                this.Type = StmtType.SQL_UPDATE;
                this.Table = this.parseTable(string);
            }
        }

        private String parseTable(String string) {
            int n;
            int n2 = 32;
            if (string.charAt(0) == '\"') {
                n2 = 34;
            }
            return (n = string.indexOf(n2)) == -1 ? string : string.substring(0, n).trim();
        }

        private void addKeyword(List<String> list, char[] cArray, int n) {
            if (cArray[0] == '.') {
                int n2 = list.size() - 1;
                String string = list.get(n2) + new String(cArray, 0, n);
                list.set(n2, string);
            } else {
                list.add(new String(cArray, 0, n));
            }
        }

        private List<String> parseKeywords(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            char[] cArray = new char[string.length()];
            int n = 0;
            char c = '\u0000';
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c2 == '\"' || c2 == '\'') {
                    if (c2 == c) {
                        this.addKeyword(arrayList, cArray, n);
                        n = 0;
                        c = '\u0000';
                        continue;
                    }
                    if (c == '\u0000') {
                        c = c2;
                        continue;
                    }
                    cArray[n++] = c2;
                    continue;
                }
                if (c != '\u0000') {
                    cArray[n++] = c2;
                    continue;
                }
                if (Character.isISOControl(c2) || c2 == ' ') {
                    if (n == 0) continue;
                    this.addKeyword(arrayList, cArray, n);
                    n = 0;
                    continue;
                }
                cArray[n++] = c2;
            }
            if (n != 0) {
                this.addKeyword(arrayList, cArray, n);
            }
            return arrayList;
        }

        private String removeDBName(String string) {
            int n = string.indexOf(46);
            if (n != -1) {
                if ((string = string.substring(n + 1)).charAt(0) == '\"') {
                    string = string.substring(1);
                }
                if (string.endsWith("\"")) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StmtType {
        SQL_OTHER,
        SQL_ATTACH_DATABASE,
        SQL_ATTACH_SEGMENT,
        SQL_ATTACH_TABLE,
        SQL_CREATE_SEGMENT,
        SQL_CREATE_TABLE,
        SQL_DELETE,
        SQL_DETACH_DATABASE,
        SQL_DETACH_SEGMENT,
        SQL_DETACH_TABLE,
        SQL_DROP_SEGMENT,
        SQL_DROP_TABLE,
        SQL_EXPLAIN,
        SQL_EXPORT,
        SQL_INSERT,
        SQL_JOIN,
        SQL_QUALIFY,
        SQL_REMOVE,
        SQL_SELECT,
        SQL_SELECT_INTO,
        SQL_SETENV,
        SQL_UPDATE;

    }

    public class ShellOutputConsumer
    implements Runnable {
        private BufferedReader m_reader;

        public ShellOutputConsumer(InputStream inputStream) {
            this.m_reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void run() {
            try {
                String string;
                while ((string = this.m_reader.readLine()) != null) {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class ConnectionPool {
        private String m_propertyFile;
        private DataSource m_dataSource;

        private ConnectionPool(String string) {
            this.propertyFile(string);
        }

        private void propertyFile(String string) {
            this.m_propertyFile = string;
            if (this.m_dataSource != null) {
                this.m_dataSource = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection getConnection() throws Exception {
            if (this.m_dataSource == null) {
                ConnectionPool connectionPool = this;
                synchronized (connectionPool) {
                    if (this.m_dataSource == null) {
                        this.createDataSource();
                    }
                }
            }
            return this.m_dataSource.getConnection();
        }

        private void createDataSource() throws Exception {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                Object object;
                String string;
                fileInputStream = new FileInputStream(this.m_propertyFile);
                properties.load(fileInputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = properties.getProperty(string);
                    if (((String)object).charAt(0) != '\"' || ((String)object).charAt(((String)object).length() - 1) != '\"') continue;
                    object = ((String)object).substring(1, ((String)object).length() - 1);
                    properties.setProperty(string, (String)object);
                }
                string = properties.getProperty("factory");
                if (string == null || string.length() == 0) {
                    throw new SQLException("Factory attribute not found in the property file");
                }
                object = Class.forName(string);
                Object t = ((Class)object).newInstance();
                Method method = ((Class)object).getMethod("createDataSource", Properties.class);
                this.m_dataSource = (DataSource)method.invoke(t, properties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JdbcsqlException(classNotFoundException.getMessage() + " not found.");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new JdbcsqlException(invocationTargetException.getCause().getMessage());
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private boolean isSame(String string) {
            return string.equals(this.m_propertyFile);
        }
    }

    public class JdbcsqlException
    extends Exception {
        private JdbcsqlException(String string) {
            super(string);
        }
    }
}

