create environment             "$OMNIDEX_GLOBAL_CONFIGURATION"
 in                            "Omnidex.xml"
 with                          delete;

create database                "$OMNIDEX_GLOBAL_CONFIGURATION"
 type                          file
 index_directory               "{$OMNIDEX_DATA/config/idx}"
 in                            "Omnidex.xml";

create table                   "$LISTS"
 options                       "DELIMITED QUOTES=OFF"
 physical                      "{$OMNIDEX_LANG/lists/*.txt},{$OMNIDEX_LANG/lists/*.tdf}"
 (
  "$LIST"                            character(32),
  "$REPLACEMENT"                     string(4094),
  "$COMMENTS"                        string(255),
  custom "$LIST" ("$LIST") case_insensitive
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$STOPWORDS"
 options                       "DELIMITED QUOTES=OFF"
 physical                      "{$OMNIDEX_LANG/stopwords/*.txt},{$OMNIDEX_LANG/stopwords/*.tdf}"
 (
  "$LIST"                            character(32),
  "$WORD"                            string(127),
  "$COMMENTS"                        string(255),
  custom "$LIST" ("$LIST") case_insensitive,
  custom "$WORD" ("$WORD") case_insensitive,
  custom "LIST_WORD" ("$LIST", "$WORD") case_insensitive
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$SYNONYMS"
 options                       "DELIMITED QUOTES=OFF"
 physical                      "{$OMNIDEX_LANG/synonyms/*.txt},{$OMNIDEX_LANG/synonyms/*.tdf}"
 (
  "$LIST"                            character(32),
  "$WORD"                            string(127),
  "$REPLACEMENT"                     string(4094),
  "$COMMENTS"                        string(255),
  custom "$LIST" ("$LIST") case_insensitive,
  custom "$WORD" ("$WORD") case_insensitive,
  custom "LIST_WORD" ("$LIST", "$WORD") case_insensitive
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PHONETIC"
 options                       "DELIMITED QUOTES=OFF"
 physical                      "{$OMNIDEX_LANG/phonetic/*.txt},{$OMNIDEX_LANG/phonetic/*.tdf}"
 (
  "$LIST"                            character(32),
  "$WORD"                            string(127),
  "$TYPE"                            character(8),
  "$SOUNDEX"                         character(64),
  "$METAPHONE1"                      character(64),
  "$METAPHONE2"                      character(64),
  "$COMMENTS"                        string(255),
  custom "$LIST" ("$LIST") case_insensitive,
  custom "$TYPE" ("$TYPE") case_insensitive,
  custom "$WORD" ("$WORD") case_insensitive,
  custom "$SOUNDEX" ("$SOUNDEX") case_insensitive,
  custom "$METAPHONE1" ("$METAPHONE1") case_insensitive,
  custom "$METAPHONE2" ("$METAPHONE2") case_insensitive,
  custom "LIST_TYPE" ("$LIST", "$TYPE") case_insensitive,
  custom "LIST_TYPE_SOUNDEX" ("$LIST", "$TYPE", "$SOUNDEX") case_insensitive
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$USAGES"
 options                       "DELIMITED QUOTES=OFF"
 physical                      "{$OMNIDEX_LANG/usages/*.txt},{$OMNIDEX_LANG/usages/*.tdf}"
 (
  "$LIST"                            character(32),
  "$USAGE"                           character(32),
  "$PARSING"                         character(32),
  "$FORMAT"                          character(255),
  "$POWERSEARCH"                     string(4094),
  "$COMMENTS"                        string(255),
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$MESSAGES"
 options                       "DELIMITED QUOTES=OFF"
 physical                      "{$OMNIDEX_LANG/messages/*.txt},{$OMNIDEX_LANG/messages/*.tdf}"
 (
  "$ERROR"                           integer,
  "$MESSAGE"                         string(255)
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$ENVIRONMENTS"
 physical                      "{$OMNIDEX_LOGS/monenv.dat}"
 options                       "MAPPED"
 autofilter                    "$environmentid > 0"
 (
  "$HOST"                            string(63),
  "$ENVIRONMENTID"                   integer,
  "$FILENAME"                        string(255),
  "$DATE_CREATED"                    c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  constraint ENVIRONMENT_ENVIRONMENTI_PK primary ("$ENVIRONMENTID")
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$CURRENT_CONNECTIONS"
 physical                      "{$OMNIDEX_LOGS/monconn.dat}"
 options                       "MAPPED"
 autofilter                    "$connectionid > 0"
 (
  "$HOST"                            string(63),
  "$ENVIRONMENTID"                   integer,
  "$PROCESSID"                       integer,
  "$CONNECTIONID"                    integer,
  "$NODE"                            string(31),
  "$ROLE"                            string(15),
  "$TYPE"                            string(15),
  "$PORT"                            integer,
  "$PID"                             integer,
  "$INSTANCE"                        integer,
  "$CLIENT_HOST"                     string(63),
  "$CLIENT_PID"                      integer,
  "$CLIENT_CONNECTIONID"             integer,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(255),
  constraint CURRENT_CONN_CONNECTIONID_PK primary ("$CONNECTIONID"),
  constraint CURRENT_CONN_ENVIRONMENTI_FK foreign ("$ENVIRONMENTID")
   references "$ENVIRONMENTS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PAST_CONNECTIONS"
 options                       "DELIMITED QUOTES CHECK_FILELIST"
 physical                      "{$OMNIDEX_LOGS/connections_*.txt}"
 (
  "$HOST"                            string(63),
  "$ENVIRONMENTID"                   integer,
  "$PROCESSID"                       integer,
  "$CONNECTIONID"                    integer,
  "$NODE"                            string(31),
  "$ROLE"                            string(15),
  "$TYPE"                            string(15),
  "$PORT"                            integer,
  "$PID"                             integer,
  "$INSTANCE"                        integer,
  "$CLIENT_HOST"                     string(63),
  "$CLIENT_PID"                      integer,
  "$CLIENT_CONNECTIONID"             integer,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(255),
  constraint PAST_CONNECT_CONNECTIONID_PK primary ("$CONNECTIONID"),
  constraint PAST_CONNECT_ENVIRONMENTI_FK foreign ("$ENVIRONMENTID")
   references "$ENVIRONMENTS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$CURRENT_STATEMENTS"
 physical                      "{$OMNIDEX_LOGS/monstmts.dat}"
 options                       "MAPPED"
 autofilter                    "$statementid > 0"
 (
  "$HOST"                            string(63),
  "$ENVIRONMENTID"                   integer,
  "$CONNECTIONID"                    integer,
  "$STATEMENTID"                     integer,
  "$CURSOR"                          integer,
  "$ROUTINE"                         integer,
  "$ERROR"                           integer,
  "$RETRIEVED"                       unsigned bigint,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(255),
  "$CPU"                             float,
  "$ELAPSED"                         float,
  "$STATEMENT_TYPE"                  string(31),
  "$SQL_STATEMENT"                   string(8191),
  constraint CURRENT_STMT_STMTID_PK primary ("$STATEMENTID"),
  constraint CURRENT_STMT_CONNECTIONID_FK foreign ("$CONNECTIONID")
   references "$CURRENT_CONNECTIONS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PAST_STATEMENTS"
 options                       "DELIMITED QUOTES CHECK_FILELIST"
 physical                      "{$OMNIDEX_LOGS/statements_*.txt}"
 (
  "$HOST"                            string(63),
  "$ENVIRONMENTID"                   integer,
  "$CONNECTIONID"                    integer,
  "$STATEMENTID"                     integer,
  "$CURSOR"                          integer,
  "$ROUTINE"                         integer,
  "$ERROR"                           integer,
  "$RETRIEVED"                       unsigned bigint,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(255),
  "$CPU"                             float,
  "$ELAPSED"                         float,
  "$STATEMENT_TYPE"                  string(31),
  "$SQL_STATEMENT"                   string(8191),
  constraint PAST_STMT_STMTID_PK primary ("$STATEMENTID"),
  constraint PAST_STMT_CONNECTIONID_FK foreign ("$CONNECTIONID")
   references "$PAST_CONNECTIONS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$CURRENT_TASKS"
 physical                      "{$OMNIDEX_LOGS/montasks.dat}"
 options                       "MAPPED"
 autofilter                    "$taskid > 0"
 (
  "$HOST"                            string(63),
  "$ENVIRONMENTID"                   integer,
  "$CONNECTIONID"                    integer,
  "$TASKID"                          integer,
  "$CURSOR"                          integer,
  "$ROUTINE"                         integer,
  "$ERROR"                           integer,
  "$RETRIEVED"                       unsigned bigint,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(255),
  "$CPU"                             float,
  "$ELAPSED"                         float,
  "$TASK_TYPE"                       string(31),
  "$SQL_STATEMENT"                   string(8191),
  constraint CURRENT_TASK_TASKID_PK primary ("$TASKID"),
  constraint CURRENT_TASK_CONNECTIONID_FK foreign ("$CONNECTIONID")
   references "$CURRENT_CONNECTIONS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PAST_TASKS"
 options                       "DELIMITED QUOTES CHECK_FILELIST"
 physical                      "{$OMNIDEX_LOGS/tasks_*.txt}"
 (
  "$HOST"                            string(63),
  "$ENVIRONMENTID"                   integer,
  "$CONNECTIONID"                    integer,
  "$TASKID"                          integer,
  "$CURSOR"                          integer,
  "$ROUTINE"                         integer,
  "$ERROR"                           integer,
  "$RETRIEVED"                       unsigned bigint,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$STATE"                           string(255),
  "$CPU"                             float,
  "$ELAPSED"                         float,
  "$TASK_TYPE"                       string(31),
  "$SQL_STATEMENT"                   string(8191),
  constraint PAST_TASK_TASKID_PK primary ("$TASKID"),
  constraint PAST_TASK_CONNECTIONID_FK foreign ("$CONNECTIONID")
   references "$PAST_CONNECTIONS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$CURRENT_TASK_DETAILS"
 physical                      "{$OMNIDEX_LOGS/montdtls.dat}"
 options                       "MAPPED"
 autofilter                    "$task_detailid > 0"
 (
  "$HOST"                            string(63),
  "$TASKID"                          integer,
  "$TASK_DETAILID"                   integer,
  "$OBJECT"                          string(127),
  "$OBJECT_TYPE"                     string(31),
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$ROWS_PROCESSED"                  unsigned bigint,
  "$KEYWORDS_PROCESSED"              unsigned bigint,
  "$STATE"                           string(255),
  "$CPU"                             float,
  "$ELAPSED"                         float,
  constraint CURRENT_TASKDTL_TASKDTLID_PK primary ("$TASK_DETAILID"),
  constraint CURRENT_TASKDTL_TASKID_FK foreign ("$TASKID")
   references "$CURRENT_TASKS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PAST_TASK_DETAILS"
 options                       "DELIMITED QUOTES CHECK_FILELIST"
 physical                      "{$OMNIDEX_LOGS/taskdtls_*.txt}"
 (
  "$HOST"                            string(63),
  "$TASKID"                          integer,
  "$TASK_DETAILID"                   integer,
  "$OBJECT"                          string(127),
  "$OBJECT_TYPE"                     string(31),
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$ROWS_PROCESSED"                  unsigned bigint,
  "$KEYWORDS_PROCESSED"              unsigned bigint,
  "$STATE"                           string(255),
  "$CPU"                             float,
  "$ELAPSED"                         float,
  constraint PAST_TASKDTL_TASKDTLID_PK primary ("$TASK_DETAILID"),
  constraint PAST_TASKDTL_TASKID_FK foreign ("$TASKID")
   references "$PAST_TASKS"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$NETWORK_SERVICES"
 physical                      "{$OMNIDEX_LOGS/monnsrvc.dat}"
 autofilter                    "$serviceid > 0"
 (
  "$HOST"                            string(63),
  "$SERVICEID"                       integer,
  "$PORT"                            integer,
  "$PID"                             integer,
  "$BUFFER_SIZE"                     integer,
  "$MAX_PROCESSES"                   integer,
  "$IDLE_TIMEOUT"                    integer,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$HOST_ADDRESS_LOOKUP"             char(1), /* Y, N */
  "$RESERVED"                        char(7),
  "$STATE"                           string(255),
  constraint NETWORK_SRVC_SERVICEID_PK primary ("$SERVICEID"),
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$NETWORK_POOLS"
 physical                      "{$OMNIDEX_LOGS/monnpool.dat}"
 autofilter                    "$poolid > 0"
 (
  "$HOST"                            string(63),
  "$SERVICEID"                       integer,
  "$ENVIRONMENTID"                   integer,
  "$POOLID"                          integer,
  "$PORT"                            integer,
  "$NODE"                            string(31),
  "$INITIAL_PROCESSES"               integer,
  "$MAX_PROCESSES"                   integer,
  "$GROWTH_THRESHOLD"                integer,
  "$GROWTH_INCREMENT"                integer,
  "$QUEUE_WAIT"                      integer,  /* 0 for immediate error */
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$TRANSPORT"                       char(8), /* ODBC, JDBC, CLOA, GRID, NA */
  "$STATE"                           string(255),
  constraint NETWORK_POOL_POOLID_PK primary ("$POOLID"),
  constraint NETWORK_POOL_SERVICEID_FK foreign ("$SERVICEID")
   references "$NETWORK_SERVICES"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$NETWORK_PROCESSES"
 physical                      "{$OMNIDEX_LOGS/monnproc.dat}"
 autofilter                    "$processid > 0"
 (
  "$HOST"                            string(63),
  "$SERVICEID"                       integer,
  "$POOLID"                          integer,
  "$CONNECTIONID"                    integer,
  "$PROCESSID"                       integer,
  "$PID"                             integer,
  "$PORT"                            integer,
  "$CLIENT_HOST"                     string(63),
  "$CLIENT_PID"                      integer,
  "$CLIENT_CONNECTIONID"             integer,
  "$START_TIME"                      c datetime(4),
  "$LAST_ACTIVITY"                   c datetime(4),
  "$LAST_ASSIGNED"                   c datetime(4),
  "$TRANSPORT"                       char(8), /* ODBC, JDBC, CLOA, GRID, NA */
  "$STATE"                           string(255),
  constraint NETWORK_PROC_PROCESSID_PK primary ("$PROCESSID"),
  constraint NETWORK_PROC_SERVICEID_FK foreign ("$SERVICEID")
   references "$NETWORK_SERVICES"
 )
 in                            "Omnidex.xml"
 with                          noinstall;

create table                   "$PROCESS_DUMPS"
 options                       "DELIMITED QUOTES=OFF ESCAPE=OFF"
 physical                      "{$OMNIDEX_LOGS/processdumps.txt}"
 (
  "$HOST"                            string(63),
  "$PROCESSID"                       integer,
  "$CONNECTIONID"                    integer,
  "$STATEMENTID"                     integer,
  "$SIGNAL"                          string(31),
  "$TIMESTAMP"                       c datetime(4),
  "$CALL_STACK_FILENAME"             string(255),
  "$DUMP_FILENAME"                   string(255),
  "$CALL_STACK"                      string(1MB)
    as "$retrieve_file($CALL_STACK_FILENAME)",
  constraint PROCESS_DUMP_PK primary ("$PROCESSID")
 )
 in                            "Omnidex.xml"
 with                          noinstall;
