/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import omnidex.client.OdxCLJException;

public final class OdxJDBCBlob
implements Blob {
    private byte[] m_data;
    private long m_length;

    protected OdxJDBCBlob() {
    }

    protected OdxJDBCBlob(byte[] byArray) {
        this.m_data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.m_data, 0, byArray.length);
        this.m_length = byArray.length;
    }

    protected void setInputStream(InputStream inputStream) throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10240);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[10240];
            int n = bufferedInputStream.read(byArray, 0, 10240);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                byArray = new byte[10240];
                n = bufferedInputStream.read(byArray, 0, 10240);
            }
            this.m_data = byteArrayOutputStream.toByteArray();
            this.m_length = this.m_data.length;
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
    }

    @Override
    public long length() throws SQLException {
        return this.m_length;
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        if (l >= (long)n) {
            throw OdxCLJException.error(25521);
        }
        if ((long)n > this.m_length - l) {
            n = (int)((long)n - l);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_data, (int)l, byArray, 0, n);
        return byArray;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.m_data);
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        for (int i = (int)(--l); i < this.m_data.length && byArray.length <= this.m_data.length - i; ++i) {
            if (this.m_data[i] != byArray[0]) continue;
            boolean bl = true;
            for (int j = 1; j < byArray.length; ++j) {
                if (this.m_data[i + j] == byArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i + 1;
        }
        return -1L;
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void truncate(long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void free() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

