/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.TimeZone;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJTrace;

public class OdxCLJResultSet {
    private HashMap<String, Integer> m_columnNumbers;
    private String[] m_columnNames;
    private int[] m_columnDatatypes;
    private int[] m_columnLengths;
    private int[] m_columnPrecisions;
    private int[] m_columnScales;
    private int m_maxFieldSize;
    private int m_maxRows;
    private int m_fetchSize;
    private int m_columnCount;
    private int m_row;
    private int m_rowCount;
    private int m_fetchDirection = 1000;
    private int m_type = 1003;
    private int m_concurrency = 1007;
    private boolean m_open = true;
    private boolean m_wasNull = false;
    private static String m_blank = "";
    private int m_mode = 0;
    private static final int QUERY = 0;
    private static final int INSERT = 1;
    private static final int UPDATE = 2;

    protected OdxCLJResultSet() {
    }

    protected void checkResultSet() throws SQLException {
        if (!this.m_open) {
            throw OdxCLJException.error(25501);
        }
    }

    protected void checkColumnNumber(int n) throws SQLException {
        if (n > this.m_columnCount || n <= 0) {
            throw OdxCLJException.error(25503);
        }
    }

    protected void checkRow() throws SQLException {
        if (this.isAfterLast()) {
            throw OdxCLJException.error(11032);
        }
        if (!this.isInsertMode() && this.m_row == 0) {
            throw OdxCLJException.error(25533);
        }
    }

    protected void checkScrollable() throws SQLException {
        if (this.m_type == 1003) {
            throw OdxCLJException.error(25534);
        }
    }

    protected void checkUpdatable() throws SQLException {
        if (this.m_concurrency == 1007) {
            throw OdxCLJException.error(25536);
        }
    }

    protected void setColumnCount(int n) {
        this.m_columnCount = n;
        this.m_columnNames = new String[n];
        this.m_columnDatatypes = new int[n];
        this.m_columnLengths = new int[n];
        this.m_columnPrecisions = new int[n];
        this.m_columnScales = new int[n];
    }

    protected void setMaxRows(int n) {
        this.m_maxRows = n;
    }

    protected void setMaxFieldSize(int n) {
        this.m_maxFieldSize = n;
    }

    protected void setType(int n) {
        this.m_type = n;
    }

    protected void setConcurrency(int n) {
        this.m_concurrency = n;
    }

    protected void setRowCount(int n) {
        this.m_rowCount = n;
    }

    protected void setRow(int n) {
        this.m_row = n;
    }

    protected int getMaxRows() {
        return this.m_maxRows;
    }

    protected boolean isQueryMode() {
        return this.m_mode == 0;
    }

    protected boolean isUpdateMode() {
        return this.m_mode == 2;
    }

    protected boolean isInsertMode() {
        return this.m_mode == 1;
    }

    protected void setQueryMode() {
        this.m_mode = 0;
    }

    protected void setUpdateMode() {
        this.m_mode = 2;
    }

    protected void setInsertMode() {
        this.m_mode = 1;
    }

    protected int getMode() {
        return this.m_mode;
    }

    protected void setMode(int n) {
        this.m_mode = n;
    }

    protected String getValueString(int n) {
        return m_blank;
    }

    protected String getValueString(int n, boolean bl) {
        return m_blank;
    }

    protected boolean getValueBoolean(int n) {
        return false;
    }

    protected long getValueBigInt(int n) {
        return 0L;
    }

    protected String getValueStringBigInt(int n) {
        return m_blank;
    }

    protected int getValueInt(int n) {
        return 0;
    }

    protected double getValueDouble(int n) {
        return 0.0;
    }

    protected long getValueTimestamp(int n) {
        return 0L;
    }

    protected boolean getNullFlag(int n) {
        return false;
    }

    protected String getTimezone() {
        return m_blank;
    }

    public int getType(int n) throws SQLException {
        this.checkResultSet();
        return 0;
    }

    public int getSubtype(int n) throws SQLException {
        this.checkResultSet();
        return 0;
    }

    public String getColumnEnvironment(int n) throws SQLException {
        this.checkResultSet();
        return m_blank;
    }

    public String getColumnDatabase(int n) throws SQLException {
        this.checkResultSet();
        return m_blank;
    }

    public String getColumnTable(int n) throws SQLException {
        this.checkResultSet();
        return m_blank;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getAlias(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public int getOaDatatype(int n) throws SQLException {
        return this.getColumnDatatype(n);
    }

    public int getOaLength(int n) throws SQLException {
        return this.getColumnLength(n);
    }

    public int getOccurrences(int n) throws SQLException {
        this.checkResultSet();
        return 1;
    }

    public int getUsage(int n) throws SQLException {
        this.checkResultSet();
        return 0;
    }

    public String getOptions(int n) throws SQLException {
        this.checkResultSet();
        return m_blank;
    }

    public int getRequiredDatatype(int n) throws SQLException {
        return this.getColumnDatatype(n);
    }

    public int getRequiredLength(int n) throws SQLException {
        return this.getColumnLength(n);
    }

    public int getRequiredUsage(int n) throws SQLException {
        this.checkResultSet();
        return 0;
    }

    public String getRequiredOptions(int n) throws SQLException {
        this.checkResultSet();
        return m_blank;
    }

    public boolean isReadOnly(int n) {
        return true;
    }

    public boolean wasNull() {
        return this.m_wasNull;
    }

    public boolean next() throws SQLException {
        ++this.m_row;
        return !this.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkResultSet();
        return this.m_row == 0;
    }

    public boolean isFirst() throws SQLException {
        this.checkResultSet();
        return this.m_row == 1;
    }

    public boolean isAfterLast() throws SQLException {
        this.checkResultSet();
        return this.m_row > this.m_rowCount;
    }

    public boolean isLast() throws SQLException {
        this.checkResultSet();
        return this.m_row == this.m_rowCount;
    }

    public void beforeFirst() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public void afterLast() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public boolean first() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public boolean last() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public boolean absolute(int n) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public boolean relative(int n) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public boolean previous() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public void updateColumnValue(int n, String string) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public void deleteRow() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public void cancelRowUpdates() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public void updateRow() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public void moveToInsertRow() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public void insertRow() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public void moveToCurrentRow() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public void setColumnInfo(int n, String string, int n2, int n3, int n4, int n5) {
        this.m_columnNames[--n] = string;
        this.m_columnDatatypes[n] = n2;
        this.m_columnLengths[n] = n3;
        this.m_columnPrecisions[n] = n4;
        this.m_columnScales[n] = n5;
    }

    public void setColumnInfo(int n, String string, int n2, int n3) {
        this.setColumnInfo(n, string, n2, n3, n3, 0);
    }

    public int getColumnNumber(String string) throws SQLException {
        Integer n = null;
        String string2 = string.toString().toUpperCase();
        if (this.m_columnNumbers == null) {
            this.m_columnNumbers = new HashMap();
        } else {
            n = this.m_columnNumbers.get(string2);
        }
        if (n == null) {
            for (int i = this.m_columnNumbers.size() + 1; i <= this.m_columnCount; ++i) {
                String string3 = this.getColumnName(i);
                this.m_columnNumbers.put(string3, i);
                if (!string3.equals(string2)) continue;
                return i;
            }
            throw OdxCLJException.error(25506);
        }
        return n;
    }

    public String getColumnName(int n) throws SQLException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return this.m_columnNames[n - 1];
    }

    public int getColumnDatatype(int n) throws SQLException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return this.m_columnDatatypes[n - 1];
    }

    public int getColumnLength(int n) throws SQLException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return this.m_columnLengths[n - 1];
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return switch (this.m_columnDatatypes[n - 1]) {
            case -4, -3, -2, -1, 1, 12, 2004, 2005 -> this.m_columnLengths[n - 1];
            case -6, -5, 4, 5 -> {
                switch (this.m_columnLengths[n - 1]) {
                    case 1: {
                        yield 4;
                    }
                    case 2: {
                        yield 6;
                    }
                    case 4: {
                        yield 11;
                    }
                    case 8: {
                        yield 20;
                    }
                }
                yield 32;
            }
            case 2, 3, 6, 7, 8 -> 32;
            case 91 -> 12;
            case 92 -> 11;
            case 93 -> 25;
            case -7 -> 5;
            default -> this.m_columnLengths[n - 1];
        };
    }

    public int getPrecision(int n) throws SQLException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return this.m_columnPrecisions[n - 1];
    }

    public int getScale(int n) throws SQLException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return this.m_columnScales[n - 1];
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    public int getRow() {
        return this.m_row;
    }

    public int getType() {
        return this.m_type;
    }

    public int getConcurrency() {
        return this.m_concurrency;
    }

    public int getFetchDirection() {
        return this.m_fetchDirection;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.m_type == 1003 && n != 1000) {
            throw OdxCLJException.error(25505);
        }
        this.m_fetchDirection = n;
    }

    public int getFetchSize() {
        return this.m_fetchSize;
    }

    public void setFetchSize(int n) {
        this.m_fetchSize = n;
    }

    public String getColumnValueString(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return null;
        }
        String string = null;
        int n2 = this.getColumnDatatype(n);
        switch (n2) {
            case 1: {
                string = this.getValueString(n);
                break;
            }
            case 12: {
                string = this.getValueString(n);
                break;
            }
            case -7: {
                string = String.valueOf(this.getValueBoolean(n));
                break;
            }
            case -5: {
                string = this.getValueStringBigInt(n);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = String.valueOf(this.getValueInt(n));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = String.format("%.6f", this.getValueDouble(n));
                break;
            }
            case 91: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d, yyyy");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.getTimezone()));
                string = simpleDateFormat.format(new Date(this.getValueTimestamp(n)));
                break;
            }
            case 92: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SS");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                string = simpleDateFormat.format(new Time(this.getValueTimestamp(n)));
                break;
            }
            case 93: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd yyyy HH:mm:ss.SS");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.getTimezone()));
                string = simpleDateFormat.format(new Timestamp(this.getValueTimestamp(n)));
                break;
            }
        }
        if (this.m_maxFieldSize != 0 && string != null && string.length() != 0) {
            string = string.substring(0, this.m_maxFieldSize);
        }
        return string;
    }

    public boolean getColumnValueBoolean(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return false;
        }
        switch (this.getColumnDatatype(n)) {
            case 1: {
                return Boolean.valueOf(this.getValueString(n));
            }
            case 12: {
                return Boolean.valueOf(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n) != 0;
            }
            case -5: {
                return this.getValueBigInt(n) != 0L;
            }
            case 6: 
            case 7: 
            case 8: {
                return this.getValueDouble(n) != 0.0;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public byte getColumnValueByte(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return 0;
        }
        switch (this.getColumnDatatype(n)) {
            case 1: {
                return Byte.parseByte(this.getValueString(n));
            }
            case 12: {
                return Byte.parseByte(this.getValueString(n, true));
            }
            case -7: {
                return (byte)(this.getValueBoolean(n) ? 1 : 0);
            }
            case -5: {
                return Byte.parseByte(this.getValueStringBigInt(n));
            }
            case -6: 
            case 4: 
            case 5: {
                return (byte)this.getValueInt(n);
            }
            case 6: 
            case 7: 
            case 8: {
                return (byte)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0;
            }
        }
        return 0;
    }

    public short getColumnValueShort(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return 0;
        }
        switch (this.getColumnDatatype(n)) {
            case 1: {
                return Short.parseShort(this.getValueString(n));
            }
            case 12: {
                return Short.parseShort(this.getValueString(n, true));
            }
            case -7: {
                return (short)(this.getValueBoolean(n) ? 1 : 0);
            }
            case -5: {
                return Short.parseShort(this.getValueStringBigInt(n));
            }
            case -6: 
            case 4: 
            case 5: {
                return (short)this.getValueInt(n);
            }
            case 6: 
            case 7: 
            case 8: {
                return (short)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0;
            }
        }
        return 0;
    }

    public int getColumnValueInt(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return 0;
        }
        switch (this.getColumnDatatype(n)) {
            case 1: {
                return Integer.parseInt(this.getValueString(n));
            }
            case 12: {
                return Integer.parseInt(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? 1 : 0;
            }
            case -5: {
                return Integer.parseInt(this.getValueStringBigInt(n));
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n);
            }
            case 6: 
            case 7: 
            case 8: {
                return (int)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0;
            }
        }
        return 0;
    }

    public long getColumnValueLong(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return 0L;
        }
        switch (this.getColumnDatatype(n)) {
            case 1: {
                return Long.parseLong(this.getValueString(n));
            }
            case 12: {
                return Long.parseLong(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? 1 : 0;
            }
            case -5: {
                return this.getValueBigInt(n);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n);
            }
            case 6: 
            case 7: 
            case 8: {
                return (long)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0L;
            }
        }
        return 0L;
    }

    public float getColumnValueFloat(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return 0.0f;
        }
        switch (this.getColumnDatatype(n)) {
            case 1: {
                return Float.parseFloat(this.getValueString(n));
            }
            case 12: {
                return Float.parseFloat(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? 1 : 0;
            }
            case -5: {
                return Float.parseFloat(this.getValueStringBigInt(n));
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n);
            }
            case 6: 
            case 7: 
            case 8: {
                return (float)this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public double getColumnValueDouble(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return 0.0;
        }
        switch (this.getColumnDatatype(n)) {
            case 1: {
                return Double.parseDouble(this.getValueString(n));
            }
            case 12: {
                return Double.parseDouble(this.getValueString(n, true));
            }
            case -7: {
                return this.getValueBoolean(n) ? 1 : 0;
            }
            case -5: {
                return Double.parseDouble(this.getValueStringBigInt(n));
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getValueInt(n);
            }
            case 6: 
            case 7: 
            case 8: {
                return this.getValueDouble(n);
            }
            case 91: 
            case 92: 
            case 93: {
                return 0.0;
            }
        }
        return 0.0;
    }

    public Date getColumnValueDate(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return null;
        }
        Date date = null;
        switch (this.getColumnDatatype(n)) {
            case 1: {
                date = Date.valueOf(this.getValueString(n));
                break;
            }
            case 12: {
                date = Date.valueOf(this.getValueString(n, true));
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                date = null;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long l = this.getValueTimestamp(n);
                if (l == 0L) break;
                date = new Date(l);
                break;
            }
        }
        return date;
    }

    public Time getColumnValueTime(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return null;
        }
        Time time = null;
        switch (this.getColumnDatatype(n)) {
            case 1: {
                time = Time.valueOf(this.getValueString(n));
                break;
            }
            case 12: {
                time = Time.valueOf(this.getValueString(n, true));
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                time = null;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long l = this.getValueTimestamp(n);
                if (l == 0L) break;
                time = new Time(l);
                break;
            }
        }
        return time;
    }

    public Timestamp getColumnValueTimestamp(int n) throws SQLException {
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            return null;
        }
        Timestamp timestamp = null;
        switch (this.getColumnDatatype(n)) {
            case 1: {
                timestamp = Timestamp.valueOf(this.getValueString(n));
                break;
            }
            case 12: {
                timestamp = Timestamp.valueOf(this.getValueString(n, true));
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                timestamp = null;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long l = this.getValueTimestamp(n);
                if (l == 0L) break;
                timestamp = new Timestamp(l);
                break;
            }
        }
        return timestamp;
    }

    public Object getColumnValueObject(int n) throws SQLException {
        OdxCLJTrace.print("getColumnValueObject");
        this.checkRow();
        this.m_wasNull = this.getNullFlag(n);
        if (this.m_wasNull) {
            OdxCLJTrace.print("null value");
            return null;
        }
        Object object = null;
        int n2 = this.getColumnDatatype(n);
        switch (n2) {
            case 1: {
                String string = this.getValueString(n);
                if (this.m_maxFieldSize != 0 && string != null && string.length() != 0) {
                    string = string.substring(0, this.m_maxFieldSize);
                }
                object = string;
                OdxCLJTrace.print("datatype(CHAR), value(" + object + ")");
                break;
            }
            case 12: {
                String string = this.getValueString(n);
                if (this.m_maxFieldSize != 0 && string != null && string.length() != 0) {
                    string = string.substring(0, this.m_maxFieldSize);
                }
                object = string;
                OdxCLJTrace.print("datatype(VARCHAR), value(" + object + ")");
                break;
            }
            case -7: {
                object = this.getValueBoolean(n);
                OdxCLJTrace.print("datatype(BIT), value " + object);
                break;
            }
            case -6: {
                object = (byte)this.getValueInt(n);
                OdxCLJTrace.print("datatype(TINYINT), value " + object);
                break;
            }
            case 5: {
                object = (short)this.getValueInt(n);
                OdxCLJTrace.print("datatype(SMALLINT), value " + object);
                break;
            }
            case 4: {
                object = this.getValueInt(n);
                OdxCLJTrace.print("datatype(INTEGER), value " + object);
                break;
            }
            case -5: {
                object = this.getValueBigInt(n);
                OdxCLJTrace.print("datatype(BIGINT), value " + object);
                break;
            }
            case 7: {
                object = Float.valueOf((float)this.getValueDouble(n));
                OdxCLJTrace.print("datatype(REAL), value " + object);
                break;
            }
            case 6: 
            case 8: {
                object = this.getValueDouble(n);
                OdxCLJTrace.print("datatype(FLOAT/DOUBLE), value " + object);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long l = this.getValueTimestamp(n);
                if (l != 0L) {
                    switch (n2) {
                        case 91: {
                            object = new Date(l);
                            break;
                        }
                        case 92: {
                            object = new Time(l);
                            break;
                        }
                        case 93: {
                            object = new Timestamp(l);
                        }
                    }
                }
                OdxCLJTrace.print("datatype(DATE/TIME/TIMESTAMP), value " + object);
                break;
            }
            default: {
                OdxCLJTrace.print("datatype(" + n2 + "), value " + object);
            }
        }
        return object;
    }

    public void close() throws SQLException {
        if (this.m_columnNumbers != null) {
            this.m_columnNumbers.clear();
            this.m_columnNumbers = null;
        }
        this.m_columnNames = null;
        this.m_columnDatatypes = null;
        this.m_columnLengths = null;
        this.m_columnPrecisions = null;
        this.m_columnScales = null;
        this.m_maxFieldSize = 0;
        this.m_maxRows = 0;
        this.m_fetchSize = 0;
        this.m_columnCount = 0;
        this.m_row = 0;
        this.m_rowCount = 0;
        this.m_open = false;
    }
}

