/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import omnidex.client.OdxCLJConnectionMgr;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJStatus;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCConnection;
import omnidex.jdbc.OdxJDBCRouterConnection;

public final class OdxJDBCDriver
implements Driver {
    private static String SUBNAME_PREFIX = "jdbc:omnidex:";
    private static String DRIVER_PREFIX = "jdbc:omnidex:driver:";
    private static String ROUTER_PREFIX = "jdbc:omnidex:router:";
    private static boolean DEFAULT_STRICT_CHECK = false;
    private boolean m_strictCheck = DEFAULT_STRICT_CHECK;

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        OdxCLJTrace.print("OdxJDBCDriver.connect(" + string + ")");
        if (string != null) {
            String string2 = string.toLowerCase();
            if (string2.startsWith(ROUTER_PREFIX)) {
                string = this.checkForConnectOptions(string.substring(ROUTER_PREFIX.length()));
                OdxJDBCRouterConnection odxJDBCRouterConnection = new OdxJDBCRouterConnection();
                odxJDBCRouterConnection.open(OdxJDBCDriver.translatePath(string), properties, this.m_strictCheck);
                return odxJDBCRouterConnection;
            }
            if (string2.startsWith(DRIVER_PREFIX)) {
                string = this.checkForConnectOptions(string.substring(DRIVER_PREFIX.length()));
                OdxJDBCConnection odxJDBCConnection = new OdxJDBCConnection();
                odxJDBCConnection.open(OdxJDBCDriver.translatePath(string), properties, this.m_strictCheck);
                return odxJDBCConnection;
            }
            if (string2.startsWith(SUBNAME_PREFIX)) {
                string = this.checkForConnectOptions(string.substring(SUBNAME_PREFIX.length()));
                OdxJDBCConnection odxJDBCConnection = new OdxJDBCConnection();
                odxJDBCConnection.open(OdxJDBCDriver.translatePath(string), properties, this.m_strictCheck);
                return odxJDBCConnection;
            }
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String string) {
        OdxCLJTrace.print("Driver.acceptsURL(" + string + ")");
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).startsWith(DRIVER_PREFIX) || string.startsWith(ROUTER_PREFIX) || string.startsWith(SUBNAME_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        OdxCLJTrace.print("Driver.getPropertyInfo(" + string + ")");
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return OdxCLJStatus.getDriverMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return OdxCLJStatus.getDriverMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public static void closeConnectionPooling() throws SQLException {
        OdxCLJConnectionMgr.close();
    }

    protected static String translatePath(String object) {
        int n;
        int n2 = 0;
        while ((n = ((String)object).indexOf("${", n2)) != -1) {
            int n3 = ((String)object).indexOf(125, n);
            if (n3 != -1) {
                String string = ((String)object).substring(n + 2, n3);
                String string2 = System.getenv(string);
                OdxCLJTrace.print("Translating: " + (String)object);
                if (string2 != null) {
                    object = ((String)object).substring(0, n) + string2 + ((String)object).substring(n3 + 1);
                }
                OdxCLJTrace.print("Environment: " + string + " = " + string2);
                OdxCLJTrace.print("Translation: " + (String)object);
            }
            n2 = n + 1;
        }
        return object;
    }

    private String checkForConnectOptions(String object) throws SQLException {
        this.m_strictCheck = DEFAULT_STRICT_CHECK;
        boolean bl = false;
        int n = 0;
        while ((n = ((String)object).indexOf(59, n)) >= 0) {
            int n2;
            String string;
            String string2 = string = (n2 = ((String)object).indexOf(59, ++n)) < 0 ? ((String)object).substring(n) : ((String)object).substring(n, n2);
            if (string.compareToIgnoreCase("strict") == 0) {
                if (bl) {
                    throw OdxCLJException.error(11104);
                }
                this.m_strictCheck = true;
                bl = true;
            } else if (string.compareToIgnoreCase("relaxed") == 0) {
                if (bl) {
                    throw OdxCLJException.error(11104);
                }
                this.m_strictCheck = false;
                bl = true;
            } else {
                String string3;
                int n3 = string.indexOf(61);
                if (n3 < 0 || (string3 = string.substring(0, n3)).compareToIgnoreCase("clienttracefile") != 0) continue;
                OdxCLJTrace.setLogWriter(string.substring(n3 + 1).trim(), true);
                OdxCLJTrace.print("OdxJDBCDriver.connect(" + (String)object + ")");
            }
            if (n2 < 0) {
                object = ((String)object).substring(0, n - 1);
                break;
            }
            object = ((String)object).substring(0, n - 1) + ((String)object).substring(n2);
            --n;
        }
        return object;
    }

    static {
        try {
            OdxCLJTrace.print("Loading OdxJDBC class...");
            DriverManager.registerDriver(new OdxJDBCDriver());
        }
        catch (SQLException sQLException) {
            OdxCLJTrace.print("Unable to load or register OdxJDBC driver");
            OdxCLJTrace.print(sQLException);
        }
    }
}

