/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCConnection;
import omnidex.jdbc.OdxJDBCDriver;
import omnidex.jdbc.OdxJDBCRouterConfig;
import omnidex.jdbc.OdxJDBCRouterPreparedStatement;
import omnidex.jdbc.OdxJDBCRouterServer;
import omnidex.jdbc.OdxJDBCRouterStatement;
import omnidex.xml.OdxJDBCIR.RuleTypeType;
import omnidex.xml.OdxJDBCIR.RulesType;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public final class OdxJDBCRouterConnection
implements Connection {
    private static String RULE_NAME_OPTION = ";RULE=";
    private OdxJDBCRouterConfig m_config;
    private RulesType.Rule m_rule;
    private static HashMap<String, GenericObjectPool> m_connectionPoolList;
    private ArrayList<Statement> m_statements;
    private Map<String, Class<?>> m_typeMap;
    private Boolean m_autoCommit;
    private Boolean m_readOnly;
    private String m_catalog = null;
    private Integer m_level;
    private Integer m_holdability;
    private boolean m_strictCheck;

    protected OdxJDBCRouterConnection() {
        this.trace(null);
        this.m_statements = new ArrayList();
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected void open(String string, Properties properties, boolean bl) throws SQLException {
        String string2 = null;
        int n = string.indexOf(59);
        if (n >= 0) {
            String string3 = string.substring(n);
            if (string3.toUpperCase().startsWith(RULE_NAME_OPTION)) {
                string2 = string3.substring(RULE_NAME_OPTION.length());
                string = string.substring(0, n);
            } else {
                throw OdxCLJException.error(25544);
            }
        }
        this.trace("Opening: " + string);
        if (string2 != null) {
            this.trace("Rule passed in the connection string: " + string2);
        }
        this.m_config = OdxJDBCRouterConfig.getConfig(string);
        this.setRule(string2);
        this.m_strictCheck = bl;
    }

    private void setRule(String string) throws SQLException {
        this.trace("Setting the rule");
        RulesType rulesType = this.m_config.getRules();
        if (string == null) {
            string = rulesType.getDefaultRule();
            if (string != null) {
                this.trace("Using default rule: " + string);
            }
        } else {
            this.trace("Using the following rule: " + string);
        }
        if (string == null) {
            List<RulesType.Rule> list = rulesType.getRule();
            this.m_rule = list.get(0);
            this.trace("Using the first rule in the config file: " + this.m_rule.getName());
            this.checkRule(this.m_rule);
        } else {
            this.m_rule = this.getRule(string);
        }
    }

    private void checkRule(RulesType.Rule rule) throws SQLException {
        RuleTypeType ruleTypeType = rule.getType();
        if (ruleTypeType == null) {
            throw OdxCLJException.error(25553);
        }
        if (ruleTypeType == RuleTypeType.JAVA) {
            String string = rule.getClassName();
            if (string == null) {
                throw OdxCLJException.error(25546);
            }
            this.trace("Rule type: JAVA, className: " + string);
        } else if (ruleTypeType == RuleTypeType.REGEXP) {
            if (rule.getConditions() == null) {
                throw OdxCLJException.error(25548);
            }
            this.trace("Rule type: REGEXP");
        } else if (ruleTypeType == RuleTypeType.DEFAULTSERVER) {
            String string = rule.getDefaultServer();
            if (string == null) {
                throw OdxCLJException.error(25547);
            }
            this.trace("Rule type: DEFAULTSERVER, serverName: " + string);
        }
    }

    protected RulesType.Rule getRule(String string) throws SQLException {
        if (string == null) {
            return this.m_rule;
        }
        RulesType.Rule rule = null;
        RulesType rulesType = this.m_config.getRules();
        List<RulesType.Rule> list = rulesType.getRule();
        for (RulesType.Rule rule2 : list) {
            if (!string.equalsIgnoreCase(rule2.getName())) continue;
            rule = rule2;
            break;
        }
        if (rule == null) {
            throw OdxCLJException.error(25545, string);
        }
        this.checkRule(rule);
        return rule;
    }

    protected HashMap<String, OdxJDBCRouterServer> getServerList() {
        return this.m_config.getServerList();
    }

    protected OdxJDBCRouterServer getServer(String string) {
        return this.m_config.getServer(string);
    }

    protected Connection getConnection(OdxJDBCRouterServer odxJDBCRouterServer) throws SQLException {
        if (odxJDBCRouterServer == null) {
            throw OdxCLJException.error(25551);
        }
        String string = odxJDBCRouterServer.getJdbcDriver();
        if (string == null) {
            throw OdxCLJException.error(25549);
        }
        this.trace("Loading driver: " + string);
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw OdxCLJException.error(25552, string);
        }
        String string2 = odxJDBCRouterServer.getConnectionString();
        if (string2 == null) {
            throw OdxCLJException.error(25550);
        }
        this.trace("Connection string: " + string2);
        string2 = OdxJDBCDriver.translatePath(string2);
        Connection connection = OdxJDBCRouterConnection.getConnectionFromPool(string2, odxJDBCRouterServer);
        if (connection instanceof OdxJDBCConnection) {
            ((OdxJDBCConnection)connection).setCheck(this.m_strictCheck);
        }
        if (this.m_typeMap != null) {
            connection.setTypeMap(this.m_typeMap);
        }
        if (this.m_autoCommit != null) {
            connection.setAutoCommit(this.m_autoCommit);
        }
        if (this.m_readOnly != null) {
            connection.setReadOnly(this.m_readOnly);
        }
        if (this.m_catalog != null) {
            connection.setCatalog(this.m_catalog);
        }
        if (this.m_level != null) {
            connection.setTransactionIsolation(this.m_level);
        }
        if (this.m_holdability != null) {
            connection.setHoldability(this.m_holdability);
        }
        return connection;
    }

    private static synchronized Connection getConnectionFromPool(String string, OdxJDBCRouterServer odxJDBCRouterServer) throws SQLException {
        GenericObjectPool genericObjectPool = null;
        if (m_connectionPoolList == null) {
            m_connectionPoolList = new HashMap();
        } else {
            genericObjectPool = m_connectionPoolList.get(string);
        }
        if (genericObjectPool == null) {
            OdxCLJTrace.print("New connection pool created");
            genericObjectPool = new GenericObjectPool(null);
            m_connectionPoolList.put(string, genericObjectPool);
            DriverManagerConnectionFactory driverManagerConnectionFactory = new DriverManagerConnectionFactory(string, null);
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, (ObjectPool)genericObjectPool, null, null, false, true);
        }
        genericObjectPool.setMaxActive(odxJDBCRouterServer.getMaxActive());
        genericObjectPool.setWhenExhaustedAction(odxJDBCRouterServer.getWhenExhaustedAction());
        genericObjectPool.setMaxWait(odxJDBCRouterServer.getMaxWait());
        genericObjectPool.setMaxIdle(odxJDBCRouterServer.getMaxIdle());
        return new PoolingDataSource((ObjectPool)genericObjectPool).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStatement(Statement statement) {
        ArrayList<Statement> arrayList = this.m_statements;
        synchronized (arrayList) {
            this.m_statements.add(statement);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        OdxJDBCRouterStatement odxJDBCRouterStatement = new OdxJDBCRouterStatement(this);
        this.addStatement(odxJDBCRouterStatement);
        return odxJDBCRouterStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        OdxJDBCRouterPreparedStatement odxJDBCRouterPreparedStatement = new OdxJDBCRouterPreparedStatement(this);
        this.addStatement(odxJDBCRouterPreparedStatement);
        odxJDBCRouterPreparedStatement.initialize(string);
        return odxJDBCRouterPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        throw OdxCLJException.error(25507);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.m_autoCommit = bl;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.m_autoCommit;
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() throws SQLException {
        throw OdxCLJException.error(25508);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ArrayList<Statement> arrayList = this.m_statements;
        synchronized (arrayList) {
            Iterator<Statement> iterator = this.m_statements.iterator();
            while (iterator.hasNext()) {
                iterator.next().close();
            }
            this.m_statements.clear();
        }
        this.m_config = null;
        this.m_rule = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_config == null || this.m_rule == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.m_readOnly = bl;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.m_readOnly;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.m_catalog = string;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.m_catalog;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.m_level = n;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.m_level == null ? 0 : this.m_level;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        OdxJDBCRouterStatement odxJDBCRouterStatement = new OdxJDBCRouterStatement(this);
        odxJDBCRouterStatement.initialize(n, n2);
        this.addStatement(odxJDBCRouterStatement);
        return odxJDBCRouterStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        OdxJDBCRouterPreparedStatement odxJDBCRouterPreparedStatement = new OdxJDBCRouterPreparedStatement(this);
        this.addStatement(odxJDBCRouterPreparedStatement);
        odxJDBCRouterPreparedStatement.initialize(string, n, n2);
        return odxJDBCRouterPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw OdxCLJException.error(25507);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.m_typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.m_typeMap = map;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.m_holdability = n;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.m_holdability == null ? 2 : this.m_holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        OdxJDBCRouterStatement odxJDBCRouterStatement = new OdxJDBCRouterStatement(this);
        odxJDBCRouterStatement.initialize(n, n2, n3);
        this.addStatement(odxJDBCRouterStatement);
        return odxJDBCRouterStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        OdxJDBCRouterPreparedStatement odxJDBCRouterPreparedStatement = new OdxJDBCRouterPreparedStatement(this);
        this.addStatement(odxJDBCRouterPreparedStatement);
        odxJDBCRouterPreparedStatement.initialize(string, n, n2, n3);
        return odxJDBCRouterPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public void setSchema(String string) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

