/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import omnidex.client.OdxCLJConnection;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJResultSet;
import omnidex.client.OdxCLJStatement;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCConnection;
import omnidex.jdbc.OdxJDBCResultSet;

public class OdxJDBCStatement
implements Statement {
    private Connection m_jdbcConnection;
    private OdxCLJStatement m_oaStatement;
    protected OdxJDBCResultSet m_resultSet;
    private OdxJDBCResultSet m_returnedResultSet;
    private ArrayList<String> m_sqlBatch;
    private int m_updateCount;
    private String m_cursorName;

    protected OdxJDBCStatement(OdxJDBCConnection odxJDBCConnection) {
        this.trace(null);
        this.m_jdbcConnection = odxJDBCConnection;
        this.m_updateCount = -1;
    }

    protected void initialize(OdxCLJConnection odxCLJConnection, int n, int n2, boolean bl) throws SQLException {
        this.trace("initialize");
        this.m_oaStatement = odxCLJConnection.createStatement(n, n2, bl);
    }

    private void checkStatement() throws SQLException {
        if (this.m_oaStatement == null) {
            throw OdxCLJException.error(25504);
        }
    }

    private void closeResultSet() throws SQLException {
        this.trace("closeResultSet");
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
            this.m_resultSet = null;
        }
        this.m_returnedResultSet = null;
        this.m_updateCount = -1;
    }

    protected void connectionClosed() throws SQLException {
        this.trace("connectionClosed");
        if (this.m_oaStatement != null) {
            this.close();
        }
    }

    protected void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected void dump() {
        OdxCLJTrace.print("Inside " + this);
        OdxCLJTrace.print(" - " + this.m_oaStatement);
        if (this.m_resultSet != null) {
            OdxCLJTrace.print(" - " + this.m_resultSet);
            this.m_resultSet.dump();
        }
    }

    protected String getCursorName() {
        return this.m_cursorName;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.trace("executeQuery");
        this.checkStatement();
        this.closeResultSet();
        OdxCLJResultSet odxCLJResultSet = this.m_oaStatement.executeSQL(string, null);
        if (odxCLJResultSet == null) {
            throw OdxCLJException.error(25501);
        }
        this.m_resultSet = new OdxJDBCResultSet(this, odxCLJResultSet);
        return this.m_resultSet;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.trace("executeUpdate");
        this.checkStatement();
        this.closeResultSet();
        OdxCLJResultSet odxCLJResultSet = this.m_oaStatement.executeSQL(string, null);
        if (odxCLJResultSet != null) {
            this.m_resultSet = new OdxJDBCResultSet(this, odxCLJResultSet);
        }
        this.m_updateCount = this.m_oaStatement.getUpdateCount();
        return this.m_updateCount;
    }

    @Override
    public void close() throws SQLException {
        this.trace("close");
        this.closeResultSet();
        if (this.m_oaStatement != null) {
            this.m_oaStatement.close();
            this.m_oaStatement = null;
        }
        this.m_jdbcConnection = null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.m_oaStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.m_oaStatement.setMaxFieldSize(n);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.m_oaStatement.getMaxRows();
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.m_oaStatement.setMaxRows(n);
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.m_oaStatement.isStrict()) {
            throw OdxCLJException.error(25500);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.m_oaStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.m_oaStatement.setQueryTimeout(n);
    }

    @Override
    public void cancel() throws SQLException {
        this.trace("cancel");
        this.checkStatement();
        try {
            this.m_oaStatement.cancel();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            this.closeResultSet();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.trace("setCursorName");
        this.m_cursorName = string;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.trace("execute");
        this.checkStatement();
        this.closeResultSet();
        OdxCLJResultSet odxCLJResultSet = this.m_oaStatement.executeSQL(string, null);
        if (odxCLJResultSet != null) {
            this.m_returnedResultSet = this.m_resultSet = new OdxJDBCResultSet(this, odxCLJResultSet);
        }
        this.m_updateCount = this.m_oaStatement.getUpdateCount();
        return odxCLJResultSet != null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.trace("getResultSet");
        this.checkStatement();
        OdxJDBCResultSet odxJDBCResultSet = this.m_returnedResultSet;
        this.m_returnedResultSet = null;
        return odxJDBCResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.trace("getUpdateCount");
        this.checkStatement();
        return this.m_updateCount;
    }

    public long[] getQualifyCounts() throws SQLException {
        this.trace("getQualifyCounts");
        this.checkStatement();
        return this.m_oaStatement.getQualifyCounts();
    }

    public long getQualifyingCount() throws SQLException {
        this.trace("getQualifyingCount");
        this.checkStatement();
        return this.m_oaStatement.getQualifyingCount();
    }

    public long getParentCount() throws SQLException {
        this.trace("getParentCount");
        this.checkStatement();
        return this.m_oaStatement.getParentCount();
    }

    public long getPreIntersectCount() throws SQLException {
        this.trace("getPreIntersectCount");
        this.checkStatement();
        return this.m_oaStatement.getPreIntersectCount();
    }

    public int getCPUTime() throws SQLException {
        this.trace("getCPUTime");
        this.checkStatement();
        return this.m_oaStatement.getCPUTime();
    }

    public int getElapsedTime() throws SQLException {
        this.trace("getElapsedTime");
        this.checkStatement();
        return this.m_oaStatement.getElapsedTime();
    }

    public int[] getOmnidexStatus() throws SQLException {
        this.trace("getOmnidexStatus");
        this.checkStatement();
        return this.m_oaStatement.getOmnidexStatus();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.m_returnedResultSet != null;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.m_oaStatement.setFetchDirection(n);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.m_oaStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.m_oaStatement.setFetchSize(n);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.m_oaStatement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.m_oaStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.m_oaStatement.getResultSetType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String string) throws SQLException {
        Object object;
        if (this.m_sqlBatch == null) {
            object = this;
            synchronized (object) {
                if (this.m_sqlBatch == null) {
                    this.m_sqlBatch = new ArrayList();
                }
            }
        }
        object = this.m_sqlBatch;
        synchronized (object) {
            this.m_sqlBatch.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        if (this.m_sqlBatch != null) {
            ArrayList<String> arrayList = this.m_sqlBatch;
            synchronized (arrayList) {
                this.m_sqlBatch.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        Iterator<String> iterator;
        int[] nArray;
        if (this.m_sqlBatch == null) {
            throw OdxCLJException.error(25522);
        }
        Iterable<String> iterable = this.m_sqlBatch;
        synchronized (iterable) {
            if (this.m_sqlBatch.size() == 0) {
                throw OdxCLJException.error(25522);
            }
            nArray = new int[this.m_sqlBatch.size()];
            iterator = this.m_sqlBatch.iterator();
        }
        iterable = null;
        try {
            int n = 0;
            while (iterator.hasNext()) {
                nArray[n] = this.executeUpdate(iterator.next());
                if (this.m_resultSet != null) {
                    SQLException sQLException = OdxCLJException.error(25515);
                    iterable = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
                    ((SQLException)iterable).setNextException(sQLException);
                    break;
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            iterable = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
            ((SQLException)iterable).setNextException(sQLException);
        }
        if (iterable != null) {
            throw iterable;
        }
        return nArray;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_jdbcConnection;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_oaStatement == null;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

